/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class WrapJsonAggFunctionArgumentsRuleTest
extends TableTestBase {
    private final boolean batchMode;
    private TableTestUtil util;

    @Parameters(name="batchMode = {0}")
    private static Collection<Boolean> data() {
        return Arrays.asList(true, false);
    }

    WrapJsonAggFunctionArgumentsRuleTest(boolean batchMode) {
        this.batchMode = batchMode;
    }

    @BeforeEach
    void setup() {
        this.util = this.batchMode ? this.batchTestUtil(TableConfig.getDefault()) : this.streamTestUtil(TableConfig.getDefault());
        this.util.tableEnv().executeSql("CREATE TABLE T(\n f0 INTEGER,\n f1 VARCHAR,\n f2 BIGINT\n) WITH (\n 'connector' = 'values'\n ,'bounded' = '" + this.batchMode + "'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE T1(\n f0 INTEGER,\n f1 VARCHAR,\n f2 BIGINT\n) WITH (\n 'connector' = 'values'\n ,'bounded' = '" + this.batchMode + "'\n)");
    }

    @TestTemplate
    void testJsonObjectAgg() {
        this.util.verifyRelPlan("SELECT JSON_OBJECTAGG(f1 VALUE f1) FROM T");
    }

    @TestTemplate
    void testJsonObjectAggInGroupWindow() {
        this.util.verifyRelPlan("SELECT f0, JSON_OBJECTAGG(f1 VALUE f0) FROM T GROUP BY f0");
    }

    @TestTemplate
    void testJsonArrayAgg() {
        this.util.verifyRelPlan("SELECT JSON_ARRAYAGG(f0) FROM T");
    }

    @TestTemplate
    void testJsonArrayAggInGroupWindow() {
        this.util.verifyRelPlan("SELECT f0, JSON_ARRAYAGG(f0) FROM T GROUP BY f0");
    }

    @TestTemplate
    void testJsonObjectAggWithOtherAggs() {
        this.util.verifyRelPlan("SELECT COUNT(*), JSON_OBJECTAGG(f1 VALUE f1) FROM T");
    }

    @TestTemplate
    void testGroupJsonObjectAggWithOtherAggs() {
        this.util.verifyRelPlan("SELECT f0, COUNT(*), JSON_OBJECTAGG(f1 VALUE f0), SUM(f2) FROM T GROUP BY f0");
    }

    @TestTemplate
    void testJsonArrayAggWithOtherAggs() {
        this.util.verifyRelPlan("SELECT COUNT(*), JSON_ARRAYAGG(f0) FROM T");
    }

    @TestTemplate
    void testGroupJsonArrayAggInWithOtherAggs() {
        this.util.verifyRelPlan("SELECT f0, COUNT(*), JSON_ARRAYAGG(f0), SUM(f2) FROM T GROUP BY f0");
    }

    @TestTemplate
    void testJsonArrayAggAndJsonObjectAggWithOtherAggs() {
        this.util.verifyRelPlan("SELECT MAX(f0), JSON_OBJECTAGG(f1 VALUE f0), JSON_ARRAYAGG(f1), JSON_ARRAYAGG(f0) FROM T");
    }

    @TestTemplate
    void testGroupJsonArrayAggAndJsonObjectAggWithOtherAggs() {
        this.util.verifyRelPlan("SELECT f0, JSON_OBJECTAGG(f1 VALUE f2), JSON_ARRAYAGG(f1), JSON_ARRAYAGG(f2), SUM(f2) FROM T GROUP BY f0");
    }
}

