/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.RankNumberColumnRemoveRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0003\u0006\u00017!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u0016\u0001A\u0003%\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u0003@\u0001\u0011\u0005Q\u0006C\u0003E\u0001\u0011\u0005Q\u0006C\u0003G\u0001\u0011\u0005Q\u0006C\u0003I\u0001\u0011\u0005QF\u0001\u0010SC:\\g*^7cKJ\u001cu\u000e\\;n]J+Wn\u001c<f%VdW\rV3ti*\u00111\u0002D\u0001\bY><\u0017nY1m\u0015\tia\"A\u0003sk2,7O\u0003\u0002\u0010!\u0005!\u0001\u000f\\1o\u0015\t\t\"#A\u0004qY\u0006tg.\u001a:\u000b\u0005M!\u0012!\u0002;bE2,'BA\u000b\u0017\u0003\u00151G.\u001b8l\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003?A\tQ!\u001e;jYNL!!\t\u0010\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t!\"\u0001\u0003vi&dW#\u0001\u0015\u0011\u0005uI\u0013B\u0001\u0016\u001f\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0015\u0019X\r^;q)\u0005q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$\u0001B+oSRD#\u0001B\u001b\u0011\u0005YjT\"A\u001c\u000b\u0005aJ\u0014aA1qS*\u0011!hO\u0001\bUV\u0004\u0018\u000e^3s\u0015\ta\u0004$A\u0003kk:LG/\u0003\u0002?o\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002CQ,7\u000f^\"b]:|GOU3n_Z,'+\u00198l\u001dVl'-\u001a:D_2,XN\\\u0019)\u0005\u0015\t\u0005C\u0001\u001cC\u0013\t\u0019uG\u0001\u0003UKN$\u0018!\t;fgR\u001c\u0015M\u001c8piJ+Wn\u001c<f%\u0006t7NT;nE\u0016\u00148i\u001c7v[:\u0014\u0004F\u0001\u0004B\u0003\u0005\"Xm\u001d;DC:tw\u000e\u001e*f[>4XMU1oW:+XNY3s\u0007>dW/\u001c84Q\t9\u0011)A\u0010uKN$8i\\;mIJ+Wn\u001c<f%\u0006t7NT;nE\u0016\u00148i\u001c7v[:D#\u0001C!")
public class RankNumberColumnRemoveRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.RankNumberColumnRemoveRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testCannotRemoveRankNumberColumn1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rank_num FROM (\n        |  SELECT *,\n        |      RANK() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num >= 1 AND rank_num < 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCannotRemoveRankNumberColumn2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num >= 1 AND rank_num < 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCannotRemoveRankNumberColumn3() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num >= 1 AND rank_num < 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCouldRemoveRankNumberColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num >= 1 AND rank_num < 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }
}

