/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ResolvedExpressionMock;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoLegacyTableSourceScanRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0010!\u0001EB\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u001dI\u0005A1A\u0005\u0012)CaA\u0014\u0001!\u0002\u0013Y\u0005\"B(\u0001\t\u0003\u0001\u0006\"\u00029\u0001\t\u0003\u0001\u0006\"B;\u0001\t\u0003\u0001\u0006\"B<\u0001\t\u0003\u0001\u0006\"B=\u0001\t\u0003\u0001\u0006\"B>\u0001\t\u0003\u0001\u0006\"B?\u0001\t\u0003\u0001\u0006\"B@\u0001\t\u0003\u0001\u0006BBA\u0002\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002\b\u0001!\t\u0001\u0015\u0005\u0007\u0003\u0017\u0001A\u0011\u0001)\t\r\u0005=\u0001\u0001\"\u0001Q\u0011\u0019\t\u0019\u0002\u0001C\u0001!\"1\u0011q\u0003\u0001\u0005\u0002ACa!a\u0007\u0001\t\u0003\u0001\u0006BBA\u0010\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002$\u0001!\t\u0001\u0015\u0005\u0007\u0003O\u0001A\u0011\u0001)\t\r\u0005-\u0002\u0001\"\u0001Q\u000f\u001d\tI\u0006\tE\u0001\u000372aa\b\u0011\t\u0002\u0005u\u0003BB\"\u001d\t\u0003\t)\u0007C\u0004\u0002hq!\t!!\u001b\u0003]A+8\u000f\u001b)beRLG/[8o\u0013:$x\u000eT3hC\u000eLH+\u00192mKN{WO]2f'\u000e\fgNU;mKR+7\u000f\u001e\u0006\u0003C\t\nq\u0001\\8hS\u000e\fGN\u0003\u0002$I\u0005)!/\u001e7fg*\u0011QEJ\u0001\u0005a2\fgN\u0003\u0002(Q\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0015+\u0003\u0015!\u0018M\u00197f\u0015\tYC&A\u0003gY&t7N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u0014\u0002\u000bU$\u0018\u000e\\:\n\u0005]\"$!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-A\u000bt_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012qAQ8pY\u0016\fg.\u0001\ft_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:!\u0003A)8/Z\"bi\u0006dwn\u001a$jYR,'/A\tvg\u0016\u001c\u0015\r^1m_\u001e4\u0015\u000e\u001c;fe\u0002\na\u0001P5oSRtDcA#H\u0011B\u0011a\tA\u0007\u0002A!)\u0001(\u0002a\u0001u!)\u0011)\u0002a\u0001u\u0005!Q\u000f^5m+\u0005Y\u0005CA\u001aM\u0013\tiEG\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0017!B;uS2\u0004\u0013!B:fiV\u0004H#A)\u0011\u0005m\u0012\u0016BA*=\u0005\u0011)f.\u001b;)\u0005!)\u0006C\u0001,^\u001b\u00059&B\u0001-Z\u0003\r\t\u0007/\u001b\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002]]\u0005)!.\u001e8ji&\u0011al\u0016\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007f\u0001\u0005a_B\u00191(Y2\n\u0005\td$A\u0002;ie><8\u000f\u0005\u0002eY:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003QB\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005-d\u0014a\u00029bG.\fw-Z\u0005\u0003[:\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0005-d4%A2\u0002;Q,7\u000f\u001e(p!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016D#!\u0003:\u0011\u0005Y\u001b\u0018B\u0001;X\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u00039\"Xm\u001d;O_B\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,w+\u001b;i-&\u0014H/^1m\u0007>dW/\u001c8)\u0005)\u0011\u0018\u0001\t;fgR|e\u000e\\=QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKFB#a\u0003:\u0002cQ,7\u000f^(oYf\u0004\u0016M\u001d;ji&|gNR5fY\u0012\u0004&/\u001a3jG\u0006$X-M,ji\"4\u0016N\u001d;vC2\u001cu\u000e\\;n]\"\u0012AB]\u0001!i\u0016\u001cHo\u00148msB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,'\u0007\u000b\u0002\u000ee\u0006\tD/Z:u\u001f:d\u0017\u0010U1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^33/&$\bNV5siV\fGnQ8mk6t\u0007F\u0001\bs\u0003\u0001\"Xm\u001d;P]2L\b+\u0019:uSRLwN\u001c$jK2$\u0007K]3eS\u000e\fG/Z\u001a)\u0005=\u0011\u0018!\r;fgR|e\u000e\\=QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKN:\u0016\u000e\u001e5WSJ$X/\u00197D_2,XN\u001c\u0015\u0003!I\f\u0001\u0005^3ti>sG.\u001f)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;fi!\u0012\u0011C]\u00012i\u0016\u001cHo\u00148msB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,GgV5uQZK'\u000f^;bY\u000e{G.^7oQ\t\u0011\"/\u0001\u0017uKN$\b+\u0019:uSRLwN\u001c$jK2$\u0007K]3eS\u000e\fG/Z!oI>#\b.\u001a:Qe\u0016$\u0017nY1uK\"\u00121C]\u0001>i\u0016\u001cH\u000fU1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^3B]\u0012|E\u000f[3s!J,G-[2bi\u0016<\u0016\u000e\u001e5WSJ$X/\u00197D_2,XN\u001c\u0015\u0003)I\f1\u0006^3tiB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,wJ](uQ\u0016\u0014\bK]3eS\u000e\fG/\u001a\u0015\u0003+I\fA\b^3tiB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,wJ](uQ\u0016\u0014\bK]3eS\u000e\fG/Z,ji\"4\u0016N\u001d;vC2\u001cu\u000e\\;n]\"\u0012aC]\u0001+i\u0016\u001cH\u000fU1si&\fG\u000eU1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^3QkNDGi\\<oQ\t9\"/A\u001euKN$\b+\u0019:uS\u0006d\u0007+\u0019:uSRLwN\u001c$jK2$\u0007K]3eS\u000e\fG/\u001a)vg\"$un\u001e8XSRDg+\u001b:uk\u0006d7i\u001c7v[:D#\u0001\u0007:\u0002\u0017Q,7\u000f^,ji\",FM\u001a\u0015\u00033I\f1\u0004^3ti^KG\u000f[+eM\u0006sGMV5siV\fGnQ8mk6t\u0007F\u0001\u000esQ\u001d\u0001\u0011\u0011GA\u001f\u0003\u007f\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o9\u0016!C3yi\u0016t7/[8o\u0013\u0011\tY$!\u000e\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\r\f\u0002\u0002B\r\u0012\u00111\t\t\u0005\u0003\u000b\n)&\u0004\u0002\u0002H)!\u0011\u0011JA&\u00035\u0001\u0018M]1nKR,'/\u001b>fI*!\u0011QJA(\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u00049\u0006E#bAA*U\u0005IA/Z:ukRLGn]\u0005\u0005\u0003/\n9E\u0001\u000eQCJ\fW.\u001a;fe&TX\r\u001a+fgR,\u0005\u0010^3og&|g.\u0001\u0018QkND\u0007+\u0019:uSRLwN\\%oi>dUmZ1dsR\u000b'\r\\3T_V\u00148-Z*dC:\u0014V\u000f\\3UKN$\bC\u0001$\u001d'\ra\u0012q\f\t\u0004w\u0005\u0005\u0014bAA2y\t1\u0011I\\=SK\u001a$\"!a\u0017\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002lA1\u0011QNA;\u0003sj!!a\u001c\u000b\u0007%\u000b\tH\u0003\u0002\u0002t\u0005!!.\u0019<b\u0013\u0011\t9(a\u001c\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003<\u0003w\ny(C\u0002\u0002~q\u0012Q!\u0011:sCf\u00042aOAA\u0013\r\t\u0019\t\u0010\u0002\u0004\u0003:L\bf\u0002\u0010\u0002\b\u00065\u0015q\u0012\t\u0005\u0003\u000b\nI)\u0003\u0003\u0002\f\u0006\u001d#A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\t\t*A\u0018t_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:>wBjH\u0006I;tK\u000e\u000bG/\u00197pO\u001aKG\u000e^3s{m\fT\u0010")
public class PushPartitionIntoLegacyTableSourceScanRuleTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final BatchTableTestUtil util;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PushPartitionIntoLegacyTableSourceScanRuleTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() throws Exception {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushPartitionIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE(), CoreRules.FILTER_PROJECT_TRANSPOSE})).build());
        Schema tableSchema = Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"part1", (DataType)DataTypes.STRING()), Column.physical((String)"part2", (DataType)DataTypes.INT())})).build();
        Schema tableSchema2 = Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"part1", (DataType)DataTypes.STRING()), Column.physical((String)"part2", (DataType)DataTypes.INT()), Column.computed((String)"virtualField", (ResolvedExpression)ResolvedExpressionMock.of((DataType)DataTypes.INT(), (String)"`part2` + 1"))})).build();
        TableEnvironment x$1 = this.util().tableEnv();
        String x$2 = "MyTable";
        Schema x$3 = tableSchema;
        boolean x$4 = true;
        List<Map<String, String>> x$5 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$5();
        boolean x$6 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$6();
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(x$1, x$2, x$4, x$3, x$5, x$6);
        TableEnvironment x$7 = this.util().tableEnv();
        String x$8 = "VirtualTable";
        Schema x$9 = tableSchema2;
        boolean x$10 = true;
        List<Map<String, String>> x$11 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$5();
        boolean x$12 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$6();
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(x$7, x$8, x$10, x$9, x$11, x$12);
    }

    @TestTemplate
    public void testNoPartitionFieldPredicate() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2");
    }

    @TestTemplate
    public void testNoPartitionFieldPredicateWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate1WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate2WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part1 = 'A' AND part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate3WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part1 = 'A' AND part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate4() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part1 = 'A' OR part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate4WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part1 = 'A' OR part2 > 1");
    }

    @TestTemplate
    public void testPartitionFieldPredicateAndOtherPredicate() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2 AND part1 = 'A'");
    }

    @TestTemplate
    public void testPartitionFieldPredicateAndOtherPredicateWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2 AND part1 = 'A'");
    }

    @TestTemplate
    public void testPartitionFieldPredicateOrOtherPredicate() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2 OR part1 = 'A'");
    }

    @TestTemplate
    public void testPartitionFieldPredicateOrOtherPredicateWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2 OR part1 = 'A'");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDownWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testWithUdf() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @TestTemplate
    public void testWithUdfAndVirtualColumn() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    public PushPartitionIntoLegacyTableSourceScanRuleTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

