/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.time.ZoneId;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoTableSourceScanRule;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoTableSourceScanRuleTestBase;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PushFilterIntoTableSourceScanRuleTest
extends PushFilterIntoTableSourceScanRuleTestBase {
    PushFilterIntoTableSourceScanRuleTest() {
    }

    @BeforeEach
    void setup() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        ((BatchTableTestUtil)this.util).buildBatchProgram(FlinkBatchProgram.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util.tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushFilterIntoTableSourceScanRule.INSTANCE, CoreRules.FILTER_PROJECT_TRANSPOSE})).build());
        String ddl1 = "CREATE TABLE MyTable (\n  name STRING,\n  id bigint,\n  amount int,\n  price double\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'amount',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl1);
        String ddl2 = "CREATE TABLE VirtualTable (\n  name STRING,\n  id bigint,\n  amount int,\n  virtualField as amount + 1,\n  price double\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'amount',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl2);
        String ddl3 = "CREATE TABLE NestedTable (\n  id int,\n  deepNested row<nested1 row<name string, `value` int>, nested2 row<num int, flag boolean>>,\n  nested row<name string, `value` int>,\n  `deepNestedWith.` row<`.value` int, nested row<```name` string, `.value` int>>,\n  name string,\n  testMap Map<string, string>\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = '`deepNested.nested1.value`;`deepNestedWith..nested..value`;`deepNestedWith..nested.``name`;', 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl3);
        String ddl4 = "CREATE TABLE NestedItemTable (\n  `ID` INT,\n  `Timestamp` TIMESTAMP(3),\n  `Result` ROW<\n    `Mid` ROW<      `data_arr` ROW<`value` BIGINT> ARRAY,\n      `data_map` MAP<STRING, ROW<`value` BIGINT>>     >   >,\n   WATERMARK FOR `Timestamp` AS `Timestamp`\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'Result_Mid_data_map;', 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl4);
    }

    @Override
    @Test
    void testLowerUpperPushdown() {
        String ddl = "CREATE TABLE MTable (\n  a STRING,\n  b STRING\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'a;b',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        super.testLowerUpperPushdown();
    }

    @Override
    @Test
    void testWithInterval() {
        String ddl = "CREATE TABLE MTable (\na TIMESTAMP(3),\nb TIMESTAMP(3)\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true',\n 'filterable-fields' = 'a;b',\n 'disable-lookup' = 'true')";
        this.util.tableEnv().executeSql(ddl);
        super.testWithInterval();
    }

    @Override
    @Test
    public void testWithTimestampWithTimeZone() {
        String ddl = "CREATE TABLE MTable (\na TIMESTAMP_LTZ(3),\nb TIMESTAMP(3)\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true',\n 'filterable-fields' = 'a',\n 'disable-lookup' = 'true')";
        this.util.tableEnv().executeSql(ddl);
        ZoneId preZoneId = this.util.tableEnv().getConfig().getLocalTimeZone();
        this.util.tableEnv().getConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        try {
            super.testWithTimestampWithTimeZone();
        }
        finally {
            this.util.tableEnv().getConfig().setLocalTimeZone(preZoneId);
        }
    }

    @Test
    void testBasicNestedFilter() {
        this.util.verifyRelPlan("SELECT * FROM NestedTable WHERE deepNested.nested1.`value` > 2");
    }

    @Test
    void testNestedFilterWithDotInTheName() {
        this.util.verifyRelPlan("SELECT id FROM NestedTable WHERE `deepNestedWith.`.nested.`.value` > 5");
    }

    @Test
    void testNestedFilterWithBacktickInTheName() {
        this.util.verifyRelPlan("SELECT id FROM NestedTable WHERE `deepNestedWith.`.nested.```name` = 'foo'");
    }

    @Test
    void testNestedFilterOnMapKey() {
        this.util.verifyRelPlan("SELECT * FROM NestedItemTable WHERE `Result`.`Mid`.data_map['item'].`value` = 3");
    }

    @Test
    void testNestedFilterOnArrayField() {
        this.util.verifyRelPlan("SELECT * FROM NestedItemTable WHERE `Result`.`Mid`.data_arr[2].`value` = 3");
    }
}

