/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForRangeEndTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4AAE\n\u0001I!)1\u0006\u0001C\u0001Y!9q\u0006\u0001b\u0001\n\u0013\u0001\u0004B\u0002\u001b\u0001A\u0003%\u0011\u0007C\u00036\u0001\u0011\u0005a\u0007C\u0003I\u0001\u0011\u0005a\u0007C\u0003K\u0001\u0011\u0005a\u0007C\u0003M\u0001\u0011\u0005a\u0007C\u0003O\u0001\u0011\u0005a\u0007C\u0003Q\u0001\u0011\u0005a\u0007C\u0003S\u0001\u0011\u0005a\u0007C\u0003U\u0001\u0011\u0005a\u0007C\u0003W\u0001\u0011\u0005a\u0007C\u0003Y\u0001\u0011\u0005a\u0007C\u0003[\u0001\u0011\u0005a\u0007C\u0003]\u0001\u0011\u0005a\u0007C\u0003_\u0001\u0011\u0005a\u0007C\u0003a\u0001\u0011\u0005aGA\u0012GY&t7\u000eT8hS\u000e\fGNU1oWJ+H.\u001a$peJ\u000bgnZ3F]\u0012$Vm\u001d;\u000b\u0005Q)\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003-]\tQA];mKNT!\u0001G\r\u0002\tAd\u0017M\u001c\u0006\u00035m\tq\u0001\u001d7b]:,'O\u0003\u0002\u001d;\u0005)A/\u00192mK*\u0011adH\u0001\u0006M2Lgn\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u001a\u0003\u0015)H/\u001b7t\u0013\tQsEA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003M\tA!\u001e;jYV\t\u0011\u0007\u0005\u0002'e%\u00111g\n\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0012i\u0016\u001cHOU8x\u001dVl'-\u001a:Gk:\u001cG#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0003\ty\u0002\"a\u0010$\u000e\u0003\u0001S!!\u0011\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0002D\t\u00069!.\u001e9ji\u0016\u0014(BA#\"\u0003\u0015QWO\\5u\u0013\t9\u0005I\u0001\u0003UKN$\u0018!\u0005;fgR<\u0016\u000e\u001e5pkR4\u0015\u000e\u001c;fe\"\u0012QAP\u0001\"i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\",\u0006\u000f]3s-\u0006dW/\u001a\u0015\u0003\ry\nA\u0004^3tiJ\u000bgn\u001b,bYV,g)\u001b7uKJ<\u0016\u000e\u001e5SC:<W\r\u000b\u0002\b}\u0005\tC/Z:u%\u0006t7NV1mk\u00164\u0015\u000e\u001c;fe^KG\u000f\u001b'po\u0016\u0014h+\u00197vK\"\u0012\u0001BP\u0001\u001ei\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\",\u0015/^1mg\"\u0012\u0011BP\u0001&i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\"4\u0016M]5bE2,g)[3mIFB#A\u0003 \u0002KQ,7\u000f\u001e*b].4\u0016\r\\;f\r&dG/\u001a:XSRDg+\u0019:jC\ndWMR5fY\u0012\u0014\u0004FA\u0006?\u0003\u0015\"Xm\u001d;SC:\\g+\u00197vK\u001aKG\u000e^3s/&$\bNV1sS\u0006\u0014G.\u001a$jK2$7\u0007\u000b\u0002\r}\u0005)C/Z:u%\u0006t7NV1mk\u00164\u0015\u000e\u001c;fe^KG\u000f\u001b,be&\f'\r\\3GS\u0016dG\r\u000e\u0015\u0003\u001by\na\u0003^3ti^KG\u000f[8viB\u000b'\u000f^5uS>t')\u001f\u0015\u0003\u001dy\nq\u0005^3ti6+H\u000e^5TC6,'+\u00198l\rVt7\r^5p]N<\u0016\u000e\u001e5TC6,wI]8va\"\u0012qBP\u0001(i\u0016\u001cH/T;mi&\u001c\u0016-\\3SC:\\g)\u001e8di&|gn],ji\"$\u0015N\u001a4He>,\b\u000f\u000b\u0002\u0011}\u0005QB/Z:u\u001bVdG/\u001b#jM\u001a\u0014\u0016M\\6Gk:\u001cG/[8og\"\u0012\u0011C\u0010")
public class FlinkLogicalRankRuleForRangeEndTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testRowNumberFunc() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rn <= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutFilter() {
        this.util().verifyRelPlan("SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable");
    }

    @Test
    public void testRankValueFilterWithUpperValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b, c ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND rk > -2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithLowerValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk > 2\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("Rank end is not specified.") instanceof TableException;
    }

    @Test
    public void testRankValueFilterWithEquals() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk = 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk > a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a and b > 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField4() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY a ORDER BY c) rk FROM MyTable) t\n        |WHERE rk = b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutPartitionBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (ORDER BY a) rk FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithSameGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithDiffGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY c ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiDiffRankFunctions() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk,\n        |        ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    public FlinkLogicalRankRuleForRangeEndTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForRangeEndTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
    }
}

