/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalAggregate$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalExpand$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacySink$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalValues$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkGroupProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.FlinkBatchRuleSets$;
import org.apache.flink.table.planner.plan.rules.logical.AggregateReduceGroupingRule;
import org.apache.flink.table.planner.plan.rules.logical.DecomposeGroupingSetsRule$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateExpandDistinctAggregatesRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRuleTest$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRule;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\u0010 \u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006)\u0002!\tA\u0011\u0005\u00063\u0002!\tA\u0011\u0005\u00067\u0002!\tA\u0011\u0005\u0006;\u0002!\tA\u0011\u0005\u0006?\u0002!\tA\u0011\u0005\u0006C\u0002!\tA\u0011\u0005\u0006G\u0002!\tA\u0011\u0005\u0006K\u0002!\tA\u0011\u0005\u0006O\u0002!\tA\u0011\u0005\u0006S\u0002!\tA\u0011\u0005\u0006W\u0002!\tA\u0011\u0005\u0006[\u0002!\tA\u0011\u0005\u0006_\u0002!\tA\u0011\u0005\u0006c\u0002!\tA\u0011\u0005\u0006g\u0002!\tA\u0011\u0005\u0006k\u0002!\tA\u0011\u0005\u0006o\u0002!\tA\u0011\u0005\u0006s\u0002!\tA\u0011\u0005\u0006w\u0002!\tA\u0011\u0005\u0006{\u0002!\tA\u0011\u0005\u0006\u007f\u0002!\tA\u0011\u0005\u0007\u0003\u0007\u0001A\u0011\u0001\"\t\r\u0005\u001d\u0001\u0001\"\u0001C\u0011\u0019\tY\u0001\u0001C\u0001\u0005\"1\u0011q\u0002\u0001\u0005\u0002\t\u0013AD\u00127j].\fum\u001a:fO\u0006$XMU3n_Z,'+\u001e7f)\u0016\u001cHO\u0003\u0002!C\u00059An\\4jG\u0006d'B\u0001\u0012$\u0003\u0015\u0011X\u000f\\3t\u0015\t!S%\u0001\u0003qY\u0006t'B\u0001\u0014(\u0003\u001d\u0001H.\u00198oKJT!\u0001K\u0015\u0002\u000bQ\f'\r\\3\u000b\u0005)Z\u0013!\u00024mS:\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001cA\u0011!'N\u0007\u0002g)\u0011A'J\u0001\u0006kRLGn]\u0005\u0003mM\u0012Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001:!\tQ\u0004!D\u0001 \u0003\u0011)H/\u001b7\u0016\u0003u\u0002\"A\r \n\u0005}\u001a$A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\nQa]3ukB$\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0005+:LG\u000f\u000b\u0002\u0005\u0015B\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\u0004CBL'BA(Q\u0003\u001dQW\u000f]5uKJT!!U\u0017\u0002\u000b),h.\u001b;\n\u0005Mc%A\u0003\"fM>\u0014X-R1dQ\u0006\tC/Z:u\u0003\u001e<'+Z7pm\u0016|vI]8va.+\u00170S:O_R,f.[9vK\"\u0012QA\u0016\t\u0003\u0017^K!\u0001\u0017'\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/Q4h%\u0016lwN^3`/&$\bn\\;u\r&dG/\u001a:2Q\t1a+\u0001\u000fuKN$\u0018iZ4SK6|g/Z0XSRDw.\u001e;GS2$XM\u001d\u001a)\u0005\u001d1\u0016!\b;fgR\fum\u001a*f[>4XmX,ji\"|W\u000f^$s_V\u0004()_\u0019)\u0005!1\u0016!\b;fgR\fum\u001a*f[>4XmX,ji\"|W\u000f^$s_V\u0004()\u001f\u001a)\u0005%1\u0016!\b;fgR\fum\u001a*f[>4XmX,ji\"|W\u000f^$s_V\u0004()_\u001a)\u0005)1\u0016!\b;fgR\fum\u001a*f[>4XmX,ji\"|W\u000f^$s_V\u0004()\u001f\u001b)\u0005-1\u0016\u0001\b;fgR\fum\u001a*f[>4XmX,ji\"|W\u000f^!hO\u000e\u000bG\u000e\u001c\u0015\u0003\u0019Y\u000b\u0001\u0004^3ti\u0006;wMU3n_Z,wlV5uQ\u001aKG\u000e^3sQ\tia+A\nuKN$\u0018iZ4SK6|g/Z0D_VtG\u000f\u000b\u0002\u000f-\u00069B/Z:u\u0003\u001e<'+Z7pm\u0016|6i\\;oiN#\u0018M\u001d\u0015\u0003\u001fY\u000b\u0001\u0004^3ti\u0006;wMU3n_Z,wl\u0012:pkB\u001cV\r^:2Q\t\u0001b+\u0001\ruKN$\u0018iZ4SK6|g/Z0He>,\boU3ugJB#!\u0005,\u0002)Q,7\u000f^!hOJ+Wn\u001c<f?J{G\u000e\\;qQ\t\u0011b+\u0001\nuKN$\u0018iZ4SK6|g/Z0Dk\n,\u0007FA\nW\u0003\u0001\"Xm\u001d;BO\u001e\u0014V-\\8wK~\u001b\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ\u0019)\u0005Q1\u0016\u0001\t;fgR\fum\u001a*f[>4XmX*j]\u001edW\rR5ti&t7\r^!hOJB#!\u0006,\u0002gQ,7\u000f^!hOJ+Wn\u001c<f?NKgn\u001a7f\t&\u001cH/\u001b8di\u0006;wmX,ji\"tuN\u001c#jgRLgn\u0019;BO\u001e\f\u0004F\u0001\fW\u0003M\"Xm\u001d;BO\u001e\u0014V-\\8wK~\u001b\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ0XSRDgj\u001c8ESN$\u0018N\\2u\u0003\u001e<'\u0007\u000b\u0002\u0018-\u0006\u0019D/Z:u\u0003\u001e<'+Z7pm\u0016|6+\u001b8hY\u0016$\u0015n\u001d;j]\u000e$\u0018iZ4`/&$\bNT8o\t&\u001cH/\u001b8di\u0006;wm\r\u0015\u00031Y\u000b1\u0007^3ti\u0006;wMU3n_Z,wlU5oO2,G)[:uS:\u001cG/Q4h?^KG\u000f\u001b(p]\u0012K7\u000f^5oGR\fum\u001a\u001b)\u0005e1\u0016\u0001\t;fgR\fum\u001a*f[>4XmX'vYRLG)[:uS:\u001cG/Q4hgFB#A\u0007,\u0002AQ,7\u000f^!hOJ+Wn\u001c<f?6+H\u000e^5ESN$\u0018N\\2u\u0003\u001e<7O\r\u0015\u00037Y\u000b\u0001\u0005^3ti\u0006;wMU3n_Z,w,T;mi&$\u0015n\u001d;j]\u000e$\u0018iZ4tg!\u0012ADV\u00014i\u0016\u001cH/Q4h%\u0016lwN^3`\u001bVdG/\u001b#jgRLgn\u0019;BO\u001e\u001cxlV5uQ:{g\u000eR5ti&t7\r^!hOFB#!\b,")
public class FlinkAggregateRemoveRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("subquery_rewrite", (FlinkOptimizeProgram)FlinkGroupProgramBuilder$.MODULE$.newBuilder().addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(FlinkBatchRuleSets$.MODULE$.SEMI_JOIN_RULES()).build(), "rewrite sub-queries to semi/anti join").build());
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, FlinkAggregateExpandDistinctAggregatesRule.INSTANCE, CoreRules.FILTER_CALC_MERGE, CoreRules.PROJECT_CALC_MERGE, CoreRules.FILTER_TO_CALC, CoreRules.PROJECT_TO_CALC, FlinkCalcMergeRule.INSTANCE, FlinkAggregateRemoveRule.INSTANCE, DecomposeGroupingSetsRule$.MODULE$.INSTANCE(), AggregateReduceGroupingRule.INSTANCE, FlinkLogicalAggregate$.MODULE$.BATCH_CONVERTER(), FlinkLogicalCalc$.MODULE$.CONVERTER(), FlinkLogicalJoin$.MODULE$.CONVERTER(), FlinkLogicalValues$.MODULE$.CONVERTER(), FlinkLogicalExpand$.MODULE$.CONVERTER(), FlinkLogicalTableSourceScan$.MODULE$.CONVERTER(), FlinkLogicalLegacySink$.MODULE$.CONVERTER()})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.LOGICAL()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRuleTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable2 (\n                                |  a INT PRIMARY KEY NOT ENFORCED,\n                                |  b INT,\n                                |  c STRING\n                                |) WITH (\n                                |  'connector' = 'values',\n                                |  'bounded' = 'true',\n                                |  'enable-projection-push-down' = 'false'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable3 (\n                                |  a INT PRIMARY KEY NOT ENFORCED,\n                                |  b INT,\n                                |  c STRING,\n                                |  d STRING\n                                |) WITH (\n                                |  'connector' = 'values',\n                                |  'bounded' = 'true',\n                                |  'enable-projection-push-down' = 'false'\n                                |)\n                                |")).stripMargin());
    }

    @Test
    public void testAggRemove_GroupKeyIsNotUnique() {
        this.util().verifyRelPlan("SELECT a, MAX(c) from MyTable1 GROUP BY a");
    }

    @Test
    public void testAggRemove_WithoutFilter1() {
        this.util().verifyRelPlan("SELECT a, b + 1, c, s FROM (SELECT a, MIN(b) AS b, SUM(b) AS s, MAX(c) AS c FROM MyTable2 GROUP BY a)");
    }

    @Test
    public void testAggRemove_WithoutFilter2() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_WithoutGroupBy1() {
        this.util().verifyRelPlan("SELECT MAX(a), SUM(b), MIN(c) FROM MyTable2");
    }

    @Test
    public void testAggRemove_WithoutGroupBy2() {
        this.util().verifyRelPlan("SELECT MAX(a), SUM(b), MIN(c) FROM (VALUES (1, 2, 3)) T(a, b, c)");
    }

    @Test
    public void testAggRemove_WithoutGroupBy3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable2 WHERE EXISTS (SELECT SUM(a) FROM MyTable1 WHERE 1=2)");
    }

    @Test
    public void testAggRemove_WithoutGroupBy4() {
        this.util().verifyRelPlan("SELECT SUM(a) FROM (SELECT a FROM MyTable2 WHERE 1=2)");
    }

    @Test
    public void testAggRemove_WithoutAggCall() {
        this.util().verifyRelPlan("SELECT a, b FROM MyTable2 GROUP BY a, b");
    }

    @Test
    public void testAggRemove_WithFilter() {
        this.util().verifyRelPlan("SELECT a, MIN(c) FILTER (WHERE b > 0), MAX(b) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_Count() {
        this.util().verifyRelPlan("SELECT a, COUNT(c) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_CountStar() {
        this.util().verifyRelPlan("SELECT a, COUNT(*) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_GroupSets1() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY GROUPING SETS((a, c), (a, d))");
    }

    @Test
    public void testAggRemove_GroupSets2() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY GROUPING SETS((a, c), (a), ())");
    }

    @Test
    public void testAggRemove_Rollup() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY ROLLUP(a, c, d)");
    }

    @Test
    public void testAggRemove_Cube() {
        this.util().verifyRelPlan("SELECT a, SUM(b) AS s FROM MyTable3 GROUP BY CUBE(a, c, d)");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg2() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable2 GROUP BY a, b");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(b) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg2() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(b) FROM MyTable2 GROUP BY a, c");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg3() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(b) FROM MyTable3 GROUP BY a");
    }

    @Test
    public void testAggRemove_SingleDistinctAgg_WithNonDistinctAgg4() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(b) FROM MyTable3 GROUP BY a, d");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(DISTINCT b) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs2() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(DISTINCT b) FROM MyTable3 GROUP BY a, d");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs3() {
        this.util().verifyRelPlan("SELECT a, SUM(DISTINCT b), MAX(DISTINCT b), MIN(DISTINCT c) FROM MyTable2 GROUP BY a");
    }

    @Test
    public void testAggRemove_MultiDistinctAggs_WithNonDistinctAgg1() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c), SUM(b) FROM MyTable3 GROUP BY a, d");
    }
}

