/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.time.Duration;
import java.util.Collections;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.collection.Seq;

@ExtendWith(value={ParameterizedTestExtension.class})
public class MiniBatchOptimizationTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(TableConfig.getDefault());
    @Parameter
    public boolean isMiniBatchEnabled;
    public long miniBatchLatency;
    public long miniBatchSize;

    @BeforeEach
    public void setup() {
        this.miniBatchLatency = 5L;
        this.miniBatchSize = 10L;
        this.util.tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)this.isMiniBatchEnabled).set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(this.miniBatchLatency)).set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)this.miniBatchSize);
        this.util.tableEnv().executeSql("CREATE TABLE MyTableA (\n  a BIGINT,\n  b INT NOT NULL,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n  'connector' = 'values',\n  'bounded' = 'false')");
        this.util.tableEnv().executeSql("CREATE TABLE MyTableB (\n  a BIGINT,\n  b INT NOT NULL,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n  'connector' = 'values',\n  'bounded' = 'false')");
    }

    @TestTemplate
    public void testMiniBatchWithAggregation() {
        String aggQuery = "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTableA";
        if (this.isMiniBatchEnabled) {
            this.util.verifyRelPlanExpected("SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTableA", (Seq<String>)JavaScalaConversionUtil.toScala(Collections.singletonList("MiniBatchAssigner")));
        } else {
            this.util.verifyRelPlanNotExpected("SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTableA", (Seq<String>)JavaScalaConversionUtil.toScala(Collections.singletonList("MiniBatchAssigner")));
        }
    }

    @TestTemplate
    public void testMiniBatchWithJoin() {
        String joinQuery = "SELECT * FROM MyTableA a, MyTableB b WHERE a.a = b.a";
        if (this.isMiniBatchEnabled) {
            this.util.verifyRelPlanExpected("SELECT * FROM MyTableA a, MyTableB b WHERE a.a = b.a", (Seq<String>)JavaScalaConversionUtil.toScala(Collections.singletonList("MiniBatchAssigner")));
        } else {
            this.util.verifyRelPlanNotExpected("SELECT * FROM MyTableA a, MyTableB b WHERE a.a = b.a", (Seq<String>)JavaScalaConversionUtil.toScala(Collections.singletonList("MiniBatchAssigner")));
        }
    }

    @TestTemplate
    public void testMiniBatchWithProjectFilter() {
        String joinQuery = "SELECT b FROM MyTableA a WHERE a.a > 123";
        this.util.verifyRelPlanNotExpected("SELECT b FROM MyTableA a WHERE a.a > 123", (Seq<String>)JavaScalaConversionUtil.toScala(Collections.singletonList("MiniBatchAssigner")));
    }

    @Parameters(name="isMiniBatchEnabled={0}")
    public static Object[][] data() {
        return new Object[][]{{true}, {false}};
    }
}

