/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;

public class WatermarkAssignerTestPrograms {
    static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{2, 2L, "Hello", "2020-04-15 08:00:00", DateTimeUtils.toLocalDateTime((long)1586937600000L)}), Row.of((Object[])new Object[]{1, 1L, "Hi", "2020-04-15 08:00:01", DateTimeUtils.toLocalDateTime((long)1586937601000L)}), Row.of((Object[])new Object[]{3, 2L, "Hello world", "2020-04-15 08:00:02", DateTimeUtils.toLocalDateTime((long)1586937602000L)}), Row.of((Object[])new Object[]{4, 3L, "Hello world, how are you?", "2020-04-15 08:00:03", DateTimeUtils.toLocalDateTime((long)1586937603000L)}), Row.of((Object[])new Object[]{5, 3L, "I am fine.", "2020-04-15 08:00:04", DateTimeUtils.toLocalDateTime((long)1586937604000L)})};
    static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{7, 4L, "Ack", "2020-04-15 08:00:21", DateTimeUtils.toLocalDateTime((long)1586937621000L)}), Row.of((Object[])new Object[]{6, 5L, "Syn", "2020-04-15 08:00:23", DateTimeUtils.toLocalDateTime((long)1586937623000L)}), Row.of((Object[])new Object[]{8, 3L, "Syn-Ack", "2020-04-15 08:00:25", DateTimeUtils.toLocalDateTime((long)1586937625000L)}), Row.of((Object[])new Object[]{10, 3L, "Close", "2020-04-15 08:00:28", DateTimeUtils.toLocalDateTime((long)1586937628000L)})};
    static final String[] SOURCE_SCHEMA = new String[]{"a INT", "b BIGINT", "c VARCHAR", "ts_string STRING", "ts TIMESTAMP(3)", "WATERMARK for ts AS ts - INTERVAL '1' SECOND"};
    static final String[] SINK_SCHEMA = new String[]{"a INT", "b BIGINT", "ts TIMESTAMP(3)"};
    static final TableTestProgram WATERMARK_ASSIGNER_BASIC_FILTER = TableTestProgram.of((String)"watermark-assigner-basic-filter", (String)"validates watermark assigner with basic filtering").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[4, 3, 2020-04-15T08:00:03]", "+I[5, 3, 2020-04-15T08:00:04]"}).consumedAfterRestore(new String[]{"+I[8, 3, 2020-04-15T08:00:25]", "+I[10, 3, 2020-04-15T08:00:28]"}).build()).runSql("INSERT INTO sink_t SELECT a, b, ts FROM source_t WHERE b = 3").build();
    static final TableTestProgram WATERMARK_ASSIGNER_PUSHDOWN_METADATA = TableTestProgram.of((String)"watermark-assigner-pushdown-metadata", (String)"validates watermark assigner with pushdown metadata").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addOption("enable-watermark-push-down", "true")).addOption("readable-metadata", "ts:timestamp(3)")).addOption("disable-lookup", "true")).addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[4, 3, 2020-04-15T08:00:03]", "+I[5, 3, 2020-04-15T08:00:04]"}).consumedAfterRestore(new String[]{"+I[8, 3, 2020-04-15T08:00:25]", "+I[10, 3, 2020-04-15T08:00:28]"}).build()).runSql("INSERT INTO sink_t SELECT a, b, ts FROM source_t WHERE b = 3").build();
}

