/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PythonCalcJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    PythonCalcJsonPlanTest() {
    }

    @BeforeEach
    void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int not null,\n  c varchar,\n  d timestamp(3)\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
    }

    @Test
    void testPythonCalc() {
        this.tEnv.createTemporaryFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select a, pyFunc(b, b) from MyTable");
    }

    @Test
    void testPythonFunctionInWhereClause() {
        this.tEnv.createTemporaryFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.BooleanPythonScalarFunction("pyFunc"));
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select a, b from MyTable where pyFunc(b, b + 1)");
    }
}

