/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;

public class DeduplicationTestPrograms {
    static final Row[] DATA1 = new Row[]{Row.of((Object[])new Object[]{1L, "terry", "pen", 1000L}), Row.of((Object[])new Object[]{2L, "alice", "pen", 2000L}), Row.of((Object[])new Object[]{3L, "bob", "pen", 3000L}), Row.of((Object[])new Object[]{4L, "bob", "apple", 4000L}), Row.of((Object[])new Object[]{5L, "fish", "apple", 5000L})};
    static final Row[] DATA2 = new Row[]{Row.of((Object[])new Object[]{6L, "jerry", "pen", 6000L}), Row.of((Object[])new Object[]{7L, "larry", "apple", 7000L}), Row.of((Object[])new Object[]{8L, "bill", "banana", 8000L}), Row.of((Object[])new Object[]{9L, "carol", "apple", 9000L})};
    static final TableTestProgram DEDUPLICATE = TableTestProgram.of((String)"deduplicate-asc", (String)"validates deduplication in ascending").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"order_id bigint", "`user` varchar", "product varchar", "order_time bigint ", "event_time as TO_TIMESTAMP(FROM_UNIXTIME(order_time)) ", "watermark for event_time as event_time - INTERVAL '5' second "})).producedBeforeRestore(DATA1).producedAfterRestore(DATA2).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"order_id bigint", "`user` varchar", "product varchar", "order_time bigint", "primary key(product) not enforced"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, "terry", "pen", 1000}), Row.of((Object[])new Object[]{4, "bob", "apple", 4000})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{8L, "bill", "banana", 8000L})}).build()).runSql("insert into MySink select order_id, user, product, order_time \nFROM (  SELECT *,    ROW_NUMBER() OVER (PARTITION BY product ORDER BY event_time ASC) AS row_num\n  FROM MyTable)WHERE row_num = 1").build();
    static final TableTestProgram DEDUPLICATE_PROCTIME = TableTestProgram.of((String)"deduplicate-asc-proctime", (String)"validates deduplication in ascending with proctime").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"order_id bigint", "`user` varchar", "product varchar", "order_time bigint ", "event_time as TO_TIMESTAMP(FROM_UNIXTIME(order_time)) ", "proctime AS PROCTIME() "})).producedBeforeRestore(DATA1).producedAfterRestore(DATA2).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"order_id bigint", "`user` varchar", "product varchar", "order_time bigint", "primary key(product) not enforced"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, "terry", "pen", 1000}), Row.of((Object[])new Object[]{4, "bob", "apple", 4000})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{8L, "bill", "banana", 8000L})}).build()).runSql("insert into MySink select order_id, user, product, order_time \nFROM (  SELECT *,    ROW_NUMBER() OVER (PARTITION BY product ORDER BY proctime ASC) AS row_num\n  FROM MyTable)WHERE row_num = 1").build();
    static final TableTestProgram DEDUPLICATE_DESC = TableTestProgram.of((String)"deduplicate-desc", (String)"validates deduplication in descending").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"order_id bigint", "`user` varchar", "product varchar", "order_time bigint ", "event_time as TO_TIMESTAMP(FROM_UNIXTIME(order_time)) ", "watermark for event_time as event_time - INTERVAL '5' second "})).producedBeforeRestore(DATA1).producedAfterRestore(DATA2).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"order_id bigint", "`user` varchar", "product varchar", "order_time bigint", "primary key(product) not enforced"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1L, "terry", "pen", 1000L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L, "alice", "pen", 2000L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L, "bob", "pen", 3000L}), Row.of((Object[])new Object[]{4L, "bob", "apple", 4000L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L, "fish", "apple", 5000L})}).consumedAfterRestore(new Row[]{Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L, "jerry", "pen", 6000L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L, "larry", "apple", 7000L}), Row.of((Object[])new Object[]{8L, "bill", "banana", 8000L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{9L, "carol", "apple", 9000L})}).build()).runSql("insert into MySink select order_id, user, product, order_time \nFROM (  SELECT *,    ROW_NUMBER() OVER (PARTITION BY product ORDER BY event_time DESC) AS row_num\n  FROM MyTable)WHERE row_num = 1").build();
}

