/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.table.api.config.LookupJoinHintOptions;
import org.apache.flink.table.planner.hint.JoinStrategy;

public class LookupJoinHintTestUtil {
    public static RelHint completeLookupHint = LookupJoinHintTestUtil.getLookupJoinHint(true, true);
    public static RelHint lookupHintWithAsync = LookupJoinHintTestUtil.getLookupJoinHint(true, false);
    public static RelHint lookupHintWithRetry = LookupJoinHintTestUtil.getLookupJoinHint(false, true);
    public static RelHint lookupHintWithTableOnly = LookupJoinHintTestUtil.getLookupJoinHint(false, false);

    public static RelHint getLookupJoinHint(String table, boolean withAsync, boolean withRetry) {
        Map<String, String> kvOptions = LookupJoinHintTestUtil.getLookupJoinHintOptions(table, withAsync, withRetry);
        return RelHint.builder((String)JoinStrategy.LOOKUP.getJoinHintName()).hintOptions(kvOptions).build();
    }

    public static RelHint getLookupJoinHint(boolean withAsync, boolean withRetry) {
        return LookupJoinHintTestUtil.getLookupJoinHint("TestTable", withAsync, withRetry);
    }

    public static Map<String, String> getLookupJoinHintOptions(String table, boolean withAsync, boolean withRetry) {
        HashMap<String, String> kvOptions = new HashMap<String, String>();
        kvOptions.put(LookupJoinHintOptions.LOOKUP_TABLE.key(), table);
        if (withAsync) {
            LookupJoinHintTestUtil.addAsyncOptions(kvOptions);
        }
        if (withRetry) {
            LookupJoinHintTestUtil.addRetryOptions(kvOptions);
        }
        return kvOptions;
    }

    public static void addAsyncOptions(Map<String, String> kvOptions) {
        kvOptions.put(LookupJoinHintOptions.ASYNC_LOOKUP.key(), "true");
        kvOptions.put(LookupJoinHintOptions.ASYNC_CAPACITY.key(), "1000");
        kvOptions.put(LookupJoinHintOptions.ASYNC_OUTPUT_MODE.key(), "allow_unordered");
        kvOptions.put(LookupJoinHintOptions.ASYNC_TIMEOUT.key(), "300 s");
    }

    public static void addRetryOptions(Map<String, String> kvOptions) {
        kvOptions.put(LookupJoinHintOptions.RETRY_PREDICATE.key(), "lookup_miss");
        kvOptions.put(LookupJoinHintOptions.RETRY_STRATEGY.key(), "fixed_delay");
        kvOptions.put(LookupJoinHintOptions.FIXED_DELAY.key(), "155 ms");
        kvOptions.put(LookupJoinHintOptions.MAX_ATTEMPTS.key(), "10");
    }
}

