/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.LookupJoinHintOptions;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.spec.LookupJoinHintTestUtil;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AsyncLookupOptionsTest {
    AsyncLookupOptionsTest() {
    }

    @Test
    void testSerdeAsyncLookupOptions() throws IOException {
        LookupJoinUtil.AsyncLookupOptions asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)LookupJoinHintTestUtil.completeLookupHint, (TableConfig)TableConfig.getDefault(), (ChangelogMode)ChangelogMode.insertOnly());
        JsonSerdeTestUtil.testJsonRoundTrip(asyncLookupOptions, LookupJoinUtil.AsyncLookupOptions.class);
        asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)LookupJoinHintTestUtil.lookupHintWithAsync, (TableConfig)TableConfig.getDefault(), (ChangelogMode)ChangelogMode.insertOnly());
        JsonSerdeTestUtil.testJsonRoundTrip(asyncLookupOptions, LookupJoinUtil.AsyncLookupOptions.class);
        asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)LookupJoinHintTestUtil.lookupHintWithRetry, (TableConfig)TableConfig.getDefault(), (ChangelogMode)ChangelogMode.insertOnly());
        JsonSerdeTestUtil.testJsonRoundTrip(asyncLookupOptions, LookupJoinUtil.AsyncLookupOptions.class);
        asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)LookupJoinHintTestUtil.lookupHintWithTableOnly, (TableConfig)TableConfig.getDefault(), (ChangelogMode)ChangelogMode.insertOnly());
        JsonSerdeTestUtil.testJsonRoundTrip(asyncLookupOptions, LookupJoinUtil.AsyncLookupOptions.class);
    }

    @Test
    void testAsyncLookupOptions() {
        LookupJoinUtil.AsyncLookupOptions asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)LookupJoinHintTestUtil.completeLookupHint, (TableConfig)TableConfig.getDefault(), (ChangelogMode)ChangelogMode.insertOnly());
        Assertions.assertThat((Comparable)asyncLookupOptions.asyncOutputMode).isSameAs((Object)AsyncDataStream.OutputMode.UNORDERED);
        asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)LookupJoinHintTestUtil.completeLookupHint, (TableConfig)TableConfig.getDefault(), (ChangelogMode)ChangelogMode.all());
        Assertions.assertThat((Comparable)asyncLookupOptions.asyncOutputMode).isSameAs((Object)AsyncDataStream.OutputMode.ORDERED);
        asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)LookupJoinHintTestUtil.lookupHintWithTableOnly, (TableConfig)TableConfig.getDefault(), (ChangelogMode)ChangelogMode.insertOnly());
        Assertions.assertThat((Comparable)asyncLookupOptions.asyncOutputMode).isSameAs((Object)AsyncDataStream.OutputMode.ORDERED);
        Assertions.assertThat((long)asyncLookupOptions.asyncTimeout).isEqualTo(((Duration)ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_TIMEOUT.defaultValue()).toMillis());
        Assertions.assertThat((int)asyncLookupOptions.asyncBufferCapacity).isEqualTo(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_BUFFER_CAPACITY.defaultValue());
        TableConfig userConf = TableConfig.getDefault();
        userConf.set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_OUTPUT_MODE, (Object)ExecutionConfigOptions.AsyncOutputMode.ALLOW_UNORDERED);
        userConf.set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_BUFFER_CAPACITY, (Object)300);
        HashMap<String, String> kvOptions = new HashMap<String, String>();
        kvOptions.put(LookupJoinHintOptions.ASYNC_LOOKUP.key(), "true");
        kvOptions.put(LookupJoinHintOptions.ASYNC_CAPACITY.key(), "1000");
        asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)RelHint.builder((String)JoinStrategy.LOOKUP.getJoinHintName()).hintOptions(kvOptions).build(), (TableConfig)userConf, (ChangelogMode)ChangelogMode.insertOnly());
        Assertions.assertThat((Comparable)asyncLookupOptions.asyncOutputMode).isSameAs((Object)AsyncDataStream.OutputMode.UNORDERED);
        Assertions.assertThat((long)asyncLookupOptions.asyncTimeout).isEqualTo(((Duration)ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_TIMEOUT.defaultValue()).toMillis());
        Assertions.assertThat((int)asyncLookupOptions.asyncBufferCapacity).isEqualTo(1000);
        asyncLookupOptions = LookupJoinUtil.getMergedAsyncOptions((RelHint)RelHint.builder((String)JoinStrategy.LOOKUP.getJoinHintName()).hintOptions(kvOptions).build(), (TableConfig)userConf, (ChangelogMode)ChangelogMode.all());
        Assertions.assertThat((Comparable)asyncLookupOptions.asyncOutputMode).isSameAs((Object)AsyncDataStream.OutputMode.ORDERED);
    }
}

