/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.TestingBatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.processor.utils.InputPriorityGraphGenerator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InputPriorityGraphGeneratorTest {
    InputPriorityGraphGeneratorTest() {
    }

    @Test
    void testCalculatePipelinedAncestors() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[7];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[1].addInput((ExecNode<?>)nodes[0]);
        nodes[2].addInput((ExecNode<?>)nodes[1], InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build());
        nodes[2].addInput((ExecNode<?>)nodes[3]);
        nodes[3].addInput((ExecNode<?>)nodes[0]);
        nodes[3].addInput((ExecNode<?>)nodes[5]);
        nodes[3].addInput((ExecNode<?>)nodes[6], InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build());
        nodes[5].addInput((ExecNode<?>)nodes[4], InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build());
        TestingInputPriorityConflictResolver resolver = new TestingInputPriorityConflictResolver(Collections.singletonList(nodes[2]), Collections.emptySet(), InputProperty.DamBehavior.END_INPUT);
        List ancestors = resolver.calculatePipelinedAncestors((ExecNode)nodes[2]);
        Assertions.assertThat((List)ancestors).hasSize(2);
        Assertions.assertThat((List)ancestors).contains((Object[])new ExecNode[]{nodes[0]});
        Assertions.assertThat((List)ancestors).contains((Object[])new ExecNode[]{nodes[5]});
    }

    @Test
    void testCalculateBoundedPipelinedAncestors() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[5];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[1].addInput((ExecNode<?>)nodes[0]);
        nodes[2].addInput((ExecNode<?>)nodes[1]);
        nodes[2].addInput((ExecNode<?>)nodes[4], InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).build());
        nodes[4].addInput((ExecNode<?>)nodes[3]);
        TestingInputPriorityConflictResolver resolver = new TestingInputPriorityConflictResolver(Collections.singletonList(nodes[2]), new HashSet<TestingBatchExecNode>(Collections.singleton(nodes[1])), InputProperty.DamBehavior.END_INPUT);
        List ancestors = resolver.calculatePipelinedAncestors((ExecNode)nodes[2]);
        Assertions.assertThat((List)ancestors).hasSize(1);
        Assertions.assertThat((List)ancestors).contains((Object[])new ExecNode[]{nodes[1]});
    }

    private static class TestingInputPriorityConflictResolver
    extends InputPriorityGraphGenerator {
        private TestingInputPriorityConflictResolver(List<ExecNode<?>> roots, Set<ExecNode<?>> boundaries, InputProperty.DamBehavior safeDamBehavior) {
            super(roots, boundaries, safeDamBehavior);
        }

        protected void resolveInputPriorityConflict(ExecNode<?> node, int higherInput, int lowerInput) {
        }
    }
}

