/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.math.BigDecimal;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class WindowTableFunctionTestPrograms {
    static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{"2020-04-15 08:00:05", new BigDecimal(4.0), "C"}), Row.of((Object[])new Object[]{"2020-04-15 08:00:07", new BigDecimal(2.0), "A"}), Row.of((Object[])new Object[]{"2020-04-15 08:00:09", new BigDecimal(5.0), "D"}), Row.of((Object[])new Object[]{"2020-04-15 08:00:11", new BigDecimal(3.0), "B"}), Row.of((Object[])new Object[]{"2020-04-15 08:00:13", new BigDecimal(1.0), "E"}), Row.of((Object[])new Object[]{"2020-04-15 08:00:17", new BigDecimal(6.0), "F"})};
    static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{"2020-04-15 08:00:21", new BigDecimal(4.0), "A"}), Row.of((Object[])new Object[]{"2020-04-15 08:00:27", new BigDecimal(5.0), "C"})};
    static final SourceTestStep SOURCE = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"bid_t").addSchema(new String[]{"ts STRING", "price DECIMAL(10,2)", "item STRING", "`bid_time` AS TO_TIMESTAMP(`ts`)", "`proc_time` AS PROCTIME()", "WATERMARK for `bid_time` AS `bid_time` - INTERVAL '1' SECOND"})).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build();
    static final String TUMBLE_TVF = "TABLE(TUMBLE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '10' SECOND))";
    static final String TUMBLE_TVF_OFFSET = "TABLE(TUMBLE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '10' SECOND, INTERVAL '%s' SECOND))";
    static final String HOP_TVF = "TABLE(HOP(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))";
    static final String CUMULATE_TVF = "TABLE(CUMULATE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))";
    static final String[] SINK_TVF_SCHEMA = new String[]{"bid_time TIMESTAMP(3)", "price DECIMAL(10,2)", "item STRING", "window_start TIMESTAMP(3)", "window_end TIMESTAMP(3)", "window_time TIMESTAMP_LTZ"};
    static final String[] SINK_TVF_AGG_SCHEMA = new String[]{"window_start TIMESTAMP(3)", "window_end TIMESTAMP(3)", "price DECIMAL(10,2)"};
    static final String[] SINK_TVF_AGG_PROC_TIME_SCHEMA = new String[]{"price DECIMAL(10,2)"};
    static final String QUERY_TVF = "INSERT INTO sink_t SELECT\n      bid_time,\n     price,\n     item,\n     window_start,\n     window_end,\n     window_time\n FROM\n     %s";
    static final String QUERY_TVF_AGG = "INSERT INTO sink_t SELECT\n     window_start,\n     window_end,\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end";
    static final String QUERY_TVF_AGG_PROC_TIME = "INSERT INTO sink_t SELECT\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end";
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_TUMBLE_TVF = TableTestProgram.of((String)"window-table-function-tumble-tvf", (String)"validates window table function using tumble tvf windows").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00:05, 4.00, C, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:07, 2.00, A, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:09, 5.00, D, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:11, 3.00, B, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]", "+I[2020-04-15T08:00:13, 1.00, E, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]", "+I[2020-04-15T08:00:17, 6.00, F, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:21, 4.00, A, 2020-04-15T08:00:20, 2020-04-15T08:00:30, 2020-04-15T08:00:29.999Z]", "+I[2020-04-15T08:00:27, 5.00, C, 2020-04-15T08:00:20, 2020-04-15T08:00:30, 2020-04-15T08:00:29.999Z]"}).build()).setupConfig(TableConfigOptions.LOCAL_TIME_ZONE, (Object)"UTC").runSql(String.format("INSERT INTO sink_t SELECT\n      bid_time,\n     price,\n     item,\n     window_start,\n     window_end,\n     window_time\n FROM\n     %s", String.format("TABLE(TUMBLE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '10' SECOND))", "bid_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_TUMBLE_TVF_POSITIVE_OFFSET = TableTestProgram.of((String)"window-table-function-tumble-tvf-positive-offset", (String)"validates window table function using tumble tvf windows with positive offset").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00:05, 4.00, C, 2020-04-15T07:59:56, 2020-04-15T08:00:06, 2020-04-15T08:00:05.999Z]", "+I[2020-04-15T08:00:07, 2.00, A, 2020-04-15T08:00:06, 2020-04-15T08:00:16, 2020-04-15T08:00:15.999Z]", "+I[2020-04-15T08:00:09, 5.00, D, 2020-04-15T08:00:06, 2020-04-15T08:00:16, 2020-04-15T08:00:15.999Z]", "+I[2020-04-15T08:00:11, 3.00, B, 2020-04-15T08:00:06, 2020-04-15T08:00:16, 2020-04-15T08:00:15.999Z]", "+I[2020-04-15T08:00:13, 1.00, E, 2020-04-15T08:00:06, 2020-04-15T08:00:16, 2020-04-15T08:00:15.999Z]", "+I[2020-04-15T08:00:17, 6.00, F, 2020-04-15T08:00:16, 2020-04-15T08:00:26, 2020-04-15T08:00:25.999Z]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:21, 4.00, A, 2020-04-15T08:00:16, 2020-04-15T08:00:26, 2020-04-15T08:00:25.999Z]", "+I[2020-04-15T08:00:27, 5.00, C, 2020-04-15T08:00:26, 2020-04-15T08:00:36, 2020-04-15T08:00:35.999Z]"}).build()).setupConfig(TableConfigOptions.LOCAL_TIME_ZONE, (Object)"UTC").runSql(String.format("INSERT INTO sink_t SELECT\n      bid_time,\n     price,\n     item,\n     window_start,\n     window_end,\n     window_time\n FROM\n     %s", String.format("TABLE(TUMBLE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '10' SECOND, INTERVAL '%s' SECOND))", "bid_time", "6"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_TUMBLE_TVF_NEGATIVE_OFFSET = TableTestProgram.of((String)"window-table-function-tumble-tvf-negative-offset", (String)"validates window table function using tumble tvf windows with negative offset").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00:05, 4.00, C, 2020-04-15T08:00:04, 2020-04-15T08:00:14, 2020-04-15T08:00:13.999Z]", "+I[2020-04-15T08:00:07, 2.00, A, 2020-04-15T08:00:04, 2020-04-15T08:00:14, 2020-04-15T08:00:13.999Z]", "+I[2020-04-15T08:00:09, 5.00, D, 2020-04-15T08:00:04, 2020-04-15T08:00:14, 2020-04-15T08:00:13.999Z]", "+I[2020-04-15T08:00:11, 3.00, B, 2020-04-15T08:00:04, 2020-04-15T08:00:14, 2020-04-15T08:00:13.999Z]", "+I[2020-04-15T08:00:13, 1.00, E, 2020-04-15T08:00:04, 2020-04-15T08:00:14, 2020-04-15T08:00:13.999Z]", "+I[2020-04-15T08:00:17, 6.00, F, 2020-04-15T08:00:14, 2020-04-15T08:00:24, 2020-04-15T08:00:23.999Z]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:21, 4.00, A, 2020-04-15T08:00:14, 2020-04-15T08:00:24, 2020-04-15T08:00:23.999Z]", "+I[2020-04-15T08:00:27, 5.00, C, 2020-04-15T08:00:24, 2020-04-15T08:00:34, 2020-04-15T08:00:33.999Z]"}).build()).setupConfig(TableConfigOptions.LOCAL_TIME_ZONE, (Object)"UTC").runSql(String.format("INSERT INTO sink_t SELECT\n      bid_time,\n     price,\n     item,\n     window_start,\n     window_end,\n     window_time\n FROM\n     %s", String.format("TABLE(TUMBLE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '10' SECOND, INTERVAL '%s' SECOND))", "bid_time", "-6"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_TUMBLE_TVF_AGG = TableTestProgram.of((String)"window-table-function-tumble-tvf-agg", (String)"validates window table function using tumble tvf windows with aggregation").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_AGG_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00, 2020-04-15T08:00:10, 11.00]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:10, 2020-04-15T08:00:20, 10.00]", "+I[2020-04-15T08:00:20, 2020-04-15T08:00:30, 9.00]"}).build()).runSql(String.format("INSERT INTO sink_t SELECT\n     window_start,\n     window_end,\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end", String.format("TABLE(TUMBLE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '10' SECOND))", "bid_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_TUMBLE_TVF_AGG_PROC_TIME = TableTestProgram.of((String)"window-table-function-tumble-tvf-agg-proc-time", (String)"validates window table function using tumble tvf windows with aggregation and processing time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_AGG_PROC_TIME_SCHEMA)).consumedBeforeRestore(new String[]{"+I[21.00]"}).consumedAfterRestore(new String[]{"+I[9.00]"}).build()).runSql(String.format("INSERT INTO sink_t SELECT\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end", String.format("TABLE(TUMBLE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '10' SECOND))", "proc_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_HOP_TVF = TableTestProgram.of((String)"window-table-function-hop-tvf", (String)"validates window table function using hop tvf windows").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00:05, 4.00, C, 2020-04-15T08:00:05, 2020-04-15T08:00:15, 2020-04-15T08:00:14.999Z]", "+I[2020-04-15T08:00:05, 4.00, C, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:07, 2.00, A, 2020-04-15T08:00:05, 2020-04-15T08:00:15, 2020-04-15T08:00:14.999Z]", "+I[2020-04-15T08:00:07, 2.00, A, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:09, 5.00, D, 2020-04-15T08:00:05, 2020-04-15T08:00:15, 2020-04-15T08:00:14.999Z]", "+I[2020-04-15T08:00:09, 5.00, D, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:11, 3.00, B, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]", "+I[2020-04-15T08:00:11, 3.00, B, 2020-04-15T08:00:05, 2020-04-15T08:00:15, 2020-04-15T08:00:14.999Z]", "+I[2020-04-15T08:00:13, 1.00, E, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]", "+I[2020-04-15T08:00:13, 1.00, E, 2020-04-15T08:00:05, 2020-04-15T08:00:15, 2020-04-15T08:00:14.999Z]", "+I[2020-04-15T08:00:17, 6.00, F, 2020-04-15T08:00:15, 2020-04-15T08:00:25, 2020-04-15T08:00:24.999Z]", "+I[2020-04-15T08:00:17, 6.00, F, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:21, 4.00, A, 2020-04-15T08:00:20, 2020-04-15T08:00:30, 2020-04-15T08:00:29.999Z]", "+I[2020-04-15T08:00:21, 4.00, A, 2020-04-15T08:00:15, 2020-04-15T08:00:25, 2020-04-15T08:00:24.999Z]", "+I[2020-04-15T08:00:27, 5.00, C, 2020-04-15T08:00:25, 2020-04-15T08:00:35, 2020-04-15T08:00:34.999Z]", "+I[2020-04-15T08:00:27, 5.00, C, 2020-04-15T08:00:20, 2020-04-15T08:00:30, 2020-04-15T08:00:29.999Z]"}).build()).setupConfig(TableConfigOptions.LOCAL_TIME_ZONE, (Object)"UTC").runSql(String.format("INSERT INTO sink_t SELECT\n      bid_time,\n     price,\n     item,\n     window_start,\n     window_end,\n     window_time\n FROM\n     %s", String.format("TABLE(HOP(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))", "bid_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_HOP_TVF_AGG = TableTestProgram.of((String)"window-table-function-hop-tvf-agg", (String)"validates window table function using hop tvf windows with aggregation").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_AGG_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00, 2020-04-15T08:00:10, 11.00]", "+I[2020-04-15T08:00:05, 2020-04-15T08:00:15, 15.00]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:10, 2020-04-15T08:00:20, 10.00]", "+I[2020-04-15T08:00:15, 2020-04-15T08:00:25, 10.00]", "+I[2020-04-15T08:00:20, 2020-04-15T08:00:30, 9.00]", "+I[2020-04-15T08:00:25, 2020-04-15T08:00:35, 5.00]"}).build()).runSql(String.format("INSERT INTO sink_t SELECT\n     window_start,\n     window_end,\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end", String.format("TABLE(HOP(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))", "bid_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_HOP_TVF_AGG_PROC_TIME = TableTestProgram.of((String)"window-table-function-hop-tvf-agg-proc-time", (String)"validates window table function using hop tvf windows with aggregation and processing time").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_AGG_PROC_TIME_SCHEMA)).consumedBeforeRestore(new String[]{"+I[21.00]", "+I[21.00]"}).consumedAfterRestore(new String[]{"+I[9.00]"}).build()).runSql(String.format("INSERT INTO sink_t SELECT\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end", String.format("TABLE(HOP(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))", "proc_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_CUMULATE_TVF = TableTestProgram.of((String)"window-table-function-cumulate-tvf", (String)"validates window table function using cumulate tvf windows").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00:05, 4.00, C, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:07, 2.00, A, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:09, 5.00, D, 2020-04-15T08:00, 2020-04-15T08:00:10, 2020-04-15T08:00:09.999Z]", "+I[2020-04-15T08:00:11, 3.00, B, 2020-04-15T08:00:10, 2020-04-15T08:00:15, 2020-04-15T08:00:14.999Z]", "+I[2020-04-15T08:00:11, 3.00, B, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]", "+I[2020-04-15T08:00:13, 1.00, E, 2020-04-15T08:00:10, 2020-04-15T08:00:15, 2020-04-15T08:00:14.999Z]", "+I[2020-04-15T08:00:13, 1.00, E, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]", "+I[2020-04-15T08:00:17, 6.00, F, 2020-04-15T08:00:10, 2020-04-15T08:00:20, 2020-04-15T08:00:19.999Z]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:21, 4.00, A, 2020-04-15T08:00:20, 2020-04-15T08:00:25, 2020-04-15T08:00:24.999Z]", "+I[2020-04-15T08:00:21, 4.00, A, 2020-04-15T08:00:20, 2020-04-15T08:00:30, 2020-04-15T08:00:29.999Z]", "+I[2020-04-15T08:00:27, 5.00, C, 2020-04-15T08:00:20, 2020-04-15T08:00:30, 2020-04-15T08:00:29.999Z]"}).build()).setupConfig(TableConfigOptions.LOCAL_TIME_ZONE, (Object)"UTC").runSql(String.format("INSERT INTO sink_t SELECT\n      bid_time,\n     price,\n     item,\n     window_start,\n     window_end,\n     window_time\n FROM\n     %s", String.format("TABLE(CUMULATE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))", "bid_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_CUMULATE_TVF_AGG = TableTestProgram.of((String)"window-table-function-cumulate-tvf-agg", (String)"validates window table function using cumulate tvf windows with aggregation").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_AGG_SCHEMA)).consumedBeforeRestore(new String[]{"+I[2020-04-15T08:00, 2020-04-15T08:00:10, 11.00]", "+I[2020-04-15T08:00:10, 2020-04-15T08:00:15, 4.00]"}).consumedAfterRestore(new String[]{"+I[2020-04-15T08:00:10, 2020-04-15T08:00:20, 10.00]", "+I[2020-04-15T08:00:20, 2020-04-15T08:00:25, 4.00]", "+I[2020-04-15T08:00:20, 2020-04-15T08:00:30, 9.00]"}).build()).runSql(String.format("INSERT INTO sink_t SELECT\n     window_start,\n     window_end,\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end", String.format("TABLE(CUMULATE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))", "bid_time"))).build();
    public static final TableTestProgram WINDOW_TABLE_FUNCTION_CUMULATE_TVF_AGG_PROC_TIME = TableTestProgram.of((String)"window-table-function-cumulate-tvf-agg-proc-time", (String)"validates window table function using cumulate tvf windows with aggregation").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_TVF_AGG_PROC_TIME_SCHEMA)).consumedBeforeRestore(new String[]{"+I[21.00]", "+I[21.00]"}).consumedAfterRestore(new String[]{"+I[9.00]"}).build()).runSql(String.format("INSERT INTO sink_t SELECT\n     SUM(price)\n FROM\n     %s\n GROUP BY window_start, window_end", String.format("TABLE(CUMULATE(TABLE bid_t, DESCRIPTOR(%s), INTERVAL '5' SECOND, INTERVAL '10' SECOND))", "proc_time"))).build();
}

