/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class CorrelateTestPrograms {
    static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{1L, 1, "hi#there"}), Row.of((Object[])new Object[]{2L, 2, "hello#world"})};
    static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{4L, 4, "foo#bar"}), Row.of((Object[])new Object[]{3L, 3, "bar#fiz"})};
    static final String[] SOURCE_SCHEMA = new String[]{"a BIGINT", "b INT NOT NULL", "c VARCHAR"};
    public static final TableTestProgram CORRELATE_CATALOG_FUNC = TableTestProgram.of((String)"correlate-catalog-func", (String)"validate correlate with temporary catalog function").setupTemporaryCatalogFunction("func1", TableFunc1.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a VARCHAR", "b VARCHAR"})).consumedBeforeRestore(new String[]{"+I[hi#there, $hi]", "+I[hi#there, $there]", "+I[hello#world, $hello]", "+I[hello#world, $world]"}).consumedAfterRestore(new String[]{"+I[foo#bar, $foo]", "+I[foo#bar, $bar]", "+I[bar#fiz, $bar]", "+I[bar#fiz, $fiz]"}).build()).runSql("INSERT INTO sink_t SELECT c, s FROM source_t, LATERAL TABLE(func1(c, '$')) AS T(s)").build();
    public static final TableTestProgram CORRELATE_SYSTEM_FUNC = TableTestProgram.of((String)"correlate-system-func", (String)"validate correlate with temporary system function").setupTemporarySystemFunction("STRING_SPLIT", JavaUserDefinedTableFunctions.StringSplit.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a VARCHAR", "b VARCHAR"})).consumedBeforeRestore(new String[]{"+I[hi#there, hi]", "+I[hi#there, there]", "+I[hello#world, hello]", "+I[hello#world, world]"}).consumedAfterRestore(new String[]{"+I[foo#bar, foo]", "+I[foo#bar, bar]", "+I[bar#fiz, bar]", "+I[bar#fiz, fiz]"}).build()).runSql("INSERT INTO sink_t SELECT c, s FROM source_t, LATERAL TABLE(STRING_SPLIT(c, '#')) AS T(s)").build();
    public static final TableTestProgram CORRELATE_JOIN_FILTER = TableTestProgram.of((String)"correlate-join-filter", (String)"validate correlate with join and filter").setupTemporaryCatalogFunction("func1", TableFunc1.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a VARCHAR", "b VARCHAR"})).consumedBeforeRestore(new String[]{"+I[hello#world, hello]", "+I[hello#world, world]"}).consumedAfterRestore(new String[]{"+I[bar#fiz, bar]", "+I[bar#fiz, fiz]"}).build()).runSql("INSERT INTO sink_t SELECT * FROM (SELECT c, s FROM source_t, LATERAL TABLE(func1(c)) AS T(s)) AS T2 WHERE c LIKE '%hello%' OR c LIKE '%fiz%'").build();
    public static final TableTestProgram CORRELATE_LEFT_JOIN = TableTestProgram.of((String)"correlate-left-join", (String)"validate correlate with left join").setupTemporaryCatalogFunction("func1", TableFunc1.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(SOURCE_SCHEMA)).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a VARCHAR", "b VARCHAR"})).consumedBeforeRestore(new String[]{"+I[hi#there, hi]", "+I[hi#there, there]", "+I[hello#world, hello]", "+I[hello#world, world]"}).consumedAfterRestore(new String[]{"+I[foo#bar, foo]", "+I[foo#bar, bar]", "+I[bar#fiz, bar]", "+I[bar#fiz, fiz]"}).build()).runSql("INSERT INTO sink_t SELECT c, s FROM source_t LEFT JOIN LATERAL TABLE(func1(c)) AS T(s) ON TRUE").build();
    public static final TableTestProgram CORRELATE_CROSS_JOIN_UNNEST = TableTestProgram.of((String)"correlate-cross-join-unnest", (String)"validate correlate with cross join and unnest").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"name STRING", "arr ARRAY<ROW<nested STRING>>"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Bob", new Row[]{Row.of((Object[])new Object[]{"1"}), Row.of((Object[])new Object[]{"2"}), Row.of((Object[])new Object[]{"3"})}})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Alice", new Row[]{Row.of((Object[])new Object[]{"4"}), Row.of((Object[])new Object[]{"5"}), Row.of((Object[])new Object[]{"6"})}})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"name STRING", "nested STRING"})).consumedBeforeRestore(new String[]{"+I[Bob, 1]", "+I[Bob, 2]", "+I[Bob, 3]"}).consumedAfterRestore(new String[]{"+I[Alice, 4]", "+I[Alice, 5]", "+I[Alice, 6]"}).build()).runSql("INSERT INTO sink_t SELECT name, nested FROM source_t CROSS JOIN UNNEST(arr) AS T(nested)").build();
}

