/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalExpand;
import org.apache.flink.table.planner.plan.utils.ExpandUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U3A\u0001E\t\u0001A!)Q\u0005\u0001C\u0001M!)\u0001\u0006\u0001C\u0001S!)1\b\u0001C\u0001S!)Q\b\u0001C\u0001S!)q\b\u0001C\u0001S!)\u0011\t\u0001C\u0001S!)1\t\u0001C\u0001S!)Q\t\u0001C\u0001S!)q\t\u0001C\u0001S!)\u0011\n\u0001C\u0001S!)1\n\u0001C\u0001S!)Q\n\u0001C\u0001S!)q\n\u0001C\u0001S!)\u0011\u000b\u0001C\u0001S!)1\u000b\u0001C\u0001S\tQb\t\\5oWJ+G.\u00143V]&\fX/Z$s_V\u00048\u000fV3ti*\u0011!cE\u0001\t[\u0016$\u0018\rZ1uC*\u0011A#F\u0001\u0005a2\fgN\u0003\u0002\u0017/\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\r\u001a\u0003\u0015!\u0018M\u00197f\u0015\tQ2$A\u0003gY&t7N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003EI!\u0001J\t\u00033\u0019c\u0017N\\6SK2lE\rS1oI2,'\u000fV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"A\t\u0001\u0002[Q,7\u000f^$fiVs\u0017.];f\u000fJ|W\u000f]:P]R\u000b'\r\\3TG\u0006tw+\u001b;i\u001dVdGnQ8mk6t7\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\t\t\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029;\u0005)!.\u001e8ji&\u0011!h\r\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$x)\u001a;V]&\fX/Z$s_V\u00048o\u00148UC\ndWmU2b]\"\u00121!M\u0001\u001ci\u0016\u001cHoR3u+:L\u0017/^3He>,\bo](o\r&dG/\u001a:)\u0005\u0011\t\u0014\u0001\b;fgR<U\r^+oSF,Xm\u0012:pkB\u001cxJ\u001c)s_*,7\r\u001e\u0015\u0003\u000bE\n\u0011\u0004^3ti\u001e+G/\u00168jcV,wI]8vaN|enQ1mG\"\u0012a!M\u0001\u001ci\u0016\u001cHoR3u+:L\u0017/^3He>,\bo](o\u000bb\u0004\u0018M\u001c3)\u0005\u001d\t\u0014!\b;fgR<U\r^+oSF,Xm\u0012:pkB\u001cxJ\\#yG\"\fgnZ3)\u0005!\t\u0014!\u0007;fgR<U\r^+oSF,Xm\u0012:pkB\u001cxJ\\*peRD#!C\u0019\u0002=Q,7\u000f^$fiVs\u0017.];f\u000fJ|W\u000f]:P]\u0006;wM]3hCR,\u0007F\u0001\u00062\u0003y!Xm\u001d;HKR,f.[9vK\u001e\u0013x.\u001e9t\u001f:<\u0016N\u001c3po\u0006;w\r\u000b\u0002\fc\u0005aB/Z:u\u000f\u0016$XK\\5rk\u0016<%o\\;qg>swJ^3s\u0003\u001e<\u0007F\u0001\u00072\u0003e!Xm\u001d;HKR,f.[9vK\u001e\u0013x.\u001e9t\u001f:Tu.\u001b8)\u00055\t\u0014A\u0007;fgR<U\r^+oSF,Xm\u0012:pkB\u001cxJ\\+oS>t\u0007F\u0001\b2\u0003q!Xm\u001d;HKR,f.[9vK\u001e\u0013x.\u001e9t\u001f:$UMZ1vYRD#aD\u0019")
public class FlinkRelMdUniqueGroupsTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetUniqueGroupsOnTableScanWithNullColumns() {
        Assertions.assertThatThrownBy(() -> this.mq().getUniqueGroups((RelNode)this.studentLogicalScan(), null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testGetUniqueGroupsOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.empFlinkLogicalScan(), this.studentBatchScan(), this.studentStreamScan(), this.empFlinkLogicalScan(), this.empFlinkLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentFlinkLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnTableScan$3(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.empFlinkLogicalScan(), this.empFlinkLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnTableScan$4(this, scan);
            return BoxedUnit.UNIT;
        });
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable4"}).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(ts, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(ts, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(ts, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)this.mq().getUniqueGroups(ts, ImmutableBitSet.of((int[])new int[]{1, 2})));
    }

    @Test
    public void testGetUniqueGroupsOnFilter() {
        this.relBuilder().scan(new String[]{"MyTable3"});
        RexNode expr1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        RexNode expr2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)10.0))});
        RelNode filter1 = this.relBuilder().filter((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)expr1, (List)new .colon.colon((Object)expr2, (List)Nil$.MODULE$)))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(filter1, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups(filter1, ImmutableBitSet.of((int[])new int[]{0, 1})));
        this.relBuilder().clear();
        this.relBuilder().scan(new String[]{"MyTable4"});
        RexNode expr3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        RexNode expr4 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)10.0))});
        RelNode filter2 = this.relBuilder().filter((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)expr3, (List)new .colon.colon((Object)expr4, (List)Nil$.MODULE$)))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(filter2, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(filter2, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(filter2, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)this.mq().getUniqueGroups(filter2, ImmutableBitSet.of((int[])new int[]{1, 2})));
    }

    @Test
    public void testGetUniqueGroupsOnProject() {
        this.relBuilder().scan(new String[]{"MyTable4"});
        RelNode proj1 = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().field(1), (List)new .colon.colon((Object)this.relBuilder().field(2), (List)Nil$.MODULE$))))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj1, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj1, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj1, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)this.mq().getUniqueGroups(proj1, ImmutableBitSet.of((int[])new int[]{1, 2})));
        this.relBuilder().clear();
        this.relBuilder().scan(new String[]{"MyTable4"});
        RelNode proj2 = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().field(1)}), (List)new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))}), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$))))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj2, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(proj2, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups(proj2, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups(proj2, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        this.relBuilder().clear();
        this.relBuilder().scan(new String[]{"MyTable4"});
        RelNode proj3 = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))}), (List)new .colon.colon((Object)this.relBuilder().field(2), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$))))))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj3, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(proj3, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups(proj3, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups(proj3, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj3, ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{3}), (Object)this.mq().getUniqueGroups(proj3, ImmutableBitSet.of((int[])new int[]{3, 4})));
        this.relBuilder().clear();
        this.relBuilder().scan(new String[]{"MyTable4"});
        RelNode proj4 = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().alias((RexNode)this.relBuilder().field(0), "a1"), (List)new .colon.colon((Object)this.relBuilder().field(2), (List)Nil$.MODULE$))))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj4, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj4, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj4, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(proj4, ImmutableBitSet.of((int[])new int[]{1, 2})));
        this.relBuilder().clear();
        this.relBuilder().scan(new String[]{"MyTable4"});
        RelNode proj5 = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj5, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(proj5, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups(proj5, ImmutableBitSet.of((int[])new int[]{0, 1})));
    }

    @Test
    public void testGetUniqueGroupsOnCalc() {
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable4"}).build();
        this.relBuilder().push(ts);
        .colon.colon projects = new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))}), (List)new .colon.colon((Object)this.relBuilder().field(2), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)))));
        RexNode condition = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        RelDataType outputRowType = this.relBuilder().push(ts).project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects)).build().getRowType();
        Calc calc = this.createLogicalCalc(ts, outputRowType, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)condition, (List)Nil$.MODULE$)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups((RelNode)calc, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups((RelNode)calc, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups((RelNode)calc, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups((RelNode)calc, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups((RelNode)calc, ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{3}), (Object)this.mq().getUniqueGroups((RelNode)calc, ImmutableBitSet.of((int[])new int[]{3, 4})));
    }

    @Test
    public void testGetUniqueGroupsOnExpand() {
        LogicalTableScan ts = this.studentLogicalScan();
        java.util.List expandProjects1 = ExpandUtil$.MODULE$.createExpandProjects(ts.getCluster().getRexBuilder(), ts.getRowType(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)ImmutableBitSet.of((int[])new int[]{2}), (Object)ImmutableBitSet.of((int[])new int[]{3})), (Integer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.class)));
        FlinkLogicalExpand expand1 = new FlinkLogicalExpand(ts.getCluster(), ts.getTraitSet(), (RelNode)ts, expandProjects1, 7);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{2}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{3}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{3})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{7}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{0, 7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand1, ImmutableBitSet.of((int[])new int[]{0, 1, 7})));
        java.util.List expandProjects2 = ExpandUtil$.MODULE$.createExpandProjects(ts.getCluster().getRexBuilder(), ts.getRowType(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)ImmutableBitSet.of((int[])new int[]{0, 2}), (Object)ImmutableBitSet.of((int[])new int[]{0, 3})), (Integer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.class)));
        FlinkLogicalExpand expand2 = new FlinkLogicalExpand(ts.getCluster(), ts.getTraitSet(), (RelNode)ts, expandProjects2, 7);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableSet.of((Object)ImmutableBitSet.of((int[])new int[]{0, 7})), (Object)this.mq().getUniqueKeys((RelNode)expand2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{2}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{3}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{3})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{7}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{0, 7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{0, 1, 7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand2, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 7})));
        java.util.List expandProjects3 = ExpandUtil$.MODULE$.createExpandProjects(ts.getCluster().getRexBuilder(), ts.getRowType(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2}), (Object)ImmutableBitSet.of((int[])new int[]{0, 1, 3})), (Integer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.class)));
        FlinkLogicalExpand expand3 = new FlinkLogicalExpand(ts.getCluster(), ts.getTraitSet(), (RelNode)ts, expandProjects3, 7);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableSet.of((Object)ImmutableBitSet.of((int[])new int[]{0, 7})), (Object)this.mq().getUniqueKeys((RelNode)expand2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{0})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{2}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{3}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{3})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{7}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{0, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{0, 7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{0, 1, 7})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 7}), (Object)this.mq().getUniqueGroups((RelNode)expand3, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 7})));
    }

    @Test
    public void testGetUniqueGroupsOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetUniqueGroupsOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.batchLocalLimit(), this.batchGlobalLimit(), this.streamLimit(), this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchSortLimit(), this.batchLocalSortLimit(), this.batchGlobalSortLimit(), this.streamSortLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetUniqueGroupsOnAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithoutLocal(), this.batchGlobalAggWithLocal(), this.batchLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAggWithAuxGroup(), this.flinkLogicalAggWithAuxGroup(), this.batchGlobalAggWithoutLocalWithAuxGroup(), this.batchGlobalAggWithLocalWithAuxGroup(), this.batchLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnAggregate$2(this, agg);
            return BoxedUnit.UNIT;
        });
        RelNode agg2 = this.relBuilder().scan(new String[]{"student"}).aggregate(this.relBuilder().groupKey(), new RelBuilder.AggCall[]{this.relBuilder().count(false, "c", new RexNode[]{this.relBuilder().field("id")}), this.relBuilder().avg(false, "a", (RexNode)this.relBuilder().field("age"))}).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)this.mq().getUniqueGroups(agg2, ImmutableBitSet.of((int[])new int[]{0, 1})));
    }

    @Test
    public void testGetUniqueGroupsOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.batchGlobalWindowAggWithLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}), (Object)this.mq().getUniqueGroups((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3})));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)this.mq().getUniqueGroups((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2}), (Object)this.mq().getUniqueGroups((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
    }

    @Test
    public void testGetUniqueGroupsOnOverAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnOverAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetUniqueGroupsOnJoin() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{3, 4}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 6, 7, 8}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{6}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalInnerJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2, 3, 4}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 2, 3, 4, 5, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalLeftJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 6, 7, 8}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 6}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinWithoutEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalRightJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{5}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 6, 7, 8}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 6}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 5, 6, 7, 8, 9}), (Object)this.mq().getUniqueGroups(this.logicalFullJoinWithoutCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalSemiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)this.mq().getUniqueGroups(this.logicalSemiJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalSemiJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalSemiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalSemiJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalAntiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)this.mq().getUniqueGroups(this.logicalAntiJoinOnRHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalAntiJoinOnLHSUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalAntiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)this.mq().getUniqueGroups(this.logicalAntiJoinWithEquiAndNonEquiCond(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
    }

    @Test
    public void testGetUniqueGroupsOnUnion() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalUnion(), this.logicalUnionAll(), this.logicalIntersect(), this.logicalIntersectAll(), this.logicalMinus(), this.logicalMinusAll()})).foreach((Function1 & Serializable & scala.Serializable)setOp -> {
            FlinkRelMdUniqueGroupsTest.$anonfun$testGetUniqueGroupsOnUnion$1(this, setOp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetUniqueGroupsOnDefault() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4}), (Object)this.mq().getUniqueGroups((RelNode)this.testRel(), ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)this.mq().getUniqueGroups((RelNode)this.testRel(), ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnTableScan$1(FlinkRelMdUniqueGroupsTest $this, TableScan scan) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of(), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), scan.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{idx}), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnTableScan$3(FlinkRelMdUniqueGroupsTest $this, TableScan scan) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1, 2})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnTableScan$4(FlinkRelMdUniqueGroupsTest $this, TableScan scan) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1, 2})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnExchange$1(FlinkRelMdUniqueGroupsTest $this, RelNode exchange) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups(exchange, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups(exchange, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)$this.mq().getUniqueGroups(exchange, ImmutableBitSet.of((int[])new int[]{1, 2})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnSort$1(FlinkRelMdUniqueGroupsTest $this, RelNode sort) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups(sort, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups(sort, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)$this.mq().getUniqueGroups(sort, ImmutableBitSet.of((int[])new int[]{1, 2})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnAggregate$1(FlinkRelMdUniqueGroupsTest $this, SingleRel agg) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnAggregate$2(FlinkRelMdUniqueGroupsTest $this, SingleRel agg) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2, 3}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2, 3})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnWindowAgg$1(FlinkRelMdUniqueGroupsTest $this, SingleRel agg) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{3, 4, 5, 6}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3, 4, 5, 6})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 3, 4, 5, 6}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3, 4, 5, 6})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnWindowAgg$2(FlinkRelMdUniqueGroupsTest $this, SingleRel agg) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnOverAgg$1(FlinkRelMdUniqueGroupsTest $this, CommonCalc agg) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 2}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 6}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 6})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 6, 7, 8}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{1, 6, 7, 8}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 6, 7, 8})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{6, 7, 8}), (Object)$this.mq().getUniqueGroups((RelNode)agg, ImmutableBitSet.of((int[])new int[]{6, 7, 8})));
    }

    public static final /* synthetic */ void $anonfun$testGetUniqueGroupsOnUnion$1(FlinkRelMdUniqueGroupsTest $this, RelNode setOp) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4}), (Object)$this.mq().getUniqueGroups(setOp, ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4})));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4}), (Object)$this.mq().getUniqueGroups(setOp, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3, 4})));
    }
}

