/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalExpand;
import org.apache.flink.table.planner.plan.nodes.calcite.Rank;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.common.CommonPhysicalWindowTableFunction;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalDataStreamTableScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalExpand;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalOverAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRank;
import org.apache.flink.table.planner.plan.utils.ExpandUtil$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0005\n\u0001C!)a\u0005\u0001C\u0001O!)\u0011\u0006\u0001C\u0001U!)A\b\u0001C\u0001U!)a\b\u0001C\u0001U!)\u0001\t\u0001C\u0001U!)!\t\u0001C\u0001U!)A\t\u0001C\u0001U!)a\t\u0001C\u0001U!)\u0001\n\u0001C\u0001U!)!\n\u0001C\u0001U!)A\n\u0001C\u0001U!)a\n\u0001C\u0001U!)\u0001\u000b\u0001C\u0001U!)!\u000b\u0001C\u0001U!)A\u000b\u0001C\u0001U!)a\u000b\u0001C\u0001U\tIb\t\\5oWJ+G.\u00143TK2,7\r^5wSRLH+Z:u\u0015\t\u0019B#\u0001\u0005nKR\fG-\u0019;b\u0015\t)b#\u0001\u0003qY\u0006t'BA\f\u0019\u0003\u001d\u0001H.\u00198oKJT!!\u0007\u000e\u0002\u000bQ\f'\r\\3\u000b\u0005ma\u0012!\u00024mS:\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA\u00111\u0005J\u0007\u0002%%\u0011QE\u0005\u0002\u001a\r2Lgn\u001b*fY6#\u0007*\u00198eY\u0016\u0014H+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u00111\u0005A\u0001\u001ei\u0016\u001cHoR3u'\u0016dWm\u0019;jm&$\u0018p\u00148UC\ndWmU2b]R\t1\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0003V]&$\bF\u0001\u00023!\t\u0019$(D\u00015\u0015\t)d'A\u0002ba&T!a\u000e\u001d\u0002\u000f),\b/\u001b;fe*\u0011\u0011HH\u0001\u0006UVt\u0017\u000e^\u0005\u0003wQ\u0012A\u0001V3ti\u0006YB/Z:u\u000f\u0016$8+\u001a7fGRLg/\u001b;z\u001f:\u0004&o\u001c6fGRD#a\u0001\u001a\u00025Q,7\u000f^$fiN+G.Z2uSZLG/_(o\r&dG/\u001a:)\u0005\u0011\u0011\u0014\u0001\u0007;fgR<U\r^*fY\u0016\u001cG/\u001b<jif|enQ1mG\"\u0012QAM\u0001\u001bi\u0016\u001cHoR3u'\u0016dWm\u0019;jm&$\u0018p\u00148FqB\fg\u000e\u001a\u0015\u0003\rI\nA\u0004^3ti\u001e+GoU3mK\u000e$\u0018N^5us>sW\t_2iC:<W\r\u000b\u0002\be\u0005AB/Z:u\u000f\u0016$8+\u001a7fGRLg/\u001b;z\u001f:\u0014\u0016M\\6)\u0005!\u0011\u0014\u0001\u0007;fgR<U\r^*fY\u0016\u001cG/\u001b<jif|enU8si\"\u0012\u0011BM\u0001\u001ei\u0016\u001cHoR3u'\u0016dWm\u0019;jm&$\u0018p\u00148BO\u001e\u0014XmZ1uK\"\u0012!BM\u0001\u001ei\u0016\u001cHoR3u'\u0016dWm\u0019;jm&$\u0018p\u00148XS:$wn^!hO\"\u00121BM\u0001\u001ci\u0016\u001cHoR3u'\u0016dWm\u0019;jm&$\u0018p\u00148Pm\u0016\u0014\u0018iZ4)\u00051\u0011\u0014\u0001\u0007;fgR<U\r^*fY\u0016\u001cG/\u001b<jif|eNS8j]\"\u0012QBM\u0001\u001ai\u0016\u001cHoR3u'\u0016dWm\u0019;jm&$\u0018p\u00148V]&|g\u000e\u000b\u0002\u000fe\u0005YB/Z:u\u000f\u0016$8+\u001a7fGRLg/\u001b;z\u001f:$UMZ1vYRD#a\u0004\u001a\u0002OQ,7\u000f^$fiN+G.Z2uSZLG/_(o/&tGm\\<UC\ndWMR;oGRLwN\u001c\u0015\u0003!I\u0002")
public class FlinkRelMdSelectivityTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetSelectivityOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetSelectivityOnProject() {
        this.relBuilder().scan(new String[]{"MyTable3"});
        RexNode expr1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        RexNode expr2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)-1))});
        RexNode expr3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)1.1))});
        this.relBuilder().filter((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)expr1, (List)new .colon.colon((Object)expr2, (List)new .colon.colon((Object)expr3, (List)Nil$.MODULE$)))));
        .colon.colon projects = new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))}), (List)new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().field(1), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)this.relBuilder().getRexBuilder().makeLiteral((Object)BoxesRunTime.boxToDouble((double)2.1), this.relBuilder().getTypeFactory().createSqlType(SqlTypeName.DOUBLE), true), (List)new .colon.colon((Object)this.relBuilder().getRexBuilder().makeLiteral((Object)BoxesRunTime.boxToLong((long)2L), this.relBuilder().getTypeFactory().createSqlType(SqlTypeName.BIGINT), true), (List)Nil$.MODULE$))))));
        RelNode project = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects)).build();
        this.relBuilder().push(project);
        RexNode pred1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.6666666666666666, (Double)this.mq().getSelectivity(project, pred1));
        RexNode pred2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.9090909090909091, (Double)this.mq().getSelectivity(project, pred2));
        RexNode pred3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(4), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.0, (Double)this.mq().getSelectivity(project, pred3));
    }

    @Test
    public void testGetSelectivityOnFilter() {
        this.relBuilder().scan(new String[]{"MyTable3"});
        RexNode expr1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        RexNode expr2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)-1))});
        RexNode expr3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)1.1))});
        RelNode filter = this.relBuilder().filter((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)expr1, (List)new .colon.colon((Object)expr2, (List)new .colon.colon((Object)expr3, (List)Nil$.MODULE$))))).build();
        this.relBuilder().push(filter);
        RexNode pred1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.6666666666666666, (Double)this.mq().getSelectivity(filter, pred1));
        RexNode pred2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.9090909090909091, (Double)this.mq().getSelectivity(filter, pred2));
    }

    @Test
    public void testGetSelectivityOnCalc() {
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable3"}).build();
        this.relBuilder().push(ts);
        .colon.colon projects = new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))}), (List)new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().field(1), (List)new .colon.colon((Object)this.relBuilder().literal((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)this.relBuilder().getRexBuilder().makeLiteral((Object)BoxesRunTime.boxToDouble((double)2.1), this.relBuilder().getTypeFactory().createSqlType(SqlTypeName.DOUBLE), true), (List)new .colon.colon((Object)this.relBuilder().getRexBuilder().makeLiteral((Object)BoxesRunTime.boxToLong((long)2L), this.relBuilder().getTypeFactory().createSqlType(SqlTypeName.BIGINT), true), (List)Nil$.MODULE$))))));
        RelDataType outputRowType = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects)).build().getRowType();
        this.relBuilder().push(ts);
        RexNode expr1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        RexNode expr2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)-1))});
        RexNode expr3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)1.1))});
        RexBuilder rexBuilder = this.relBuilder().getRexBuilder();
        RexNode predicate = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)expr1, (List)new .colon.colon((Object)expr2, (List)new .colon.colon((Object)expr3, (List)Nil$.MODULE$)))), (boolean)true);
        RexProgram program = RexProgram.create((RelDataType)ts.getRowType(), (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)projects), (RexNode)predicate, (RelDataType)outputRowType, (RexBuilder)rexBuilder);
        BatchPhysicalCalc calc = new BatchPhysicalCalc(this.cluster(), this.batchPhysicalTraits(), ts, program, outputRowType);
        this.relBuilder().build();
        this.relBuilder().push((RelNode)calc);
        RexNode pred1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.6666666666666666, (Double)this.mq().getSelectivity((RelNode)calc, pred1));
        RexNode pred2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.9090909090909091, (Double)this.mq().getSelectivity((RelNode)calc, pred2));
        RexNode pred3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(4), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.0, (Double)this.mq().getSelectivity((RelNode)calc, pred3));
    }

    @Test
    public void testGetSelectivityOnExpand() {
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable3"}).project((Iterable)this.relBuilder().fields().subList(0, 2)).build();
        java.util.List expandProjects = ExpandUtil$.MODULE$.createExpandProjects(ts.getCluster().getRexBuilder(), ts.getRowType(), ImmutableBitSet.of((int[])new int[]{0, 1}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0}), (Object)ImmutableBitSet.of((int[])new int[]{1})), (Integer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.class)));
        FlinkLogicalExpand expand = new FlinkLogicalExpand(ts.getCluster(), ts.getTraitSet(), ts, expandProjects, 2);
        this.relBuilder().push((RelNode)expand);
        RexNode predicate1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        Assertions.assertEquals((double)0.3, (Double)this.mq().getSelectivity((RelNode)expand, predicate1));
        RexNode predicate2 = this.relBuilder().and(new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))}), this.relBuilder().equals((RexNode)this.relBuilder().field(2), (RexNode)this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)))});
        Assertions.assertEquals((double)0.075, (Double)this.mq().getSelectivity((RelNode)expand, predicate2));
    }

    @Test
    public void testGetSelectivityOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetSelectivityOnRank() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchGlobalRank(), this.batchLocalRank(), this.streamRank()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnRank$1(this, rank);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRank2(), this.flinkLogicalRank2(), this.batchGlobalRank2(), this.streamRank2()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnRank$2(this, rank);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetSelectivityOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort(), this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchGlobalSortLimit(), this.streamSortLimit(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.streamLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetSelectivityOnAggregate() {
        RelNode agg2 = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("c")}), new RelBuilder.AggCall[]{this.relBuilder().sum(false, "sum_b", (RexNode)this.relBuilder().field("b")), this.relBuilder().max("max_d", (RexNode)this.relBuilder().field("d"))}).build();
        this.relBuilder().push(agg2);
        RexNode pred1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))});
        Assertions.assertEquals((double)0.5098039215686274, (Double)this.mq().getSelectivity(agg2, pred1));
        RexNode pred2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)165))});
        Assertions.assertEquals((double)0.36036036036036057, (Double)this.mq().getSelectivity(agg2, pred2));
        RexNode pred3 = this.relBuilder().and(new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)20))}), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))})});
        Assertions.assertEquals((double)0.22165387894288147, (Double)this.mq().getSelectivity(agg2, pred3));
        this.relBuilder().clear();
        RelNode agg1 = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a")}), new RelBuilder.AggCall[]{this.relBuilder().aggregateCall(FlinkSqlOperatorTable.AUXILIARY_GROUP, false, false, null, "c", new RexNode[]{this.relBuilder().field("c")}), this.relBuilder().sum(false, "sum_b", (RexNode)this.relBuilder().field("b")), this.relBuilder().max("max_d", (RexNode)this.relBuilder().field("d"))}).build();
        this.relBuilder().push(agg1);
        RexNode pred4 = this.relBuilder().and(new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)20))}), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))})});
        Assertions.assertEquals((double)0.008525149190110796, (Double)this.mq().getSelectivity(agg1, pred4));
        this.relBuilder().clear();
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable4"}).build();
        java.util.List expandProjects = ExpandUtil$.MODULE$.createExpandProjects(ts.getCluster().getRexBuilder(), ts.getRowType(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0, 1}), (Object)ImmutableBitSet.of((int[])new int[]{0, 2})), (Integer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.class)));
        LogicalExpand expand = new LogicalExpand(ts.getCluster(), ts.getTraitSet(), ts, expandProjects, 4);
        RelNode aggWithAuxGroupAndExpand = this.relBuilder().push((RelNode)expand).aggregate(this.relBuilder().groupKey((Iterable)this.relBuilder().fields(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)((TraversableOnce)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)Nil$.MODULE$))).toList()))), (java.util.List)Lists.newArrayList((Object[])new AggregateCall[]{AggregateCall.create((SqlAggFunction)FlinkSqlOperatorTable.AUXILIARY_GROUP, (boolean)false, (boolean)false, (boolean)false, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)Nil$.MODULE$)), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)1, (RelNode)ts, null, (String)"b"), AggregateCall.create((SqlAggFunction)FlinkSqlOperatorTable.AUXILIARY_GROUP, (boolean)false, (boolean)false, (boolean)false, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)1, (RelNode)ts, null, (String)"c"), AggregateCall.create((SqlAggFunction)new SqlCountAggFunction("COUNT"), (boolean)false, (boolean)false, (boolean)false, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)2, (RelNode)ts, null, (String)"a")})).build();
        this.relBuilder().push(aggWithAuxGroupAndExpand);
        RexNode predicate3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)2.0))});
        Assertions.assertEquals((double)0.6078431372549019, (Double)this.mq().getSelectivity(aggWithAuxGroupAndExpand, predicate3));
        RexNode predicate4 = this.relBuilder().and(new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)2.0))}), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(3), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)23))})});
        Assertions.assertEquals((double)0.30392156862745096, (Double)this.mq().getSelectivity(aggWithAuxGroupAndExpand, predicate4));
        RexNode predicate5 = this.relBuilder().and(new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))}), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)2.0))}), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(3), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)23))})});
        Assertions.assertEquals((double)0.27911164465786314, (Double)this.mq().getSelectivity(aggWithAuxGroupAndExpand, predicate5));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithLocal(), this.batchGlobalAggWithoutLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAggWithAuxGroup(), this.flinkLogicalAggWithAuxGroup(), this.batchGlobalAggWithLocalWithAuxGroup(), this.batchGlobalAggWithoutLocalWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnAggregate$2(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetSelectivityOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.batchGlobalWindowAggWithLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetSelectivityOnOverAgg() {
        AggregateCall rankAggCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.RANK, (boolean)false, (boolean)false, (boolean)false, (java.util.List)ImmutableList.of(), (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)this.longType(), (String)"rk");
        AggregateCall maxAggCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.MAX, (boolean)false, (boolean)false, (boolean)false, (java.util.List)ImmutableList.of((Object)3), (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)this.doubleType(), (String)"max_d");
        ImmutableList overAggGroups = ImmutableList.of((Object)new Window.Group(ImmutableBitSet.of((int[])new int[]{2}), true, RexWindowBounds.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)new SqlParserPos(0, 0)), null), RexWindowBounds.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)new SqlParserPos(0, 0)), null), RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(1, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST)}), (java.util.List)ImmutableList.of((Object)new Window.RexWinAggCall((SqlAggFunction)SqlStdOperatorTable.RANK, this.longType(), (java.util.List)ImmutableList.of(), 0, false, false), (Object)new Window.RexWinAggCall(SqlStdOperatorTable.MAX, this.doubleType(), Arrays.asList((Object[])new RexNode[]{new RexInputRef(3, this.doubleType())}), 1, false, false))));
        FlinkLogicalDataStreamTableScan scan = (FlinkLogicalDataStreamTableScan)this.createDataStreamScan(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)"MyTable4", (List)Nil$.MODULE$)), this.flinkLogicalTraits());
        RelDataTypeFactory.FieldInfoBuilder builder = this.typeFactory().builder();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(scan.getRowType().getFieldList()).foreach((Function1 & Serializable & scala.Serializable)f -> builder.add(f.getName(), f.getType()));
        builder.add(rankAggCall.getName(), rankAggCall.getType());
        builder.add(maxAggCall.getName(), maxAggCall.getType());
        FlinkLogicalOverAggregate overWindow = new FlinkLogicalOverAggregate(this.cluster(), this.flinkLogicalTraits(), (RelNode)scan, (java.util.List)ImmutableList.of(), builder.build(), (java.util.List)overAggGroups);
        this.relBuilder().push((RelNode)overWindow);
        RexNode pred = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))});
        Assertions.assertEquals((double)0.1836734693877551, (Double)this.mq().getSelectivity((RelNode)overWindow, pred));
        RexNode pred1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))});
        Assertions.assertEquals((double)0.04, (Double)this.mq().getSelectivity((RelNode)overWindow, pred1));
        RexNode pred2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{pred, pred1});
        Assertions.assertEquals((double)0.007346938775510205, (Double)this.mq().getSelectivity((RelNode)overWindow, pred2));
        RexNode pred3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{pred, pred1, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(4), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))})});
        Assertions.assertEquals((double)0.0036734693877551023, (Double)this.mq().getSelectivity((RelNode)overWindow, pred3));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnOverAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetSelectivityOnJoin() {
        RelNode ts = this.relBuilder().scan(new String[]{"MyTable3"}).project((Iterable)this.relBuilder().fields().subList(0, 2)).build();
        RelNode right = this.relBuilder().push(ts).filter(new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))}), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)1.1))})}).build();
        this.relBuilder().push(ts).push(right);
        RexNode joinCondition = RexUtil.composeConjunction((RexBuilder)this.rexBuilder(), (Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 0), this.relBuilder().field(2, 1, 0)}), (List)new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(2, 0, 0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)-1))}), (List)new .colon.colon((Object)this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(2, 1, 1), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)0.1))}), (List)Nil$.MODULE$)))), (boolean)true);
        LogicalJoin join = LogicalJoin.create((RelNode)ts, (RelNode)right, Collections.emptyList(), (RexNode)joinCondition, (java.util.Set)JavaConversions$.MODULE$.deprecated$u0020setAsJavaSet((Set)Predef$.MODULE$.Set().empty()), (JoinRelType)JoinRelType.INNER);
        this.relBuilder().push((RelNode)join);
        RexNode pred1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)0))});
        Assertions.assertEquals((double)0.16666666666666666, (Double)this.mq().getSelectivity((RelNode)join, pred1));
        RexNode pred2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(1), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assertions.assertEquals((double)0.1639344262295082, (Double)this.mq().getSelectivity((RelNode)join, pred2));
        RexNode pred3 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(2), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)3))});
        Assertions.assertEquals((double)1.0, (Double)this.mq().getSelectivity((RelNode)join, pred3));
        RexNode pred4 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(3), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)0))});
        Assertions.assertEquals((double)0.0, (Double)this.mq().getSelectivity((RelNode)join, pred4));
        Assertions.assertEquals((double)3.125E-8, (Double)this.mq().getSelectivity(this.logicalSemiJoinOnUniqueKeys(), pred1));
        RexNode pred5 = this.relBuilder().push(this.logicalSemiJoinNotOnUniqueKeys()).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToLong((long)100000000L))});
        Assertions.assertEquals((double)0.5, (Double)this.mq().getSelectivity(this.logicalSemiJoinNotOnUniqueKeys(), pred5));
        RexNode pred6 = this.relBuilder().push(this.logicalAntiJoinWithoutEquiCond()).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToLong((long)100L))});
        Assertions.assertEquals((double)0.375, (Double)this.mq().getSelectivity(this.logicalAntiJoinWithoutEquiCond(), pred6));
        RexNode pred7 = this.relBuilder().push(this.logicalAntiJoinNotOnUniqueKeys()).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToLong((long)100000000L))});
        Assertions.assertEquals((double)0.05, (Double)this.mq().getSelectivity(this.logicalAntiJoinNotOnUniqueKeys(), pred7));
    }

    @Test
    public void testGetSelectivityOnUnion() {
        RelNode union = this.relBuilder().scan(new String[]{"MyTable4"}).project((Iterable)this.relBuilder().fields().subList(0, 2)).scan(new String[]{"MyTable3"}).project((Iterable)this.relBuilder().fields().subList(0, 2)).union(true).build();
        RexNode pred = this.relBuilder().push(union).call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        Assertions.assertEquals((double)0.473469387755102, (Double)this.mq().getSelectivity(union, pred));
    }

    @Test
    public void testGetSelectivityOnDefault() {
        RexNode pred = this.relBuilder().push((RelNode)this.testRel()).call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        Assertions.assertEquals((double)0.5, (Double)this.mq().getSelectivity((RelNode)this.testRel(), pred));
    }

    @Test
    public void testGetSelectivityOnWindowTableFunction() {
        RexNode predicate = this.relBuilder().push((RelNode)this.windowTableFunctionScan()).in((RexNode)this.relBuilder().field(0), new RexNode[]{this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1)), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)3)), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5)), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)7))});
        Assertions.assertEquals((double)0.25, (Double)this.mq().getSelectivity((RelNode)this.windowTableFunctionScan(), predicate));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonPhysicalWindowTableFunction[]{this.streamTumbleWindowTVFRel(), this.batchTumbleWindowTVFRel()})).foreach((Function1 & Serializable & scala.Serializable)tvf -> {
            FlinkRelMdSelectivityTest.$anonfun$testGetSelectivityOnWindowTableFunction$1(this, predicate, tvf);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnTableScan$1(FlinkRelMdSelectivityTest $this, TableScan scan) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getSelectivity((RelNode)scan, null));
        RexNode condition1 = $this.relBuilder().push((RelNode)$this.studentLogicalScan()).call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))});
        Assertions.assertEquals((double)0.14285714285714285, (Double)$this.mq().getSelectivity((RelNode)scan, condition1));
        RexNode condition2 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)4.0))})});
        Assertions.assertEquals((double)0.054421768707482984, (Double)$this.mq().getSelectivity((RelNode)scan, condition2));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnExchange$1(FlinkRelMdSelectivityTest $this, RelNode exchange) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getSelectivity(exchange, null));
        RexNode condition1 = $this.relBuilder().push((RelNode)$this.studentLogicalScan()).call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))});
        Assertions.assertEquals((double)0.14285714285714285, (Double)$this.mq().getSelectivity(exchange, condition1));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnRank$1(FlinkRelMdSelectivityTest $this, RelNode rank) {
        BatchPhysicalRank batchPhysicalRank;
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getSelectivity(rank, null));
        $this.relBuilder().push(rank);
        RexNode condition1 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))});
        Assertions.assertEquals((double)0.14285714285714285, (Double)$this.mq().getSelectivity(rank, condition1));
        RelNode relNode = rank;
        if (relNode instanceof BatchPhysicalRank && !(batchPhysicalRank = (BatchPhysicalRank)relNode).isGlobal()) {
            return;
        }
        RexNode condition2 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(7), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        Assertions.assertEquals((double)0.75, (Double)$this.mq().getSelectivity(rank, condition2));
        RexNode condition3 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(7), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))})});
        Assertions.assertEquals((double)0.375, (Double)$this.mq().getSelectivity(rank, condition3));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnRank$2(FlinkRelMdSelectivityTest $this, Rank rank) {
        RexNode condition1 = $this.relBuilder().push((RelNode)rank).call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{$this.relBuilder().field(7), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        Assertions.assertEquals((double)0.0, (Double)$this.mq().getSelectivity((RelNode)rank, condition1));
        RexNode condition2 = $this.relBuilder().push((RelNode)rank).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{$this.relBuilder().field(7), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)2))});
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getSelectivity((RelNode)rank, condition2));
        RexNode condition3 = $this.relBuilder().push((RelNode)rank).call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(7), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)4))});
        Assertions.assertEquals((double)0.3333333333333333, (Double)$this.mq().getSelectivity((RelNode)rank, condition3));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnSort$1(FlinkRelMdSelectivityTest $this, RelNode sort) {
        Assertions.assertEquals((double)1.0, (Double)$this.mq().getSelectivity(sort, null));
        RexNode condition1 = $this.relBuilder().push((RelNode)$this.studentLogicalScan()).call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))});
        Assertions.assertEquals((double)0.14285714285714285, (Double)$this.mq().getSelectivity(sort, condition1));
        RexNode condition2 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)4.0))})});
        Assertions.assertEquals((double)0.054421768707482984, (Double)$this.mq().getSelectivity(sort, condition2));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnAggregate$1(FlinkRelMdSelectivityTest $this, SingleRel agg) {
        $this.relBuilder().clear();
        $this.relBuilder().push((RelNode)agg);
        RexNode predicate = $this.relBuilder().and(new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)10.0))})});
        Assertions.assertEquals((double)0.495, (Double)$this.mq().getSelectivity((RelNode)agg, predicate));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnAggregate$2(FlinkRelMdSelectivityTest $this, SingleRel agg) {
        RexNode predicate = $this.relBuilder().and(new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)170.0))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)10.0))})});
        Assertions.assertEquals((double)0.187297, (double)Predef$.MODULE$.Double2double($this.mq().getSelectivity((RelNode)agg, predicate)), (double)1.0E-6);
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnWindowAgg$1(FlinkRelMdSelectivityTest $this, SingleRel agg) {
        $this.relBuilder().clear();
        $this.relBuilder().push((RelNode)agg);
        RexNode predicate1 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))});
        Assertions.assertEquals((double)0.75, (Double)$this.mq().getSelectivity((RelNode)agg, predicate1));
        RexNode predicate2 = $this.relBuilder().and(new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(4), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1000000))})});
        Assertions.assertEquals((double)0.11249999999999999, (Double)$this.mq().getSelectivity((RelNode)agg, predicate2));
        RexNode predicate3 = $this.relBuilder().and(new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)100))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(4), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1000000))})});
        Assertions.assertEquals((double)0.001125, (Double)$this.mq().getSelectivity((RelNode)agg, predicate3));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnWindowAgg$2(FlinkRelMdSelectivityTest $this, SingleRel agg) {
        $this.relBuilder().clear();
        $this.relBuilder().push((RelNode)agg);
        RexNode predicate4 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))});
        Assertions.assertEquals((double)0.8, (Double)$this.mq().getSelectivity((RelNode)agg, predicate4));
        RexNode predicate5 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(1), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))});
        Assertions.assertEquals((double)0.7, (Double)$this.mq().getSelectivity((RelNode)agg, predicate5));
        RexNode predicate6 = $this.relBuilder().and(new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(1), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)100))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(4), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1000000))})});
        Assertions.assertEquals((double)8.399999999999999E-4, (Double)$this.mq().getSelectivity((RelNode)agg, predicate6));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnOverAgg$2(FlinkRelMdSelectivityTest $this, CommonCalc agg) {
        $this.relBuilder().clear();
        $this.relBuilder().push((RelNode)agg);
        RexNode pred1 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)4.0))});
        Assertions.assertEquals((double)0.38095238095238093, (Double)$this.mq().getSelectivity((RelNode)agg, pred1));
        RexNode pred2 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{pred1, $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(9), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)4.5))})});
        Assertions.assertEquals((double)0.19047619047619047, (Double)$this.mq().getSelectivity((RelNode)agg, pred2));
    }

    public static final /* synthetic */ void $anonfun$testGetSelectivityOnWindowTableFunction$1(FlinkRelMdSelectivityTest $this, RexNode predicate$1, CommonPhysicalWindowTableFunction tvf) {
        Assertions.assertEquals((double)0.6, (Double)$this.mq().getSelectivity((RelNode)tvf, predicate$1));
    }
}

