/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.calcite.Expand;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.calcite.Rank;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.common.CommonPhysicalWindowTableFunction;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00054A\u0001F\u000b\u0001I!)\u0011\u0006\u0001C\u0001U!)A\u0006\u0001C\u0001[!)q\b\u0001C\u0001[!)\u0011\t\u0001C\u0001[!)1\t\u0001C\u0001[!)Q\t\u0001C\u0001[!)q\t\u0001C\u0001[!)\u0011\n\u0001C\u0001[!)1\n\u0001C\u0001[!)Q\n\u0001C\u0001[!)q\n\u0001C\u0001[!)\u0011\u000b\u0001C\u0001[!)1\u000b\u0001C\u0001[!)Q\u000b\u0001C\u0001[!)q\u000b\u0001C\u0001[!)\u0011\f\u0001C\u0001[!)1\f\u0001C\u0001[!)Q\f\u0001C\u0001[!)q\f\u0001C\u0001[\t1b\t\\5oWJ+G.\u00143S_^\u001cu.\u001e8u)\u0016\u001cHO\u0003\u0002\u0017/\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u00193\u0005!\u0001\u000f\\1o\u0015\tQ2$A\u0004qY\u0006tg.\u001a:\u000b\u0005qi\u0012!\u0002;bE2,'B\u0001\u0010 \u0003\u00151G.\u001b8l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\n\t\u0003M\u001dj\u0011!F\u0005\u0003QU\u0011\u0011D\u00127j].\u0014V\r\\'e\u0011\u0006tG\r\\3s)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003M\u0001\t!\u0004^3ti\u001e+GOU8x\u0007>,h\u000e^(o)\u0006\u0014G.Z*dC:$\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0005+:LG\u000f\u000b\u0002\u0003kA\u0011a'P\u0007\u0002o)\u0011\u0001(O\u0001\u0004CBL'B\u0001\u001e<\u0003\u001dQW\u000f]5uKJT!\u0001P\u0011\u0002\u000b),h.\u001b;\n\u0005y:$\u0001\u0002+fgR\fq\u0003^3ti\u001e+GOU8x\u0007>,h\u000e^(o-\u0006dW/Z:)\u0005\r)\u0014\u0001\u0007;fgR<U\r\u001e*po\u000e{WO\u001c;P]B\u0013xN[3di\"\u0012A!N\u0001\u0018i\u0016\u001cHoR3u%><8i\\;oi>sg)\u001b7uKJD#!B\u001b\u0002+Q,7\u000f^$fiJ{woQ8v]R|enQ1mG\"\u0012a!N\u0001\u0018i\u0016\u001cHoR3u%><8i\\;oi>sW\t\u001f9b]\u0012D#aB\u001b\u00023Q,7\u000f^$fiJ{woQ8v]R|e.\u0012=dQ\u0006tw-\u001a\u0015\u0003\u0011U\nQ\u0003^3ti\u001e+GOU8x\u0007>,h\u000e^(o%\u0006t7\u000e\u000b\u0002\nk\u0005)B/Z:u\u000f\u0016$(k\\<D_VtGo\u00148T_J$\bF\u0001\u00066\u0003i!Xm\u001d;HKR\u0014vn^\"pk:$xJ\\!hOJ,w-\u0019;fQ\tYQ'\u0001\u000euKN$x)\u001a;S_^\u001cu.\u001e8u\u001f:<\u0016N\u001c3po\u0006;w\r\u000b\u0002\rk\u0005AB/Z:u\u000f\u0016$(k\\<D_VtGo\u00148Pm\u0016\u0014\u0018iZ4)\u00055)\u0014!\u0006;fgR<U\r\u001e*po\u000e{WO\u001c;P]*{\u0017N\u001c\u0015\u0003\u001dU\n!\u0004^3ti\u001e+GOU8x\u0007>,h\u000e^(o\u001fZ,'/\u00168j_:D#aD\u001b\u0002=Q,7\u000f^$fiJ{woQ8v]R|en\u0014<fe&sG/\u001a:tK\u000e$\bF\u0001\t6\u0003i!Xm\u001d;HKR\u0014vn^\"pk:$xJ\\(wKJl\u0015N\\;tQ\t\tR'\u0001\u000fuKN$x)\u001a;S_^\u001cu.\u001e8u\u001f:|e/\u001a:EK\u001a\fW\u000f\u001c;)\u0005I)\u0014\u0001\n;fgR<U\r\u001e*po\u000e{WO\u001c;P]^Kg\u000eZ8x)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8)\u0005M)\u0004")
public class FlinkRelMdRowCountTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetRowCountOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.empLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnTableScan$2(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnValues() {
        Assertions.assertEquals((double)4.0, (Double)this.mq().getRowCount((RelNode)this.logicalValues()));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getRowCount((RelNode)this.emptyValues()));
    }

    @Test
    public void testGetRowCountOnProject() {
        Assertions.assertEquals((double)50.0, (Double)this.mq().getRowCount((RelNode)this.logicalProject()));
    }

    @Test
    public void testGetRowCountOnFilter() {
        Assertions.assertEquals((double)25.0, (Double)this.mq().getRowCount(this.logicalFilter()));
    }

    @Test
    public void testGetRowCountOnCalc() {
        Assertions.assertEquals((double)25.0, (Double)this.mq().getRowCount((RelNode)this.logicalCalc()));
    }

    @Test
    public void testGetRowCountOnExpand() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Expand[]{this.logicalExpand(), this.flinkLogicalExpand(), this.batchExpand(), this.streamExpand()})).foreach((Function1 & Serializable & scala.Serializable)expand -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnExpand$1(this, expand);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnRank() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchLocalRank(), this.streamRank()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$1(this, rank);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((double)1.0, (Double)this.mq().getRowCount(this.batchGlobalRank()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRank2(), this.flinkLogicalRank2(), this.batchLocalRank2(), this.streamRank2()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$2(this, rank);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((double)21.0, (Double)this.mq().getRowCount((RelNode)this.batchGlobalRank2()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRowNumber(), this.flinkLogicalRowNumber(), this.streamRowNumber()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$3(this, rank);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRankWithVariableRange(), this.flinkLogicalRankWithVariableRange(), this.streamRankWithVariableRange()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$4(this, rank);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchSortLimit(), this.streamSortLimit(), this.batchGlobalSortLimit(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.batchGlobalLimit(), this.streamLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnSort$2(this, sort);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchLocalSortLimit(), this.batchLocalLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnSort$3(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithLocal(), this.batchGlobalAggWithoutLocal(), this.batchLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StreamPhysicalGroupAggregateBase[]{this.streamGlobalAggWithLocal(), this.streamGlobalAggWithoutLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnAggregate$2(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAggWithAuxGroup(), this.flinkLogicalAggWithAuxGroup(), this.batchGlobalAggWithoutLocalWithAuxGroup(), this.batchGlobalAggWithLocalWithAuxGroup(), this.batchLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnAggregate$3(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchLocalWindowAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.batchGlobalWindowAggWithLocalAgg(), this.streamWindowAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchLocalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
        this.relBuilder().clear();
        RelNode ts = this.relBuilder().scan(new String[]{"TemporalTable3"}).peek();
        ArrayList aggCallOfWindowAgg = Lists.newArrayList((Object[])new AggregateCall[]{AggregateCall.create((SqlAggFunction)new SqlCountAggFunction("COUNT"), (boolean)false, (boolean)false, (boolean)false, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)2, (RelNode)ts, null, (String)"s")});
        LogicalWindowAggregate windowAgg = new LogicalWindowAggregate(ts.getCluster(), ts.getTraitSet(), ts, ImmutableBitSet.of((int[])new int[]{0, 1}), (java.util.List)aggCallOfWindowAgg, this.tumblingGroupWindow(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(this.namedPropertiesOfWindowAgg()));
        Assertions.assertEquals((double)4.0E9, (Double)this.mq().getRowCount((RelNode)windowAgg));
    }

    @Test
    public void testGetRowCountOnOverAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnOverAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnJoin() {
        Assertions.assertEquals((double)50.0, (Double)this.mq().getRowCount(this.logicalInnerJoinOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalInnerJoinNotOnUniqueKeys()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalInnerJoinOnRHSUniqueKeys()));
        Assertions.assertEquals((double)1.0E7, (Double)this.mq().getRowCount(this.logicalInnerJoinWithEquiAndNonEquiCond()));
        Assertions.assertEquals((double)8.0E15, (Double)this.mq().getRowCount(this.logicalInnerJoinWithoutEquiCond()));
        Assertions.assertEquals((double)1.0, (Double)this.mq().getRowCount(this.logicalInnerJoinOnDisjointKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalLeftJoinOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalLeftJoinNotOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalLeftJoinOnLHSUniqueKeys()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalLeftJoinOnRHSUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalLeftJoinWithEquiAndNonEquiCond()));
        Assertions.assertEquals((double)8.0E15, (Double)this.mq().getRowCount(this.logicalLeftJoinWithoutEquiCond()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalLeftJoinOnDisjointKeys()));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getRowCount(this.logicalRightJoinOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalRightJoinNotOnUniqueKeys()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalRightJoinOnLHSUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalRightJoinOnRHSUniqueKeys()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalRightJoinWithEquiAndNonEquiCond()));
        Assertions.assertEquals((double)8.0E15, (Double)this.mq().getRowCount(this.logicalRightJoinWithoutEquiCond()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalRightJoinOnDisjointKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalFullJoinOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalFullJoinNotOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalFullJoinOnLHSUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalFullJoinOnRHSUniqueKeys()));
        Assertions.assertEquals((double)8.1E8, (Double)this.mq().getRowCount(this.logicalFullJoinWithEquiAndNonEquiCond()));
        Assertions.assertEquals((double)8.0E15, (Double)this.mq().getRowCount(this.logicalFullJoinWithoutEquiCond()));
        Assertions.assertEquals((double)8.2E8, (Double)this.mq().getRowCount(this.logicalFullJoinOnDisjointKeys()));
        Assertions.assertEquals((double)50.0, (Double)this.mq().getRowCount(this.logicalSemiJoinOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalSemiJoinNotOnUniqueKeys()));
        Assertions.assertEquals((double)2556.0, (Double)this.mq().getRowCount(this.logicalSemiJoinOnLHSUniqueKeys()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalSemiJoinOnRHSUniqueKeys()));
        Assertions.assertEquals((double)1278.0, (Double)this.mq().getRowCount(this.logicalSemiJoinWithEquiAndNonEquiCond()));
        Assertions.assertEquals((double)4.0E8, (Double)this.mq().getRowCount(this.logicalSemiJoinWithoutEquiCond()));
        Assertions.assertEquals((double)8.0E8, (Double)this.mq().getRowCount(this.logicalSemiJoinOnDisjointKeys()));
        Assertions.assertEquals((double)7.9999995E8, (Double)this.mq().getRowCount(this.logicalAntiJoinOnUniqueKeys()));
        Assertions.assertEquals((double)8.0E7, (Double)this.mq().getRowCount(this.logicalAntiJoinNotOnUniqueKeys()));
        Assertions.assertEquals((double)7.99997444E8, (Double)this.mq().getRowCount(this.logicalAntiJoinOnLHSUniqueKeys()));
        Assertions.assertEquals((double)2000000.0, (Double)this.mq().getRowCount(this.logicalAntiJoinOnRHSUniqueKeys()));
        Assertions.assertEquals((double)6.0E8, (Double)this.mq().getRowCount(this.logicalAntiJoinWithEquiAndNonEquiCond()));
        Assertions.assertEquals((double)6.0E8, (Double)this.mq().getRowCount(this.logicalAntiJoinWithoutEquiCond()));
        Assertions.assertEquals((double)8.0E7, (Double)this.mq().getRowCount(this.logicalAntiJoinOnDisjointKeys()));
    }

    @Test
    public void testGetRowCountOnOverUnion() {
        Assertions.assertEquals((double)8.2E8, (Double)this.mq().getRowCount(this.logicalUnion()));
        Assertions.assertEquals((double)8.2E8, (Double)this.mq().getRowCount(this.logicalUnionAll()));
    }

    @Test
    public void testGetRowCountOnOverIntersect() {
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalIntersect()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalIntersectAll()));
    }

    @Test
    public void testGetRowCountOnOverMinus() {
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalMinus()));
        Assertions.assertEquals((double)2.0E7, (Double)this.mq().getRowCount(this.logicalMinusAll()));
    }

    @Test
    public void testGetRowCountOnOverDefault() {
        Assertions.assertEquals((double)50.0, (Double)this.mq().getRowCount((RelNode)this.testRel()));
    }

    @Test
    public void testGetRowCountOnWindowTableFunction() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonPhysicalWindowTableFunction[]{this.batchTumbleWindowTVFRel(), this.streamTumbleWindowTVFRel()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowTableFunction$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonPhysicalWindowTableFunction[]{this.batchHopWindowTVFRel(), this.batchCumulateWindowTVFRel(), this.streamHopWindowTVFRel(), this.streamCumulateWindowTVFRel()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowTableFunction$2(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnTableScan$1(FlinkRelMdRowCountTest $this, TableScan scan) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount((RelNode)scan));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnTableScan$2(FlinkRelMdRowCountTest $this, TableScan scan) {
        Assertions.assertEquals((double)1.0E8, (Double)$this.mq().getRowCount((RelNode)scan));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnExpand$1(FlinkRelMdRowCountTest $this, Expand expand) {
        Assertions.assertEquals((double)150.0, (Double)$this.mq().getRowCount((RelNode)expand));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnExchange$1(FlinkRelMdRowCountTest $this, RelNode exchange) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount(exchange));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$1(FlinkRelMdRowCountTest $this, RelNode rank) {
        Assertions.assertEquals((double)5.0, (Double)$this.mq().getRowCount(rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$2(FlinkRelMdRowCountTest $this, Rank rank) {
        Assertions.assertEquals((double)(7.0 * Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.getRankRangeNdv(rank.rankRange()))), (Double)$this.mq().getRowCount((RelNode)rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$3(FlinkRelMdRowCountTest $this, Rank rank) {
        Assertions.assertEquals((double)4.0, (Double)$this.mq().getRowCount((RelNode)rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$4(FlinkRelMdRowCountTest $this, Rank rank) {
        Assertions.assertEquals((double)5.0, (Double)$this.mq().getRowCount((RelNode)rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnSort$1(FlinkRelMdRowCountTest $this, RelNode sort) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount(sort));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnSort$2(FlinkRelMdRowCountTest $this, RelNode sort) {
        Assertions.assertEquals((double)20.0, (Double)$this.mq().getRowCount(sort));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnSort$3(FlinkRelMdRowCountTest $this, RelNode sort) {
        Assertions.assertEquals((double)30.0, (Double)$this.mq().getRowCount(sort));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnAggregate$1(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assertions.assertEquals((double)7.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnAggregate$2(FlinkRelMdRowCountTest $this, StreamPhysicalGroupAggregateBase agg) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnAggregate$3(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowAgg$1(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowAgg$2(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnOverAgg$1(FlinkRelMdRowCountTest $this, CommonCalc agg) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowTableFunction$1(FlinkRelMdRowCountTest $this, CommonPhysicalWindowTableFunction agg) {
        Assertions.assertEquals((double)50.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowTableFunction$2(FlinkRelMdRowCountTest $this, CommonPhysicalWindowTableFunction agg) {
        Assertions.assertEquals((double)300.0, (Double)$this.mq().getRowCount((RelNode)agg));
    }
}

