/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.common.ViewsExpandingTest$;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtilBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\n\u0015\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006i\u0001!\t!\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\u0006\u0013\u0002!\tA\u000f\u0005\u0006\u0017\u0002!\tA\u000f\u0005\u0006\u001b\u0002!\tA\u000f\u0005\u0006\u001f\u0002!\tA\u000f\u0005\u0006#\u0002!\tA\u000f\u0005\u0006'\u0002!\tA\u000f\u0005\u0006+\u0002!\tA\u000f\u0005\u0006/\u0002!I\u0001W\u0004\b\u0003\u0007!\u0002\u0012AA\u0003\r\u0019\u0019B\u0003#\u0001\u0002\b!1A'\u0004C\u0001\u0003\u001fAq!!\u0005\u000e\t\u0003\t\u0019B\u0002\u0004\u000265\u0001\u0011q\u0007\u0005\u0007iA!\t!!\u0012\t\u000f\u0005-\u0003\u0003\"\u0001\u0002N\t\u0011b+[3xg\u0016C\b/\u00198eS:<G+Z:u\u0015\t)b#\u0001\u0004d_6lwN\u001c\u0006\u0003/a\tA\u0001\u001d7b]*\u0011\u0011DG\u0001\ba2\fgN\\3s\u0015\tYB$A\u0003uC\ndWM\u0003\u0002\u001e=\u0005)a\r\\5oW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dB\u0012!B;uS2\u001c\u0018BA\u0015'\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u0006iA/\u00192mKR+7\u000f^+uS2\u0004B\u0001L\u0018%c5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0005Gk:\u001cG/[8ocA\u0011QEM\u0005\u0003g\u0019\u0012Q\u0002V1cY\u0016$Vm\u001d;Vi&d\u0017A\u0002\u001fj]&$h\b\u0006\u00027qA\u0011q\u0007A\u0007\u0002)!)!F\u0001a\u0001W\u0005qB/Z:u\u001b&DX\rZ*rYR\u000b'\r\\3WS\u0016<X\t\u001f9b]\u0012Lgn\u001a\u000b\u0002wA\u0011A\u0006P\u0005\u0003{5\u0012A!\u00168ji\"\u00121a\u0010\t\u0003\u0001\u001ek\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1!\u00199j\u0015\t!U)A\u0004kkBLG/\u001a:\u000b\u0005\u0019\u0003\u0013!\u00026v]&$\u0018B\u0001%B\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0003U!Xm\u001d;UC\ndW-\u00119j\u000bb\u0004\u0018M\u001c3j]\u001eD#\u0001B \u0002!Q,7\u000f^*rY\u0016C\b/\u00198eS:<\u0007FA\u0003@\u0003\u0011\"Xm\u001d;WS\u0016<X\t\u001f9b]\u0012LgnZ,ji\"l\u0015n]7bi\u000eD'k\\<UsB,\u0007F\u0001\u0004@\u0003%\"Xm\u001d;WS\u0016<X\t\u001f9b]\u0012LgnZ,ji\"d\u0015\r^3sC2$\u0016M\u00197f\rVt7\r^5p]\"\u0012qaP\u0001%i\u0016\u001cHOV5fo\u0016C\b/\u00198eS:<w+\u001b;i\u0005VLG\u000e^5o\rVt7\r^5p]\"\u0012\u0001bP\u0001\u0019i\u0016\u001cHOV5fo\u0016C\b/\u00198eS:<w+\u001b;i+\u00123\u0005FA\u0005@\u0003y!Xm\u001d;FqB\fg\u000eZ)vKJLx+\u001b;i'f\u001cH/Z7BY&\f7\u000f\u000b\u0002\u000b\u007f\u0005i1M]3bi\u0016\u001c\u0016\u000f\u001c,jK^$\"!W0\u0011\u0005ikV\"A.\u000b\u0005qS\u0012aB2bi\u0006dwnZ\u0005\u0003=n\u00131bQ1uC2|wMV5fo\")\u0001m\u0003a\u0001C\u0006YqN]5hS:$\u0016M\u00197f!\t\u0011\u0017N\u0004\u0002dOB\u0011A-L\u0007\u0002K*\u0011aMI\u0001\u0007yI|w\u000e\u001e \n\u0005!l\u0013A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001[\u0017)\t\u0001i7\u000f\u001e\t\u0003]Fl\u0011a\u001c\u0006\u0003a\u0006\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005I|'AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\nQoI\u0001w!\t9x0D\u0001y\u0015\tI(0A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0003wr\f!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\t1UP\u0003\u0002\u007f9\u0005IA/Z:ukRLGn]\u0005\u0004\u0003\u0003A(A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017A\u0005,jK^\u001cX\t\u001f9b]\u0012Lgn\u001a+fgR\u0004\"aN\u0007\u0014\u00075\tI\u0001E\u0002-\u0003\u0017I1!!\u0004.\u0005\u0019\te.\u001f*fMR\u0011\u0011QA\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA\u000b!\u0019\t9\"!\t\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003vi&d'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012\u0011\u0004\u0002\u000b\u0007>dG.Z2uS>t\u0007#\u0002\u00170I\u0005\u001d\u0002cA\u0013\u0002*%\u0019\u00111\u0006\u0014\u0003#Q\u000b'\r\\3UKN$X\u000b^5m\u0005\u0006\u001cX\rK\u0002\u0010\u0003_\u00012a^A\u0019\u0013\r\t\u0019\u0004\u001f\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(a\u0006)sS6LG/\u001b<f'\u000e\fG.\u0019:Gk:\u001cG/[8o'\r\u0001\u0012\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u000e\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018\u0002BA\"\u0003{\u0011abU2bY\u0006\u0014h)\u001e8di&|g\u000e\u0006\u0002\u0002HA\u0019\u0011\u0011\n\t\u000e\u00035\tA!\u001a<bYRA\u0011qJA+\u0003?\n\u0019\u0007E\u0002-\u0003#J1!a\u0015.\u0005\u0011auN\\4\t\u000f\u0005]#\u00031\u0001\u0002Z\u0005\t\u0011\u000eE\u0002-\u00037J1!!\u0018.\u0005\rIe\u000e\u001e\u0005\b\u0003C\u0012\u0002\u0019AA(\u0003\u0005a\u0007BBA3%\u0001\u0007\u0011-A\u0001t\u0001")
public class ViewsExpandingTest
extends TableTestBase {
    private final Function1<TableTestBase, TableTestUtil> tableTestUtil;

    @Parameters
    public static Collection<Function1<TableTestBase, TableTestUtilBase>> parameters() {
        return ViewsExpandingTest$.MODULE$.parameters();
    }

    @TestTemplate
    public void testMixedSqlTableViewExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        tableEnv.createTemporaryView("view4", tableEnv.from("view3"));
        tableUtil.verifyExecPlan("select * from view4");
    }

    @TestTemplate
    public void testTableApiExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        tableEnv.createTemporaryView("view1", tableEnv.from("t1"));
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        tableEnv.createTemporaryView("view3", tableEnv.from("view2"));
        Table query = tableEnv.from("view3");
        tableUtil.verifyExecPlan(query);
    }

    @TestTemplate
    public void testSqlExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view2"), (CatalogBaseTable)this.createSqlView("view1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        String query = "SELECT * FROM view3";
        tableUtil.verifyExecPlan(query);
    }

    @TestTemplate
    public void testViewExpandingWithMismatchRowType() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String originTableName = "t1";
        tableUtil.addDataStream(originTableName, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        CatalogView aggSqlView = CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"b", (DataType)DataTypes.STRING()), Column.physical((String)"c", (DataType)DataTypes.INT())})).build(), (String)"", (String)new StringBuilder(41).append("select a, b, count(c) from ").append(originTableName).append(" group by a, b").toString(), (String)new StringBuilder(41).append("select a, b, count(c) from ").append(originTableName).append(" group by a, b").toString(), new HashMap());
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)aggSqlView, false);
        tableUtil.verifyExecPlan("select * from view1");
    }

    @TestTemplate
    public void testViewExpandingWithLateralTableFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporarySystemFunction("myFunc", (UserDefinedFunction)new TableFunc0());
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT f0, f1\n        |  FROM source as S, LATERAL TABLE(myFunc(f0)) as T(f1, f2)\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        tableUtil.verifyExecPlan("select * from tmp_view");
    }

    @TestTemplate
    public void testViewExpandingWithBuiltinFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT CONCAT('a', 'bc', 'def')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assertions.assertThat((String)((CatalogView)view).getExpandedQuery()).isEqualTo("SELECT `CONCAT`('a', 'bc', 'def')");
    }

    @TestTemplate
    public void testViewExpandingWithUDF() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryFunction("func", PrimitiveScalarFunction.class);
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT func(1, 2, 'abc')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assertions.assertThat((String)((CatalogView)view).getExpandedQuery()).isEqualTo("SELECT `default_catalog`.`default_database`.`func`(1, 2, 'abc')");
    }

    @TestTemplate
    public void testExpandQueryWithSystemAlias() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |create view tmp_view as\n        |select * from (\n        |  select f0,\n        |  row_number() over (partition by f0 order by f0 desc) as rowNum\n        |  from source)\n        |  where rowNum = 1\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assertions.assertThat((String)((CatalogView)view).getExpandedQuery()).isEqualTo("SELECT *\nFROM (SELECT `source`.`f0`, ROW_NUMBER() OVER (PARTITION BY `source`.`f0` ORDER BY `source`.`f0` DESC) AS `rowNum`\nFROM `default_catalog`.`default_database`.`source`)\nWHERE `rowNum` = 1");
    }

    private CatalogView createSqlView(String originTable) {
        return CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.INT()), Column.physical((String)"b", (DataType)DataTypes.STRING()), Column.physical((String)"c", (DataType)DataTypes.INT())})).build(), (String)"", (String)new StringBuilder(19).append("select * as c from ").append(originTable).toString(), (String)new StringBuilder(14).append("select * from ").append(originTable).toString(), new HashMap());
    }

    public ViewsExpandingTest(Function1<TableTestBase, TableTestUtil> tableTestUtil) {
        this.tableTestUtil = tableTestUtil;
    }

    public static class PrimitiveScalarFunction
    extends ScalarFunction {
        public long eval(int i, long l, String s) {
            return (long)i + l + (long)s.length();
        }
    }
}

