/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.common.JoinReorderTestBase$;
import org.apache.flink.table.planner.plan.rules.logical.JoinDeriveNullFilterRule;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d!\u0002\u0013&\u0003\u0003!\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u000b\t\u0003A\u0011A\"\t\u000f\u001d\u0003!\u0019!C\t\u0011\"1A\n\u0001Q\u0001\n%CQ!\u0014\u0001\u0007\u0012!CQA\u0014\u0001\u0005\u0002=CQA\u0018\u0001\u0005\u0002=CQa\u0019\u0001\u0005\u0002=CQ!\u001a\u0001\u0005\u0002=CQa\u001a\u0001\u0005\u0002=CQ!\u001b\u0001\u0005\u0002=CQa\u001b\u0001\u0005\u0002=CQ!\u001c\u0001\u0005\u0002=CQa\u001c\u0001\u0005\u0002=CQ!\u001d\u0001\u0005\u0002=CQa\u001d\u0001\u0005\u0002=CQ!\u001e\u0001\u0005\u0002=CQa\u001e\u0001\u0005\u0002=CQ!\u001f\u0001\u0005\u0002=CQa\u001f\u0001\u0005\u0002=CQ! \u0001\u0005\u0002=CQa \u0001\u0005\u0002=Ca!a\u0001\u0001\t\u0003y\u0005BBA\u0004\u0001\u0011\u0005q\n\u0003\u0004\u0002\f\u0001!\ta\u0014\u0005\u0007\u0003\u001f\u0001A\u0011A(\t\r\u0005M\u0001\u0001\"\u0001P\u0011\u0019\t9\u0002\u0001C\u0001\u001f\"1\u00111\u0004\u0001\u0005\u0002=Ca!a\b\u0001\t\u0003y\u0005BBA\u0012\u0001\u0011\u0005qjB\u0004\u0002(\u0015B\t!!\u000b\u0007\r\u0011*\u0003\u0012AA\u0016\u0011\u0019\u0011\u0015\u0005\"\u0001\u00024!9\u0011QG\u0011\u0005\u0002\u0005]\"a\u0005&pS:\u0014Vm\u001c:eKJ$Vm\u001d;CCN,'B\u0001\u0014(\u0003\u0019\u0019w.\\7p]*\u0011\u0001&K\u0001\u0005a2\fgN\u0003\u0002+W\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u0017.\u0003\u0015!\u0018M\u00197f\u0015\tqs&A\u0003gY&t7N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0002\"AN\u001d\u000e\u0003]R!\u0001O\u0015\u0002\u000bU$\u0018\u000e\\:\n\u0005i:$!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\njg\n+8\u000f[=K_&t'+Z8sI\u0016\u0014\bCA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00113\u0005CA#\u0001\u001b\u0005)\u0003\"B\u001e\u0003\u0001\u0004a\u0014\u0001B;uS2,\u0012!\u0013\t\u0003m)K!aS\u001c\u0003\u001bQ\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003A9W\r\u001e+bE2,G+Z:u+RLG.A\u0003tKR,\b\u000fF\u0001Q!\ti\u0014+\u0003\u0002S}\t!QK\\5uQ\t1A\u000b\u0005\u0002V96\taK\u0003\u0002X1\u0006\u0019\u0011\r]5\u000b\u0005eS\u0016a\u00026va&$XM\u001d\u0006\u00037F\nQA[;oSRL!!\u0018,\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\fuKN$8\u000b^1s\u0015>LgnQ8oI&$\u0018n\u001c82Q\t9\u0001\r\u0005\u0002VC&\u0011!M\u0016\u0002\r)\u0016\u001cH\u000fV3na2\fG/Z\u0001\u0017i\u0016\u001cHo\u0015;be*{\u0017N\\\"p]\u0012LG/[8oe!\u0012\u0001\u0002Y\u0001\u0018i\u0016\u001cHOQ;tQfTu.\u001b8D_:$\u0017\u000e^5p]FB#!\u00031\u0002/Q,7\u000f\u001e\"vg\"L(j\\5o\u0007>tG-\u001b;j_:\u0014\u0004F\u0001\u0006a\u0003Y!Xm\u001d;XSRDw.\u001e;D_2,XN\\*uCR\u001c\bFA\u0006a\u0003M!Xm\u001d;K_&tw+\u001b;i!J|'.Z2uQ\ta\u0001-\u0001\nuKN$(j\\5o/&$\bNR5mi\u0016\u0014\bFA\u0007a\u0003A!Xm\u001d;BY2LeN\\3s\u0015>Lg\u000e\u000b\u0002\u000fA\u0006IB/Z:u\u0013:tWM]!oI2+g\r^(vi\u0016\u0014(j\\5oQ\ty\u0001-\u0001\u000euKN$\u0018J\u001c8fe\u0006sGMU5hQR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002\u0011A\u0006IB/Z:u\u0013:tWM]!oI\u001a+H\u000e\\(vi\u0016\u0014(j\\5oQ\t\t\u0002-\u0001\u000buKN$\u0018\t\u001c7MK\u001a$x*\u001e;fe*{\u0017N\u001c\u0015\u0003%\u0001\fQ\u0003^3ti\u0006cGNU5hQR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002\u0014A\u0006!B/Z:u\u00032dg)\u001e7m\u001fV$XM\u001d&pS:D#\u0001\u00061\u0002aQ,7\u000f^%o]\u0016\u0014(j\\5o\u0019\u00164GoT;uKJTu.\u001b8J]:,'OS8j]2+g\r^(vi\u0016\u0014(j\\5oQ\t)\u0002-\u0001\u0019uKN$H*\u001a4u\u001fV$XM\u001d&pS:LeN\\3s\u0015>Lg\u000eT3gi>+H/\u001a:K_&t\u0017J\u001c8fe*{\u0017N\u001c\u0015\u0003-\u0001\f!\u0007^3ti&sg.\u001a:K_&t'+[4ii>+H/\u001a:K_&t\u0017J\u001c8fe*{\u0017N\u001c*jO\"$x*\u001e;fe*{\u0017N\u001c\u0015\u0003/\u0001\f!\u0007^3tiJKw\r\u001b;PkR,'OS8j]&sg.\u001a:K_&t'+[4ii>+H/\u001a:K_&t\u0017J\u001c8fe*{\u0017N\u001c\u0015\u00031\u0001\fQ\u0003^3ti&sg.\u001a:K_&t7+Z7j\u0015>Lg\u000e\u000b\u0002\u001aA\u0006)B/Z:u\u0013:tWM\u001d&pS:\fe\u000e^5K_&t\u0007F\u0001\u000ea\u00035!Xm\u001d;De>\u001c8OS8j]\"\u00121\u0004Y\u0001\u0017i\u0016\u001cH/\u00138oKJTu.\u001b8De>\u001c8OS8j]\"\u0012A\u0004Y\u0001$i\u0016\u001cH/\u00138oKJTu.\u001b8MK\u001a$x*\u001e;fe*{\u0017N\\\"s_N\u001c(j\\5oQ\ti\u0002-A\u0014uKN$\u0018J\u001c8fe*{\u0017N\\,ji\"\u0014Uo\u001d5z)f\u0004XMS8j]\u000e{g\u000eZ5uS>t\u0007F\u0001\u0010a\u0003\u0011\"Xm\u001d;EKJLg/\u001a(vY24\u0015\u000e\u001c;fe\u00063G/\u001a:K_&t'+Z8sI\u0016\u0014\bFA\u0010a\u0003MQu.\u001b8SK>\u0014H-\u001a:UKN$()Y:f!\t)\u0015eE\u0002\"\u0003[\u00012!PA\u0018\u0013\r\t\tD\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005%\u0012A\u00039be\u0006lW\r^3sgR\u0011\u0011\u0011\b\t\u0006\u0003w\t\u0019\u0005P\u0007\u0003\u0003{Q1aRA \u0015\t\t\t%\u0001\u0003kCZ\f\u0017\u0002BA#\u0003{\u0011!bQ8mY\u0016\u001cG/[8oQ\u001d\u0019\u0013\u0011JA0\u0003C\u0002B!a\u0013\u0002\\5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u0003'\n)&\u0001\u0006fqR,gn]5p]NT1aWA,\u0015\r\tI&L\u0001\ni\u0016\u001cH/\u001e;jYNLA!!\u0018\u0002N\tQ\u0001+\u0019:b[\u0016$XM]:\u0002\t9\fW.Z\u0011\u0003\u0003G\na#[:CkND\u0017PS8j]J+wN\u001d3fevZ\b' ")
public abstract class JoinReorderTestBase
extends TableTestBase {
    private final boolean isBushyJoinReorder;
    private final TableTestUtil util;

    @Parameters(name="isBushyJoinReorder={0}")
    public static Collection<Object> parameters() {
        return JoinReorderTestBase$.MODULE$.parameters();
    }

    public TableTestUtil util() {
        return this.util;
    }

    public abstract TableTestUtil getTableTestUtil();

    @BeforeEach
    public void setup() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()});
        this.util().addTableSource("T1", types, (String[])((Object[])new String[]{"a1", "b1", "c1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(1000000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(50L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T2", types, (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(10000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T3", types, (String[])((Object[])new String[]{"a3", "b3", "c3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(50L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T4", types, (String[])((Object[])new String[]{"a4", "b4", "c4"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T5", types, (String[])((Object[])new String[]{"a5", "b5", "c5"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (!this.isBushyJoinReorder) {
            this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BUSHY_JOIN_REORDER_THRESHOLD, (Object)3);
            return;
        }
        this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BUSHY_JOIN_REORDER_THRESHOLD, (Object)1000);
    }

    @TestTemplate
    public void testStarJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a1 = a3 AND a1 = a4 AND a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testStarJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b1 = b3 AND b1 = b4 AND b1 = b5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testBushyJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a2 = a3 AND a1 = a4 AND a3 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testBushyJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b2 = b3 AND b1 = b4 AND b3 = b5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testWithoutColumnStats() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE c1 = c2 AND c1 = c3 AND c2 = c4 AND c1 = c5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testJoinWithProject() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH V1 AS (SELECT b1, a1, a2, c2 FROM T1 JOIN T2 ON a1 = a2),\n         |     V2 AS (SELECT a3, b1, a1, c2, c3 FROM V1 JOIN T3 ON a2 = a3),\n         |     V3 AS (SELECT a3, b1, a1, c2, c3, a4, b4 FROM T4 JOIN V2 ON a1 = a4)\n         |\n         |SELECT * FROM V3, T5 where a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testJoinWithFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH V1 AS (SELECT * FROM T1 JOIN T2 ON a1 = a2 WHERE b1 * b2 > 10),\n         |     V2 AS (SELECT * FROM V1 JOIN T3 ON a2 = a3 WHERE b1 * b3 < 2000),\n         |     V3 AS (SELECT * FROM T4 JOIN V2 ON a3 = a4 WHERE b2 + b4 > 100)\n         |\n         |SELECT * FROM V3, T5 WHERE a4 = a5 AND b5 < 15\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a2 = a4\n         |   JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerAndLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerAndRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a2 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerAndFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   LEFT OUTER JOIN T2 ON a1 = a2\n         |   LEFT OUTER JOIN T3 ON a1 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   LEFT OUTER JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   RIGHT OUTER JOIN T3 ON a2 = a3\n         |   RIGHT OUTER JOIN T4 ON a1 = a4\n         |   RIGHT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   FULL OUTER JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a1 = a3\n         |   FULL OUTER JOIN T4 ON a1 = a4\n         |   FULL OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinLeftOuterJoinInnerJoinLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   LEFT OUTER JOIN T3 ON a1 = a3\n         |   JOIN T4 ON a1 = a4\n         |   LEFT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testLeftOuterJoinInnerJoinLeftOuterJoinInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   LEFT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a1 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinRightOuterJoinInnerJoinRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   RIGHT OUTER JOIN T3 ON a1 = a3\n         |   JOIN T4 ON a1 = a4\n         |   RIGHT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testRightOuterJoinInnerJoinRightOuterJoinInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a1 = a3\n         |   RIGHT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinSemiJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   WHERE a1 IN (SELECT a5 FROM T5)\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinAntiJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   WHERE NOT EXISTS (SELECT a5 FROM T5 WHERE a1 = a5)\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCrossJoin() {
        String sql = "SELECT * FROM T1, T2, T3, T4, T5";
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinCrossJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1,\n         |   (SELECT * FROM T2 JOIN T3 ON a2 = a3) tab1, T4\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinLeftOuterJoinCrossJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1,\n         |   (SELECT * FROM T2 LEFT JOIN T3 ON a2 = a3 JOIN T4 ON a2 = a4) tab1, T5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinWithBushyTypeJoinCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM\n         |(SELECT * FROM T1 JOIN T2 ON T1.b1 = T2.b2) tab1 JOIN\n         |(SELECT * FROM T3 JOIN T4 ON T3.b3 = T4.b4) tab2\n         |ON tab1.b2 = tab2.b4\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testDeriveNullFilterAfterJoinReorder() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG()});
        ColumnStats.Builder builderA = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(2000000L)).setNullCount(Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(JoinDeriveNullFilterRule.JOIN_NULL_FILTER_THRESHOLD) + 1L)).setAvgLen(Predef$.MODULE$.double2Double(4.0)).setMaxLen(Predef$.MODULE$.int2Integer(4));
        ColumnStats.Builder builderB = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(1000000L)).setNullCount(Predef$.MODULE$.long2Long(0L)).setAvgLen(Predef$.MODULE$.double2Double(8.0)).setMaxLen(Predef$.MODULE$.int2Integer(8));
        this.util().addTableSource("T6", types, (String[])((Object[])new String[]{"a6", "b6"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(5000000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a6"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b6"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T7", types, (String[])((Object[])new String[]{"a7", "b7"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(5000000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a7"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b7"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T8", types, (String[])((Object[])new String[]{"a8", "b8"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(5000000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a8"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b8"), (Object)builderB.build())}))))).build());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T6\n         |   INNER JOIN T7 ON b6 = b7\n         |   INNER JOIN T8 ON a6 = a8\n         |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public JoinReorderTestBase(boolean isBushyJoinReorder) {
        this.isBushyJoinReorder = isBushyJoinReorder;
        this.util = this.getTableTestUtil();
    }
}

