/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DynamicFunctionPlanTestBase
extends TableTestBase {
    private TableTestUtil util;

    protected abstract boolean isBatchMode();

    protected abstract TableTestUtil getTableTestUtil();

    @BeforeEach
    void setup() {
        this.util = this.getTableTestUtil();
        this.util.tableEnv().executeSql("CREATE TABLE src (\n a INTEGER,\n b VARCHAR,\n cat VARCHAR,\n gmt_date DATE,\n cnt BIGINT,\n ts TIME,\n PRIMARY KEY (cat) NOT ENFORCED\n) WITH (\n 'connector' = 'values'\n ,'bounded' = '" + this.isBatchMode() + "'\n)");
    }

    @Test
    void testAggregateReduceConstants() {
        this.util.verifyExecPlan("SELECT\n     cat, gmt_date, SUM(cnt), count(*)\nFROM src\nWHERE gmt_date = current_date\nGROUP BY cat, gmt_date");
    }

    @Test
    void testAggregateReduceConstants2() {
        this.util.verifyExecPlan("SELECT\ncat, hh, SUM(cnt), COUNT(*)\nFROM (SELECT *, SUBSTR(CAST(LOCALTIME AS VARCHAR), 1, 2) hh FROM src)\nWHERE SUBSTR(CAST(ts AS VARCHAR), 1, 2) = hh\nGROUP BY cat, hh");
    }

    @Test
    void testAggregateReduceConstants3() {
        this.util.verifyExecPlan("SELECT\n     gmt_date, ts, cat, SUBSTR(CAST(ts AS VARCHAR), 1, 2), SUM(cnt)\nFROM src\nWHERE gmt_date = CURRENT_DATE\n  AND cat = 'fruit' AND ts = CURRENT_TIME\nGROUP BY gmt_date, ts, cat");
    }

    @Test
    void testCalcMerge() {
        this.util.verifyExecPlan("SELECT * FROM ( \n   SELECT *, SUBSTR(CAST(LOCALTIME AS VARCHAR), 1, 2) hh\n   FROM src\n ) t1 WHERE hh > 12 AND cat LIKE 'fruit%'\n");
    }
}

