/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.common.DistinctAggregateTestBase$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c!B\u0011#\u0003\u0003\t\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b}\u0002A\u0011\u0001!\t\u000f\u0011\u0003!\u0019!C\t\u000b\"1\u0011\n\u0001Q\u0001\n\u0019CQA\u0013\u0001\u0005\u0002-CQA\u0017\u0001\u0005\u0002-CQa\u0018\u0001\u0005\u0002-CQ!\u0019\u0001\u0005\u0002-CQa\u0019\u0001\u0005\u0002-CQ!\u001a\u0001\u0005\u0002-CQa\u001a\u0001\u0005\u0002-CQ!\u001b\u0001\u0005\u0002-CQa\u001b\u0001\u0005\u0002-CQ!\u001c\u0001\u0005\u0002-CQa\u001c\u0001\u0005\u0002-CQ!\u001d\u0001\u0005\u0002-CQa\u001d\u0001\u0005\u0002-CQ!\u001e\u0001\u0005\u0002-CQa\u001e\u0001\u0005\u0002-CQ!\u001f\u0001\u0005\u0002-CQa\u001f\u0001\u0005\u0002-CQ! \u0001\u0005\u0002-CQa \u0001\u0005\u0002-Ca!a\u0001\u0001\t\u0003Y\u0005BBA\u0004\u0001\u0011\u00051\n\u0003\u0004\u0002\f\u0001!\ta\u0013\u0005\u0007\u0003\u001f\u0001A\u0011A&\t\r\u0005M\u0001\u0001\"\u0001L\u0011\u0019\t9\u0002\u0001C\u0001\u0017\"1\u00111\u0004\u0001\u0005\u0002-Ca!a\b\u0001\t\u0003Y\u0005bBA\u0012\u0001\u0011%\u0011Q\u0005\u0002\u001a\t&\u001cH/\u001b8di\u0006;wM]3hCR,G+Z:u\u0005\u0006\u001cXM\u0003\u0002$I\u000511m\\7n_:T!!\n\u0014\u0002\tAd\u0017M\u001c\u0006\u0003O!\nq\u0001\u001d7b]:,'O\u0003\u0002*U\u0005)A/\u00192mK*\u00111\u0006L\u0001\u0006M2Lgn\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b'\u0003\u0015)H/\u001b7t\u0013\t9DGA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\ro&$\b.\u0012=fGBc\u0017M\u001c\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0011\u0011i\u0011\t\u0003\u0005\u0002i\u0011A\t\u0005\u0006q\t\u0001\r!O\u0001\u0005kRLG.F\u0001G!\t\u0019t)\u0003\u0002Ii\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003\u0015\u0019X\r^;q)\u0005a\u0005C\u0001\u001eN\u0013\tq5H\u0001\u0003V]&$\bFA\u0003Q!\t\t\u0006,D\u0001S\u0015\t\u0019F+A\u0002ba&T!!\u0016,\u0002\u000f),\b/\u001b;fe*\u0011qKL\u0001\u0006UVt\u0017\u000e^\u0005\u00033J\u0013!BQ3g_J,W)Y2i\u0003U!Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001eD#A\u0002/\u0011\u0005Ek\u0016B\u00010S\u0005\u0011!Vm\u001d;\u0002AQ,7\u000f^'vYRLG)[:uS:\u001cG/Q4h\u001f:\u001c\u0016-\\3D_2,XN\u001c\u0015\u0003\u000fq\u000b\u0011\u0007^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;w-\u00118e\u001f:,wJ]'vYRLgj\u001c8ESN$\u0018N\\2u\u0003\u001e<\u0017\u0007\u000b\u0002\t9\u0006\tD/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<\u0017I\u001c3P]\u0016|%/T;mi&tuN\u001c#jgRLgn\u0019;BO\u001e\u0014\u0004FA\u0005]\u0003\u0015\"Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hO>sG)\u001b4gKJ,g\u000e^\"pYVlg\u000e\u000b\u0002\u000b9\u0006\u0019D/Z:u\u001bVdG/\u001b#jgRLgn\u0019;B]\u0012tuN\u001c#jgRLgn\u0019;BO\u001e|e\u000eR5gM\u0016\u0014XM\u001c;D_2,XN\u001c\u0015\u0003\u0017q\u000b\u0001\u0005^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;wmV5uQ\u001e\u0013x.\u001e9Cs\"\u0012A\u0002X\u0001-i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4h/&$\bn\u0012:pkB\u0014\u00150\u00118e\u0007>,h\u000e^*uCJD#!\u0004/\u0002SQ,7\u000f\u001e+x_\u0012K7\u000f^5oGR\fumZ,ji\"<%o\\;q\u0005f\fe\u000eZ\"pk:$8\u000b^1sQ\tqA,\u0001\u001auKN$Hk^8ES\u001a4WM]3oi\u0012K7\u000f^5oGR\fumZ,ji\"<%o\\;q\u0005f\fe\u000eZ\"pk:$8\u000b^1sQ\tyA,A\u001euKN$X*\u001e7uS\u0012KgMZ3sK:$H)[:uS:\u001cG/Q4h/&$\bNT8o\t&\u001cH/\u001b8di\u0006;wm\u00148TC6,7i\u001c7v[:D#\u0001\u0005/\u0002\u000bR,7\u000f^'vYRLG)\u001b4gKJ,g\u000e\u001e#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5O_:$\u0015n\u001d;j]\u000e$\u0018iZ4P]N\u000bW.Z\"pYVlg.\u00118e\u000fJ|W\u000f\u001d\"zQ\t\tB,\u0001&uKN$X*\u001e7uS\u0012KgMZ3sK:$H)[:uS:\u001cG/Q4h/&$\bNT8o\t&\u001cH/\u001b8di\u0006;wm\u00148ES\u001a4WM]3oi\u000e{G.^7o\u0003:$wI]8va\nK\bF\u0001\n]\u0003\u0005\"Xm\u001d;ESN$\u0018N\\2u\u0003\u001e<w+\u001b;i\tV\u0004H.[2bi\u00164\u0015.\u001a7eQ\t\u0019B,\u0001\u0019uKN$X*\u001e7uS\u0012K7\u000f^5oGR\fumZ(o'\u0006lWmQ8mk6tw+\u001b;i\u000fJ|W\u000f]5oON+Go\u001d\u0015\u0003)q\u000b\u0011\t^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;w-\u00118e\u001f:,wJ]'vYRLgj\u001c8ESN$\u0018N\\2u\u0003\u001e<w+\u001b;i\u000fJ|W\u000f]5oON+Go]\u0019)\u0005Ua\u0016!\u0011;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ!oI>sWm\u0014:Nk2$\u0018NT8o\t&\u001cH/\u001b8di\u0006;wmV5uQ\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:3Q\t1B,A\u001buKN$X*\u001e7uS\u0012K7\u000f^5oGR\fumZ(o\t&4g-\u001a:f]R\u001cu\u000e\\;n]^KG\u000f[$s_V\u0004\u0018N\\4TKR\u001c\bFA\f]\u0003\r#Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!oI:{g\u000eR5ti&t7\r^!hO>sG)\u001b4gKJ,g\u000e^\"pYVlgnV5uQ\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:)\u0005aa\u0016\u0001\b;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u00033q\u000bq\u0005^3ti6+H\u000e^5ESN$\u0018N\\2u\u001f:\u001c\u0016-\\3D_2,XN\\,ji\"4\u0015\u000e\u001c;fe\"\u0012!\u0004X\u0001-)\u0016\u001cH/T;mi&$\u0015n\u001d;j]\u000e$xJ\u001c#jM\u001a,'/\u001a8u\u0007>dW/\u001c8XSRDg)\u001b7uKJD#a\u0007/\u0002YQ+7\u000f^'vYRLG)[:uS:\u001cGoV5uQ\u001aKG\u000e^3s\u0003:$gj\u001c8ESN$\u0018N\\2u\u0003\u001e<\u0007F\u0001\u000f]\u00031\"Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!oI:{g\u000eR5ti&t7\r^!hO^KG\u000f\u001b$jYR,'\u000f\u000b\u0002\u001e9\u00069C/Z:u\t&\u001cH/\u001b8di\u0006;wmV5uQ\u0012+\b\u000f\\5dCR,g)\u001b7uKJ4\u0015.\u001a7eQ\tqB,A\u0014uKN$Hk\\8NC:LH)[:uS:\u001cG/Q4h\u001f:$\u0015N\u001a4fe\u0016tGoQ8mk6t\u0007FA\u0010]\u0003)1XM]5gsBc\u0017M\u001c\u000b\u0004\u0019\u0006\u001d\u0002bBA\u0015A\u0001\u0007\u00111F\u0001\tgFd\u0017+^3ssB!\u0011QFA\u001e\u001d\u0011\ty#a\u000e\u0011\u0007\u0005E2(\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\tIdO\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0012q\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e2\b")
public abstract class DistinctAggregateTestBase
extends TableTestBase {
    private final boolean withExecPlan;
    private final BatchTableTestUtil util;

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.common.DistinctAggregateTestBase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, String, String>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, String, String>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, String, String> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((String)fields[3]), (Object)((String)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.common.DistinctAggregateTestBase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSingleDistinctAgg() {
        this.verifyPlan("SELECT COUNT(DISTINCT a) FROM MyTable");
    }

    @Test
    public void testMultiDistinctAggOnSameColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT a) FILTER (WHERE b > 0),\nMAX(DISTINCT a) FROM MyTable");
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAgg1() {
        this.verifyPlan("SELECT COUNT(DISTINCT a) FILTER (WHERE a > 0), SUM(b) FROM MyTable");
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAgg2() {
        this.verifyPlan("SELECT COUNT(a) filter (WHERE a > 0), SUM(DISTINCT b) FROM MyTable");
    }

    @Test
    public void testMultiDistinctAggOnDifferentColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b),\nCOUNT(DISTINCT c) FILTER (WHERE a > 5) FROM MyTable");
    }

    @Test
    public void testMultiDistinctAndNonDistinctAggOnDifferentColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a) FILTER (WHERE c > 0),\nSUM(DISTINCT b), COUNT(c) FROM MyTable");
    }

    @Test
    public void testSingleDistinctAggWithGroupBy() {
        this.verifyPlan("SELECT a, COUNT(a), SUM(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithGroupByAndCountStar() {
        this.verifyPlan("SELECT a, COUNT(*), SUM(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testTwoDistinctAggWithGroupByAndCountStar() {
        String sqlQuery = "SELECT a, COUNT(*), SUM(DISTINCT b), COUNT(DISTINCT b) FROM MyTable GROUP BY a";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testTwoDifferentDistinctAggWithGroupByAndCountStar() {
        String sqlQuery = "SELECT a, COUNT(*), SUM(DISTINCT b), COUNT(DISTINCT c) FROM MyTable GROUP BY a";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDifferentDistinctAggWithNonDistinctAggOnSameColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b), MAX(a), MIN(a) FROM MyTable");
    }

    @Test
    public void testMultiDifferentDistinctAggWithNonDistinctAggOnSameColumnAndGroupBy() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b), MAX(a), MIN(a) FROM MyTable GROUP BY c";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDifferentDistinctAggWithNonDistinctAggOnDifferentColumnAndGroupBy() {
        this.verifyPlan("SELECT SUM(DISTINCT a), COUNT(DISTINCT c) FROM MyTable GROUP BY b");
    }

    @Test
    public void testDistinctAggWithDuplicateField() {
        this.verifyPlan("SELECT a, COUNT(a), SUM(b), SUM(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testMultiDistinctAggOnSameColumnWithGroupingSets() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT a), MAX(DISTINCT a) FROM MyTable2 GROUP BY GROUPING SETS (b, c)";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAggWithGroupingSets1() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(b) FROM MyTable2 GROUP BY GROUPING SETS (b, c)");
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAggWithGroupingSets2() {
        this.verifyPlan("SELECT COUNT(a), SUM(DISTINCT b) FROM MyTable2 GROUP BY GROUPING SETS (c, d)");
    }

    @Test
    public void testMultiDistinctAggOnDifferentColumnWithGroupingSets() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable2 GROUP BY GROUPING SETS (c, d)";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDistinctAndNonDistinctAggOnDifferentColumnWithGroupingSets() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b), COUNT(c) FROM MyTable2 GROUP BY GROUPING SETS (d, e)";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctWithFilter() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c) FILTER (WHERE a > 0) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDistinctOnSameColumnWithFilter() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c), COUNT(DISTINCT c) FILTER (WHERE a > 10),\nCOUNT(DISTINCT c) FILTER (WHERE a < 10) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void TestMultiDistinctOnDifferentColumnWithFilter() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c), COUNT(DISTINCT c) FILTER (WHERE a > 0),\nCOUNT(DISTINCT b) FILTER (WHERE b > 1) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void TestMultiDistinctWithFilterAndNonDistinctAgg() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c), COUNT(DISTINCT c) FILTER (WHERE a > 0),\nMAX(e), MIN(e) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDistinctAndNonDistinctAggWithFilter() {
        String sqlQuery = "SELECT d, MAX(e), MAX(e) FILTER (WHERE a < 10), COUNT(DISTINCT c),\nCOUNT(DISTINCT c) FILTER (WHERE a > 5), COUNT(DISTINCT b) FILTER (WHERE b > 3)\nFROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testDistinctAggWithDuplicateFilterField() {
        String sqlQuery = "SELECT a, COUNT(c) FILTER (WHERE b > 1),\nCOUNT(DISTINCT d) FILTER (WHERE b > 1) FROM MyTable2 GROUP BY a";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testTooManyDistinctAggOnDifferentColumn() {
        String[] fieldNames = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 64).map((Function1 & Serializable & scala.Serializable)i -> DistinctAggregateTestBase.$anonfun$testTooManyDistinctAggOnDifferentColumn$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        AbstractDataType[] fieldTypes = (AbstractDataType[])Array$.MODULE$.fill(fieldNames.length, (Function0 & Serializable & scala.Serializable)() -> DataTypes.INT(), ClassTag$.MODULE$.apply(AbstractDataType.class));
        this.util().addTableSource("MyTable64", fieldTypes, fieldNames);
        String distinctList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(16).append("COUNT(DISTINCT ").append((String)f).append(")").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String maxList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(5).append("MAX(").append((String)f).append(")").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String sqlQuery = new StringBuilder(24).append("SELECT ").append(distinctList).append(", ").append(maxList).append(" FROM MyTable64").toString();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.verifyPlan(sqlQuery));
    }

    private void verifyPlan(String sqlQuery) {
        if (this.withExecPlan) {
            this.util().verifyExecPlan(sqlQuery);
            return;
        }
        this.util().verifyRelPlan(sqlQuery);
    }

    public static final /* synthetic */ String $anonfun$testTooManyDistinctAggOnDifferentColumn$1(int i) {
        return new StringBuilder(1).append("f").append(i).toString();
    }

    public DistinctAggregateTestBase(boolean withExecPlan) {
        this.withExecPlan = withExecPlan;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

