/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRule;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005me!\u0002\u00192\u0003\u0003\u0001\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b9\u0003A\u0011A(\t\u000fM\u0003!\u0019!C\t)\"1\u0001\f\u0001Q\u0001\nUCQ!\u0017\u0001\u0005\u0002iCQ!\u001b\u0001\u0005\u0002iCQA\u001c\u0001\u0005\u0002iCQ\u0001\u001d\u0001\u0005\u0002iCQA\u001d\u0001\u0005\u0002iCQ\u0001\u001e\u0001\u0005\u0002iCQA\u001e\u0001\u0005\u0002iCQ\u0001\u001f\u0001\u0005\u0002iCQA\u001f\u0001\u0005\u0002iCQ\u0001 \u0001\u0005\u0002iCQA \u0001\u0005\u0002iCa!!\u0001\u0001\t\u0003Q\u0006BBA\u0003\u0001\u0011\u0005!\f\u0003\u0004\u0002\n\u0001!\tA\u0017\u0005\u0007\u0003\u001b\u0001A\u0011\u0001.\t\r\u0005E\u0001\u0001\"\u0001[\u0011\u0019\t)\u0002\u0001C\u00015\"1\u0011\u0011\u0004\u0001\u0005\u0002iCa!!\b\u0001\t\u0003Q\u0006BBA\u0011\u0001\u0011\u0005!\f\u0003\u0004\u0002&\u0001!\tA\u0017\u0005\u0007\u0003S\u0001A\u0011\u0001.\t\r\u00055\u0002\u0001\"\u0001[\u0011\u0019\t\t\u0004\u0001C\u00015\"1\u0011Q\u0007\u0001\u0005\u0002iCa!!\u000f\u0001\t\u0003Q\u0006BBA\u001f\u0001\u0011\u0005!\f\u0003\u0004\u0002B\u0001!\tA\u0017\u0005\u0007\u0003\u000b\u0002A\u0011\u0001.\t\r\u0005%\u0003\u0001\"\u0001[\u0011\u0019\ti\u0005\u0001C\u00015\"1\u0011\u0011\u000b\u0001\u0005\u0002iCa!!\u0016\u0001\t\u0003Q\u0006BBA-\u0001\u0011\u0005!\f\u0003\u0004\u0002^\u0001!\tA\u0017\u0005\u0007\u0003C\u0002A\u0011\u0001.\t\r\u0005\u0015\u0004\u0001\"\u0001[\u0011\u0019\tI\u0007\u0001C\u00015\"1\u0011Q\u000e\u0001\u0005\u0002iCa!!\u001d\u0001\t\u0003Q\u0006BBA;\u0001\u0011\u0005!\f\u0003\u0004\u0002z\u0001!\tA\u0017\u0005\b\u0003{\u0002A\u0011AA@\u0005}\tum\u001a:fO\u0006$XMU3ek\u000e,wI]8va&tw\rV3ti\n\u000b7/\u001a\u0006\u0003eM\naaY8n[>t'B\u0001\u001b6\u0003\u0011\u0001H.\u00198\u000b\u0005Y:\u0014a\u00029mC:tWM\u001d\u0006\u0003qe\nQ\u0001^1cY\u0016T!AO\u001e\u0002\u000b\u0019d\u0017N\\6\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002Ek\u0005)Q\u000f^5mg&\u0011ai\u0011\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\u0019]LG\u000f[#yK\u000e\u0004F.\u00198\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\"\u0001\u0015*\u0011\u0005E\u0003Q\"A\u0019\t\u000b\u001d\u0013\u0001\u0019\u0001%\u0002\tU$\u0018\u000e\\\u000b\u0002+B\u0011!IV\u0005\u0003/\u000e\u0013!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u0005)1/\u001a;vaR\t1\f\u0005\u0002J9&\u0011QL\u0013\u0002\u0005+:LG\u000f\u000b\u0002\u0006?B\u0011\u0001mZ\u0007\u0002C*\u0011!mY\u0001\u0004CBL'B\u00013f\u0003\u001dQW\u000f]5uKJT!AZ\u001f\u0002\u000b),h.\u001b;\n\u0005!\f'A\u0003\"fM>\u0014X-R1dQ\u0006)B/Z:u\u0003\u001e<w+\u001b;i_V$\u0018iZ4DC2d\u0007F\u0001\u0004l!\t\u0001G.\u0003\u0002nC\n!A+Z:u\u0003q!Xm\u001d;BO\u001e<\u0016\u000e\u001e5pkR\u0014V\rZ;dK\u001e\u0013x.\u001e9j]\u001eD#aB6\u0002CQ,7\u000f^*j]\u001edW-Q4h\u001f:$\u0016M\u00197f/&$\b.\u00168jcV,7*Z=)\u0005!Y\u0017\u0001\n;fgR\u001c\u0016N\\4mK\u0006;wm\u00148UC\ndWmV5uQ>,H/\u00168jcV,7*Z=)\u0005%Y\u0017A\t;fgR\u001c\u0016N\\4mK\u0006;wm\u00148UC\ndWmV5uQVs\u0017.];f\u0017\u0016L8\u000f\u000b\u0002\u000bW\u0006\tC/Z:u'&tw\r\\3BO\u001e<\u0016\u000e\u001e5D_:\u001cH/\u00198u\u000fJ|W\u000f]&fs\"\u00121b[\u0001\"i\u0016\u001cHoU5oO2,\u0017iZ4P]2L8i\u001c8ti\u0006tGo\u0012:pkB\\U-\u001f\u0015\u0003\u0019-\fa\u0002^3ti6+H\u000e^5BO\u001e\u001c\u0018\u0007\u000b\u0002\u000eW\u0006qA/Z:u\u001bVdG/[!hON\u0014\u0004F\u0001\bl\u0003M!Xm\u001d;BO\u001e|e.\u00138oKJTu.\u001b82Q\ty1.A\nuKN$\u0018iZ4P]&sg.\u001a:K_&t'\u0007\u000b\u0002\u0011W\u0006\u0019B/Z:u\u0003\u001e<wJ\\%o]\u0016\u0014(j\\5og!\u0012\u0011c[\u0001\u0013i\u0016\u001cH/Q4h\u001f:dUM\u001a;K_&t\u0017\u0007\u000b\u0002\u0013W\u0006\u0011B/Z:u\u0003\u001e<wJ\u001c'fMRTu.\u001b83Q\t\u00192.\u0001\nuKN$\u0018iZ4P]2+g\r\u001e&pS:\u001c\u0004F\u0001\u000bl\u0003M!Xm\u001d;BO\u001e|eNU5hQRTu.\u001b82Q\t)2.A\nuKN$\u0018iZ4P]JKw\r\u001b;K_&t'\u0007\u000b\u0002\u0017W\u0006\u0019B/Z:u\u0003\u001e<wJ\u001c*jO\"$(j\\5og!\u0012qc[\u0001\u0013i\u0016\u001cH/Q4h\u001f:4U\u000f\u001c7K_&t\u0017\u0007\u000b\u0002\u0019W\u0006\u0011B/Z:u\u0003\u001e<wJ\u001c$vY2Tu.\u001b83Q\tI2.A\u0007uKN$\u0018iZ4P]>3XM\u001d\u0015\u00035-\f\u0001\u0003^3ti\u0006;wm\u00148XS:$wn^\u0019)\u0005mY\u0017\u0001\u0005;fgR\fumZ(o/&tGm\\<3Q\ta2.\u0001\tuKN$\u0018iZ4P]^Kg\u000eZ8xg!\u0012Qd[\u0001\u0011i\u0016\u001cH/Q4h\u001f:<\u0016N\u001c3poRB#AH6\u0002!Q,7\u000f^!hO>sw+\u001b8e_^,\u0004FA\u0010l\u0003a!Xm\u001d;BO\u001e<\u0016\u000e\u001e5He>,\b/\u001b8h'\u0016$8/\r\u0015\u0003A-\f\u0001\u0004^3ti\u0006;wmV5uQ\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:3Q\t\t3.\u0001\ruKN$\u0018iZ4XSRDwI]8va&twmU3ugNB#AI6\u0002#Q,7\u000f^!hO^KG\u000f\u001b*pY2,\b\u000f\u000b\u0002$W\u0006yA/Z:u\u0003\u001e<w+\u001b;i\u0007V\u0014W\r\u000b\u0002%W\u00061B/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<\u0017\u0007\u000b\u0002&W\u00061B/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<'\u0007\u000b\u0002'W\u0006IC/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<wlV5uQ:{g\u000eR5ti&t7\r^!hOFB#aJ6\u0002SQ,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO~;\u0016\u000e\u001e5O_:$\u0015n\u001d;j]\u000e$\u0018iZ43Q\tA3.A\u0015uKN$8+\u001b8hY\u0016$\u0015n\u001d;j]\u000e$\u0018iZ4`/&$\bNT8o\t&\u001cH/\u001b8di\u0006;wm\r\u0015\u0003S-\f\u0011\u0006^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;wmX,ji\"tuN\u001c#jgRLgn\u0019;BO\u001e$\u0004F\u0001\u0016l\u0003Y!Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hON\f\u0004FA\u0016l\u0003Y!Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hON\u0014\u0004F\u0001\u0017l\u0003Y!Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hON\u001c\u0004FA\u0017l\u0003%\"Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hON|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hc!\u0012af[\u0001\u000bm\u0016\u0014\u0018NZ=QY\u0006tGcA.\u0002\u0002\"9\u00111Q\u0018A\u0002\u0005\u0015\u0015\u0001C:rYF+XM]=\u0011\t\u0005\u001d\u0015Q\u0013\b\u0005\u0003\u0013\u000b\t\nE\u0002\u0002\f*k!!!$\u000b\u0007\u0005=u(\u0001\u0004=e>|GOP\u0005\u0004\u0003'S\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0006e%AB*ue&twMC\u0002\u0002\u0014*\u0003")
public abstract class AggregateReduceGroupingTestBase
extends TableTestBase {
    private final boolean withExecPlan;
    private final BatchTableTestUtil util;

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("T1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a1"))).build());
        this.util().addTableSource("T2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"b2"), (Object)ImmutableSet.of((Object)"a2", (Object)"b2"))).build());
        this.util().addTableSource("T3", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"a3", "b3", "c3", "d3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L)).build());
        this.util().addTableSource("T4", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LOCAL_DATE_TIME()}), (String[])((Object[])new String[]{"a4", "b4", "c4", "d4"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a4"))).build());
    }

    @Test
    public void testAggWithoutAggCall() {
        FlinkChainedProgram<BatchOptimizeContext> programs = this.util().getBatchProgram();
        ((FlinkRuleSetProgram)programs.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.LOGICAL()).get()).remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkAggregateRemoveRule.INSTANCE}));
        this.util().replaceBatchProgram(programs);
        this.util().verifyRelPlan("SELECT a1, b1, c1 FROM T1 GROUP BY a1, b1, c1");
    }

    @Test
    public void testAggWithoutReduceGrouping() {
        this.verifyPlan("SELECT a3, b3, count(c3) FROM T3 GROUP BY a3, b3");
    }

    @Test
    public void testSingleAggOnTableWithUniqueKey() {
        this.verifyPlan("SELECT a1, b1, count(c1) FROM T1 GROUP BY a1, b1");
    }

    @Test
    public void testSingleAggOnTableWithoutUniqueKey() {
        this.verifyPlan("SELECT a3, b3, count(c3) FROM T3 GROUP BY a3, b3");
    }

    @Test
    public void testSingleAggOnTableWithUniqueKeys() {
        this.verifyPlan("SELECT  b2, c2, avg(a2) FROM T2 GROUP BY b2, c2");
    }

    @Test
    public void testSingleAggWithConstantGroupKey() {
        this.verifyPlan("SELECT a1, b1, count(c1) FROM T1 GROUP BY a1, b1, 1, true");
    }

    @Test
    public void testSingleAggOnlyConstantGroupKey() {
        this.verifyPlan("SELECT count(c1) FROM T1 GROUP BY 1, true");
    }

    @Test
    public void testMultiAggs1() {
        this.verifyPlan("SELECT a1, b1, c1, d1, m, COUNT(*) FROM (SELECT a1, b1, c1, COUNT(d1) AS d1, MAX(d1) AS m FROM T1 GROUP BY a1, b1, c1) t GROUP BY a1, b1, c1, d1, m");
    }

    @Test
    public void testMultiAggs2() {
        this.verifyPlan("SELECT a3, b3, c, s, a, COUNT(*) FROM (SELECT a3, b3, COUNT(c3) AS c, SUM(d3) AS s, AVG(d3) AS a FROM T3 GROUP BY a3, b3) t GROUP BY a3, b3, c, s, a");
    }

    @Test
    public void testAggOnInnerJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1, T2 WHERE a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnInnerJoin2() {
        this.verifyPlan("SELECT a2, b2, a3, b3, COUNT(c2), AVG(d3) FROM (SELECT * FROM T2, T3 WHERE b2 = a3) t GROUP BY a2, b2, a3, b3");
    }

    @Test
    public void testAggOnInnerJoin3() {
        this.verifyPlan("SELECT a1, b1, a2, b2, a3, b3, COUNT(c1) FROM (SELECT * FROM T1, T2, T3 WHERE a1 = b2 AND a1 = a3) t GROUP BY a1, b1, a2, b2, a3, b3");
    }

    @Test
    public void testAggOnLeftJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 LEFT JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnLeftJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 LEFT JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnLeftJoin3() {
        this.verifyPlan("SELECT a3, b3, a1, b1, COUNT(c1) FROM (SELECT * FROM T3 LEFT JOIN T1 ON a1 = a3) t GROUP BY a3, b3, a1, b1");
    }

    @Test
    public void testAggOnRightJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 RIGHT JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnRightJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 RIGHT JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnRightJoin3() {
        this.verifyPlan("SELECT a3, b3, a1, b1, COUNT(c1) FROM (SELECT * FROM T3 RIGHT JOIN T1 ON a1 = a3) t GROUP BY a3, b3, a1, b1");
    }

    @Test
    public void testAggOnFullJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 FULL OUTER JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnFullJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 FULL OUTER JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnOver() {
        this.verifyPlan("SELECT a1, b1, c, COUNT(d1) FROM (SELECT a1, b1, d1, COUNT(*) OVER (PARTITION BY c1) AS c FROM T1) t GROUP BY a1, b1, c");
    }

    @Test
    public void testAggOnWindow1() {
        this.verifyPlan("SELECT a4, b4, COUNT(c4) FROM T4 GROUP BY a4, b4, TUMBLE(d4, INTERVAL '15' MINUTE)");
    }

    @Test
    public void testAggOnWindow2() {
        this.verifyPlan("SELECT a4, c4, COUNT(b4), AVG(b4) FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)");
    }

    @Test
    public void testAggOnWindow3() {
        this.verifyPlan("SELECT a4, c4, s, COUNT(b4) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, c4, s");
    }

    @Test
    public void testAggOnWindow4() {
        this.verifyPlan("SELECT a4, c4, e, COUNT(b4) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, c4, e");
    }

    @Test
    public void testAggOnWindow5() {
        this.verifyPlan("SELECT a4, b4, c4, COUNT(*) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, b4, c4");
    }

    @Test
    public void testAggWithGroupingSets1() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY GROUPING SETS ((a1, b1), (a1, c1))");
    }

    @Test
    public void testAggWithGroupingSets2() {
        this.verifyPlan("SELECT a1, SUM(b1) AS s FROM T1 GROUP BY GROUPING SETS((a1, c1), (a1), ())");
    }

    @Test
    public void testAggWithGroupingSets3() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY GROUPING SETS ((a1, b1, c1), (a1, b1, d1))");
    }

    @Test
    public void testAggWithRollup() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY ROLLUP (a1, b1, c1)");
    }

    @Test
    public void testAggWithCube() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY CUBE (a1, b1, c1)");
    }

    @Test
    public void testSingleDistinctAgg1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT c1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg2() {
        this.verifyPlan("SELECT a1, b1, COUNT(DISTINCT c1) FROM T1 GROUP BY a1, b1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg2() {
        this.verifyPlan("SELECT a1, c1, COUNT(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1, c1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg3() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT c1), SUM(b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg4() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), SUM(b1) FROM T1 GROUP BY a1, d1");
    }

    @Test
    public void testMultiDistinctAggs1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT b1), SUM(DISTINCT b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testMultiDistinctAggs2() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), SUM(DISTINCT b1) FROM T1 GROUP BY a1, d1");
    }

    @Test
    public void testMultiDistinctAggs3() {
        this.verifyPlan("SELECT a1, SUM(DISTINCT b1), MAX(DISTINCT b1), MIN(DISTINCT c1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testMultiDistinctAggs_WithNonDistinctAgg1() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), MAX(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1, d1");
    }

    public void verifyPlan(String sqlQuery) {
        if (this.withExecPlan) {
            this.util().verifyExecPlan(sqlQuery);
            return;
        }
        this.util().verifyRelPlan(sqlQuery);
    }

    public AggregateReduceGroupingTestBase(boolean withExecPlan) {
        this.withExecPlan = withExecPlan;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

