/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.join.TemporalFunctionJoinTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e3AAD\b\u0001E!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0003q\u0003B\u0002\u001a\u0001A\u0003%q\u0006C\u00044\u0001\t\u0007I\u0011\u0001\u001b\t\rm\u0002\u0001\u0015!\u00036\u0011\u001da\u0004A1A\u0005\u0002QBa!\u0010\u0001!\u0002\u0013)\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000bM\u0003A\u0011\u0001%\t\u000bU\u0003A\u0011\u0001%\t\u000b]\u0003A\u0011\u0001%\u00031Q+W\u000e]8sC24UO\\2uS>t'j\\5o)\u0016\u001cHO\u0003\u0002\u0011#\u0005!!n\\5o\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000b\t\fGo\u00195\u000b\u0005Y9\u0012\u0001\u00029mC:T!\u0001G\r\u0002\u000fAd\u0017M\u001c8fe*\u0011!dG\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00039u\tQA\u001a7j].T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\t1s#A\u0003vi&d7/\u0003\u0002)K\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u0016\u0011\u00051\u0002Q\"A\b\u0002\tU$\u0018\u000e\\\u000b\u0002_A\u0011A\u0005M\u0005\u0003c\u0015\u0012!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u00051qN\u001d3feN,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0003qe\t1!\u00199j\u0013\tQtGA\u0003UC\ndW-A\u0004pe\u0012,'o\u001d\u0011\u0002\u0019I\fG/Z:ISN$xN]=\u0002\u001bI\fG/Z:ISN$xN]=!\u0003\u0015\u0011\u0018\r^3t+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%\u0001B+oSR\faA]1uKN\u0004\u0013A\u0004;fgR\u001c\u0016.\u001c9mK*{\u0017N\u001c\u000b\u0002\u0001\"\u0012!B\u0013\t\u0003\u0017Fk\u0011\u0001\u0014\u0006\u0003q5S!AT(\u0002\u000f),\b/\u001b;fe*\u0011\u0001kH\u0001\u0006UVt\u0017\u000e^\u0005\u0003%2\u0013A\u0001V3ti\u0006yA/Z:u\u0007>l\u0007\u000f\\3y\u0015>Lg\u000e\u000b\u0002\f\u0015\u0006!B/Z:u+:\u001cwN\u001d:fY\u0006$X\r\u001a&pS:D#\u0001\u0004&\u0002;Q,7\u000f\u001e+f[B|'/\u00197UC\ndWMR;oGRLwN\\*dC:D#!\u0004&")
public class TemporalFunctionJoinTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private final Table orders = this.util().addDataStream("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.join.TemporalFunctionJoinTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
        }
    });
    private final Table ratesHistory = this.util().addDataStream("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
            });
            ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                }
            };
            return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.join.TemporalFunctionJoinTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
        }
    });
    private final BoxedUnit rates;

    public BatchTableTestUtil util() {
        return this.util;
    }

    public Table orders() {
        return this.orders;
    }

    public Table ratesHistory() {
        return this.ratesHistory;
    }

    public void rates() {
    }

    @Test
    public void testSimpleJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o, LATERAL TABLE (Rates(o_rowtime)) AS r WHERE currency = o_currency";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sqlQuery)).hasMessageContaining("Cannot generate a valid execution plan for the given query") instanceof TableException;
    }

    @Test
    public void testComplexJoin() {
        BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
        util.addDataStream("Table3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3_comment")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3_secondary_key"))}), new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.join.TemporalFunctionJoinTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        util.addDataStream("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_comment")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_secondary_key"))}), new CaseClassTypeInfo<Tuple5<Timestamp, String, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Timestamp, String, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Timestamp, String, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Timestamp, String, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Timestamp, String, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)((Timestamp)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.join.TemporalFunctionJoinTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Table ratesHistory = util.addDataStream("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "comment")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "secondary_key"))}), new CaseClassTypeInfo<Tuple5<Timestamp, String, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Timestamp, String, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Timestamp, String, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Timestamp, String, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Timestamp, String, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)((Timestamp)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.batch.sql.join.TemporalFunctionJoinTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        TemporalTableFunction rates = ratesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$));
        util.addTemporarySystemFunction("Rates", (UserDefinedFunction)rates);
        String sqlQuery = "SELECT * FROM (SELECT o_amount * rate as rate, secondary_key as secondary_key FROM Orders AS o, LATERAL TABLE (Rates(o_rowtime)) AS r WHERE currency = o_currency OR secondary_key = o_secondary_key), Table3 WHERE t3_secondary_key = secondary_key";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> util.verifyExplain(sqlQuery));
    }

    @Test
    public void testUncorrelatedJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o, LATERAL TABLE (Rates(TIMESTAMP '2016-06-27 10:10:42.123')) AS r WHERE currency = o_currency";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sqlQuery)).hasMessageContaining("Cannot generate a valid execution plan") instanceof TableException;
    }

    @Test
    public void testTemporalTableFunctionScan() {
        String sqlQuery = "SELECT * FROM LATERAL TABLE (Rates(TIMESTAMP '2016-06-27 10:10:42.123'))";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sqlQuery)).hasMessageContaining("Cannot generate a valid execution plan") instanceof TableException;
    }

    public TemporalFunctionJoinTest() {
        this.util().addTemporarySystemFunction("Rates", (UserDefinedFunction)this.ratesHistory().createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        this.rates = BoxedUnit.UNIT;
    }
}

