/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.join.JoinTestBase$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed!\u0002\u00180\u0003\u0003\u0011\u0005\"B%\u0001\t\u0003Q\u0005bB'\u0001\u0005\u0004%\tB\u0014\u0005\u0007%\u0002\u0001\u000b\u0011B(\t\u000bM\u0003A\u0011\u0001+\t\u000b\u0019\u0004A\u0011\u0001+\t\u000b!\u0004A\u0011\u0001+\t\u000b)\u0004A\u0011\u0001+\t\u000b1\u0004A\u0011\u0001+\t\u000b9\u0004A\u0011\u0001+\t\u000bA\u0004A\u0011\u0001+\t\u000bI\u0004A\u0011\u0001+\t\u000bQ\u0004A\u0011\u0001+\t\u000bY\u0004A\u0011\u0001+\t\u000ba\u0004A\u0011\u0001+\t\u000bi\u0004A\u0011\u0001+\t\u000bq\u0004A\u0011\u0001+\t\u000by\u0004A\u0011\u0001+\t\r\u0005\u0005\u0001\u0001\"\u0001U\u0011\u0019\t)\u0001\u0001C\u0001)\"1\u0011\u0011\u0002\u0001\u0005\u0002QCa!!\u0004\u0001\t\u0003!\u0006BBA\t\u0001\u0011\u0005A\u000b\u0003\u0004\u0002\u0016\u0001!\t\u0001\u0016\u0005\u0007\u00033\u0001A\u0011\u0001+\t\r\u0005u\u0001\u0001\"\u0001U\u0011\u0019\t\t\u0003\u0001C\u0001)\"1\u0011Q\u0005\u0001\u0005\u0002QCa!!\u000b\u0001\t\u0003!\u0006BBA\u0017\u0001\u0011\u0005A\u000b\u0003\u0004\u00022\u0001!\t\u0001\u0016\u0005\u0007\u0003k\u0001A\u0011\u0001+\t\r\u0005e\u0002\u0001\"\u0001U\u0011\u0019\ti\u0004\u0001C\u0001)\"1\u0011\u0011\t\u0001\u0005\u0002QCa!!\u0012\u0001\t\u0003!\u0006BBA%\u0001\u0011\u0005A\u000b\u0003\u0004\u0002N\u0001!\t\u0001\u0016\u0005\u0007\u0003#\u0002A\u0011\u0001+\t\r\u0005U\u0003\u0001\"\u0001U\u0011\u0019\tI\u0006\u0001C\u0001)\"1\u0011Q\f\u0001\u0005\u0002QCa!!\u0019\u0001\t\u0003!\u0006BBA3\u0001\u0011\u0005A\u000b\u0003\u0004\u0002j\u0001!\t\u0001\u0016\u0005\u0007\u0003[\u0002A\u0011\u0001+\u0003\u0019){\u0017N\u001c+fgR\u0014\u0015m]3\u000b\u0005A\n\u0014\u0001\u00026pS:T!AM\u001a\u0002\u0007M\fHN\u0003\u00025k\u0005)!-\u0019;dQ*\u0011agN\u0001\u0005a2\fgN\u0003\u00029s\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u001e<\u0003\u0015!\u0018M\u00197f\u0015\taT(A\u0003gY&t7N\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<7\u0001A\n\u0003\u0001\r\u0003\"\u0001R$\u000e\u0003\u0015S!AR\u001c\u0002\u000bU$\u0018\u000e\\:\n\u0005!+%!\u0004+bE2,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017B\u0011A\nA\u0007\u0002_\u0005!Q\u000f^5m+\u0005y\u0005C\u0001#Q\u0013\t\tVI\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0017!B;uS2\u0004\u0013A\u0006;fgRTu.\u001b8O_:,\u00050[:uS:<7*Z=\u0015\u0003U\u0003\"AV-\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u0013A!\u00168ji\"\u0012A\u0001\u0018\t\u0003;\u0012l\u0011A\u0018\u0006\u0003?\u0002\f1!\u00199j\u0015\t\t'-A\u0004kkBLG/\u001a:\u000b\u0005\r|\u0014!\u00026v]&$\u0018BA3_\u0005\u0011!Vm\u001d;\u00029Q,7\u000f\u001e'fMR|U\u000f^3s\u0015>LgnV5uQ\u001aKG\u000e^3se!\u0012Q\u0001X\u0001\u001di\u0016\u001cH\u000fT3gi>+H/\u001a:K_&tw+\u001b;i\r&dG/\u001a:4Q\t1A,\u0001\u000fuKN$H*\u001a4u\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5GS2$XM\u001d\u001b)\u0005\u001da\u0016a\u0007;fgRTu.\u001b8O_:l\u0015\r^2iS:<7*Z=UsB,7\u000f\u000b\u0002\t9\u0006YB/Z:u\u0015>LgnV5uQ\u0006k'-[4v_V\u001ch)[3mIND#!\u0003/\u00023Q,7\u000f^%o]\u0016\u0014(j\\5o/&$\b.R9vSB\u0013X\r\u001a\u0015\u0003\u0015q\u000bq\u0003^3ti&sg.\u001a:K_&tw+\u001b;i\r&dG/\u001a:)\u0005-a\u0016!\t;fgRLeN\\3s\u0015>LgnV5uQ\u0016\u000bX/[!oI2{7-\u00197Qe\u0016$\u0007F\u0001\u0007]\u0003\r\"Xm\u001d;J]:,'OS8j]^KG\u000f[#rk&\fe\u000e\u001a(p]\u0016\u000bX/\u001b)sK\u0012D#!\u0004/\u00029Q,7\u000f^%o]\u0016\u0014(j\\5o/&$\bn\\;u\u0015>Lg\u000e\u0015:fI\"\u0012a\u0002X\u0001\u001di\u0016\u001cH/\u00138oKJTu.\u001b8XSRDgj\u001c8FcVL\u0007K]3eQ\tyA,A\u000fuKN$\u0018J\u001c8fe*{\u0017N\\,ji\"lU\u000f\u001c;ja2,7*Z=tQ\t\u0001B,\u0001\u0010uKN$\u0018J\u001c8fe*{\u0017N\\,ji\"LeN^3si\u0016$g)[3mI\"\u0012\u0011\u0003X\u0001\u001ei\u0016\u001cH\u000fT3gi>+H/\u001a:K_&tw+\u001b;i\u000bF,\u0018\u000e\u0015:fI\"\u0012!\u0003X\u0001&i\u0016\u001cH\u000fT3gi>+H/\u001a:K_&tw+\u001b;i\u000bF,\u0018.\u00118e\u0019>\u001c\u0017\r\u001c)sK\u0012D#a\u0005/\u0002OQ,7\u000f\u001e'fMR|U\u000f^3s\u0015>LgnV5uQ\u0016\u000bX/[!oI:{g.R9vSB\u0013X\r\u001a\u0015\u0003)q\u000b1\u0004^3ti2+g\r^(vi\u0016\u0014(j\\5o\u001d>,\u0015/^5Qe\u0016$\u0007FA\u000b]\u0003]!Xm\u001d;MK\u001a$x*\u001e;fe*{\u0017N\\(o)J,X\r\u000b\u0002\u00179\u0006AB/Z:u\u0019\u00164GoT;uKJTu.\u001b8P]\u001a\u000bGn]3)\u0005]a\u0016A\b;fgR\u0014\u0016n\u001a5u\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5FcVL\u0007K]3eQ\tAB,\u0001\u0014uKN$(+[4ii>+H/\u001a:K_&tw+\u001b;i\u000bF,\u0018.\u00118e\u0019>\u001c\u0017\r\u001c)sK\u0012D#!\u0007/\u0002QQ,7\u000f\u001e*jO\"$x*\u001e;fe*{\u0017N\\,ji\",\u0015/^5B]\u0012tuN\\#rk&\u0004&/\u001a3)\u0005ia\u0016!\t;fgR\u0014\u0016n\u001a5u\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5O_:,\u0015/^5Qe\u0016$\u0007FA\u000e]\u0003a!Xm\u001d;SS\u001eDGoT;uKJTu.\u001b8P]R\u0013X/\u001a\u0015\u00039q\u000b\u0011\u0004^3tiJKw\r\u001b;PkR,'OS8j]>sg)\u00197tK\"\u0012Q\u0004X\u0001\u001ei\u0016\u001cHOR;mY>+H/\u001a:K_&tw+\u001b;i\u000bF,\u0018\u000e\u0015:fI\"\u0012a\u0004X\u0001&i\u0016\u001cHOR;mY>+H/\u001a:K_&tw+\u001b;i\u000bF,\u0018.\u00118e\u0019>\u001c\u0017\r\u001c)sK\u0012D#a\b/\u0002OQ,7\u000f\u001e$vY2|U\u000f^3s\u0015>LgnV5uQ\u0016\u000bX/[!oI:{g.R9vSB\u0013X\r\u001a\u0015\u0003Aq\u000b\u0001\u0005^3ti\u001a+H\u000e\\(vi\u0016\u0014(j\\5o/&$\bNT8o\u000bF,\u0018\u000e\u0015:fI\"\u0012\u0011\u0005X\u0001\u0018i\u0016\u001cHOR;mY>+H/\u001a:K_&twJ\u001c+sk\u0016D#A\t/\u00021Q,7\u000f\u001e$vY2|U\u000f^3s\u0015>Lgn\u00148GC2\u001cX\r\u000b\u0002$9\u00061B/Z:u\rVdGnT;uKJ<\u0016\u000e\u001e5Vg&tw\r\u000b\u0002%9\u0006iA/Z:u\u0007J|7o\u001d&pS:D#!\n/\u0002\u0019Q,7\u000f^*fY\u001aTu.\u001b8)\u0005\u0019b\u0016a\b;fgRLeN\\3s\u0015>LgnV5uQ\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\"\u0012q\u0005X\u0001'i\u0016\u001cH/\u00138oKJTu.\u001b8XSRD'j\\5o\u0007>tG-\u001b;j_:\u0004Vo\u001d5E_^t\u0007F\u0001\u0015]\u0003y!Xm\u001d;MK\u001a$(j\\5o/&$\bNR5mi\u0016\u0014\b+^:i\t><h\u000e\u000b\u0002*9\u0006)C/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b&pS:\u001cuN\u001c3ji&|g\u000eU;tQ\u0012{wO\u001c\u0015\u0003Uq\u000bq\u0004^3tiJKw\r\u001b;K_&tw+\u001b;i\r&dG/\u001a:QkNDGi\\<oQ\tYC,\u0001\u0014uKN$(+[4ii*{\u0017N\\,ji\"Tu.\u001b8D_:$\u0017\u000e^5p]B+8\u000f\u001b#po:D#\u0001\f/\u0002]Q,7\u000f\u001e&pS:\u0004\u0016M\u001d;ji&|g\u000eV1cY\u0016<\u0016\u000e\u001e5O_:,\u00050[:uK:$\b+\u0019:uSRLwN\u001c\u0015\u0003[q\u0003")
public abstract class JoinTestBase
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testJoinNonExistingKey() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT c, g FROM MyTable1, MyTable2 WHERE foo = e"));
    }

    @Test
    public void testLeftOuterJoinWithFilter2() {
        this.util().verifyExecPlan("SELECT d, e, f FROM MyTable1 LEFT JOIN MyTable2 ON a = d where d IS NULL AND a < 12");
    }

    @Test
    public void testLeftOuterJoinWithFilter3() {
        this.util().verifyExecPlan("SELECT d, e, f FROM MyTable1 LEFT JOIN MyTable2 ON a = d where d < 10 AND a < 12");
    }

    @Test
    public void testLeftOuterJoinWithFilter4() {
        this.util().verifyExecPlan("SELECT d, e, f FROM MyTable1 LEFT JOIN MyTable2 ON a = d where d = null");
    }

    @Test
    public void testJoinNonMatchingKeyTypes() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT c, g FROM MyTable1, MyTable2 WHERE a = g"));
    }

    @Test
    public void testJoinWithAmbiguousFields() {
        this.util().addTableSource("MyTable0", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.join.JoinTestBase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT c FROM MyTable1, MyTable0 WHERE a = a0"));
    }

    @Test
    public void testInnerJoinWithEquiPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable1, MyTable2 WHERE a = d");
    }

    @Test
    public void testInnerJoinWithFilter() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable2, MyTable1 WHERE a = d AND d < 2");
    }

    @Test
    public void testInnerJoinWithEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable2 INNER JOIN MyTable1 ON a = d AND d < 2");
    }

    @Test
    public void testInnerJoinWithEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 INNER JOIN MyTable1 ON a = d AND d < 2 AND b < h");
    }

    @Test
    public void testInnerJoinWithoutJoinPred() {
        String query = "SELECT a, d FROM MyTable1, MyTable2";
        this.util().verifyExecPlan(query);
    }

    @Test
    public void testInnerJoinWithNonEquiPred() {
        String query = "SELECT a, d FROM MyTable1, MyTable2 WHERE a + 1 = d";
        this.util().verifyExecPlan(query);
    }

    @Test
    public void testInnerJoinWithMultipleKeys() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable2 INNER JOIN MyTable1 ON a = d AND b = e");
    }

    @Test
    public void testInnerJoinWithInvertedField() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable1, MyTable2 WHERE b = e AND a = d");
    }

    @Test
    public void testLeftOuterJoinWithEquiPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable1 LEFT OUTER JOIN MyTable2 ON b = e");
    }

    @Test
    public void testLeftOuterJoinWithEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable2 LEFT OUTER JOIN  MyTable1 ON a = d AND d < 2");
    }

    @Test
    public void testLeftOuterJoinWithEquiAndNonEquiPred() {
        String sql = "SELECT * FROM MyTable2 LEFT OUTER JOIN  MyTable1 ON a = d AND d < 2 AND b < h";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLeftOuterJoinNoEquiPred() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 LEFT OUTER JOIN MyTable1 ON a <> d");
    }

    @Test
    public void testLeftOuterJoinOnTrue() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 LEFT OUTER JOIN MyTable1 ON true");
    }

    @Test
    public void testLeftOuterJoinOnFalse() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 LEFT OUTER JOIN MyTable1 ON false");
    }

    @Test
    public void testRightOuterJoinWithEquiPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable1 RIGHT OUTER JOIN MyTable2 ON b = e");
    }

    @Test
    public void testRightOuterJoinWithEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable2 RIGHT OUTER JOIN  MyTable1 ON a = d AND d < 2");
    }

    @Test
    public void testRightOuterJoinWithEquiAndNonEquiPred() {
        String sql = "SELECT * FROM MyTable2 RIGHT OUTER JOIN  MyTable1 ON a = d AND d < 2 AND b < h";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRightOuterJoinWithNonEquiPred() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 RIGHT OUTER JOIN MyTable1 ON a <> d");
    }

    @Test
    public void testRightOuterJoinOnTrue() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 RIGHT OUTER JOIN MyTable1 ON true");
    }

    @Test
    public void testRightOuterJoinOnFalse() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 RIGHT OUTER JOIN MyTable1 ON false");
    }

    @Test
    public void testFullOuterJoinWithEquiPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable1 FULL OUTER JOIN MyTable2 ON b = e");
    }

    @Test
    public void testFullOuterJoinWithEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT c, g FROM MyTable2 FULL OUTER JOIN  MyTable1 ON a = d AND d < 2");
    }

    @Test
    public void testFullOuterJoinWithEquiAndNonEquiPred() {
        String sql = "SELECT * FROM MyTable2 FULL OUTER JOIN MyTable1 ON a = d AND d < 2 AND b < h";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFullOuterJoinWithNonEquiPred() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 FULL OUTER JOIN MyTable1 ON a <> d");
    }

    @Test
    public void testFullOuterJoinOnTrue() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 FULL OUTER JOIN MyTable1 ON true");
    }

    @Test
    public void testFullOuterJoinOnFalse() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 FULL OUTER JOIN MyTable1 ON false");
    }

    @Test
    public void testFullOuterWithUsing() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.join.JoinTestBase$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (SELECT * FROM MyTable1) FULL JOIN (SELECT * FROM MyTable3) USING (a)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCrossJoin() {
        this.util().verifyExecPlan("SELECT * FROM MyTable2 CROSS JOIN MyTable1");
    }

    @Test
    public void testSelfJoin() {
        this.util().addTableSource("src", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.batch.sql.join.JoinTestBase$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM\n         |  (SELECT * FROM src WHERE k = 0) src1\n         |LEFT OUTER JOIN\n         |  (SELECT * from src WHERE k = 0) src2\n         |ON (src1.k = src2.k AND src2.k > 10)\n         ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInnerJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a, count(b) as b from MyTable1 group by a)\n                          |   join\n                          |   (select d, count(e) as e from MyTable2 group by d)\n                          |   on true where a = d and b = e and d = 2\n                          |")).stripMargin());
    }

    @Test
    public void testInnerJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a, count(b) as b from MyTable1 group by a)\n                          |   join\n                          |   (select d, count(e) as e from MyTable2 group by d)\n                          |   on a = d and b = e and d = 2 and b = 1\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a, count(b) as b from MyTable1 group by a)\n                          |   left join\n                          |   (select d, count(e) as e from MyTable2 group by d)\n                          |   on true where a = d and b = e and a = 2\n                          |")).stripMargin());
    }

    @Test
    public void testLeftJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a, count(b) as b from MyTable1 group by a)\n                          |   left join\n                          |   (select d, count(e) as e from MyTable2 group by d)\n                          |   on a = d and b = e and a = 2 and e = 1\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithFilterPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a, count(b) as b from MyTable1 group by a)\n                          |   right join\n                          |   (select d, count(e) as e from MyTable2 group by d)\n                          |   on true where a = d and b = e and d = 2\n                          |")).stripMargin());
    }

    @Test
    public void testRightJoinWithJoinConditionPushDown() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT * FROM\n                          |   (select a, count(b) as b from MyTable1 group by a)\n                          |   right join\n                          |   (select d, count(e) as e from MyTable2 group by d)\n                          |   on a = d and b = e and d = 2 and b = 1\n                          |")).stripMargin());
    }

    @Test
    public void testJoinPartitionTableWithNonExistentPartition() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table leftPartitionTable (\n                               | a1 varchar,\n                               | b1 int)\n                               | partitioned by (b1) \n                               | with (\n                               | 'connector' = 'values',\n                               | 'bounded' = 'true',\n                               | 'partition-list' = 'b1:1'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table rightPartitionTable (\n                               | a2 varchar,\n                               | b2 int)\n                               | partitioned by (b2) \n                               | with (\n                               | 'connector' = 'values',\n                               | 'bounded' = 'true',\n                               | 'partition-list' = 'b2:2'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM leftPartitionTable, rightPartitionTable WHERE b1 = 1 AND b2 = 3 AND a1 = a2\n        |")).stripMargin());
    }

    public JoinTestBase() {
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.join.JoinTestBase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.join.JoinTestBase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

