/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.util.Collection;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase;
import org.apache.flink.table.planner.plan.batch.sql.agg.SortAggregateTest$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001M4A!\u0003\u0006\u0001;!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003B\u0001\u0011\u0005\u0001gB\u0003\\\u0015!\u0005ALB\u0003\n\u0015!\u0005Q\fC\u0003,\r\u0011\u0005\u0011\rC\u0003c\r\u0011\u00051MA\tT_J$\u0018iZ4sK\u001e\fG/\u001a+fgRT!a\u0003\u0007\u0002\u0007\u0005<wM\u0003\u0002\u000e\u001d\u0005\u00191/\u001d7\u000b\u0005=\u0001\u0012!\u00022bi\u000eD'BA\t\u0013\u0003\u0011\u0001H.\u00198\u000b\u0005M!\u0012a\u00029mC:tWM\u001d\u0006\u0003+Y\tQ\u0001^1cY\u0016T!a\u0006\r\u0002\u000b\u0019d\u0017N\\6\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0004\u0005\u0002 A5\t!\"\u0003\u0002\"\u0015\t\t\u0012iZ4sK\u001e\fG/\u001a+fgR\u0014\u0015m]3\u0002\u0017\u0005<wm\u0015;sCR,w-\u001f\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\naaY8oM&<'B\u0001\u0015\u0015\u0003\r\t\u0007/[\u0005\u0003U\u0015\u0012a#Q4he\u0016<\u0017\r^3QQ\u0006\u001cXm\u0015;sCR,w-_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055r\u0003CA\u0010\u0001\u0011\u0015\u0011#\u00011\u0001$\u0003\u0019\u0011WMZ8sKR\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0003V]&$\bFA\u00029!\tIt(D\u0001;\u0015\tA3H\u0003\u0002={\u00059!.\u001e9ji\u0016\u0014(B\u0001 \u001b\u0003\u0015QWO\\5u\u0013\t\u0001%H\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0004^3ti\u0006\u0003\bO]8yS6\fG/Z\"pk:$H)[:uS:\u001cG\u000f\u000b\u0002\u0005\u0007B\u0011\u0011\bR\u0005\u0003\u000bj\u0012A\u0002V3tiR+W\u000e\u001d7bi\u0016DC\u0001A$N\u001dB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JO\u0001\nKb$XM\\:j_:L!\u0001T%\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\rL\u0001PG\u0005\u0001\u0006CA)Z\u001b\u0005\u0011&BA*U\u00035\u0001\u0018M]1nKR,'/\u001b>fI*\u0011QKV\u0001\u000bKb$XM\\:j_:\u001c(B\u0001 X\u0015\tAf#A\u0005uKN$X\u000f^5mg&\u0011!L\u0015\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0001\u0012'>\u0014H/Q4he\u0016<\u0017\r^3UKN$\bCA\u0010\u0007'\t1a\f\u0005\u00023?&\u0011\u0001m\r\u0002\u0007\u0003:L(+\u001a4\u0015\u0003q\u000b!\u0002]1sC6,G/\u001a:t)\u0005!\u0007cA3kG5\taM\u0003\u0002hQ\u0006!Q\u000f^5m\u0015\u0005I\u0017\u0001\u00026bm\u0006L!a\u001b4\u0003\u0015\r{G\u000e\\3di&|g\u000e\u000b\u0003\t[B\f\bCA)o\u0013\ty'K\u0001\u0006QCJ\fW.\u001a;feN\fAA\\1nK\u0006\n!/A\bbO\u001e\u001cFO]1uK\u001eLXh\u001f\u0019~\u0001")
public class SortAggregateTest
extends AggregateTestBase {
    private final AggregatePhaseStrategy aggStrategy;

    @Parameters(name="aggStrategy={0}")
    public static Collection<AggregatePhaseStrategy> parameters() {
        return SortAggregateTest$.MODULE$.parameters();
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.HashAgg.toString());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggStrategy);
    }

    @TestTemplate
    public void testApproximateCountDistinct() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT \n        | APPROX_COUNT_DISTINCT(`byte`), \n        | APPROX_COUNT_DISTINCT(`short`), \n        | APPROX_COUNT_DISTINCT(`int`), \n        | APPROX_COUNT_DISTINCT(`long`), \n        | APPROX_COUNT_DISTINCT(`float`), \n        | APPROX_COUNT_DISTINCT(`double`), \n        | APPROX_COUNT_DISTINCT(`string`), \n        | APPROX_COUNT_DISTINCT(`date`), \n        | APPROX_COUNT_DISTINCT(`time`), \n        | APPROX_COUNT_DISTINCT(`timestamp`), \n        | APPROX_COUNT_DISTINCT(`decimal3020`), \n        | APPROX_COUNT_DISTINCT(`decimal105`)\n        | FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public SortAggregateTest(AggregatePhaseStrategy aggStrategy) {
        this.aggStrategy = aggStrategy;
    }
}

