/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q3Aa\u0004\t\u0001C!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0013i\u0003BB\u0019\u0001A\u0003%a\u0006C\u00033\u0001\u0011\u00051\u0007C\u0003F\u0001\u0011\u00051\u0007C\u0003K\u0001\u0011\u00051\u0007C\u0003M\u0001\u0011\u00051\u0007C\u0003O\u0001\u0011\u00051\u0007C\u0003Q\u0001\u0011\u00051\u0007C\u0003S\u0001\u0011\u00051\u0007C\u0003U\u0001\u0011\u00051\u0007C\u0003W\u0001\u0011\u00051\u0007C\u0003Y\u0001\u0011\u00051\u0007C\u0003[\u0001\u0011\u00051GA\bUC\ndWmU8ve\u000e,G+Z:u\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u000b\t\fGo\u00195\u000b\u0005U1\u0012\u0001\u00029mC:T!a\u0006\r\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011DG\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00037q\tQA\u001a7j].T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011C\u0001\u0001#!\t\u0019c%D\u0001%\u0015\t)c#A\u0003vi&d7/\u0003\u0002(I\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\t\u0002\tU$\u0018\u000e\\\u000b\u0002]A\u00111eL\u0005\u0003a\u0011\u0012!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u0005)1/\u001a;vaR\tA\u0007\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0003V]&$\bF\u0001\u0003<!\ta4)D\u0001>\u0015\tqt(A\u0002ba&T!\u0001Q!\u0002\u000f),\b/\u001b;fe*\u0011!IH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\tv\u0012!BQ3g_J,W)Y2i\u0003E!Xm\u001d;TS6\u0004H.\u001a)s_*,7\r\u001e\u0015\u0003\u000b\u001d\u0003\"\u0001\u0010%\n\u0005%k$\u0001\u0002+fgR\fQ\u0004^3tiNKW\u000e\u001d7f!J|'.Z2u/&$\b\u000e\u0015:pGRLW.\u001a\u0015\u0003\r\u001d\u000b!\u0004^3tiB\u0013xN[3di^KG\u000f[8vi&s\u0007/\u001e;SK\u001aD#aB$\u0002#Q,7\u000f\u001e(fgR,G\r\u0015:pU\u0016\u001cG\u000f\u000b\u0002\t\u000f\u0006YB/Z:u\u001d\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ6+G/\u00193bi\u0006D#!C$\u0002=Q,7\u000f\u001e(fgR,G\r\u0015:pU\u0016\u001cGOR5fY\u0012<\u0016\u000e\u001e5J)\u0016k\u0005F\u0001\u0006H\u0003\u0005\"Xm\u001d;UC\ndW\rS5oi^KG\u000f\u001b#jM\u001a,'/\u001a8u\u001fB$\u0018n\u001c8tQ\tYq)\u0001\u000fuKN$H+\u00192mK\"Kg\u000e^,ji\"\u001c\u0016-\\3PaRLwN\\:)\u000519\u0015a\f;fgR$\u0016M\u00197f\u0011&tGoV5uQ\u0012Kw-Z:u%\u0016,8/\u001a$pe2{w-[2bYR\u000b'\r\\3TG\u0006t\u0007FA\u0007H\u0003\u0015\"Xm\u001d;Ck&dG/\u00138Gk:\u001cG/[8o/&$\bNR5mi\u0016\u0014\b+^:iI><h\u000e\u000b\u0002\u000f\u000f\u0002")
public class TableSourceTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE ProjectableTable (\n         |  a int,\n         |  b bigint,\n         |  c varchar(32)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'bounded' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE NestedTable (\n        |  id int,\n        |  deepNested row<nested1 row<name string, `value` int>, nested2 row<num int, flag\n        |  boolean>>,\n        |  nested row<name string, `value` int>,\n        |  name string\n        |) WITH (\n        | 'connector' = 'values',\n        | 'nested-projection-supported' = 'true',\n        | 'bounded' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl2);
        String ddl3 = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |    nested2 row<num int, flag boolean>>,\n         |  metadata_1 int metadata,\n         |  metadata_2 string metadata\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'bounded' = 'true',\n         |  'readable-metadata' =\n         |    'metadata_1:INT, metadata_2:STRING, metadata_3:BIGINT'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl3);
        String ddl4 = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE NestedItemTable (\n         |  `id` INT,\n         |  `name` STRING,\n         |  `result` ROW<\n         |     `data_arr` ROW<`value` BIGINT> ARRAY,\n         |     `data_map` MAP<STRING, ROW<`value` BIGINT>>>,\n         |  `extra` STRING\n         |  ) WITH (\n         |    'connector' = 'values',\n         |    'nested-projection-supported' = 'true',\n         |    'bounded' = 'true'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl4);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'values',\n                                |  'bounded' = 'true'\n                                |)\n                                |")).stripMargin());
    }

    @Test
    public void testSimpleProject() {
        this.util().verifyExecPlan("SELECT a, c FROM ProjectableTable");
    }

    @Test
    public void testSimpleProjectWithProctime() {
        this.util().verifyExecPlan("SELECT a, c, PROCTIME() FROM ProjectableTable");
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.util().verifyExecPlan("SELECT COUNT(1) FROM ProjectableTable");
    }

    @Test
    public void testNestedProject() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM NestedTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestProjectWithMetadata() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |       deepNested.nested1 AS nested1,\n        |       deepNested.nested1.`value` + deepNested.nested2.num + metadata_1 as results\n        |FROM T\n        |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedProjectFieldWithITEM() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  `result`.`data_arr`[`id`].`value`,\n         |  `result`.`data_map`['item'].`value`\n         |FROM NestedItemTable\n         |")).stripMargin());
    }

    @Test
    public void testTableHintWithDifferentOptions() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MySink (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'filesystem',\n                                |  'format' = 'testcsv',\n                                |  'path' = '/tmp/test'\n                                |)\n       ")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n                           |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n                           |")).stripMargin());
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testTableHintWithSameOptions() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MySink (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'filesystem',\n                                |  'format' = 'testcsv',\n                                |  'path' = '/tmp/test'\n                                |)\n       ")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n                           |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n                           |")).stripMargin());
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testTableHintWithDigestReuseForLogicalTableScan() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MySink (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'filesystem',\n                                |  'format' = 'testcsv',\n                                |  'path' = '/tmp/test'\n                                |)\n       ")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='0') */\n        |union all\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                           |insert into MySink select a,b,c from MyTable\n                           |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n                           |")).stripMargin());
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testBuiltInFunctionWithFilterPushdown() {
        this.util().verifyExecPlan("SELECT a FROM ProjectableTable WHERE IFNULL(a, 1) = 1");
    }
}

