/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0015+\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0013\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006?\u0002!\t!\u0014\u0005\u0006I\u0002!\t!\u0014\u0005\u0006M\u0002!\t!\u0014\u0005\u0006Q\u0002!\t!\u0014\u0005\u0006U\u0002!\t!\u0014\u0005\u0006Y\u0002!\t!\u0014\u0005\u0006]\u0002!\t!\u0014\u0005\u0006a\u0002!\t!\u0014\u0005\u0006e\u0002!\t!\u0014\u0005\u0006i\u0002!\t!\u0014\u0005\u0006m\u0002!\t!\u0014\u0005\u0006q\u0002!\t!\u0014\u0005\u0006u\u0002!\t!\u0014\u0005\u0006y\u0002!\t!\u0014\u0005\u0006}\u0002!\t!\u0014\u0005\u0007\u0003\u0003\u0001A\u0011A'\t\r\u0005\u0015\u0001\u0001\"\u0001N\u0011\u0019\tI\u0001\u0001C\u0001\u001b\"1\u0011Q\u0002\u0001\u0005\u00025Ca!!\u0005\u0001\t\u0003i\u0005BBA\u000b\u0001\u0011\u0005Q\n\u0003\u0004\u0002\u001a\u0001!\t!\u0014\u0005\u0007\u0003;\u0001A\u0011A'\t\r\u0005\u0005\u0002\u0001\"\u0001N\u0011\u0019\t)\u0003\u0001C\u0001\u001b\"1\u0011\u0011\u0006\u0001\u0005\u00025Ca!!\f\u0001\t\u0003i\u0005BBA\u0019\u0001\u0011\u0005Q\n\u0003\u0004\u00026\u0001!\t!\u0014\u0005\u0007\u0003s\u0001A\u0011A'\t\r\u0005u\u0002\u0001\"\u0001N\u0011\u0019\t\t\u0005\u0001C\u0001\u001b\"1\u0011Q\t\u0001\u0005\u00025Ca!!\u0013\u0001\t\u0003i\u0005BBA'\u0001\u0011\u0005Q\n\u0003\u0004\u0002R\u0001!\t!\u0014\u0002\u0012%\u0016lwN^3TQV4g\r\\3UKN$(BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003[9\nQAY1uG\"T!a\f\u0019\u0002\tAd\u0017M\u001c\u0006\u0003cI\nq\u0001\u001d7b]:,'O\u0003\u00024i\u0005)A/\u00192mK*\u0011QGN\u0001\u0006M2Lgn\u001b\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0004CA\u001fA\u001b\u0005q$BA 1\u0003\u0015)H/\u001b7t\u0013\t\teHA\u0007UC\ndW\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0003\"!\u0012\u0001\u000e\u0003)\nA!\u001e;jYV\t\u0001\n\u0005\u0002>\u0013&\u0011!J\u0010\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0003tKR,\b\u000fF\u0001O!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0011)f.\u001b;)\u0005\u0011)\u0006C\u0001,^\u001b\u00059&B\u0001-Z\u0003\r\t\u0007/\u001b\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002]q\u0005)!.\u001e8ji&\u0011al\u0016\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\t;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0Pm\u0016\u0014x+\u001b8e_^\fum\u001a\u0015\u0003\u000b\u0005\u0004\"A\u00162\n\u0005\r<&\u0001\u0002+fgR\f\u0001\u0006^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX'vYRLwJ^3s/&tGm\\<BO\u001eD#AB1\u0002]Q,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~{e/\u001a:XS:$wn^!hO~\u0003\u0016M\u001d;jC2\\U-\u001f\u0015\u0003\u000f\u0005\fA\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX!hO~\u0003\u0016M\u001d;jC2\\U-\u001f\u0015\u0003\u0011\u0005\f1\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018%bg\"\fum\u001a:fO\u0006$X\r\u000b\u0002\nC\u0006)C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,w\fS1tQ\u0006;wM]3hCR,w,\r\u0015\u0003\u0015\u0005\fQ\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018%bg\"\fum\u001a:fO\u0006$Xm\u0018\u001a)\u0005-\t\u0017a\t;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0T_J$\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003\u0019\u0005\fQ\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX*peR\fum\u001a:fO\u0006$XmX\u0019)\u00055\t\u0017!\n;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0T_J$\u0018iZ4sK\u001e\fG/Z03Q\tq\u0011-A\u0012uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`'>\u0014H/T3sO\u0016Tu.\u001b8)\u0005=\t\u0017a\n;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0T_J$X*\u001a:hK*{\u0017N\\0M\u001f*C#\u0001E1\u0002OQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~\u001bvN\u001d;NKJ<WMS8j]~\u0013vJ\u0013\u0015\u0003#\u0005\fq\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX*peRlUM]4f\u0015>Lgn\u0018$P\u0015\"\u0012!#Y\u0001\u001fi\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?\"\u000b7\u000f\u001b&pS:D#aE1\u0002OQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~\u0013%o\\1eG\u0006\u001cH\u000fS1tQ*{\u0017N\u001c\u0015\u0003)\u0005\f!\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018%bg\"Tu.\u001b8`\u0019>S\u0005FA\u000bb\u0003\t\"Xm\u001d;SK6|g/\u001a%bg\"\u001c\u0006.\u001e4gY\u0016|\u0006*Y:i\u0015>Lgn\u0018*P\u0015\"\u0012a#Y\u0001#i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?\"\u000b7\u000f\u001b&pS:|fi\u0014&)\u0005]\t\u0017\u0001\t;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0ICND'j\\5o?FB#\u0001G1\u0002IQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~sUm\u001d;fI2{w\u000e\u001d&pS:D#!G1\u0002KQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~Su.\u001b8`!\u0006\u0014H/[1m\u0017\u0016L\bF\u0001\u000eb\u0003q!Xm\u001d;SK6|g/Z*j]\u001edW-\u0012=dQ\u0006tw-Z0BO\u001eD#aG1\u00027Q,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~+f.[8oQ\ta\u0012-\u0001\u000euKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`%\u0006t7\u000e\u000b\u0002\u001eC\u00061C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLU1oW~\u0003\u0016M\u001d;jC2\\U-_\u0019)\u0005y\t\u0017A\n;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0SC:\\w\fU1si&\fGnS3ze!\u0012q$Y\u0001'i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?J\u000bgn[0QCJ$\u0018.\u00197LKf\u001c\u0004F\u0001\u0011b\u0003\u0015\"Xm\u001d;SK6|g/\u001a%bg\"\u001c\u0006.\u001e4gY\u0016|&+\u00198l?NKgn\u001a7fi>t\u0017\u0007\u000b\u0002\"C\u0006)C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLU1oW~\u001b\u0016N\\4mKR|gN\r\u0015\u0003E\u0005\f\u0001\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX\"peJ,G.\u0019;fc!\u00121%Y\u0001!i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?\u000e{'O]3mCR,'\u0007\u000b\u0002%C\u0006\u0001C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wlQ8se\u0016d\u0017\r^34Q\t)\u0013-\u0001\u0012uKN$(+Z7pm\u0016\u001c\u0016N\\4mKR|gn\u00155vM\u001adWmX(wKJ\fum\u001a\u0015\u0003M\u0005\f!\u0005^3tiJ+Wn\u001c<f'&tw\r\\3u_:\u001c\u0006.\u001e4gY\u0016|\u0006*Y:i\u0003\u001e<\u0007FA\u0014b\u0003\t\"Xm\u001d;SK6|g/Z*j]\u001edW\r^8o'\",hM\u001a7f?N{'\u000f^!hO\"\u0012\u0001&\u0019")
public class RemoveShuffleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("x", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"a", "b", "c"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().addTableSource("y", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"d", "e", "f"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testRemoveHashShuffle_OverWindowAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY c) rn,\n        |   c\n        | FROM x\n        | GROUP BY c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_MultiOverWindowAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY a, c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY a, c) rn,\n        |   c\n        | FROM x\n        | GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_OverWindowAgg_PartialKey() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY c) rn,\n        |   c\n        | FROM x\n        | GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Agg_PartialKey() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | WITH r AS (SELECT a, c, count(b) as cnt FROM x GROUP BY a, c)\n        | SELECT count(cnt) FROM r group by c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate_2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate_2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_LOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x left join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_ROJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x right join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_FOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x full join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_BroadcastHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_LOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x left join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_ROJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x right join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_FOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x full join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r1 AS (SELECT a, c, sum(b) FROM x group by a, c),\n        |r2 AS (SELECT a, c, sum(b) FROM x group by a, c)\n        |SELECT * FROM r1, r2 WHERE r1.a = r2.a and r1.c = r2.c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_NestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Join_PartialKey() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT d, count(f) as cnt FROM y GROUP BY d)\n        |SELECT * FROM x, r WHERE x.a = r.d AND x.b = r.cnt\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveSingleExchange_Agg() {
        String sqlQuery = "SELECT avg(b) FROM x GROUP BY c  HAVING sum(b) > (SELECT sum(b) * 0.1 FROM x)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Union() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (\n        |SELECT count(a) as cnt, c FROM x WHERE b > 10 group by c\n        |UNION ALL\n        |SELECT count(d) as cnt, f FROM y WHERE e < 100 group by f)\n        |SELECT r1.c, r1.cnt, r2.c, r2.cnt FROM r r1, r r2 WHERE r1.c = r2.c and r1.cnt < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b) FROM (\n        | SELECT * FROM (\n        |   SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM x)\n        | WHERE rk <= 10\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b, COUNT(c) AS c FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey3() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b, COUNT(c) AS c FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_Singleton1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(ORDER BY b) rk FROM (\n        |   SELECT COUNT(a) AS a, SUM(b) AS b FROM x\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_Singleton2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM (\n        |   SELECT COUNT(a) AS a, SUM(b) AS b FROM x\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1, f, cnt FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f, f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f AND f LIKE '%llo%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate3() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveSingletonShuffle_OverAgg() {
        this.util().verifyExecPlan("SELECT SUM(b) sum_b, AVG(SUM(b)) OVER () avg_b FROM x");
    }

    @Test
    public void testRemoveSingletonShuffle_HashAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        this.util().verifyExecPlan("SELECT MAX(b) FROM (SELECT SUM(b) AS b FROM x)");
    }

    @Test
    public void testRemoveSingletonShuffle_SortAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.util().verifyExecPlan("SELECT MAX(b) FROM (SELECT SUM(b) AS b FROM x)");
    }
}

