/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.batch.sql.OperatorFusionCodegenTest$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001u4A!\u0004\b\u0001?!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00043\u0001\t\u0007I\u0011B\u001a\t\r]\u0002\u0001\u0015!\u00035\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015A\u0005\u0001\"\u0001:\u0011\u0015i\u0005\u0001\"\u0001:\u0011\u0015y\u0005\u0001\"\u0001:\u000f\u00151g\u0002#\u0001h\r\u0015ia\u0002#\u0001i\u0011\u0015i#\u0002\"\u0001m\u0011\u0015i'\u0002\"\u0001o\u0005ey\u0005/\u001a:bi>\u0014h)^:j_:\u001cu\u000eZ3hK:$Vm\u001d;\u000b\u0005=\u0001\u0012aA:rY*\u0011\u0011CE\u0001\u0006E\u0006$8\r\u001b\u0006\u0003'Q\tA\u0001\u001d7b]*\u0011QCF\u0001\ba2\fgN\\3s\u0015\t9\u0002$A\u0003uC\ndWM\u0003\u0002\u001a5\u0005)a\r\\5oW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\"\u0012!B;uS2\u001c\u0018BA\u0013#\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u0006!b-^:j_:\u001cu\u000eZ3hK:,e.\u00192mK\u0012\u0004\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u00039AQA\n\u0002A\u0002\u001d\nA!\u001e;jYV\tA\u0007\u0005\u0002\"k%\u0011aG\t\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG.A\u0003vi&d\u0007%A\u0003tKR,\b\u000fF\u0001;!\tA3(\u0003\u0002=S\t!QK\\5uQ\t)a\b\u0005\u0002@\r6\t\u0001I\u0003\u0002B\u0005\u0006\u0019\u0011\r]5\u000b\u0005\r#\u0015a\u00026va&$XM\u001d\u0006\u0003\u000br\tQA[;oSRL!a\u0012!\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0010uKN$\b*Y:i\u0003\u001e<\u0017i]'vi2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f\u001e*p_RD#A\u0002&\u0011\u0005}Z\u0015B\u0001'A\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0003\u0011\"Xm\u001d;M_\u000e\fG\u000eS1tQ\u0006;w-Q:NkRdG/\u001b9mK&s\u0007/\u001e;S_>$\bFA\u0004K\u0003q!Xm\u001d;DC2\u001c\u0017i]'vi2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f\u001e*p_RD#\u0001\u0003&)\t\u0001\u0011\u0006,\u0017\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0002\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005]#&AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\n!lI\u0001\\!\taF-D\u0001^\u0015\tqv,A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0003A\u0006\f!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\t)%M\u0003\u0002d1\u0005IA/Z:ukRLGn]\u0005\u0003Kv\u0013!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:\f\u0011d\u00149fe\u0006$xN\u001d$vg&|gnQ8eK\u001e,g\u000eV3tiB\u0011\u0001GC\n\u0003\u0015%\u0004\"\u0001\u000b6\n\u0005-L#AB!osJ+g\rF\u0001h\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0002_B\u0019\u0001\u000f^\u0014\u000e\u0003ET!A\r:\u000b\u0003M\fAA[1wC&\u0011Q/\u001d\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0006\u0002\u0007xun\u0004\"\u0001\u0018=\n\u0005el&A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\u0005a\u0018\u0001\u00074vg&|gnQ8eK\u001e,g.\u00128bE2,G-P>1{\u0002")
public class OperatorFusionCodegenTest
extends TableTestBase {
    private final boolean fusionCodegenEnabled;
    private final BatchTableTestUtil util;

    @Parameters(name="fusionCodegenEnabled={0}")
    public static Collection<Object> parameters() {
        return OperatorFusionCodegenTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("T1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a1"))).build());
        this.util().addTableSource("T2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"b2"), (Object)ImmutableSet.of((Object)"a2", (Object)"b2"))).build());
        this.util().addTableSource("T3", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"a3", "b3", "c3", "d3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L)).build());
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.fusionCodegenEnabled));
    }

    @TestTemplate
    public void testHashAggAsMutltipleInputRoot() {
        this.util().verifyExecPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1, T2 WHERE a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @TestTemplate
    public void testLocalHashAggAsMutltipleInputRoot() {
        this.util().verifyExecPlan("SELECT a2, b2, a3, b3, COUNT(c2), AVG(d3) FROM (SELECT * FROM T2, T3 WHERE b2 = a3) t GROUP BY a2, b2, a3, b3");
    }

    @TestTemplate
    public void testCalcAsMutltipleInputRoot() {
        this.util().verifyExecPlan("SELECT a1, b1, a2, b2, a3, b3, COUNT(c1) FROM (SELECT * FROM T1, T2, T3 WHERE a1 = b2 AND a1 = a3) t GROUP BY a1, b1, a2, b2, a3, b3");
    }

    public OperatorFusionCodegenTest(boolean fusionCodegenEnabled) {
        this.fusionCodegenEnabled = fusionCodegenEnabled;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

