/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.CalcTest$;
import org.apache.flink.table.planner.plan.utils.MyPojo;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\u0012$\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004E\u0001\u0001\u0006I!\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u00061\u0002!\tA\u0012\u0005\u0006;\u0002!\tA\u0012\u0005\u0006?\u0002!\tA\u0012\u0005\u0006C\u0002!\tA\u0012\u0005\u0006G\u0002!\tA\u0012\u0005\u0006K\u0002!\tA\u0012\u0005\u0006O\u0002!\tA\u0012\u0005\u0006S\u0002!\tA\u0012\u0005\u0006W\u0002!\tA\u0012\u0005\u0006[\u0002!\tA\u0012\u0005\u0006_\u0002!\tA\u0012\u0005\u0006c\u0002!\tA\u0012\u0005\u0006g\u0002!\tA\u0012\u0005\u0006k\u0002!\tA\u0012\u0005\u0006o\u0002!\tA\u0012\u0005\u0006s\u0002!\tA\u0012\u0005\u0006w\u0002!\tA\u0012\u0005\u0006{\u0002!\tA\u0012\u0005\u0006\u007f\u0002!\tA\u0012\u0005\u0007\u0003\u0007\u0001A\u0011\u0001$\t\r\u0005\u001d\u0001\u0001\"\u0001G\u0011\u0019\tY\u0001\u0001C\u0001\r\"1\u0011q\u0002\u0001\u0005\u0002\u0019Ca!a\u0005\u0001\t\u00031\u0005BBA\f\u0001\u0011\u0005a\t\u0003\u0004\u0002\u001c\u0001!\tA\u0012\u0005\u0007\u0003?\u0001A\u0011\u0001$\t\r\u0005\r\u0002\u0001\"\u0001G\u0011\u0019\t9\u0003\u0001C\u0001\r\nA1)\u00197d)\u0016\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!\u00022bi\u000eD'B\u0001\u0015*\u0003\u0011\u0001H.\u00198\u000b\u0005)Z\u0013a\u00029mC:tWM\u001d\u0006\u0003Y5\nQ\u0001^1cY\u0016T!AL\u0018\u0002\u000b\u0019d\u0017N\\6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0007\u0005\u00027s5\tqG\u0003\u00029S\u0005)Q\u000f^5mg&\u0011!h\u000e\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005i\u0004C\u0001 \u0001\u001b\u0005\u0019\u0013\u0001B;uS2,\u0012!\u0011\t\u0003m\tK!aQ\u001c\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\\\u0001\u0006kRLG\u000eI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5uQ\t!a\n\u0005\u0002P-6\t\u0001K\u0003\u0002R%\u0006\u0019\u0011\r]5\u000b\u0005M#\u0016a\u00026va&$XM\u001d\u0006\u0003+F\nQA[;oSRL!a\u0016)\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\buKN$xJ\u001c7z!J|'.Z2uQ\t)!\f\u0005\u0002P7&\u0011A\f\u0015\u0002\u0005)\u0016\u001cH/A\u000buKN$\bK]8kK\u000e$x+\u001b;i\u001d\u0006l\u0017N\\4)\u0005\u0019Q\u0016!\u0005;fgRlU\u000f\u001c;j!J|'.Z2ug\"\u0012qAW\u0001\u000fi\u0016\u001cHo\u00148ms\u001aKG\u000e^3sQ\tA!,A\u000buKN$H)[:kk:\u001cG/\u001b<f\r&dG/\u001a:)\u0005%Q\u0016!\u0006;fgR\u001cuN\u001c6v]\u000e$\u0018N^3GS2$XM\u001d\u0015\u0003\u0015i\u000b\u0001\u0003^3ti6+H\u000e^5GS2$XM]:)\u0005-Q\u0016\u0001\u0006;fgR\u0004&o\u001c6fGR\fe\u000e\u001a$jYR,'\u000f\u000b\u0002\r5\u00061A/Z:u\u0013:D#!\u0004.\u0002/Q,7\u000f^%o\u001d>t7i\u001c8ti\u0006tGOV1mk\u0016\u001c\bF\u0001\b[\u0003%!Xm\u001d;O_RLe\u000e\u000b\u0002\u00105\u00061B/Z:u\u001bVdG/\u001b9mK\u001ac\u0017\r\u001e;f]&tw\r\u000b\u0002\u00115\u0006\tB/Z:u\u0013:4\u0018\r\\5e\r&,G\u000eZ:)\u0005EQ\u0016\u0001\u0006;fgR\u0004&/[7ji&4X-T1q)f\u0004X\r\u000b\u0002\u00135\u00069B/Z:u\u001d>t\u0007K]5nSRLg/Z'baRK\b/\u001a\u0015\u0003'i\u000b1\u0002^3tiJ{w\u000fV=qK\"\u0012ACW\u0001\u000ei\u0016\u001cH/\u0011:sCf$\u0016\u0010]3)\u0005UQ\u0016a\u0006;fgR\u0004&o\u001c6fGR<\u0016\u000e\u001e5ECR,G+\u001f9fQ\t1\",\u0001\fuKN$h)\u001b7uKJ<\u0016\u000e\u001e5ECR,G+\u001f9fQ\t9\",\u0001\u0007uKN$\bk\u001c6p)f\u0004X\r\u000b\u0002\u00195\u0006iA/Z:u\u001b&DX\r\u001a+za\u0016D#!\u0007.\u00023Q,7\u000f^\"pY2\fG/[8o\t\u0016\u0014\u0018N^3P]\u000e\u000bGn\u0019\u0015\u00035i\u000b\u0011\u0004^3ti>\u0013x+\u001b;i\u0013NtU\u000f\u001c7Qe\u0016$\u0017nY1uK\"\u00121DW\u0001\u0015i\u0016\u001cHo\u0014:XSRD\u0017j\u001d(vY2Le.\u00134)\u0005qQ\u0016A\n;fgR$UmY5nC2\f%O]1z/&$\b\u000eR5gM\u0016\u0014XM\u001c;Qe\u0016\u001c\u0017n]5p]\"\u0012QDW\u0001%i\u0016\u001cH\u000fR3dS6\fG.T1q/&$\b\u000eR5gM\u0016\u0014XM\u001c;Qe\u0016\u001c\u0017n]5p]\"\u0012aDW\u0001&i\u0016\u001cHoQ1mG6+'oZ3XSRDgj\u001c8EKR,'/\\5oSN$\u0018nY#yaJD#a\b.\u0002MQ,7\u000f^\"bY\u000elUM]4f/&$\bNT8o\t\u0016$XM]7j]&\u001cH/[2FqB\u0014(\u0007\u000b\u0002!5\u0006QB/Z:u\u0007\u0006d7-T3sO\u0016<\u0016\u000e\u001e5D_J\u0014X\r\\1uK\"\u0012\u0011E\u0017")
public class CalcTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testOnlyProject() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable");
    }

    @Test
    public void testProjectWithNaming() {
        this.util().verifyExecPlan("SELECT `1-_./\u00dc`, b, c FROM (SELECT a as `1-_./\u00dc`, b, c FROM MyTable)");
    }

    @Test
    public void testMultiProjects() {
        this.util().verifyExecPlan("SELECT c FROM (SELECT a, c FROM MyTable)");
    }

    @Test
    public void testOnlyFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 0");
    }

    @Test
    public void testDisjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 OR a > 20");
    }

    @Test
    public void testConjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 AND b > 20");
    }

    @Test
    public void testMultiFilters() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT * FROM MyTable WHERE b > 0) t WHERE a < 50");
    }

    @Test
    public void testProjectAndFilter() {
        this.util().verifyExecPlan("SELECT a, b + 1 FROM MyTable WHERE b > 2");
    }

    @Test
    public void testIn() {
        String sql = "SELECT * FROM MyTable WHERE b IN (1, 3, 4, 5, 6) AND c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInNonConstantValues() {
        String sql = "SELECT * FROM MyTable WHERE b IN (1, 3, CAST(a AS INT), 5, 6) AND c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNotIn() {
        String sql = "SELECT * FROM MyTable WHERE b NOT IN (1, 3, 4, 5, 6) OR c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleFlattening() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this, fieldSerializers){

                    public Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((Tuple2)fields[0]), (Object)((Tuple2)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT MyTable2.a.*, c, MyTable2.b.* FROM MyTable2");
    }

    @Test
    public void testInvalidFields() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().tableEnv().sqlQuery("SELECT a, foo FROM MyTable"));
    }

    @Test
    public void testPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[b, 30, 10, a] FROM MyTable");
    }

    @Test
    public void testNonPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[a, c] FROM MyTable");
    }

    @Test
    public void testRowType() {
        this.util().verifyExecPlan("SELECT ROW(1, 'Hi', a) FROM MyTable");
    }

    @Test
    public void testArrayType() {
        this.util().verifyExecPlan("SELECT ARRAY['Hi', 'Hello', c] FROM MyTable");
    }

    @Test
    public void testProjectWithDateType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c,\n        | DATE '1984-07-12',\n        | TIME '14:34:24',\n        | TIMESTAMP '1984-07-12 14:34:24'\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterWithDateType() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Date, Time, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Date, Time, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((Date)fields[1]), (Object)((Time)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$13 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable3\n        |WHERE b = DATE '1984-07-12' AND c = TIME '14:34:24' AND d = TIMESTAMP '1984-07-12 14:34:24'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testPojoType() {
        this.util().addTableSource("MyTable4", (AbstractDataType[])((Object[])new AbstractDataType[]{DataTypes.STRUCTURED(MyPojo.class, (DataTypes.Field[])new DataTypes.Field[0])}), (String[])((Object[])new String[]{"a"}));
        this.util().verifyExecPlan("SELECT a FROM MyTable4");
    }

    @Test
    public void testMixedType() {
        this.util().addTableSource("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$15 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT ROW(a, b, c), ARRAY[12, b], MAP[a, c] FROM MyTable5 WHERE (a, b, c) = ('foo', 12, TIMESTAMP '1984-07-12 14:34:24')");
    }

    @Test
    public void testCollationDeriveOnCalc() {
        this.util().verifyExecPlan("SELECT CAST(a AS INT), CAST(b AS VARCHAR) FROM (VALUES (3, 'c')) T(a,b)");
    }

    @Test
    public void testOrWithIsNullPredicate() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 10 OR a IS NULL");
    }

    @Test
    public void testOrWithIsNullInIf() {
        this.util().verifyExecPlan("SELECT IF(c = '' OR c IS NULL, 'a', 'b') FROM MyTable");
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT ARRAY[0.12, 0.5, 0.99]");
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT MAP['a', 0.12, 'b', 0.5]");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr() {
        String sqlQuery = "SELECT a, a1 FROM (SELECT a, random_udf(b) AS a1 FROM MyTable) t WHERE a1 > 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        String sqlQuery = "SELECT a FROM (SELECT a, b FROM MyTable) t WHERE random_udf(b) > 10";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithCorrelate() {
        this.util().addTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, r FROM (\n        | SELECT a, random_udf(b) r FROM (\n        |  select a, b, c1 FROM MyTable, LATERAL TABLE(str_split(c)) AS T(c1)\n        | ) t\n        |)\n        |WHERE r > 10\n        |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

