/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ReplaceTableAsOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversionTestBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SqlRTASNodeToOperationConverterTest
extends SqlNodeToOperationConversionTestBase {
    @Test
    public void testReplaceTableAs() {
        String tableName = "replace_table";
        String tableComment = "test table comment \u8868\u63cf\u8ff0";
        String sql = "REPLACE TABLE " + tableName + " COMMENT '" + tableComment + "' WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        this.testCommonReplaceTableAs(sql, tableName, tableComment);
    }

    @Test
    public void testReplaceTableAsWithOrderingColumns() {
        String tableName = "replace_table";
        String sql = "REPLACE TABLE " + tableName + " (a, b) WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT b, a FROM t1";
        Schema tableSchema = Schema.newBuilder().column("a", DataTypes.BIGINT().notNull()).column("b", (AbstractDataType)DataTypes.STRING()).build();
        this.testCommonReplaceTableAs(sql, tableName, null, tableSchema, null, Collections.emptyList());
    }

    @Test
    public void testReplaceTableAsWithNotFoundColumnIdentifiers() {
        String tableName = "replace_table";
        String sql = "REPLACE TABLE " + tableName + " (a, d) WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT b, a FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("Column 'd' not found in the source schema.");
    }

    @Test
    public void testReplaceTableAsWithMismatchIdentifiersLength() {
        String tableName = "replace_table";
        String sql = "REPLACE TABLE " + tableName + " (a) WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT b, a FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("The number of columns in the column list must match the number of columns in the source schema.");
    }

    @Test
    public void testCreateOrReplaceTableAs() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + " WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        this.testCommonReplaceTableAs(sql, tableName, null);
    }

    @Test
    public void testCreateOrReplaceTableAsWithColumns() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(c0 int, c1 double metadata, c2 as c0 * a, c3 int metadata virtual)  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        Schema tableSchema = Schema.newBuilder().column("c0", (AbstractDataType)DataTypes.INT()).columnByMetadata("c1", (AbstractDataType)DataTypes.DOUBLE()).columnByExpression("c2", "`c0` * `a`").columnByMetadata("c3", (AbstractDataType)DataTypes.INT(), true).fromSchema(this.getDefaultTableSchema()).build();
        this.testCommonReplaceTableAs(sql, tableName, null, tableSchema, null, Collections.emptyList());
    }

    @Test
    public void testCreateOrReplaceTableAsWithColumnsOverridden() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(c0 int, a double, bb string, c int metadata, dd string metadata)  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT a, b as `bb`, c, d as `dd` FROM t1";
        Schema tableSchema = Schema.newBuilder().column("c0", (AbstractDataType)DataTypes.INT()).column("a", (AbstractDataType)DataTypes.DOUBLE()).column("bb", (AbstractDataType)DataTypes.STRING()).columnByMetadata("c", (AbstractDataType)DataTypes.INT()).columnByMetadata("dd", (AbstractDataType)DataTypes.STRING()).build();
        this.testCommonReplaceTableAs(sql, tableName, null, tableSchema, null, Collections.emptyList());
    }

    @Test
    public void testCreateOrReplaceTableAsWithNotNullColumnsAreNotAllowed() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(c0 int not null)  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("Column 'c0' has no default value and does not allow NULLs.");
    }

    @Test
    public void testCreateOrReplaceTableAsWithOverriddenVirtualMetadataColumnsNotAllowed() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(c int metadata virtual)  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("A column named 'c' already exists in the source schema. Virtual metadata columns cannot overwrite columns from source.");
    }

    @Test
    public void testCreateOrReplaceTableAsWithOverriddenComputedColumnsNotAllowed() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(c as 'f0 * 2')  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("A column named 'c' already exists in the source schema. Computed columns cannot overwrite columns from source.");
    }

    @Test
    public void testCreateOrReplaceTableAsWithIncompatibleImplicitCastTypes() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(a boolean)  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parseAndConvert(sql)).isInstanceOf(ValidationException.class)).hasMessageContaining("Incompatible types for sink column 'a' at position 0. The source column has type 'BIGINT NOT NULL', while the target column has type 'BOOLEAN'.");
    }

    @Test
    public void testCreateOrReplaceTableAsWithDistribution() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + " DISTRIBUTED BY HASH(b) INTO 2 BUCKETS  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        Schema tableSchema = Schema.newBuilder().fromSchema(this.getDefaultTableSchema()).build();
        this.testCommonReplaceTableAs(sql, tableName, null, tableSchema, TableDistribution.ofHash(Collections.singletonList("b"), (Integer)2), Collections.emptyList());
    }

    @Test
    public void testCreateOrReplaceTableAsWithPrimaryKey() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(PRIMARY KEY (a) NOT ENFORCED)  WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        Schema tableSchema = Schema.newBuilder().column("a", DataTypes.BIGINT().notNull()).column("b", (AbstractDataType)DataTypes.STRING()).column("c", (AbstractDataType)DataTypes.INT()).column("d", (AbstractDataType)DataTypes.STRING()).primaryKey(new String[]{"a"}).build();
        this.testCommonReplaceTableAs(sql, tableName, null, tableSchema, null, Collections.emptyList());
    }

    @Test
    public void testCreateOrReplaceTableAsWithWatermark() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + "(c0 TIMESTAMP(3), WATERMARK FOR c0 AS c0 - INTERVAL '3' SECOND) WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        Schema tableSchema = Schema.newBuilder().column("c0", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).column("a", DataTypes.BIGINT().notNull()).column("b", (AbstractDataType)DataTypes.STRING()).column("c", (AbstractDataType)DataTypes.INT()).column("d", (AbstractDataType)DataTypes.STRING()).watermark("c0", "`c0` - INTERVAL '3' SECOND").build();
        this.testCommonReplaceTableAs(sql, tableName, null, tableSchema, null, Collections.emptyList());
    }

    private void testCommonReplaceTableAs(String sql, String tableName, @Nullable String tableComment) {
        this.testCommonReplaceTableAs(sql, tableName, tableComment, this.getDefaultTableSchema(), null, Collections.emptyList());
    }

    private void testCommonReplaceTableAs(String sql, String tableName, @Nullable String tableComment, Schema tableSchema, @Nullable TableDistribution distribution, List<String> partitionKey) {
        ObjectIdentifier expectedIdentifier = ObjectIdentifier.of((String)"builtin", (String)"default", (String)tableName);
        Operation operation = this.parseAndConvert(sql);
        CatalogTable expectedCatalogTable = CatalogTable.newBuilder().schema(tableSchema).comment(tableComment).distribution(distribution).options(this.getDefaultTableOptions()).partitionKeys(partitionKey).build();
        this.verifyReplaceTableAsOperation(operation, expectedIdentifier, expectedCatalogTable);
    }

    private Operation parseAndConvert(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlNodeToOperationConversion.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private void verifyReplaceTableAsOperation(Operation operation, ObjectIdentifier expectedTableIdentifier, CatalogTable expectedCatalogTable) {
        Assertions.assertThat((Object)operation).isInstanceOf(ReplaceTableAsOperation.class);
        ReplaceTableAsOperation replaceTableAsOperation = (ReplaceTableAsOperation)operation;
        CreateTableOperation createTableOperation = replaceTableAsOperation.getCreateTableOperation();
        Assertions.assertThat((boolean)createTableOperation.isTemporary()).isFalse();
        Assertions.assertThat((boolean)createTableOperation.isIgnoreIfExists()).isFalse();
        Assertions.assertThat((Object)createTableOperation.getTableIdentifier()).isEqualTo((Object)expectedTableIdentifier);
        this.verifyCatalogTable(expectedCatalogTable, (CatalogTable)createTableOperation.getCatalogTable());
    }

    private void verifyCatalogTable(CatalogTable expectedCatalogTable, CatalogTable actualCatalogTable) {
        Assertions.assertThat((Object)actualCatalogTable.getUnresolvedSchema()).isEqualTo((Object)expectedCatalogTable.getUnresolvedSchema());
        Assertions.assertThat((String)actualCatalogTable.getComment()).isEqualTo(expectedCatalogTable.getComment());
        Assertions.assertThat((List)actualCatalogTable.getPartitionKeys()).isEqualTo((Object)expectedCatalogTable.getPartitionKeys());
        Assertions.assertThat((Map)actualCatalogTable.getOptions()).isEqualTo((Object)expectedCatalogTable.getOptions());
        Assertions.assertThat((Optional)actualCatalogTable.getDistribution()).isEqualTo((Object)expectedCatalogTable.getDistribution());
    }

    private Map<String, String> getDefaultTableOptions() {
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("k1", "v1");
        expectedOptions.put("k2", "v2");
        return expectedOptions;
    }

    private Schema getDefaultTableSchema() {
        return Schema.newBuilder().fromFields(new String[]{"a", "b", "c", "d"}, new AbstractDataType[]{DataTypes.BIGINT().notNull(), DataTypes.STRING(), DataTypes.INT(), DataTypes.STRING()}).build();
    }
}

