/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableAsQueryOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableRefreshOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableResumeOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableSuspendOperation;
import org.apache.flink.table.operations.materializedtable.CreateMaterializedTableOperation;
import org.apache.flink.table.operations.materializedtable.DropMaterializedTableOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversionTestBase;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SqlMaterializedTableNodeToOperationConverterTest
extends SqlNodeToOperationConversionTestBase {
    @Override
    @BeforeEach
    public void before() throws TableAlreadyExistException, DatabaseNotExistException {
        super.before();
        ObjectPath path3 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t3");
        Schema tableSchema = Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"b", (DataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE)), Column.physical((String)"c", (DataType)DataTypes.INT()), Column.physical((String)"d", (DataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE))})).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "COLLECTION");
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(tableSchema).comment("").partitionKeys(Arrays.asList("b", "c")).options(options).build();
        this.catalog.createTable(path3, (CatalogBaseTable)catalogTable, true);
        String sql = "CREATE MATERIALIZED TABLE base_mtbl (\n   CONSTRAINT ct1 PRIMARY KEY(a) NOT ENFORCED)\nCOMMENT 'materialized table comment'\nPARTITIONED BY (a, d)\nWITH (\n  'connector' = 'filesystem', \n  'format' = 'json'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1";
        ObjectPath path4 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "base_mtbl");
        CreateMaterializedTableOperation operation = (CreateMaterializedTableOperation)this.parse("CREATE MATERIALIZED TABLE base_mtbl (\n   CONSTRAINT ct1 PRIMARY KEY(a) NOT ENFORCED)\nCOMMENT 'materialized table comment'\nPARTITIONED BY (a, d)\nWITH (\n  'connector' = 'filesystem', \n  'format' = 'json'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1");
        this.catalog.createTable(path4, (CatalogBaseTable)operation.getCatalogMaterializedTable(), true);
    }

    @Test
    void testCreateMaterializedTable() {
        String sql = "CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(a) NOT ENFORCED)\nCOMMENT 'materialized table comment'\nPARTITIONED BY (a, d)\nWITH (\n  'connector' = 'filesystem', \n  'format' = 'json'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1";
        Operation operation = this.parse("CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(a) NOT ENFORCED)\nCOMMENT 'materialized table comment'\nPARTITIONED BY (a, d)\nWITH (\n  'connector' = 'filesystem', \n  'format' = 'json'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1");
        Assertions.assertThat((Object)operation).isInstanceOf(CreateMaterializedTableOperation.class);
        CreateMaterializedTableOperation op = (CreateMaterializedTableOperation)operation;
        CatalogMaterializedTable materializedTable = op.getCatalogMaterializedTable();
        Assertions.assertThat((Object)materializedTable).isInstanceOf(ResolvedCatalogMaterializedTable.class);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "filesystem");
        options.put("format", "json");
        CatalogMaterializedTable expected = CatalogMaterializedTable.newBuilder().schema(Schema.newBuilder().column("a", DataTypes.BIGINT().notNull()).column("b", (AbstractDataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE)).column("c", (AbstractDataType)DataTypes.INT()).column("d", (AbstractDataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE)).primaryKeyNamed("ct1", Collections.singletonList("a")).build()).comment("materialized table comment").options(options).partitionKeys(Arrays.asList("a", "d")).freshness(IntervalFreshness.ofSecond((String)"30")).logicalRefreshMode(CatalogMaterializedTable.LogicalRefreshMode.FULL).refreshMode(CatalogMaterializedTable.RefreshMode.FULL).refreshStatus(CatalogMaterializedTable.RefreshStatus.INITIALIZING).definitionQuery("SELECT *\nFROM `builtin`.`default`.`t1`").build();
        Assertions.assertThat((Object)((ResolvedCatalogMaterializedTable)materializedTable).getOrigin()).isEqualTo((Object)expected);
    }

    @Test
    void testCreateMaterializedTableWithUDTFQuery() {
        this.functionCatalog.registerCatalogFunction(UnresolvedIdentifier.of((ObjectIdentifier)ObjectIdentifier.of((String)this.catalogManager.getCurrentCatalog(), (String)"default", (String)"myFunc")), TableFunc0.class, true);
        String sql = "CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(a) NOT ENFORCED)\nCOMMENT 'materialized table comment'\nPARTITIONED BY (a)\nWITH (\n  'connector' = 'filesystem', \n  'format' = 'json'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT a, f1, f2 FROM t1,LATERAL TABLE(myFunc(b)) as T(f1, f2)";
        Operation operation = this.parse("CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(a) NOT ENFORCED)\nCOMMENT 'materialized table comment'\nPARTITIONED BY (a)\nWITH (\n  'connector' = 'filesystem', \n  'format' = 'json'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT a, f1, f2 FROM t1,LATERAL TABLE(myFunc(b)) as T(f1, f2)");
        Assertions.assertThat((Object)operation).isInstanceOf(CreateMaterializedTableOperation.class);
        CreateMaterializedTableOperation createOperation = (CreateMaterializedTableOperation)operation;
        Assertions.assertThat((String)createOperation.getCatalogMaterializedTable().getDefinitionQuery()).isEqualTo("SELECT `t1`.`a`, `T`.`f1`, `T`.`f2`\nFROM `builtin`.`default`.`t1`,\nLATERAL TABLE(`builtin`.`default`.`myFunc`(`b`)) AS `T` (`f1`, `f2`)");
    }

    @Test
    void testContinuousRefreshMode() {
        String sql = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1";
        Operation operation = this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1");
        Assertions.assertThat((Object)operation).isInstanceOf(CreateMaterializedTableOperation.class);
        CreateMaterializedTableOperation op = (CreateMaterializedTableOperation)operation;
        CatalogMaterializedTable materializedTable = op.getCatalogMaterializedTable();
        Assertions.assertThat((Object)materializedTable).isInstanceOf(ResolvedCatalogMaterializedTable.class);
        Assertions.assertThat((Comparable)materializedTable.getLogicalRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.LogicalRefreshMode.AUTOMATIC);
        Assertions.assertThat((Comparable)materializedTable.getRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.RefreshMode.CONTINUOUS);
        String sql2 = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' DAY\nREFRESH_MODE = CONTINUOUS\nAS SELECT * FROM t1";
        Operation operation2 = this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' DAY\nREFRESH_MODE = CONTINUOUS\nAS SELECT * FROM t1");
        Assertions.assertThat((Object)operation2).isInstanceOf(CreateMaterializedTableOperation.class);
        CreateMaterializedTableOperation op2 = (CreateMaterializedTableOperation)operation2;
        CatalogMaterializedTable materializedTable2 = op2.getCatalogMaterializedTable();
        Assertions.assertThat((Object)materializedTable2).isInstanceOf(ResolvedCatalogMaterializedTable.class);
        Assertions.assertThat((Comparable)materializedTable2.getLogicalRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.LogicalRefreshMode.CONTINUOUS);
        Assertions.assertThat((Comparable)materializedTable2.getRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.RefreshMode.CONTINUOUS);
    }

    @Test
    void testFullRefreshMode() {
        String sql = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '1' DAY\nAS SELECT * FROM t1";
        Operation operation = this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '1' DAY\nAS SELECT * FROM t1");
        Assertions.assertThat((Object)operation).isInstanceOf(CreateMaterializedTableOperation.class);
        CreateMaterializedTableOperation op = (CreateMaterializedTableOperation)operation;
        CatalogMaterializedTable materializedTable = op.getCatalogMaterializedTable();
        Assertions.assertThat((Object)materializedTable).isInstanceOf(ResolvedCatalogMaterializedTable.class);
        Assertions.assertThat((Comparable)materializedTable.getLogicalRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.LogicalRefreshMode.AUTOMATIC);
        Assertions.assertThat((Comparable)materializedTable.getRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.RefreshMode.FULL);
        String sql2 = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1";
        Operation operation2 = this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1");
        Assertions.assertThat((Object)operation2).isInstanceOf(CreateMaterializedTableOperation.class);
        CreateMaterializedTableOperation op2 = (CreateMaterializedTableOperation)operation2;
        CatalogMaterializedTable materializedTable2 = op2.getCatalogMaterializedTable();
        Assertions.assertThat((Object)materializedTable2).isInstanceOf(ResolvedCatalogMaterializedTable.class);
        Assertions.assertThat((Comparable)materializedTable2.getLogicalRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.LogicalRefreshMode.FULL);
        Assertions.assertThat((Comparable)materializedTable2.getRefreshMode()).isEqualTo((Object)CatalogMaterializedTable.RefreshMode.FULL);
        String sql3 = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '40' MINUTE\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '40' MINUTE\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, only freshness that are factors of 60 are currently supported when the time unit is MINUTE.");
    }

    @Test
    void testCreateMaterializedTableWithInvalidPrimaryKey() {
        String sql = "CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 UNIQUE(a) NOT ENFORCED)\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 UNIQUE(a) NOT ENFORCED)\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Primary key validation failed: UNIQUE constraint is not supported yet.");
        String sql2 = "CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(e) NOT ENFORCED)\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(e) NOT ENFORCED)\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Primary key column 'e' not defined in the query schema. Available columns: ['a', 'b', 'c', 'd'].");
        String sql3 = "CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(d) NOT ENFORCED)\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1 (\n   CONSTRAINT ct1 PRIMARY KEY(d) NOT ENFORCED)\nFRESHNESS = INTERVAL '30' SECOND\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Could not create a PRIMARY KEY with nullable column 'd'.");
    }

    @Test
    void testCreateMaterializedTableWithInvalidPartitionKey() {
        String sql = "CREATE MATERIALIZED TABLE mtbl1\nPARTITIONED BY (a, e)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nPARTITIONED BY (a, e)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Partition column 'e' not defined in the query schema. Available columns: ['a', 'b', 'c', 'd'].");
        String sql2 = "CREATE MATERIALIZED TABLE mtbl1\nPARTITIONED BY (b, c)\nWITH (\n 'partition.fields.ds.date-formatter' = 'yyyy-MM-dd'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t3";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nPARTITIONED BY (b, c)\nWITH (\n 'partition.fields.ds.date-formatter' = 'yyyy-MM-dd'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t3")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column 'ds' referenced by materialized table option 'partition.fields.ds.date-formatter' isn't a partition column. Available partition columns: ['b', 'c'].");
        String sql3 = "CREATE MATERIALIZED TABLE mtbl1\nWITH (\n 'partition.fields.c.date-formatter' = 'yyyy-MM-dd'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t3";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nWITH (\n 'partition.fields.c.date-formatter' = 'yyyy-MM-dd'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t3")).isInstanceOf(ValidationException.class)).hasMessageContaining("Column 'c' referenced by materialized table option 'partition.fields.c.date-formatter' isn't a partition column. Available partition columns: [''].");
        String sql4 = "CREATE MATERIALIZED TABLE mtbl1\nPARTITIONED BY (b, c)\nWITH (\n 'partition.fields.c.date-formatter' = 'yyyy-MM-dd'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t3";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nPARTITIONED BY (b, c)\nWITH (\n 'partition.fields.c.date-formatter' = 'yyyy-MM-dd'\n)\nFRESHNESS = INTERVAL '30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t3")).isInstanceOf(ValidationException.class)).hasMessageContaining("Materialized table option 'partition.fields.c.date-formatter' only supports referring to char, varchar and string type partition column. Column c type is INT.");
    }

    @Test
    void testCreateMaterializedTableWithInvalidFreshnessType() {
        String sql = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL -'30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL -'30' SECOND\nREFRESH_MODE = FULL\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Materialized table freshness doesn't support negative value.");
        String sql2 = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' YEAR\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' YEAR\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Materialized table freshness only support SECOND, MINUTE, HOUR, DAY as the time unit.");
        String sql3 = "CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' DAY TO HOUR\nAS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("CREATE MATERIALIZED TABLE mtbl1\nFRESHNESS = INTERVAL '30' DAY TO HOUR\nAS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Materialized table freshness only support SECOND, MINUTE, HOUR, DAY as the time unit.");
    }

    @Test
    void testAlterMaterializedTableRefreshOperationWithPartitionSpec() {
        String sql = "ALTER MATERIALIZED TABLE mtbl1 REFRESH PARTITION (ds1 = '1', ds2 = '2')";
        Operation operation = this.parse("ALTER MATERIALIZED TABLE mtbl1 REFRESH PARTITION (ds1 = '1', ds2 = '2')");
        Assertions.assertThat((Object)operation).isInstanceOf(AlterMaterializedTableRefreshOperation.class);
        AlterMaterializedTableRefreshOperation op = (AlterMaterializedTableRefreshOperation)operation;
        Assertions.assertThat((String)op.getTableIdentifier().toString()).isEqualTo("`builtin`.`default`.`mtbl1`");
        Assertions.assertThat((Map)op.getPartitionSpec()).isEqualTo((Object)ImmutableMap.of((Object)"ds1", (Object)"1", (Object)"ds2", (Object)"2"));
    }

    @Test
    public void testAlterMaterializedTableRefreshOperationWithoutPartitionSpec() {
        String sql = "ALTER MATERIALIZED TABLE mtbl1 REFRESH";
        Operation operation = this.parse("ALTER MATERIALIZED TABLE mtbl1 REFRESH");
        Assertions.assertThat((Object)operation).isInstanceOf(AlterMaterializedTableRefreshOperation.class);
        AlterMaterializedTableRefreshOperation op = (AlterMaterializedTableRefreshOperation)operation;
        Assertions.assertThat((String)op.getTableIdentifier().toString()).isEqualTo("`builtin`.`default`.`mtbl1`");
        Assertions.assertThat((Map)op.getPartitionSpec()).isEmpty();
    }

    @Test
    void testAlterMaterializedTableSuspend() {
        String sql = "ALTER MATERIALIZED TABLE mtbl1 SUSPEND";
        Operation operation = this.parse("ALTER MATERIALIZED TABLE mtbl1 SUSPEND");
        Assertions.assertThat((Object)operation).isInstanceOf(AlterMaterializedTableSuspendOperation.class);
    }

    @Test
    void testAlterMaterializedTableResume() {
        String sql1 = "ALTER MATERIALIZED TABLE mtbl1 RESUME";
        Operation operation = this.parse("ALTER MATERIALIZED TABLE mtbl1 RESUME");
        Assertions.assertThat((Object)operation).isInstanceOf(AlterMaterializedTableResumeOperation.class);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("ALTER MATERIALIZED TABLE builtin.default.mtbl1 RESUME");
        String sql2 = "ALTER MATERIALIZED TABLE mtbl1 RESUME WITH ('k1' = 'v1')";
        Operation operation2 = this.parse("ALTER MATERIALIZED TABLE mtbl1 RESUME WITH ('k1' = 'v1')");
        Assertions.assertThat((Object)operation2).isInstanceOf(AlterMaterializedTableResumeOperation.class);
        Assertions.assertThat((Map)((AlterMaterializedTableResumeOperation)operation2).getDynamicOptions()).containsEntry((Object)"k1", (Object)"v1");
        Assertions.assertThat((String)operation2.asSummaryString()).isEqualTo("ALTER MATERIALIZED TABLE builtin.default.mtbl1 RESUME WITH (k1: [v1])");
    }

    @Test
    void testAlterMaterializedTableAsQuery() throws TableNotExistException {
        String sql = "ALTER MATERIALIZED TABLE base_mtbl AS SELECT a, b, c, d, d as e, cast('123' as string) as f FROM t3";
        Operation operation = this.parse(sql);
        Assertions.assertThat((Object)operation).isInstanceOf(AlterMaterializedTableAsQueryOperation.class);
        AlterMaterializedTableAsQueryOperation op = (AlterMaterializedTableAsQueryOperation)operation;
        Assertions.assertThat((List)op.getTableChanges()).isEqualTo(Arrays.asList(TableChange.add((Column)Column.physical((String)"e", (DataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE))), TableChange.add((Column)Column.physical((String)"f", (DataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE))), TableChange.modifyDefinitionQuery((String)"SELECT `t3`.`a`, `t3`.`b`, `t3`.`c`, `t3`.`d`, `t3`.`d` AS `e`, CAST('123' AS STRING) AS `f`\nFROM `builtin`.`default`.`t3`")));
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("ALTER MATERIALIZED TABLE builtin.default.base_mtbl AS SELECT `t3`.`a`, `t3`.`b`, `t3`.`c`, `t3`.`d`, `t3`.`d` AS `e`, CAST('123' AS STRING) AS `f`\nFROM `builtin`.`default`.`t3`");
        CatalogMaterializedTable oldTable = (CatalogMaterializedTable)this.catalog.getTable(new ObjectPath(this.catalogManager.getCurrentDatabase(), "base_mtbl"));
        CatalogMaterializedTable newTable = op.getNewMaterializedTable();
        Assertions.assertThat((Object)oldTable.getUnresolvedSchema()).isNotEqualTo((Object)newTable.getUnresolvedSchema());
        Assertions.assertThat((Optional)oldTable.getUnresolvedSchema().getPrimaryKey()).isEqualTo((Object)newTable.getUnresolvedSchema().getPrimaryKey());
        Assertions.assertThat((List)oldTable.getUnresolvedSchema().getWatermarkSpecs()).isEqualTo((Object)newTable.getUnresolvedSchema().getWatermarkSpecs());
        Assertions.assertThat((String)oldTable.getDefinitionQuery()).isNotEqualTo((Object)newTable.getDefinitionQuery());
        Assertions.assertThat((Object)oldTable.getDefinitionFreshness()).isEqualTo((Object)newTable.getDefinitionFreshness());
        Assertions.assertThat((Comparable)oldTable.getRefreshMode()).isEqualTo((Object)newTable.getRefreshMode());
        Assertions.assertThat((Comparable)oldTable.getRefreshStatus()).isEqualTo((Object)newTable.getRefreshStatus());
        Assertions.assertThat((byte[])oldTable.getSerializedRefreshHandler()).isEqualTo((Object)newTable.getSerializedRefreshHandler());
        List addedColumn = newTable.getUnresolvedSchema().getColumns().stream().filter(column -> !oldTable.getUnresolvedSchema().getColumns().contains(column)).collect(Collectors.toList());
        Assertions.assertThat(addedColumn).isEqualTo(Arrays.asList(new Schema.UnresolvedPhysicalColumn("e", (AbstractDataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE)), new Schema.UnresolvedPhysicalColumn("f", (AbstractDataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE))));
    }

    @Test
    void testAlterMaterializedTableAsQueryWithConflictColumnName() {
        String sql5 = "ALTER MATERIALIZED TABLE base_mtbl AS SELECT a, b, c, d, c as a FROM t3";
        AlterMaterializedTableAsQueryOperation sqlAlterMaterializedTableAsQuery = (AlterMaterializedTableAsQueryOperation)this.parse(sql5);
        Assertions.assertThat((List)sqlAlterMaterializedTableAsQuery.getTableChanges()).isEqualTo(Arrays.asList(TableChange.add((Column)Column.physical((String)"a0", (DataType)DataTypes.INT())), TableChange.modifyDefinitionQuery((String)"SELECT `t3`.`a`, `t3`.`b`, `t3`.`c`, `t3`.`d`, `t3`.`c` AS `a`\nFROM `builtin`.`default`.`t3`")));
    }

    @Test
    void testAlterMaterializedTableAsQueryWithUnsupportedColumnChange() {
        String sql1 = "ALTER MATERIALIZED TABLE base_mtbl AS SELECT a, b FROM t3";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse(sql1)).isInstanceOf(ValidationException.class)).hasMessageContaining("Failed to modify query because drop column is unsupported. When modifying a query, you can only append new columns at the end of original schema. The original schema has 4 columns, but the newly derived schema from the query has 2 columns.");
        String sql2 = "ALTER MATERIALIZED TABLE base_mtbl AS SELECT a, b, d, c FROM t3";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse(sql2)).isInstanceOf(ValidationException.class)).hasMessageContaining("When modifying the query of a materialized table, currently only support appending columns at the end of original schema, dropping, renaming, and reordering columns are not supported.\nColumn mismatch at position 2: Original column is [`c` INT], but new column is [`d` STRING].");
        String sql3 = "ALTER MATERIALIZED TABLE base_mtbl AS SELECT a, b, c, cast(d as int) as d FROM t3";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse(sql3)).isInstanceOf(ValidationException.class)).hasMessageContaining("When modifying the query of a materialized table, currently only support appending columns at the end of original schema, dropping, renaming, and reordering columns are not supported.\nColumn mismatch at position 3: Original column is [`d` STRING], but new column is [`d` INT].");
        String sql4 = "ALTER MATERIALIZED TABLE base_mtbl AS SELECT a, b, c, cast('d' as string) as d FROM t3";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse(sql4)).isInstanceOf(ValidationException.class)).hasMessageContaining("When modifying the query of a materialized table, currently only support appending columns at the end of original schema, dropping, renaming, and reordering columns are not supported.\nColumn mismatch at position 3: Original column is [`d` STRING], but new column is [`d` STRING NOT NULL].");
    }

    @Test
    void testAlterAlterMaterializedTableAsQueryWithCatalogTable() {
        String sql = "ALTER MATERIALIZED TABLE t1 AS SELECT * FROM t1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("ALTER MATERIALIZED TABLE t1 AS SELECT * FROM t1")).isInstanceOf(ValidationException.class)).hasMessageContaining("Only materialized table support modify definition query.");
    }

    @Test
    void testDropMaterializedTable() {
        String sql = "DROP MATERIALIZED TABLE mtbl1";
        Operation operation = this.parse("DROP MATERIALIZED TABLE mtbl1");
        Assertions.assertThat((Object)operation).isInstanceOf(DropMaterializedTableOperation.class);
        Assertions.assertThat((boolean)((DropMaterializedTableOperation)operation).isIfExists()).isFalse();
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("DROP MATERIALIZED TABLE: (identifier: [`builtin`.`default`.`mtbl1`], IfExists: [false])");
        String sql2 = "DROP MATERIALIZED TABLE IF EXISTS mtbl1";
        Operation operation2 = this.parse("DROP MATERIALIZED TABLE IF EXISTS mtbl1");
        Assertions.assertThat((Object)operation2).isInstanceOf(DropMaterializedTableOperation.class);
        Assertions.assertThat((boolean)((DropMaterializedTableOperation)operation2).isIfExists()).isTrue();
        Assertions.assertThat((String)operation2.asSummaryString()).isEqualTo("DROP MATERIALIZED TABLE: (identifier: [`builtin`.`default`.`mtbl1`], IfExists: [true])");
    }
}

