/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.match;

import java.time.Duration;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.plan.logical.MatchRecognize;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecMatch;
import org.apache.flink.table.planner.plan.nodes.exec.spec.MatchSpec;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMatch;
import org.apache.flink.table.planner.plan.utils.MatchUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!B\t\u0013\u0003\u0003y\u0002\"\u0002\u0014\u0001\t\u00039\u0003b\u0002\u0016\u0001\u0005\u0004%Ia\u000b\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\u0017\t\u000f]\u0002!\u0019!C\u0005q!1\u0011\t\u0001Q\u0001\neBqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019A\u0007\u0001)A\u0005\u001d\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007B\u00029\u0001A\u0003%1\u000eC\u0004r\u0001\t\u0007I\u0011\u0002:\t\re\u0004\u0001\u0015!\u0003t\u0011\u0015Q\b\u0001\"\u0003|\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!a\u001b\u0001\t\u0013\tiGA\rQCR$XM\u001d8Ue\u0006t7\u000f\\1u_J$Vm\u001d;CCN,'BA\n\u0015\u0003\u0015i\u0017\r^2i\u0015\t)b#A\u0004qY\u0006tg.\u001a:\u000b\u0005]A\u0012!\u0002;bE2,'BA\r\u001b\u0003\u00151G.\u001b8l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0003CA\u0015\u0001\u001b\u0005\u0011\u0012!\u0005;fgR$\u0016M\u00197f)f\u0004X-\u00138g_V\tA\u0006\u0005\u0002.i5\taF\u0003\u00020a\u0005IA/\u001f9fkRLGn\u001d\u0006\u0003cI\nAA[1wC*\u00111\u0007G\u0001\u0004CBL\u0017BA\u001b/\u0005-\u0011vn\u001e+za\u0016LeNZ8\u0002%Q,7\u000f\u001e+bE2,G+\u001f9f\u0013:4w\u000eI\u0001\u0011i\u0016\u001cH\u000fV1cY\u0016\u0014vn\u001e+za\u0016,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nq\u0001\\8hS\u000e\fGN\u0003\u0002?-\u0005)A/\u001f9fg&\u0011\u0001i\u000f\u0002\b%><H+\u001f9f\u0003E!Xm\u001d;UC\ndWMU8x)f\u0004X\rI\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012\u0001\u0012\t\u0003\u000b&k\u0011A\u0012\u0006\u0003\u000f\"\u000bA\u0001\\1oO*\t\u0011'\u0003\u0002K\r\n11\u000b\u001e:j]\u001e\f!\u0002^1cY\u0016t\u0015-\\3!\u0003\u001d\u0019wN\u001c;fqR,\u0012A\u0014\t\u0006C=\u000b\u0016lX\u0005\u0003!\n\u0012a\u0001V;qY\u0016\u001c\u0004C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0015!xn\u001c7t\u0015\t1&$A\u0004dC2\u001c\u0017\u000e^3\n\u0005a\u001b&A\u0003*fY\n+\u0018\u000e\u001c3feB\u0011!,X\u0007\u00027*\u0011A\fF\u0001\u000bI\u0016dWmZ1uS>t\u0017B\u00010\\\u0005-\u0001F.\u00198oKJ\u0014\u0015m]3\u0011\u0005\u00014W\"A1\u000b\u0005\t\u001c\u0017aC3om&\u0014xN\\7f]RT!a\r3\u000b\u0005\u0015D\u0012!C:ue\u0016\fW.\u001b8h\u0013\t9\u0017M\u0001\u000eTiJ,\u0017-\\#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG/\u0001\u0005d_:$X\r\u001f;!\u00039\u0019\u0017\r\\2ji\u0016\u0004F.\u00198oKJ,\u0012a\u001b\t\u0003Y:l\u0011!\u001c\u0006\u0003-RI!a\\7\u0003!\u0019c\u0017N\\6QY\u0006tg.\u001a:J[Bd\u0017aD2bY\u000eLG/\u001a)mC:tWM\u001d\u0011\u0002\rA\f'o]3s+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<\u0015\u0003\u0015\u0001\u0018M]:f\u0013\tAXOA\u0007DC2\u001c\u0017\u000e^3QCJ\u001cXM]\u0001\ba\u0006\u00148/\u001a:!\u00039\u0001(/\u001a9be\u0016\u001cuN\u001c;fqR$\"A\u0014?\t\u000but\u0001\u0019\u0001@\u0002\u0011QL\b/Z%oM>\u0004Ra`A\u0005\u0003\u001bi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\tif\u0004X-\u001b8g_*\u0019\u0011q\u0001\u001a\u0002\r\r|W.\\8o\u0013\u0011\tY!!\u0001\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004B!a\u0004\u0002\u00145\u0011\u0011\u0011\u0003\u0006\u0003}aIA!!\u0006\u0002\u0012\t\u0019!k\\<\u0002\u001bY,'/\u001b4z!\u0006$H/\u001a:o)\u0019\tY\"!\t\u0002:A\u0019\u0011%!\b\n\u0007\u0005}!E\u0001\u0003V]&$\bbBA\u0012\u001f\u0001\u0007\u0011QE\u0001\u000f[\u0006$8\r\u001b*fG><g.\u001b>f!\u0011\t9#!\u000e\u000f\t\u0005%\u0012\u0011\u0007\t\u0004\u0003W\u0011SBAA\u0017\u0015\r\tyCH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\"%\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0015\u0006]\"bAA\u001aE!9\u00111H\bA\u0002\u0005u\u0012\u0001C3ya\u0016\u001cG/\u001a31\t\u0005}\u0012q\f\t\t\u0003\u0003\nY%a\u0014\u0002\\5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0004qCR$XM\u001d8\u000b\u0007\u0005%\u0003$A\u0002dKBLA!!\u0014\u0002D\t9\u0001+\u0019;uKJt\u0007\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005Uc#\u0001\u0003eCR\f\u0017\u0002BA-\u0003'\u0012qAU8x\t\u0006$\u0018\r\u0005\u0003\u0002^\u0005}C\u0002\u0001\u0003\r\u0003C\nI$!A\u0001\u0002\u000b\u0005\u00111\r\u0002\u0004?\u0012\n\u0014\u0003BA3\u0003\u001f\u00022!IA4\u0013\r\tIG\t\u0002\b\u001d>$\b.\u001b8h\u0003\u001d\u0019w.\u001c9be\u0016$b!a\u0007\u0002p\u0005m\u0004bBA\u001e!\u0001\u0007\u0011\u0011\u000f\u0019\u0005\u0003g\n9\b\u0005\u0005\u0002B\u0005-\u0013qJA;!\u0011\ti&a\u001e\u0005\u0019\u0005e\u0014qNA\u0001\u0002\u0003\u0015\t!a\u0019\u0003\u0007}##\u0007C\u0004\u0002~A\u0001\r!a \u0002\r\u0005\u001cG/^1ma\u0011\t\t)!\"\u0011\u0011\u0005\u0005\u00131JA(\u0003\u0007\u0003B!!\u0018\u0002\u0006\u0012a\u0011qQA>\u0003\u0003\u0005\tQ!\u0001\u0002d\t\u0019q\fJ\u001a")
public abstract class PatternTranslatorTestBase {
    private final RowTypeInfo testTableTypeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO});
    private final RowType testTableRowType = RowType.of((LogicalType[])new LogicalType[]{new IntType()});
    private final String tableName;
    private final Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> context = this.prepareContext((TypeInformation<Row>)this.testTableTypeInfo());
    private final FlinkPlannerImpl calcitePlanner = ((PlannerBase)this.context()._2()).createFlinkPlanner();
    private final CalciteParser parser = ((PlannerBase)this.context()._2()).plannerContext().createCalciteParser();

    private RowTypeInfo testTableTypeInfo() {
        return this.testTableTypeInfo;
    }

    private RowType testTableRowType() {
        return this.testTableRowType;
    }

    private String tableName() {
        return this.tableName;
    }

    private Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> context() {
        return this.context;
    }

    private FlinkPlannerImpl calcitePlanner() {
        return this.calcitePlanner;
    }

    private CalciteParser parser() {
        return this.parser;
    }

    private Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> prepareContext(TypeInformation<Row> typeInfo) {
        DataStream dataStreamMock = (DataStream)Mockito.mock(DataStream.class);
        Mockito.when((Object)dataStreamMock.getType()).thenReturn(typeInfo);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)dataStreamMock.getId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        TableTestUtil$.MODULE$.createTemporaryView((TableEnvironment)tEnv, this.tableName(), dataStreamMock, (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), TableTestUtil$.MODULE$.createTemporaryView$default$5(), TableTestUtil$.MODULE$.createTemporaryView$default$6());
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        FlinkRelBuilder relBuilder = planner.createRelBuilder();
        relBuilder.scan(new String[]{this.tableName()});
        return new Tuple3((Object)relBuilder, (Object)planner, (Object)env);
    }

    public void verifyPattern(String matchRecognize, Pattern<RowData, ? extends RowData> expected) {
        SqlNode parsed = this.parser().parse(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n                                 |SELECT *\n                                 |FROM ").append(this.tableName()).append("\n                                 |").append(matchRecognize).append("\n                                 |").toString())).stripMargin());
        SqlNode validated = this.calcitePlanner().validate(parsed);
        RelNode converted = this.calcitePlanner().rel((SqlNode)validated).rel;
        PlannerBase plannerBase = (PlannerBase)this.context()._2();
        RelNode optimized = (RelNode)plannerBase.optimize((Seq)new .colon.colon((Object)converted, (List)Nil$.MODULE$)).head();
        Object object = !(optimized.getInput(0).getInput(0) instanceof StreamPhysicalDataStreamScan) ? Assertions.fail((String)"Expression is converted into more than a Match operation. Use a different test method.") : BoxedUnit.UNIT;
        StreamPhysicalMatch dataMatch = (StreamPhysicalMatch)optimized;
        Pattern p = (Pattern)CommonExecMatch.translatePattern((MatchSpec)MatchUtil$.MODULE$.createMatchSpec((MatchRecognize)dataMatch.getLogicalMatch()), (ReadableConfig)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (RelBuilder)((RelBuilder)this.context()._1()), (RowType)this.testTableRowType()).f0;
        this.compare(expected, (Pattern<RowData, ? extends RowData>)p);
    }

    private void compare(Pattern<RowData, ? extends RowData> expected, Pattern<RowData, ? extends RowData> actual) {
        Pattern currentLeft = expected;
        Pattern currentRight = actual;
        do {
            boolean sameSkipStrategy;
            String string = currentLeft.getName();
            String string2 = currentRight.getName();
            boolean sameName = !(string != null ? !string.equals(string2) : string2 != null);
            Quantifier quantifier = currentLeft.getQuantifier();
            Quantifier quantifier2 = currentRight.getQuantifier();
            boolean sameQuantifier = !(quantifier != null ? !quantifier.equals(quantifier2) : quantifier2 != null);
            Quantifier.Times times = currentLeft.getTimes();
            Quantifier.Times times2 = currentRight.getTimes();
            boolean sameTimes = !(times != null ? !times.equals(times2) : times2 != null);
            AfterMatchSkipStrategy afterMatchSkipStrategy = currentLeft.getAfterMatchSkipStrategy();
            AfterMatchSkipStrategy afterMatchSkipStrategy2 = currentRight.getAfterMatchSkipStrategy();
            boolean bl = !(afterMatchSkipStrategy != null ? !afterMatchSkipStrategy.equals(afterMatchSkipStrategy2) : afterMatchSkipStrategy2 != null) ? true : (sameSkipStrategy = false);
            boolean sameTimeWindow = currentLeft.getWindowSize().isPresent() && currentRight != null ? ((Duration)currentLeft.getWindowSize().get()).toMillis() == ((Duration)currentRight.getWindowSize().get()).toMillis() : !currentLeft.getWindowSize().isPresent() && !currentRight.getWindowSize().isPresent();
            currentLeft = currentLeft.getPrevious();
            currentRight = currentRight.getPrevious();
            if (!(sameName && sameQuantifier && sameTimes && sameSkipStrategy && sameTimeWindow)) {
                throw new AssertionError((Object)new StringBuilder(48).append("Compiled different pattern. expected: ").append(expected).append(", actual: ").append(actual).toString());
            }
        } while (currentLeft != null);
        if (currentRight != null) {
            throw new AssertionError((Object)new StringBuilder(48).append("Compiled different pattern. expected: ").append(expected).append(", actual: ").append(actual).toString());
        }
    }

    public PatternTranslatorTestBase() {
        this.tableName = "testTable";
    }
}

