/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.planner.functions.casting.ArrayToArrayCastRule;
import org.apache.flink.table.planner.functions.casting.ArrayToStringCastRule;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.IdentityCastRule;
import org.apache.flink.table.planner.functions.casting.NumericPrimitiveCastRule;
import org.apache.flink.table.planner.functions.casting.NumericToStringCastRule;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CastRuleProviderTest {
    private static final LogicalType DISTINCT_INT = DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"a", (String)"b", (String)"c"), (LogicalType)DataTypes.INT().getLogicalType()).build();
    private static final LogicalType DISTINCT_BIG_INT = DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"a", (String)"b", (String)"c"), (LogicalType)DataTypes.BIGINT().getLogicalType()).build();
    private static final LogicalType INT = DataTypes.INT().getLogicalType();
    private static final LogicalType TINYINT = DataTypes.TINYINT().getLogicalType();

    CastRuleProviderTest() {
    }

    @Test
    void testResolveDistinctTypeToIdentityCastRule() {
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)DISTINCT_INT, (LogicalType)INT)).isSameAs((Object)IdentityCastRule.INSTANCE);
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)INT, (LogicalType)DISTINCT_INT)).isSameAs((Object)IdentityCastRule.INSTANCE);
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)DISTINCT_INT, (LogicalType)DISTINCT_INT)).isSameAs((Object)IdentityCastRule.INSTANCE);
    }

    @Test
    void testResolveIntToBigIntWithDistinct() {
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)INT, (LogicalType)DISTINCT_BIG_INT)).isSameAs((Object)NumericPrimitiveCastRule.INSTANCE);
    }

    @Test
    void testResolveArrayIntToBigIntWithDistinct() {
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)new ArrayType(INT), (LogicalType)new ArrayType(DISTINCT_BIG_INT))).isSameAs((Object)ArrayToArrayCastRule.INSTANCE);
    }

    @Test
    void testResolvePredefinedToString() {
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)INT, (LogicalType)new VarCharType(10))).isSameAs((Object)CharVarCharTrimPadCastRule.INSTANCE);
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)INT, (LogicalType)new CharType(10))).isSameAs((Object)CharVarCharTrimPadCastRule.INSTANCE);
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)INT, (LogicalType)VarCharType.STRING_TYPE)).isSameAs((Object)NumericToStringCastRule.INSTANCE);
    }

    @Test
    void testResolveConstructedToString() {
        Assertions.assertThat((Object)CastRuleProvider.resolve((LogicalType)new ArrayType(INT), (LogicalType)new VarCharType(10))).isSameAs((Object)ArrayToStringCastRule.INSTANCE);
    }

    @Test
    void testCanFail() {
        Assertions.assertThat((boolean)CastRuleProvider.canFail((LogicalType)TINYINT, (LogicalType)INT)).isFalse();
        Assertions.assertThat((boolean)CastRuleProvider.canFail((LogicalType)VarCharType.STRING_TYPE, (LogicalType)DataTypes.TIME().getLogicalType())).isTrue();
        Assertions.assertThat((boolean)CastRuleProvider.canFail((LogicalType)VarCharType.STRING_TYPE, (LogicalType)VarCharType.STRING_TYPE)).isFalse();
        LogicalType inputType = DataTypes.ROW((DataType[])new DataType[]{DataTypes.TINYINT(), DataTypes.STRING()}).getLogicalType();
        Assertions.assertThat((boolean)CastRuleProvider.canFail((LogicalType)inputType, (LogicalType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.TIME()}).getLogicalType())).isTrue();
        Assertions.assertThat((boolean)CastRuleProvider.canFail((LogicalType)inputType, (LogicalType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()}).getLogicalType())).isFalse();
    }
}

