/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.MinWithRetractAggFunction;
import org.junit.jupiter.api.Nested;

final class MinWithRetractAggFunctionTest {
    MinWithRetractAggFunctionTest() {
    }

    static abstract class NumberMinWithRetractAggFunctionTestBase<T>
    extends MinWithRetractAggFunctionTestBase<T> {
        NumberMinWithRetractAggFunctionTestBase() {
        }

        protected abstract T getMinValue();

        protected abstract T getMaxValue();

        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getMaxValue(), this.getValue("-99"), this.getValue("3"), this.getValue("56"), this.getValue("0"), this.getMinValue(), this.getValue("-20"), this.getValue("17"), null), Arrays.asList(null, null, null, null, null, null), Arrays.asList(null, this.getValue("10")));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getMinValue(), null, this.getValue("10"));
        }
    }

    static abstract class MinWithRetractAggFunctionTestBase<T>
    extends AggFunctionTestBase<T, T, MinWithRetractAggFunction.MinWithRetractAccumulator<T>> {
        MinWithRetractAggFunctionTestBase() {
        }

        @Override
        protected Class<?> getAccClass() {
            return MinWithRetractAggFunction.MinWithRetractAccumulator.class;
        }

        @Override
        protected Method getAccumulateFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("accumulate", this.getAccClass(), Comparable.class);
        }

        @Override
        protected Method getRetractFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("retract", this.getAccClass(), Comparable.class);
        }
    }

    @Nested
    final class TimeMinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<Integer> {
        TimeMinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<Integer>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(0, 1000, 100, null, 10), Arrays.asList(null, null, null, null, null), Arrays.asList(null, 1));
        }

        @Override
        protected List<Integer> getExpectedResults() {
            return Arrays.asList(0, null, 1);
        }

        @Override
        protected AggregateFunction<Integer, MinWithRetractAggFunction.MinWithRetractAccumulator<Integer>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.TIME((int)0).getLogicalType());
        }
    }

    @Nested
    final class DateMinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<Integer> {
        DateMinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<Integer>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(0, 1000, 100, null, 10), Arrays.asList(null, null, null, null, null), Arrays.asList(null, 1));
        }

        @Override
        protected List<Integer> getExpectedResults() {
            return Arrays.asList(0, null, 1);
        }

        @Override
        protected AggregateFunction<Integer, MinWithRetractAggFunction.MinWithRetractAccumulator<Integer>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.DATE().getLogicalType());
        }
    }

    @Nested
    final class LocalTimestamp9MinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<TimestampData> {
        LocalTimestamp9MinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L, (int)1), TimestampData.fromEpochMillis((long)0L, (int)2), TimestampData.fromEpochMillis((long)1000L, (int)0), TimestampData.fromEpochMillis((long)100L, (int)0), null, TimestampData.fromEpochMillis((long)10L, (int)0)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L, (int)1), TimestampData.fromEpochMillis((long)1L, (int)2)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)0L, (int)1), null, TimestampData.fromEpochMillis((long)1L, (int)1));
        }

        @Override
        protected AggregateFunction<TimestampData, MinWithRetractAggFunction.MinWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.TIMESTAMP_LTZ((int)9).getLogicalType());
        }
    }

    @Nested
    final class LocalTimestampMinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<TimestampData> {
        LocalTimestampMinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)1000L), TimestampData.fromEpochMillis((long)100L), null, TimestampData.fromEpochMillis((long)10L)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)0L), null, TimestampData.fromEpochMillis((long)1L));
        }

        @Override
        protected AggregateFunction<TimestampData, MinWithRetractAggFunction.MinWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType());
        }
    }

    @Nested
    final class Timestamp9MinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<TimestampData> {
        Timestamp9MinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L, (int)1), TimestampData.fromEpochMillis((long)0L, (int)2), TimestampData.fromEpochMillis((long)1000L, (int)0), TimestampData.fromEpochMillis((long)100L, (int)0), null, TimestampData.fromEpochMillis((long)10L, (int)0)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L, (int)1), TimestampData.fromEpochMillis((long)1L, (int)2)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)0L, (int)1), null, TimestampData.fromEpochMillis((long)1L, (int)1));
        }

        @Override
        protected AggregateFunction<TimestampData, MinWithRetractAggFunction.MinWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.TIMESTAMP((int)9).getLogicalType());
        }
    }

    @Nested
    final class TimestampMinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<TimestampData> {
        TimestampMinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<TimestampData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)1000L), TimestampData.fromEpochMillis((long)100L), null, TimestampData.fromEpochMillis((long)10L)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, TimestampData.fromEpochMillis((long)1L)));
        }

        @Override
        protected List<TimestampData> getExpectedResults() {
            return Arrays.asList(TimestampData.fromEpochMillis((long)0L), null, TimestampData.fromEpochMillis((long)1L));
        }

        @Override
        protected AggregateFunction<TimestampData, MinWithRetractAggFunction.MinWithRetractAccumulator<TimestampData>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.TIMESTAMP((int)3).getLogicalType());
        }
    }

    @Nested
    final class StringMinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<StringData> {
        StringMinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"abc"), null, StringData.fromString((String)"a"), StringData.fromString((String)"e"));
        }

        @Override
        protected AggregateFunction<StringData, MinWithRetractAggFunction.MinWithRetractAccumulator<StringData>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    @Nested
    final class DecimalMinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        DecimalMinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, MinWithRetractAggFunction.MinWithRetractAccumulator<DecimalData>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    @Nested
    final class BooleanMinWithRetractAggFunctionTest
    extends MinWithRetractAggFunctionTestBase<Boolean> {
        BooleanMinWithRetractAggFunctionTest() {
        }

        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, false, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, MinWithRetractAggFunction.MinWithRetractAccumulator<Boolean>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    @Nested
    final class DoubleMinWithRetractAggFunctionTest
    extends NumberMinWithRetractAggFunctionTestBase<Double> {
        DoubleMinWithRetractAggFunctionTest() {
        }

        @Override
        protected Double getMinValue() {
            return -8.988465674311579E307;
        }

        @Override
        protected Double getMaxValue() {
            return 8.988465674311579E307;
        }

        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, MinWithRetractAggFunction.MinWithRetractAccumulator<Double>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    @Nested
    final class FloatMinWithRetractAggFunctionTest
    extends NumberMinWithRetractAggFunctionTestBase<Float> {
        FloatMinWithRetractAggFunctionTest() {
        }

        @Override
        protected Float getMinValue() {
            return Float.valueOf(-1.7014117E38f);
        }

        @Override
        protected Float getMaxValue() {
            return Float.valueOf(1.7014117E38f);
        }

        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, MinWithRetractAggFunction.MinWithRetractAccumulator<Float>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    @Nested
    final class LongMinWithRetractAggFunctionTest
    extends NumberMinWithRetractAggFunctionTestBase<Long> {
        LongMinWithRetractAggFunctionTest() {
        }

        @Override
        protected Long getMinValue() {
            return -9223372036854775807L;
        }

        @Override
        protected Long getMaxValue() {
            return 0x7FFFFFFFFFFFFFFEL;
        }

        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, MinWithRetractAggFunction.MinWithRetractAccumulator<Long>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    @Nested
    final class IntMinWithRetractAggFunctionTest
    extends NumberMinWithRetractAggFunctionTestBase<Integer> {
        IntMinWithRetractAggFunctionTest() {
        }

        @Override
        protected Integer getMinValue() {
            return -2147483647;
        }

        @Override
        protected Integer getMaxValue() {
            return 0x7FFFFFFE;
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, MinWithRetractAggFunction.MinWithRetractAccumulator<Integer>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    @Nested
    final class ShortMinWithRetractAggFunctionTest
    extends NumberMinWithRetractAggFunctionTestBase<Short> {
        ShortMinWithRetractAggFunctionTest() {
        }

        @Override
        protected Short getMinValue() {
            return (short)-32767;
        }

        @Override
        protected Short getMaxValue() {
            return (short)32766;
        }

        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, MinWithRetractAggFunction.MinWithRetractAccumulator<Short>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    @Nested
    final class ByteMinWithRetractAggFunctionTest
    extends NumberMinWithRetractAggFunctionTestBase<Byte> {
        ByteMinWithRetractAggFunctionTest() {
        }

        @Override
        protected Byte getMinValue() {
            return (byte)-127;
        }

        @Override
        protected Byte getMaxValue() {
            return (byte)126;
        }

        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, MinWithRetractAggFunction.MinWithRetractAccumulator<Byte>> getAggregator() {
            return new MinWithRetractAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

