/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.ArrayAggFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.Nested;

final class ArrayAggFunctionTest {
    ArrayAggFunctionTest() {
    }

    static abstract class NumberArrayAggFunctionTestBase<T>
    extends ArrayAggFunctionTestBase<T> {
        NumberArrayAggFunctionTestBase() {
        }

        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getValue("-99"), this.getValue("3"), null), Arrays.asList(null, null, null, null), Arrays.asList(null, this.getValue("10"), null, this.getValue("3")));
        }

        @Override
        protected List<ArrayData> getExpectedResults() {
            return Arrays.asList(new GenericArrayData(new Object[]{this.getValue("1"), this.getValue("-99"), this.getValue("3")}), null, new GenericArrayData(new Object[]{this.getValue("10"), this.getValue("3")}));
        }
    }

    static abstract class ArrayAggFunctionTestBase<T>
    extends AggFunctionTestBase<T, ArrayData, ArrayAggFunction.ArrayAggAccumulator<T>> {
        ArrayAggFunctionTestBase() {
        }

        @Override
        protected Class<?> getAccClass() {
            return ArrayAggFunction.ArrayAggAccumulator.class;
        }

        @Override
        protected Method getAccumulateFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("accumulate", this.getAccClass(), Object.class);
        }

        @Override
        protected Method getRetractFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("retract", this.getAccClass(), Object.class);
        }
    }

    @Nested
    final class ArrayArrayAggFunctionTest
    extends ArrayAggFunctionTestBase<ArrayData> {
        ArrayArrayAggFunctionTest() {
        }

        private ArrayData getValue(Integer ... elements) {
            return new GenericArrayData((Object[])elements);
        }

        @Override
        protected List<List<ArrayData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue(0, 1, 2), this.getValue(1, null), this.getValue(5, 3, 4, 5), null, this.getValue(6, null, 7)), Arrays.asList(null, null));
        }

        @Override
        protected List<ArrayData> getExpectedResults() {
            return Arrays.asList(new GenericArrayData(new Object[]{this.getValue(0, 1, 2), this.getValue(1, null), this.getValue(5, 3, 4, 5), this.getValue(6, null, 7)}), null);
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<ArrayData>> getAggregator() {
            return new ArrayAggFunction(DataTypes.ARRAY((DataType)DataTypes.INT()).getLogicalType(), true);
        }
    }

    @Nested
    final class RowDArrayAggFunctionTest
    extends ArrayAggFunctionTestBase<RowData> {
        RowDArrayAggFunctionTest() {
        }

        private RowData getValue(Integer f0, String f1) {
            GenericRowData rowData = new GenericRowData(RowKind.INSERT, 2);
            rowData.setField(0, (Object)f0);
            rowData.setField(1, (Object)(f1 == null ? null : StringData.fromString((String)f1)));
            return rowData;
        }

        @Override
        protected List<List<RowData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue(0, "abc"), this.getValue(1, "def"), this.getValue(2, "ghi"), null, this.getValue(3, "jkl"), null, this.getValue(4, "zzz")), Arrays.asList(null, null), Arrays.asList(null, this.getValue(null, "a")), Arrays.asList(this.getValue(5, null), null, this.getValue(null, "e")));
        }

        @Override
        protected List<ArrayData> getExpectedResults() {
            return Arrays.asList(new GenericArrayData(new Object[]{this.getValue(0, "abc"), this.getValue(1, "def"), this.getValue(2, "ghi"), this.getValue(3, "jkl"), this.getValue(4, "zzz")}), null, new GenericArrayData(new Object[]{this.getValue(null, "a")}), new GenericArrayData(new Object[]{this.getValue(5, null), this.getValue(null, "e")}));
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<RowData>> getAggregator() {
            return new ArrayAggFunction(DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()}).getLogicalType(), true);
        }
    }

    @Nested
    final class StringArrayAggFunctionTest
    extends ArrayAggFunctionTestBase<StringData> {
        StringArrayAggFunctionTest() {
        }

        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<ArrayData> getExpectedResults() {
            return Arrays.asList(new GenericArrayData(new Object[]{StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), StringData.fromString((String)"jkl"), StringData.fromString((String)"zzz")}), null, new GenericArrayData(new Object[]{StringData.fromString((String)"a")}), new GenericArrayData(new Object[]{StringData.fromString((String)"x"), StringData.fromString((String)"e")}));
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<StringData>> getAggregator() {
            return new ArrayAggFunction(DataTypes.STRING().getLogicalType(), true);
        }
    }

    @Nested
    final class DecimalArrayAggFunctionTest
    extends NumberArrayAggFunctionTestBase<DecimalData> {
        private final int precision = 20;
        private final int scale = 6;

        DecimalArrayAggFunctionTest() {
        }

        @Override
        protected DecimalData getValue(String v) {
            return DecimalDataUtils.castFrom((String)v, (int)20, (int)6);
        }

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), this.getValue("1000.000001"), this.getValue("-1"), this.getValue("-999.998999"), null, this.getValue("0"), this.getValue("-999.999"), null, this.getValue("999.999")), Arrays.asList(null, null, null, null, null), Arrays.asList(null, this.getValue("0")));
        }

        @Override
        protected List<ArrayData> getExpectedResults() {
            return Arrays.asList(new GenericArrayData(new Object[]{this.getValue("1"), this.getValue("1000.000001"), this.getValue("-1"), this.getValue("-999.998999"), this.getValue("0"), this.getValue("-999.999"), this.getValue("999.999")}), null, new GenericArrayData(new Object[]{this.getValue("0")}));
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<DecimalData>> getAggregator() {
            return new ArrayAggFunction(DataTypes.DECIMAL((int)20, (int)6).getLogicalType(), true);
        }
    }

    @Nested
    final class BooleanArrayAggTest
    extends ArrayAggFunctionTestBase<Boolean> {
        BooleanArrayAggTest() {
        }

        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<ArrayData> getExpectedResults() {
            return Arrays.asList(new GenericArrayData(new Object[]{false, false, false}), new GenericArrayData(new Object[]{true, true, true}), new GenericArrayData(new Object[]{true, false, true, false, true}), null, new GenericArrayData(new Object[]{true}));
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<Boolean>> getAggregator() {
            return new ArrayAggFunction(DataTypes.BOOLEAN().getLogicalType(), true);
        }
    }

    @Nested
    final class DoubleArrayAggTest
    extends NumberArrayAggFunctionTestBase<Double> {
        DoubleArrayAggTest() {
        }

        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<Double>> getAggregator() {
            return new ArrayAggFunction(DataTypes.DOUBLE().getLogicalType(), true);
        }
    }

    @Nested
    final class FloatArrayAggTest
    extends NumberArrayAggFunctionTestBase<Float> {
        FloatArrayAggTest() {
        }

        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<Float>> getAggregator() {
            return new ArrayAggFunction(DataTypes.FLOAT().getLogicalType(), true);
        }
    }

    @Nested
    final class LongArrayAggTest
    extends NumberArrayAggFunctionTestBase<Long> {
        LongArrayAggTest() {
        }

        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<Long>> getAggregator() {
            return new ArrayAggFunction(DataTypes.BIGINT().getLogicalType(), true);
        }
    }

    @Nested
    final class IntArrayAggTest
    extends NumberArrayAggFunctionTestBase<Integer> {
        IntArrayAggTest() {
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<Integer>> getAggregator() {
            return new ArrayAggFunction(DataTypes.INT().getLogicalType(), true);
        }
    }

    @Nested
    final class ShortArrayAggTest
    extends NumberArrayAggFunctionTestBase<Short> {
        ShortArrayAggTest() {
        }

        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<Short>> getAggregator() {
            return new ArrayAggFunction(DataTypes.SMALLINT().getLogicalType(), true);
        }
    }

    @Nested
    final class ByteArrayAggFunctionTest
    extends NumberArrayAggFunctionTestBase<Byte> {
        ByteArrayAggFunctionTest() {
        }

        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<ArrayData, ArrayAggFunction.ArrayAggAccumulator<Byte>> getAggregator() {
            return new ArrayAggFunction(DataTypes.TINYINT().getLogicalType(), true);
        }
    }
}

