/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;

class RegexpFunctionsITCase
extends BuiltInFunctionTestBase {
    RegexpFunctionsITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(this.regexpCountTestCases(), this.regexpExtractTestCases(), this.regexpExtractAllTestCases(), this.regexpInstrTestCases(), this.regexpSubstrTestCases()).flatMap(s -> s);
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> regexpCountTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_COUNT).onFieldsWithData(null, "abcdeabde").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").regexpCount((Object)Expressions.$((String)"f1")), "REGEXP_COUNT(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").regexpCount((Object)Expressions.$((String)"f0")), "REGEXP_COUNT(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").regexpCount((Object)"("), "REGEXP_COUNT(f1, '(')", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"hello world! Hello everyone!").regexpCount((Object)"Hello"), "REGEXP_COUNT('hello world! Hello everyone!', 'Hello')", 1, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"abcabcabc").regexpCount((Object)"abcab"), "REGEXP_COUNT('abcabcabc', 'abcab')", 1, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"abcd").regexpCount((Object)"z"), "REGEXP_COUNT('abcd', 'z')", 0, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"^abc").regexpCount((Object)"\\^abc"), "REGEXP_COUNT('^abc', '\\^abc')", 1, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"a.b.c.d").regexpCount((Object)"\\."), "REGEXP_COUNT('a.b.c.d', '\\.')", 3, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"a*b*c*d").regexpCount((Object)"\\*"), "REGEXP_COUNT('a*b*c*d', '\\*')", 3, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"abc123xyz456").regexpCount((Object)"\\d"), "REGEXP_COUNT('abc123xyz456', '\\d')", 6, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"Helloworld! Hello everyone!").regexpCount((Object)"\\bHello\\b"), "REGEXP_COUNT('Helloworld! Hello everyone!', '\\bHello\\b')", 1, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_COUNT, "Validation Error").onFieldsWithData(1024).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").regexpCount((Object)"1024"), "Invalid input arguments. Expected signatures are:\nREGEXP_COUNT(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)").testSqlValidationError("REGEXP_COUNT(f0, '1024')", "Invalid input arguments. Expected signatures are:\nREGEXP_COUNT(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> regexpExtractTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_EXTRACT, "Check return type").onFieldsWithData("22", "ABC").testResult((Expression)Expressions.call((String)"regexpExtract", (Object[])new Object[]{Expressions.$((String)"f0"), "[A-Z]+"}), "REGEXP_EXTRACT(f0,'[A-Z]+')", null, DataTypes.STRING().nullable()).testResult((Expression)Expressions.call((String)"regexpExtract", (Object[])new Object[]{Expressions.$((String)"f1"), "[A-Z]+"}), "REGEXP_EXTRACT(f1, '[A-Z]+')", "ABC", DataTypes.STRING().nullable()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> regexpExtractAllTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_EXTRACT_ALL).onFieldsWithData(null, "abcdeabde", "100-200, 300-400").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").regexpExtractAll((Object)Expressions.$((String)"f1")), "REGEXP_EXTRACT_ALL(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)Expressions.$((String)"f0")), "REGEXP_EXTRACT_ALL(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)Expressions.$((String)"f1"), null), "REGEXP_EXTRACT_ALL(f1, f1, NULL)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"("), "REGEXP_EXTRACT_ALL(f1, '(')", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"(abcdeabde)", (Object)-1), "REGEXP_EXTRACT_ALL(f1, '(abcdeabde)', -1)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"abcdeabde"), "REGEXP_EXTRACT_ALL(f1, 'abcdeabde')", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"(abcdeabde)", (Object)2), "REGEXP_EXTRACT_ALL(f1, '(abcdeabde)', 2)", (Object)null, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f2").regexpExtractAll((Object)"[a-z]", (Object)0), "REGEXP_EXTRACT_ALL(f2, '[a-z]', 0)", new String[0], (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"(abcdeabde)|([a-z]*)", (Object)2), "REGEXP_EXTRACT_ALL(f1, '(abcdeabde)|([a-z]*)', 2)", new String[]{null, ""}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"ab((c)|(.?))de", (Object)2), "REGEXP_EXTRACT_ALL(f1, 'ab((c)|(.?))de', 2)", new String[]{"c", null}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"(ab)([a-z]+)(e)", (Object)2), "REGEXP_EXTRACT_ALL(f1, '(ab)([a-z]+)(e)', 2)", new String[]{"cdeabd"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f1").regexpExtractAll((Object)"", (Object)0), "REGEXP_EXTRACT_ALL(f1, '', 0)", new String[]{"", "", "", "", "", "", "", "", "", ""}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f2").regexpExtractAll((Object)"(\\d+)-(\\d+)", (Object)0), "REGEXP_EXTRACT_ALL(f2, '(\\d+)-(\\d+)', 0)", new String[]{"100-200", "300-400"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f2").regexpExtractAll((Object)"(\\d+)-(\\d+)", (Object)1), "REGEXP_EXTRACT_ALL(f2, '(\\d+)-(\\d+)', 1)", new String[]{"100", "300"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f2").regexpExtractAll((Object)"(\\d+)-(\\d+)", (Object)2), "REGEXP_EXTRACT_ALL(f2, '(\\d+)-(\\d+)', 2)", new String[]{"200", "400"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f2").regexpExtractAll((Object)"(\\d+).*", (Object)1), "REGEXP_EXTRACT_ALL(f2, '(\\d+).*', 1)", new String[]{"100"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_EXTRACT_ALL, "Validation Error").onFieldsWithData(1024).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").regexpExtractAll((Object)"1024"), "Invalid input arguments. Expected signatures are:\nREGEXP_EXTRACT_ALL(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)\nREGEXP_EXTRACT_ALL(str <CHARACTER_STRING>, regex <CHARACTER_STRING>, extractIndex <INTEGER_NUMERIC>)").testSqlValidationError("REGEXP_EXTRACT_ALL(f0, '1024')", "Invalid input arguments. Expected signatures are:\nREGEXP_EXTRACT_ALL(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)\nREGEXP_EXTRACT_ALL(str <CHARACTER_STRING>, regex <CHARACTER_STRING>, extractIndex <INTEGER_NUMERIC>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> regexpInstrTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_INSTR).onFieldsWithData(null, "abcdeabde", "100-200, 300-400").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").regexpInstr((Object)Expressions.$((String)"f1")), "REGEXP_INSTR(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").regexpInstr((Object)Expressions.$((String)"f0")), "REGEXP_INSTR(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f1").regexpInstr((Object)"("), "REGEXP_INSTR(f1, '(')", (Object)null, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f2").regexpInstr((Object)"[a-z]"), "REGEXP_INSTR(f2, '[a-z]')", 0, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"Helloworld! Hello everyone!").regexpInstr((Object)"\\bHello\\b"), "REGEXP_INSTR('Helloworld! Hello everyone!', '\\bHello\\b')", 13, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"Helloworld!  Hello everyone!").regexpInstr((Object)"\\bHello\\b"), "REGEXP_INSTR('Helloworld!  Hello everyone!', '\\bHello\\b')", 14, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"hello world! Hello everyone!").regexpInstr((Object)"Hello"), "REGEXP_INSTR('hello world! Hello everyone!', 'Hello')", 14, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"a.b.c.d").regexpInstr((Object)"\\."), "REGEXP_INSTR('a.b.c.d', '\\.')", 2, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.lit((Object)"abc123xyz456").regexpInstr((Object)"\\d"), "REGEXP_INSTR('abc123xyz456', '\\d')", 4, (AbstractDataType<?>)DataTypes.INT()).testResult((Expression)Expressions.$((String)"f2").regexpInstr((Object)"(\\d+)-(\\d+)"), "REGEXP_INSTR(f2, '(\\d+)-(\\d+)')", 1, (AbstractDataType<?>)DataTypes.INT()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_INSTR, "Validation Error").onFieldsWithData(1024).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").regexpInstr((Object)"1024"), "Invalid input arguments. Expected signatures are:\nREGEXP_INSTR(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)").testSqlValidationError("REGEXP_INSTR(f0, '1024')", "Invalid input arguments. Expected signatures are:\nREGEXP_INSTR(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> regexpSubstrTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_SUBSTR).onFieldsWithData(null, "abcdeabde", "100-200, 300-400").andDataTypes(new AbstractDataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}).testResult((Expression)Expressions.$((String)"f0").regexpSubstr((Object)Expressions.$((String)"f1")), "REGEXP_SUBSTR(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").regexpSubstr((Object)Expressions.$((String)"f0")), "REGEXP_SUBSTR(f1, f0)", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f1").regexpSubstr((Object)"("), "REGEXP_SUBSTR(f1, '(')", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f2").regexpSubstr((Object)"[a-z]"), "REGEXP_SUBSTR(f2, '[a-z]')", (Object)null, (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"Helloworld! Hello everyone!").regexpSubstr((Object)"\\bHello\\b"), "REGEXP_SUBSTR('Helloworld! Hello everyone!', '\\bHello\\b')", "Hello", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f2").regexpSubstr((Object)"(\\d+)-(\\d+)$"), "REGEXP_SUBSTR(f2, '(\\d+)-(\\d+)$')", "300-400", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"hello world! Hello everyone!").regexpSubstr((Object)"Hello"), "REGEXP_SUBSTR('hello world! Hello everyone!', 'Hello')", "Hello", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"a.b.c.d").regexpSubstr((Object)"\\."), "REGEXP_SUBSTR('a.b.c.d', '\\.')", ".", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.lit((Object)"abc123xyz456").regexpSubstr((Object)"\\d"), "REGEXP_SUBSTR('abc123xyz456', '\\d')", "1", (AbstractDataType<?>)DataTypes.STRING()).testResult((Expression)Expressions.$((String)"f2").regexpSubstr((Object)"(\\d+)-(\\d+)"), "REGEXP_SUBSTR(f2, '(\\d+)-(\\d+)')", "100-200", (AbstractDataType<?>)DataTypes.STRING()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.REGEXP_SUBSTR, "Validation Error").onFieldsWithData(1024).andDataTypes(new AbstractDataType[]{DataTypes.INT()}).testTableApiValidationError((Expression)Expressions.$((String)"f0").regexpSubstr((Object)"1024"), "Invalid input arguments. Expected signatures are:\nREGEXP_SUBSTR(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)").testSqlValidationError("REGEXP_SUBSTR(f0, '1024')", "Invalid input arguments. Expected signatures are:\nREGEXP_SUBSTR(str <CHARACTER_STRING>, regex <CHARACTER_STRING>)"));
    }
}

