/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.legacy.table.connector.source.SourceFunctionProvider;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.operations.AggregateQueryOperation;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
abstract class BuiltInAggregateFunctionTestBase {
    @RegisterExtension
    public static final MiniClusterExtension MINI_CLUSTER_EXTENSION = new MiniClusterExtension();

    BuiltInAggregateFunctionTestBase() {
    }

    abstract Stream<TestSpec> getTestCaseSpecs();

    final Stream<BuiltInFunctionTestBase.TestCase> getTestCases() {
        return this.getTestCaseSpecs().flatMap(TestSpec::getTestCases);
    }

    @ParameterizedTest
    @MethodSource(value={"getTestCases"})
    final void test(BuiltInFunctionTestBase.TestCase testCase) throws Throwable {
        testCase.execute();
    }

    protected static Table asTable(TableEnvironment tEnv, DataType sourceRowType, List<Row> rows) {
        TableDescriptor descriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().fromRowDataType(sourceRowType).build()).source(BuiltInAggregateFunctionTestBase.asSource(rows, sourceRowType)).build();
        return tEnv.from(descriptor);
    }

    protected static TableFactoryHarness.ScanSourceBase asSource(final List<Row> rows, final DataType producedDataType) {
        return new TableFactoryHarness.ScanSourceBase(){

            @Override
            public ChangelogMode getChangelogMode() {
                Set rowKinds = rows.stream().map(Row::getKind).collect(Collectors.toSet());
                if (rowKinds.size() == 1 && rowKinds.contains(RowKind.INSERT)) {
                    return ChangelogMode.insertOnly();
                }
                return ChangelogMode.all();
            }

            @Override
            public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
                DynamicTableSource.DataStructureConverter converter = context.createDataStructureConverter(producedDataType);
                return SourceFunctionProvider.of((SourceFunction)new Source(rows, converter), (boolean)true);
            }
        };
    }

    private static List<Row> materializeResult(TableResult tableResult) {
        ArrayList<Row> arrayList;
        block8: {
            CloseableIterator iterator = tableResult.collect();
            try {
                ArrayList<Row> actualRows = new ArrayList<Row>();
                iterator.forEachRemaining(row -> {
                    RowKind kind = row.getKind();
                    switch (kind) {
                        case INSERT: 
                        case UPDATE_AFTER: {
                            row.setKind(RowKind.INSERT);
                            actualRows.add((Row)row);
                            break;
                        }
                        case UPDATE_BEFORE: 
                        case DELETE: {
                            row.setKind(RowKind.INSERT);
                            actualRows.remove(row);
                        }
                    }
                });
                arrayList = actualRows;
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not collect results", e);
                }
            }
            iterator.close();
        }
        return arrayList;
    }

    private static class Source
    implements SourceFunction<RowData> {
        private final List<Row> rows;
        private final DynamicTableSource.DataStructureConverter converter;

        public Source(List<Row> rows, DynamicTableSource.DataStructureConverter converter) {
            this.rows = rows;
            this.converter = converter;
        }

        public void run(SourceFunction.SourceContext<RowData> ctx) throws Exception {
            this.rows.stream().map(row -> (RowData)this.converter.toInternal(row)).forEach(arg_0 -> ctx.collect(arg_0));
        }

        public void cancel() {
        }
    }

    private static final class TableApiErrorTestItem
    extends ErrorTestItem {
        private final List<Expression> selectExpr;
        private final List<Expression> groupByExpr;

        public TableApiErrorTestItem(List<Expression> selectExpr, List<Expression> groupByExpr, DataType expectedRowType, Class<? extends Throwable> errorClass, String errorMessage, boolean expectedDuringValidation) {
            super(expectedRowType, errorClass, errorMessage, expectedDuringValidation);
            this.selectExpr = selectExpr;
            this.groupByExpr = groupByExpr;
        }

        @Override
        protected Table query(TableEnvironment tEnv, Table sourceTable) {
            if (this.groupByExpr != null) {
                return sourceTable.groupBy(this.groupByExpr.toArray(new Expression[0])).select(this.selectExpr.toArray(new Expression[0]));
            }
            return sourceTable.select(this.selectExpr.toArray(new Expression[0]));
        }
    }

    private static final class SqlErrorTestItem
    extends ErrorTestItem {
        private final Function<Table, String> spec;

        public SqlErrorTestItem(Function<Table, String> spec, @Nullable DataType expectedRowType, Class<? extends Throwable> errorClass, String errorMessage, boolean expectedDuringValidation) {
            super(expectedRowType, errorClass, errorMessage, expectedDuringValidation);
            this.spec = spec;
        }

        @Override
        protected Table query(TableEnvironment tEnv, Table sourceTable) {
            return tEnv.sqlQuery(this.spec.apply(sourceTable));
        }
    }

    private static abstract class ErrorTestItem
    implements TestItem {
        private final DataType expectedRowType;
        private final Class<? extends Throwable> errorClass;
        private final String errorMessage;
        private final boolean expectedDuringValidation;

        public ErrorTestItem(@Nullable DataType expectedRowType, @Nullable Class<? extends Throwable> errorClass, @Nullable String errorMessage, boolean expectedDuringValidation) {
            Preconditions.checkState((errorClass != null || errorMessage != null ? 1 : 0) != 0);
            this.expectedRowType = expectedRowType;
            this.errorClass = errorClass;
            this.errorMessage = errorMessage;
            this.expectedDuringValidation = expectedDuringValidation;
        }

        Consumer<? super Throwable> errorMatcher() {
            if (this.errorClass != null && this.errorMessage != null) {
                return FlinkAssertions.anyCauseMatches(this.errorClass, (String)this.errorMessage);
            }
            if (this.errorMessage != null) {
                return FlinkAssertions.anyCauseMatches((String)this.errorMessage);
            }
            return FlinkAssertions.anyCauseMatches(this.errorClass);
        }

        @Override
        public void execute(TableEnvironment tEnv, Table sourceTable) {
            AtomicReference tableResult = new AtomicReference();
            Throwable t = Assertions.catchThrowable(() -> tableResult.set(this.query(tEnv, sourceTable).execute()));
            if (this.expectedDuringValidation) {
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).as("Expected a validation exception", new Object[0])).isNotNull()).satisfies(new Consumer[]{this.errorMatcher()});
                return;
            }
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).as("Error while validating the query", new Object[0])).isNull();
            if (this.expectedRowType != null) {
                DataType actualRowType = ((TableResult)tableResult.get()).getResolvedSchema().toSourceRowDataType();
                TableAssertions.assertThat((DataType)actualRowType).getChildren().containsExactlyElementsOf((Iterable)DataType.getFieldDataTypes((DataType)this.expectedRowType));
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableResult)tableResult.get()).await()).isNotNull()).satisfies(new Consumer[]{this.errorMatcher()});
        }

        protected abstract Table query(TableEnvironment var1, @Nullable Table var2);
    }

    private static class TableApiSqlResultTestItem
    extends SuccessItem {
        private final List<Expression> selectExpr;
        private final List<Expression> groupByExpr;

        public TableApiSqlResultTestItem(List<Expression> selectExpr, @Nullable List<Expression> groupByExpr, @Nullable DataType expectedRowType, @Nullable List<Row> expectedRows) {
            super(expectedRowType, expectedRows);
            this.selectExpr = selectExpr;
            this.groupByExpr = groupByExpr;
        }

        @Override
        protected TableResult getResult(TableEnvironment tEnv, Table sourceTable) {
            Table select = this.groupByExpr != null ? sourceTable.groupBy(this.groupByExpr.toArray(new Expression[0])).select(this.selectExpr.toArray(new Expression[0])) : sourceTable.select(this.selectExpr.toArray(new Expression[0]));
            ProjectQueryOperation projectQueryOperation = (ProjectQueryOperation)select.getQueryOperation();
            AggregateQueryOperation aggQueryOperation = (AggregateQueryOperation)select.getQueryOperation().getChildren().get(0);
            List<ResolvedExpression> selectExpr = TableApiSqlResultTestItem.recreateSelectList(aggQueryOperation, projectQueryOperation);
            String selectAsSerializableString = TableApiSqlResultTestItem.toSerializableExpr(selectExpr);
            String groupByAsSerializableString = TableApiSqlResultTestItem.toSerializableExpr(aggQueryOperation.getGroupingExpressions());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT ").append(selectAsSerializableString).append(" FROM ").append(sourceTable);
            if (!groupByAsSerializableString.isEmpty()) {
                stringBuilder.append(" GROUP BY ").append(groupByAsSerializableString);
            }
            return tEnv.sqlQuery(stringBuilder.toString()).execute();
        }

        @Nonnull
        private static List<ResolvedExpression> recreateSelectList(AggregateQueryOperation aggQueryOperation, ProjectQueryOperation projectQueryOperation) {
            List projectSchemaFields = projectQueryOperation.getResolvedSchema().getColumnNames();
            List aggSchemaFields = aggQueryOperation.getResolvedSchema().getColumnNames();
            return IntStream.range(0, projectSchemaFields.size()).mapToObj(idx -> {
                int indexInAgg = aggSchemaFields.indexOf(projectSchemaFields.get(idx));
                if (indexInAgg >= 0) {
                    int groupingExprCount = aggQueryOperation.getGroupingExpressions().size();
                    if (indexInAgg < groupingExprCount) {
                        return (ResolvedExpression)aggQueryOperation.getGroupingExpressions().get(indexInAgg);
                    }
                    return (ResolvedExpression)aggQueryOperation.getAggregateExpressions().get(indexInAgg - groupingExprCount);
                }
                return (ResolvedExpression)projectQueryOperation.getProjectList().get(idx);
            }).collect(Collectors.toList());
        }

        private static String toSerializableExpr(List<ResolvedExpression> expressions) {
            return expressions.stream().map(ResolvedExpression::asSerializableString).collect(Collectors.joining(", "));
        }

        public String toString() {
            return String.format("[API as SQL] select: [%s] groupBy: [%s]", this.selectExpr.stream().map(Expression::asSummaryString).collect(Collectors.joining(", ")), this.groupByExpr != null ? this.groupByExpr.stream().map(Expression::asSummaryString).collect(Collectors.joining(", ")) : "");
        }
    }

    private static class TableApiTestItem
    extends SuccessItem {
        private final List<Expression> selectExpr;
        private final List<Expression> groupByExpr;

        public TableApiTestItem(List<Expression> selectExpr, @Nullable List<Expression> groupByExpr, @Nullable DataType expectedRowType, @Nullable List<Row> expectedRows) {
            super(expectedRowType, expectedRows);
            this.selectExpr = selectExpr;
            this.groupByExpr = groupByExpr;
        }

        @Override
        protected TableResult getResult(TableEnvironment tEnv, Table sourceTable) {
            if (this.groupByExpr != null) {
                return sourceTable.groupBy(this.groupByExpr.toArray(new Expression[0])).select(this.selectExpr.toArray(new Expression[0])).execute();
            }
            return sourceTable.select(this.selectExpr.toArray(new Expression[0])).execute();
        }
    }

    private static class SqlTestItem
    extends SuccessItem {
        private final Function<Table, String> spec;

        public SqlTestItem(Function<Table, String> spec, @Nullable DataType expectedRowType, @Nullable List<Row> expectedRows) {
            super(expectedRowType, expectedRows);
            this.spec = spec;
        }

        @Override
        protected TableResult getResult(TableEnvironment tEnv, Table sourceTable) {
            return tEnv.sqlQuery(this.spec.apply(sourceTable)).execute();
        }
    }

    private static abstract class SuccessItem
    implements TestItem {
        @Nullable
        private final DataType expectedRowType;
        @Nullable
        private final List<Row> expectedRows;

        public SuccessItem(@Nullable DataType expectedRowType, @Nullable List<Row> expectedRows) {
            this.expectedRowType = expectedRowType;
            this.expectedRows = expectedRows;
        }

        @Override
        public void execute(TableEnvironment tEnv, Table sourceTable) {
            TableResult tableResult = this.getResult(tEnv, sourceTable);
            if (this.expectedRowType != null) {
                DataType actualRowType = tableResult.getResolvedSchema().toSourceRowDataType();
                TableAssertions.assertThat((DataType)actualRowType).getChildren().containsExactlyElementsOf((Iterable)DataType.getFieldDataTypes((DataType)this.expectedRowType));
            }
            if (this.expectedRows != null) {
                List<Row> actualRows = BuiltInAggregateFunctionTestBase.materializeResult(tableResult);
                Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(this.expectedRows);
            }
        }

        protected abstract TableResult getResult(TableEnvironment var1, Table var2);
    }

    private static interface TestItem {
        public void execute(TableEnvironment var1, Table var2);
    }

    protected static class TestSpec {
        @Nullable
        private final BuiltInFunctionDefinition definition;
        private final List<TestItem> testItems = new ArrayList<TestItem>();
        @Nullable
        private String description;
        private DataType sourceRowType;
        private List<Row> sourceRows;

        private TestSpec(BuiltInFunctionDefinition definition) {
            this.definition = definition;
        }

        static TestSpec forFunction(BuiltInFunctionDefinition definition) {
            return new TestSpec(definition);
        }

        static TestSpec forExpression(String expr) {
            return new TestSpec(null).withDescription(expr);
        }

        TestSpec withDescription(String description) {
            this.description = description;
            return this;
        }

        TestSpec withSource(DataType sourceRowType, List<Row> sourceRows) {
            this.sourceRowType = sourceRowType;
            this.sourceRows = sourceRows;
            return this;
        }

        TestSpec testSqlResult(Function<Table, String> sqlSpec, DataType expectedRowType, List<Row> expectedRows) {
            this.testItems.add(new SqlTestItem(sqlSpec, expectedRowType, expectedRows));
            return this;
        }

        TestSpec testApiResult(List<Expression> selectExpr, List<Expression> groupByExpr, DataType expectedRowType, List<Row> expectedRows) {
            this.testItems.add(new TableApiTestItem(selectExpr, groupByExpr, expectedRowType, expectedRows));
            return this;
        }

        TestSpec testApiSqlResult(List<Expression> selectExpr, List<Expression> groupByExpr, DataType expectedRowType, List<Row> expectedRows) {
            this.testItems.add(new TableApiSqlResultTestItem(selectExpr, groupByExpr, expectedRowType, expectedRows));
            return this;
        }

        TestSpec testResult(Function<Table, String> sqlSpec, TableApiAggSpec tableApiSpec, DataType expectedRowType, List<Row> expectedRows) {
            return this.testResult(sqlSpec, tableApiSpec, expectedRowType, expectedRowType, expectedRows);
        }

        TestSpec testResult(Function<Table, String> sqlSpec, TableApiAggSpec tableApiSpec, DataType expectedSqlRowType, DataType expectedTableApiRowType, List<Row> expectedRows) {
            this.testSqlResult(sqlSpec, expectedSqlRowType, expectedRows);
            this.testApiResult(tableApiSpec.selectExpr, tableApiSpec.groupByExpr, expectedTableApiRowType, expectedRows);
            this.testApiSqlResult(tableApiSpec.selectExpr, tableApiSpec.groupByExpr, expectedSqlRowType, expectedRows);
            return this;
        }

        TestSpec testSqlValidationError(Function<Table, String> sqlSpec, String errorMessage) {
            this.testItems.add(new SqlErrorTestItem(sqlSpec, null, ValidationException.class, errorMessage, true));
            return this;
        }

        TestSpec testTableApiValidationError(TableApiAggSpec tableApiSpec, String errorMessage) {
            this.testItems.add(new TableApiErrorTestItem(tableApiSpec.selectExpr, tableApiSpec.groupByExpr, null, ValidationException.class, errorMessage, true));
            return this;
        }

        TestSpec testValidationError(Function<Table, String> sqlSpec, TableApiAggSpec tableApiSpec, String errorMessage) {
            this.testSqlValidationError(sqlSpec, errorMessage);
            this.testTableApiValidationError(tableApiSpec, errorMessage);
            return this;
        }

        TestSpec testSqlRuntimeError(Function<Table, String> sqlSpec, DataType expectedRowType, Class<? extends Throwable> errorClass, String errorMessage) {
            this.testItems.add(new SqlErrorTestItem(sqlSpec, expectedRowType, errorClass, errorMessage, false));
            return this;
        }

        private Executable createTestItemExecutable(TestItem testItem, String stateBackend) {
            return () -> {
                Configuration conf = new Configuration();
                conf.set(StateBackendOptions.STATE_BACKEND, (Object)stateBackend);
                TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inStreamingMode().withConfiguration(conf).build());
                Table sourceTable = BuiltInAggregateFunctionTestBase.asTable(tEnv, this.sourceRowType, this.sourceRows);
                testItem.execute(tEnv, sourceTable);
            };
        }

        Stream<BuiltInFunctionTestBase.TestCase> getTestCases() {
            return Stream.concat(this.testItems.stream().map(testItem -> new BuiltInFunctionTestBase.TestCase(testItem.toString(), this.createTestItemExecutable((TestItem)testItem, "hashmap"))), this.testItems.stream().map(testItem -> new BuiltInFunctionTestBase.TestCase(testItem.toString(), this.createTestItemExecutable((TestItem)testItem, "rocksdb"))));
        }

        public String toString() {
            StringBuilder bob = new StringBuilder();
            if (this.definition != null) {
                bob.append(this.definition.getName());
            }
            if (this.description != null) {
                bob.append(" (");
                bob.append(this.description);
                bob.append(")");
            }
            return bob.toString();
        }
    }

    protected static final class TableApiAggSpec {
        private final List<Expression> selectExpr;
        private final List<Expression> groupByExpr;

        public TableApiAggSpec(List<Expression> selectExpr, List<Expression> groupByExpr) {
            this.selectExpr = selectExpr;
            this.groupByExpr = groupByExpr;
        }

        public static TableApiAggSpec groupBySelect(List<Expression> groupByExpr, Expression ... selectExpr) {
            return new TableApiAggSpec(Arrays.stream(selectExpr).collect(Collectors.toList()), groupByExpr);
        }

        public static TableApiAggSpec select(Expression ... selectExpr) {
            return new TableApiAggSpec(Arrays.stream(selectExpr).collect(Collectors.toList()), null);
        }
    }
}

