/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.factories;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.planner.factories.TestFunctionDefinitionFactory;
import org.apache.flink.table.planner.utils.FilterUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;

public class TestValuesCatalog
extends GenericInMemoryCatalog {
    private final boolean supportListPartitionByFilter;

    public TestValuesCatalog(String name, String defaultDatabase, boolean supportListPartitionByFilter) {
        super(name, defaultDatabase);
        this.supportListPartitionByFilter = supportListPartitionByFilter;
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        if (!this.supportListPartitionByFilter) {
            throw new UnsupportedOperationException("TestValuesCatalog doesn't support list partition by filters");
        }
        List partitions = this.listPartitions(tablePath);
        if (partitions.isEmpty()) {
            return partitions;
        }
        CatalogBaseTable table = this.getTable(tablePath);
        TableSchema schema = table.getSchema();
        List resolvedExpressions = filters.stream().map(filter -> {
            if (filter instanceof ResolvedExpression) {
                return (ResolvedExpression)filter;
            }
            throw new UnsupportedOperationException(String.format("TestValuesCatalog only works with resolved expressions. Get unresolved expression: %s", filter));
        }).collect(Collectors.toList());
        return partitions.stream().filter(partition -> {
            Function<String, Comparable<?>> getter = this.getValueGetter(partition.getPartitionSpec(), schema);
            return FilterUtils.isRetainedAfterApplyingFilterPredicates(resolvedExpressions, getter, null);
        }).collect(Collectors.toList());
    }

    public Optional<FunctionDefinitionFactory> getFunctionDefinitionFactory() {
        return Optional.of(new TestFunctionDefinitionFactory());
    }

    private Function<String, Comparable<?>> getValueGetter(Map<String, String> spec, TableSchema schema) {
        return field -> {
            Optional optionalDataType = schema.getFieldDataType(field);
            if (!optionalDataType.isPresent()) {
                throw new TableException(String.format("Field %s is not found in table schema.", field));
            }
            return this.convertValue(((DataType)optionalDataType.get()).getLogicalType(), spec.getOrDefault(field, null));
        };
    }

    private Comparable<?> convertValue(LogicalType type, String value) {
        if (type instanceof BooleanType) {
            return Boolean.valueOf(value);
        }
        if (type instanceof CharType) {
            return Character.valueOf(value.charAt(0));
        }
        if (type instanceof DoubleType) {
            return Double.valueOf(value);
        }
        if (type instanceof IntType) {
            return Integer.valueOf(value);
        }
        if (type instanceof BigIntType) {
            return Long.valueOf(value);
        }
        if (type instanceof VarCharType) {
            return value;
        }
        throw new UnsupportedOperationException(String.format("Unsupported data type: %s.", type));
    }
}

