/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.RowTypeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001y2A\u0001C\u0005\u0001-!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)A\u0007\u0001C\u0001E!)a\u0007\u0001C\u0001E!)\u0001\b\u0001C\u0001E!)!\b\u0001C\u0001E!)A\b\u0001C\u0001E\tY!k\\<UsB,G+Z:u\u0015\tQ1\"A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0007\u000e\u0003\u001d\u0001H.\u00198oKJT!AD\b\u0002\u000bQ\f'\r\\3\u000b\u0005A\t\u0012!\u00024mS:\\'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\u0011!$C\u0001\u0006kRLGn]\u0005\u00039e\u0011qBU8x)f\u0004X\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003%\ta\u0002^3tiJ{w\u000fT5uKJ\fG\u000eF\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0011)f.\u001b;)\u0005\tQ\u0003CA\u00163\u001b\u0005a#BA\u0017/\u0003\r\t\u0007/\u001b\u0006\u0003_A\nqA[;qSR,'O\u0003\u00022'\u0005)!.\u001e8ji&\u00111\u0007\f\u0002\u0005)\u0016\u001cH/\u0001\u0007uKN$(k\\<GS\u0016dG\r\u000b\u0002\u0004U\u0005\tB/Z:u%><x\n]3sCRLwN\\:)\u0005\u0011Q\u0013a\u0007;fgR,fn];qa>\u0014H/\u001a3DCN$H+\u00192mK\u0006\u0003\u0018\u000e\u000b\u0002\u0006U\u0005IB/Z:u+:\u001cX\u000f\u001d9peR,GmQ1tiN\u000bH.\u00119jQ\t1!&A\nuKN$(k\\<UsB,W)];bY&$\u0018\u0010\u000b\u0002\bU\u0001")
public class RowTypeTest
extends RowTypeTestBase {
    @Test
    public void testRowLiteral() {
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("foo"), package$.MODULE$.boolean2Literal(true)})), "ROW(1, 'foo', true)", "(1, foo, TRUE)");
        this.testTableApi(package$.MODULE$.row(package$.MODULE$.localDate2Literal(DateTimeTestUtil$.MODULE$.localDate("1985-04-11")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localTime2Literal(DateTimeTestUtil$.MODULE$.localTime("14:15:16")), package$.MODULE$.localDateTime2Literal(DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16")), package$.MODULE$.javaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("0.1").bigDecimal()), package$.MODULE$.array(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(2), package$.MODULE$.int2Literal(3)})), package$.MODULE$.map(package$.MODULE$.string2Literal("foo"), package$.MODULE$.string2Literal("bar"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), package$.MODULE$.row(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.boolean2Literal(true)}))})), "(1985-04-11, 14:15:16, 1985-04-11 14:15:16, 0.1, [1, 2, 3], {foo=bar}, (1, TRUE))");
        this.testSqlApi("ROW(DATE '1985-04-11', TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16', CAST(0.1 AS DECIMAL(2, 1)), ARRAY[1, 2, 3], MAP['foo', 'bar'], row(1, true))", "(1985-04-11, 14:15:16, 1985-04-11 14:15:16, 0.1, [1, 2, 3], {foo=bar}, (1, TRUE))");
        this.testSqlApi("ROW(DATE '1985-04-11', TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16.123456', CAST(0.1 AS DECIMAL(2, 1)), ARRAY[1, 2, 3], MAP['foo', 'bar'], row(1, true))", "(1985-04-11, 14:15:16, 1985-04-11 14:15:16.123456, 0.1, [1, 2, 3], {foo=bar}, (1, TRUE))");
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(6), package$.MODULE$.nullOf(DataTypes.STRING())})), "ROW(1 + 1, 2 * 3, NULLIF(1, 1))", "(2, 6, NULL)");
        this.testSqlApi("(1, 'foo', true)", "(1, foo, TRUE)");
    }

    @Test
    public void testRowField() {
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "(f0, f1)", "(NULL, 1)");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "(2, foo, TRUE)");
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))})), "(f2, f5)", "((2, foo, TRUE), (foo, NULL))");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), "f4", "(1984-03-12, 0.00000000, [1, 2, 3])");
        this.testAllApis(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("foo"), package$.MODULE$.boolean2Literal(true)})), "(f1, 'foo',true)", "(1, foo, TRUE)");
    }

    @Test
    public void testRowOperations() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).get("f0"), "f5.f0", "foo");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).get("f1")).get("f2"), "f3.f1.f2", "TRUE");
        this.testTableApi((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.row(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))}))).get("f1")).get("f1"), "NULL");
    }

    @Test
    public void testUnsupportedCastTableApi() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cast(DataTypes.BIGINT()), ""));
    }

    @Test
    public void testUnsupportedCastSqlApi() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("CAST(f5 AS BIGINT)", "")).withMessageContaining("Cast function cannot convert value");
    }

    @Test
    public void testRowTypeEquality() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$eq$eq$eq(package$.MODULE$.row(package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("foo"), package$.MODULE$.boolean2Literal(true)}))), "f2 = row(2, 'foo', true)", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).$eq$eq$eq(package$.MODULE$.row(package$.MODULE$.int2Literal(3), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.row(package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("foo"), package$.MODULE$.boolean2Literal(true)}))}))), "f3 = row(3, row(2, 'foo', true))", "TRUE");
    }
}

