/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.DateDiffFun$;
import org.apache.flink.table.planner.expressions.NonDeterministicTest$;
import org.apache.flink.table.planner.expressions.TimeDiffFun$;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\n\u0015\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0006\t\u0002!\t!\u000e\u0005\u0006\r\u0002!\t!\u000e\u0005\u0006\u0011\u0002!\t!\u000e\u0005\u0006\u0015\u0002!\t!\u000e\u0005\u0006\u0019\u0002!I!\u0014\u0005\u00061\u0002!I!\u0017\u0005\u00067\u0002!\t!\u000e\u0005\u0006;\u0002!\t!\u000e\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006c\u0002!\tE]\u0004\b\u0003o!\u0002\u0012AA\u001d\r\u0019\u0019B\u0003#\u0001\u0002<!1q\u0006\u0005C\u0001\u0003\u0007Bq!!\u0012\u0011\t\u0003\t9E\u0001\u000bO_:$U\r^3s[&t\u0017n\u001d;jGR+7\u000f\u001e\u0006\u0003+Y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0003G\u0001\ba2\fgN\\3s\u0015\tI\"$A\u0003uC\ndWM\u0003\u0002\u001c9\u0005)a\r\\5oW*\u0011QDH\u0001\u0007CB\f7\r[3\u000b\u0003}\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0012!B;uS2\u001c\u0018BA\u0014%\u0005I)\u0005\u0010\u001d:fgNLwN\u001c+fgR\u0014\u0015m]3\u0002\u0017%\u001c8\u000b\u001e:fC6Lgn\u001a\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0011\u0011g\r\t\u0003e\u0001i\u0011\u0001\u0006\u0005\u0006Q\t\u0001\r!K\u0001\"i\u0016\u001cH\u000fV3na>\u0014\u0018\r\u001c$v]\u000e$\u0018n\u001c8t\u0013:\u001cFO]3b[6{G-\u001a\u000b\u0002mA\u0011!fN\u0005\u0003q-\u0012A!\u00168ji\"\u00121A\u000f\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\n1!\u00199j\u0015\ty\u0004)A\u0004kkBLG/\u001a:\u000b\u0005\u0005s\u0012!\u00026v]&$\u0018BA\"=\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0003\u0001\"Xm\u001d;UK6\u0004xN]1m\rVt7\r^5p]NLeNQ1uG\"lu\u000eZ3)\u0005\u0011Q\u0014a\u000b;fgR\u001cUO\u001d:f]R\u0014vn\u001e+j[\u0016\u001cH/Y7q\rVt7\r^5p]NLeNQ1uG\"lu\u000eZ3)\u0005\u0015Q\u0014A\u0007;fgR$V-\u001c9pe\u0006dg)\u001e8di&|gn]%o+R\u001b\u0005F\u0001\u0004;\u0003}!Xm\u001d;UK6\u0004xN]1m\rVt7\r^5p]NLen\u00155b]\u001eD\u0017-\u001b\u0015\u0003\u000fi\nAc]3u\u000bB|7\r[!oI2{7-\u00197US6,GC\u0001\u001cO\u0011\u0015y\u0005\u00021\u0001Q\u0003\u0019QxN\\3JIB\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0005i&lWMC\u0001V\u0003\u0011Q\u0017M^1\n\u0005]\u0013&A\u0002.p]\u0016LE-A\u000buKN$H+Z7q_J\fG\u000eV5nKN$\u0018-\u001c9\u0015\u0005YR\u0006\"B(\n\u0001\u0004\u0001\u0016\u0001\u0003;fgR,V+\u0013#)\u0005)Q\u0014\u0001\u0003;fgR\u0014\u0016M\u001c3)\u0005-Q\u0014\u0001\u0003;fgR$\u0015\r^1\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u000e\u0002\u000bQL\b/Z:\n\u0005\u0019\u001c'a\u0001*po\u0006AA/\u001f9f\u0013:4w.F\u0001j!\tQw.D\u0001l\u0015\taW.A\u0005usB,W\u000f^5mg*\u0011QK\u001c\u0006\u0003{iI!\u0001]6\u0003\u0017I{w\u000fV=qK&sgm\\\u0001\nMVt7\r^5p]N,\u0012a\u001d\t\u0006int\u00181\u0001\b\u0003kf\u0004\"A^\u0016\u000e\u0003]T!\u0001\u001f\u0011\u0002\rq\u0012xn\u001c;?\u0013\tQ8&\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u00141!T1q\u0015\tQ8\u0006\u0005\u0002u\u007f&\u0019\u0011\u0011A?\u0003\rM#(/\u001b8h!\u0011\t)!!\u0003\u000e\u0005\u0005\u001d!BA9\u0019\u0013\u0011\tY!a\u0002\u0003\u001dM\u001b\u0017\r\\1s\rVt7\r^5p]\":\u0001!a\u0004\u0002\u001c\u0005u\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UA(A\u0005fqR,gn]5p]&!\u0011\u0011DA\n\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003?\u0019#!!\t\u0011\t\u0005\r\u00121G\u0007\u0003\u0003KQA!a\n\u0002*\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a\u000b\u0002.\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007\u0005\u000byCC\u0002\u00022i\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005U\u0012Q\u0005\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0001\u0015\u001d>tG)\u001a;fe6Lg.[:uS\u000e$Vm\u001d;\u0011\u0005I\u00022c\u0001\t\u0002>A\u0019!&a\u0010\n\u0007\u0005\u00053F\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003s\t!\u0002]1sC6,G/\u001a:t)\t\tI\u0005E\u0003\u0002L\u0005E\u0013&\u0004\u0002\u0002N)\u0019\u0011q\n+\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003'\niE\u0001\u0006D_2dWm\u0019;j_:DsAEA,\u0003;\ny\u0006\u0005\u0003\u0002$\u0005e\u0013\u0002BA.\u0003K\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005\u0005\u0014\u0001D5t'R\u0014X-Y7>wBj\b")
public class NonDeterministicTest
extends ExpressionTestBase {
    private final boolean isStreaming;

    @Parameters(name="isStream={0}")
    public static Collection<Object> parameters() {
        return NonDeterministicTest$.MODULE$.parameters();
    }

    @TestTemplate
    public void testTemporalFunctionsInStreamMode() {
        Assumptions.assumeThat((boolean)this.isStreaming).isTrue();
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_DATE", (List)new .colon.colon((Object)"CURRENT_TIME", (List)new .colon.colon((Object)"CURRENT_TIMESTAMP", (List)new .colon.colon((Object)"CURRENT_ROW_TIMESTAMP()", (List)new .colon.colon((Object)"NOW()", (List)new .colon.colon((Object)"LOCALTIME", (List)new .colon.colon((Object)"LOCALTIMESTAMP", (List)Nil$.MODULE$))))))));
        List<String> round1 = this.evaluateFunctionResult(temporalFunctions);
        Thread.sleep(1000L);
        List<String> round2 = this.evaluateFunctionResult(temporalFunctions);
        Assertions.assertThat((int)round2.size()).isEqualTo(round2.size());
        ((List)((IterableLike)round1.zip(round2, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NonDeterministicTest.$anonfun$testTemporalFunctionsInStreamMode$1(x0$1);
            return BoxedUnit.UNIT;
        });
        int currentTimeStampIndex = 2;
        int currentRowTimestampIndex = 3;
        Assertions.assertThat((String)((String)round1.apply(currentTimeStampIndex))).isEqualTo((String)round1.apply(currentRowTimestampIndex));
        Assertions.assertThat((String)((String)round2.apply(currentTimeStampIndex))).isEqualTo((String)round2.apply(currentRowTimestampIndex));
    }

    @TestTemplate
    public void testTemporalFunctionsInBatchMode() {
        Assumptions.assumeThat((boolean)this.isStreaming).isFalse();
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        this.tableConfig().setLocalTimeZone(zoneId);
        this.tableConfig().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)BoxesRunTime.boxToLong((long)1123L));
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)BoxesRunTime.boxToLong((long)(1123L + (long)TimeZone.getTimeZone(zoneId).getOffset(1123L))));
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_DATE", (List)new .colon.colon((Object)"CURRENT_TIME", (List)new .colon.colon((Object)"CURRENT_TIMESTAMP", (List)new .colon.colon((Object)"NOW()", (List)new .colon.colon((Object)"LOCALTIME", (List)new .colon.colon((Object)"LOCALTIMESTAMP", (List)Nil$.MODULE$)))))));
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01", "08:00:01", "1970-01-01 08:00:01.123", "1970-01-01 08:00:01.123", "08:00:01", "1970-01-01 08:00:01.123"}));
        List<String> result = this.evaluateFunctionResult(temporalFunctions);
        Assertions.assertThat((Object)result.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.toList().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCurrentRowTimestampFunctionsInBatchMode() {
        Assumptions.assumeThat((boolean)this.isStreaming).isFalse();
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_ROW_TIMESTAMP()", (List)Nil$.MODULE$));
        List<String> round1 = this.evaluateFunctionResult(temporalFunctions);
        Thread.sleep(1000L);
        List<String> round2 = this.evaluateFunctionResult(temporalFunctions);
        Assumptions.assumeThat((int)round2.size()).isEqualTo(round1.size());
        ((List)round1.zip(round2, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NonDeterministicTest.$anonfun$testCurrentRowTimestampFunctionsInBatchMode$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testTemporalFunctionsInUTC() {
        this.testTemporalTimestamp(ZoneId.of("UTC"));
    }

    @TestTemplate
    public void testTemporalFunctionsInShanghai() {
        this.testTemporalTimestamp(ZoneId.of("Asia/Shanghai"));
    }

    private void setEpochAndLocalTime(ZoneId zoneId) {
        this.tableConfig().setLocalTimeZone(zoneId);
        Long epochTime = Predef$.MODULE$.long2Long(System.currentTimeMillis());
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)epochTime);
        Long localTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(epochTime) + (long)TimeZone.getTimeZone(TableConfigUtils.getLocalTimeZone((ReadableConfig)this.tableConfig())).getOffset(Predef$.MODULE$.Long2long(epochTime)));
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)localTime);
    }

    private void testTemporalTimestamp(ZoneId zoneId) {
        this.setEpochAndLocalTime(zoneId);
        LocalDateTime localDateTime = LocalDateTime.now(zoneId);
        String formattedLocalTime = localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String formattedLocalDateTime = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String formattedCurrentDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String formattedCurrentTime = localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String formattedCurrentTimestamp = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.testSqlApi(new StringBuilder(37).append("TIME_SUB(LOCALTIME, TIME '").append(formattedLocalTime).append("') <= 60000").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(57).append("TIMESTAMPDIFF(SECOND, TIMESTAMP '").append(formattedLocalDateTime).append("', LOCALTIMESTAMP) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(36).append("DATE_SUB(CURRENT_DATE, DATE '").append(formattedCurrentDate).append("') >= 0").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(40).append("TIME_SUB(CURRENT_TIME, TIME '").append(formattedCurrentTime).append("') <= 60000").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(48).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz(formattedCurrentTimestamp)).append(", CURRENT_TIMESTAMP) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(36).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz(formattedCurrentTimestamp)).append(", NOW()) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(54).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz(formattedCurrentTimestamp)).append(", CURRENT_ROW_TIMESTAMP()) <= 60").toString(), "TRUE");
    }

    @TestTemplate
    public void testUUID() {
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.uuid()).charLength(), "CHARACTER_LENGTH(UUID())", "36");
    }

    @TestTemplate
    public void testRand() {
        this.testSqlApi("RAND() <> RAND() or RAND() = RAND()", "TRUE");
        this.testSqlApi("RAND(1) <> RAND(1) or RAND(1) = RAND(1)", "TRUE");
        this.testSqlApi("RAND_INTEGER(10) <> RAND_INTEGER(10) or RAND_INTEGER(10) = RAND_INTEGER(10)", "TRUE");
    }

    @Override
    public Row testData() {
        return new Row(0);
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }

    @Override
    public Map<String, ScalarFunction> functions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME_SUB"), (Object)TimeDiffFun$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DATE_SUB"), (Object)DateDiffFun$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$testTemporalFunctionsInStreamMode$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                String result1 = (String)tuple22._1();
                String result2 = (String)tuple22._2();
                if (result1 != null) {
                    String string = result1;
                    if (result2 != null) {
                        String string2 = result2;
                        int n = index;
                        if (n == 0) {
                            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less$eq((Object)string2));
                            return;
                        }
                        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less((Object)string2));
                        return;
                    }
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$testCurrentRowTimestampFunctionsInBatchMode$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String result1 = (String)tuple2._1();
            String result2 = (String)tuple2._2();
            if (result1 != null) {
                String string = result1;
                if (result2 != null) {
                    String string2 = result2;
                    Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less((Object)string2));
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public NonDeterministicTest(boolean isStreaming) {
        this.isStreaming = isStreaming;
        super(isStreaming);
    }
}

