/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Double$;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0006\f\u0001G!)!\u0006\u0001C\u0001W!)a\u0006\u0001C\u0001_!)\u0011\t\u0001C\u0001_!)1\t\u0001C\u0001_!)Q\t\u0001C\u0001_!)q\t\u0001C\u0001_!)\u0011\n\u0001C\u0001_!)1\n\u0001C\u0001_!)Q\n\u0001C\u0001_!)q\n\u0001C\u0001_!)\u0011\u000b\u0001C\u0001_!)1\u000b\u0001C\u0001_!)Q\u000b\u0001C\u0001_!)q\u000b\u0001C\u0001_!)\u0011\f\u0001C\u0001_!)1\f\u0001C\u0001_!)Q\f\u0001C\u0001_!)q\f\u0001C!A\")q\r\u0001C!Q\")a\u000e\u0001C!_\nyA)Z2j[\u0006dG+\u001f9f)\u0016\u001cHO\u0003\u0002\u00181\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tI\"$A\u0004qY\u0006tg.\u001a:\u000b\u0005ma\u0012!\u0002;bE2,'BA\u000f\u001f\u0003\u00151G.\u001b8l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0003OY\tQ!\u001e;jYNL!!\u000b\u0014\u0003%\u0015C\bO]3tg&|g\u000eV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003Y\t1\u0003^3ti\u0012+7-[7bY2KG/\u001a:bYN$\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0005+:LG\u000f\u000b\u0002\u0003oA\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\u0004CBL'B\u0001\u001f>\u0003\u001dQW\u000f]5uKJT!A\u0010\u0011\u0002\u000b),h.\u001b;\n\u0005\u0001K$\u0001\u0002+fgR\f!\u0003^3ti\u0012+7-[7bY\n{'\u000fZ3sg\"\u00121aN\u0001\u0016i\u0016\u001cH\u000fR3dS6\fG.\u0011:ji\"lW\r^5dQ\t!q'A\u000buKN$H)Z2j[\u0006d7i\\7qCJL7o\u001c8)\u0005\u00159\u0014a\u0004;fgR4\u0015.\u001a7e\u0003\u000e\u001cWm]:)\u0005\u00199\u0014A\u0005;fgR,f.\u0019:z!2,8/T5okND#aB\u001c\u0002\u001bQ,7\u000f\u001e)mkNl\u0015N\\;tQ\tAq'\u0001\u0007uKN$X*\u001e7uSBd\u0017\u0010\u000b\u0002\no\u0005QA/Z:u\t&4\u0018\u000eZ3)\u0005)9\u0014a\u0002;fgRlu\u000e\u001a\u0015\u0003\u0017]\nQ\u0003^3ti\u0016C\u0018m\u0019;j_:4UO\\2uS>t7\u000f\u000b\u0002\ro\u0005AB/Z:u\u0003B\u0004(o\u001c=j[\u0006$XMR;oGRLwN\\:)\u000559\u0014\u0001\u0004;fgR\u001c\u0015m]3XQ\u0016t\u0007F\u0001\b8\u00031!Xm\u001d;FcV\fG.\u001b;zQ\tyq'\u0001\buKN$8i\\7qCJL7o\u001c8)\u0005A9\u0014!\b;fgR\u001cu.\u001c9be\u0016$UmY5nC2\u001cu\u000e\\,ji\"tU\u000f\u001c7)\u0005E9\u0014\u0001\u0003;fgR$\u0015\r^1\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u000f\u0002\u000bQL\b/Z:\n\u0005\u0019\u001c'a\u0001*po\u0006aA/Z:u\t\u0006$\u0018\rV=qKV\t\u0011\u000e\u0005\u0002kY6\t1N\u0003\u0002e5%\u0011Qn\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006\u00192m\u001c8uC&t7\u000fT3hC\u000eLH+\u001f9fgV\t\u0001\u000f\u0005\u00022c&\u0011!O\r\u0002\b\u0005>|G.Z1o\u0001")
public class DecimalTypeTest
extends ExpressionTestBase {
    @Test
    public void testDecimalLiterals() {
        this.testAllApis(package$.MODULE$.double2Literal(11.2), "11.2", "11.2");
        this.testAllApis(package$.MODULE$.double2Literal(0.7623533651719233), "0.7623533651719233", "0.7623533651719233");
        this.testAllApis(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("1234567891234567891")), "1234567891234567891", "1234567891234567891");
        this.testTableApi(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789")), "123456789123456789123456789");
        this.testTableApi(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("12.3456789123456789123456789")), "12.3456789123456789123456789");
    }

    @Test
    public void testDecimalBorders() {
        this.testAllApis(package$.MODULE$.double2Literal(Double.MAX_VALUE), Double.toString(Double.MAX_VALUE), Double.toString(Double.MAX_VALUE));
        this.testAllApis(package$.MODULE$.double2Literal(Double$.MODULE$.MinValue()), Double.toString(Double$.MODULE$.MinValue()), Double.toString(Double$.MODULE$.MinValue()));
    }

    @Test
    public void testDecimalArithmetic() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus(package$.MODULE$.int2Literal(12)), "f1 + 12", "123456789123456789123456801");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)12))).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "12 + f1", "123456789123456789123456801");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("12.3"))), "f1 + 12.3", "123456789123456789123456801.3");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.lit((Object)scala.package$.MODULE$.BigDecimal().apply("12.3").bigDecimal())).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "12.3 + f1", "123456789123456789123456801.3");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 + f1", "246913578246913578246913578");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 - f1", "0");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 / f1", "1.00000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "MOD(f1, f1)", "0");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).unary_$minus(), "-f0", "-123456789.123456789123456789");
    }

    @Test
    public void testDecimalComparison() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$less(package$.MODULE$.int2Literal(12)), "f1 < 12", "FALSE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$greater(package$.MODULE$.int2Literal(12)), "f1 > 12", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.int2Literal(12)), "f1 = 12", "FALSE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).$eq$eq$eq(package$.MODULE$.int2Literal(0)), "f5 = 0", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789"))), "f1 = CAST('123456789123456789123456789' AS DECIMAL(30, 0))", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$bang$eq$eq(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789"))), "f1 <> CAST('123456789123456789123456789' AS DECIMAL(30, 0))", "FALSE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "f4 < f0", "TRUE");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).toExpr()).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "12 < f1", "TRUE");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).toExpr()).$greater(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "12 > f1", "FALSE");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).toExpr()).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f37"))), "12 - f37", "10");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).toExpr()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f37"))), "12 + f37", "14");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).toExpr()).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f37"))), "12 * f37", "24");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).toExpr()).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f37"))), "12 / f37", "6");
    }

    @Test
    public void testFieldAccess() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")), "f6", "123");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")), "f7", "123.45");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")), "f8", "100.00");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8"))), "f8 + f8", "200.00");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")), "f9", "100.10");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f9 + f9", "200.20");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")), "f10", "100.00");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10"))), "f10 + f10", "200.00");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")), "f11", "NULL");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f12")), "f12", "NULL");
    }

    @Test
    public void testUnaryPlusMinus() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).unary_$plus(), "+f6", "123");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).unary_$minus(), "-f7", "-123.45");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).unary_$plus()).$minus(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).unary_$minus())).unary_$minus(), "- (( + f6) - ( - f7))", "-246.45");
    }

    @Test
    public void testPlusMinus() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f14"))), "f13 + f14", "300.2434");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f14"))), "f13 - f14", "-100.0034");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "f7 + f2", "165.45");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2 + f7", "165.45");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3"))), "f7 + f3", "127.65");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f3 + f7", "127.65");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16"))), "f15 + f16", "300.024691358");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16"))), "f15 - f16", "-100.000000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18"))), "f17 + f18", "10000000000.000000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18"))), "f17 - f18", "10000000000.000000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19"))), "f19 + f19", "NULL");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")))).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19"))), "f19 + f19 - f19", "NULL");
    }

    @Test
    public void testMultiply() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20"))), "f20 * f20", "1.0000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21"))), "f20 * f21", "2.000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22"))), "f20 * f22", "200.00");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20"))), "f22 * f20", "200.00");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f23"))), "f20 * f23", "3.14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f23")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20"))), "f23 * f20", "3.14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f24")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f24"))), "f24 * f24", "1.000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f24")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25"))), "f24 * f25", "2.000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26"))), "f26 * f26", "0.00010000000000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28"))), "f27 * f28", "0.000001");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29"))), "f29 * f29", "NULL");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30"))), "f30 * f30", "1.00000000000000000");
    }

    @Test
    public void testDivide() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32"))), "f31 / f32", "0.333333");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))), "f31 / f33", "0.3333333");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f34"))), "f31 / f34", "0.3333333333");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f35"))), "f31 / f35", "0.333333");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f36")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f37"))), "f36 / f37", "0.5000000000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f37")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f36"))), "f37 / f36", "2.00000000000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f36")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f38"))), "f36 / f38", Double.toString(0.3333333333333333));
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f38")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f36"))), "f38 / f36", Double.toString(3.0));
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f39")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f40"))), "f39 / f40", "NULL");
    }

    @Test
    public void testMod() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f41")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f42"))), "mod(f41, f42)", "3.0000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f42")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f41"))), "mod(f42, f41)", "2.0000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f41")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f43"))), "mod(f41, f43)", "3.00");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f43")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f41"))), "mod(f43, f41)", "1.00");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f44")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f45"))), "mod(f44, f45)", Integer.toString(3));
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f44")).unary_$minus()).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f45"))), "mod(-f44, f45)", Integer.toString(-3));
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f44")).$percent(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f45")).unary_$minus()), "mod(f44, -f45)", Integer.toString(3));
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f44")).unary_$minus()).$percent(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f45")).unary_$minus()), "mod(-f44, -f45)", Integer.toString(-3));
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f46")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f47"))), "mod(f46, f47)", "3.1234");
    }

    @Test
    public void testExactionFunctions() {
        this.testAllApis(package$.MODULE$.ifThenElse(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).$greater(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f49"))), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f49"))), "if(f48 > f49, f48, f49)", "3.14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).abs(), "abs(f48)", "3.14");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).unary_$minus()).abs(), "abs(-f48)", "3.14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).floor(), "floor(f48)", "3");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).ceil(), "ceil(f48)", "4");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).sign(), "sign(f48)", "1.00");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).unary_$minus()).sign(), "sign(-f48)", "-1.00");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f48")))).sign(), "sign(f48 - f48)", "0.00");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(0)), "round(f50)", "647");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(0)), "round(f50,0)", "647");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(1)), "round(f50,1)", "646.6");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(2)), "round(f50,2)", "646.65");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(3)), "round(f50,3)", "646.646");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(4)), "round(f50,4)", "646.646");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(-1)), "round(f50,-1)", "650");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(-2)), "round(f50,-2)", "600");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(-3)), "round(f50,-3)", "1000");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f50")).round((Object)package$.MODULE$.int2Literal(-4)), "round(f50,-4)", "0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f51")).round((Object)package$.MODULE$.int2Literal(1)), "round(f51,1)", "100.0");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f51")).unary_$minus()).round((Object)package$.MODULE$.int2Literal(1)), "round(-f51,1)", "-100.0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f51")).round((Object)package$.MODULE$.int2Literal(-1)), "round(f51,-1)", "100");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f51")).unary_$minus()).round((Object)package$.MODULE$.int2Literal(-1)), "round(-f51,-1)", "-100");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f52")).round((Object)package$.MODULE$.int2Literal(-1)), "round(f52,-1)", "NULL");
    }

    @Test
    public void testApproximateFunctions() {
    }

    @Test
    public void testCaseWhen() {
        this.testSqlApi("case f53 when 0 then f53 else f54 end", "0.0100");
        this.testSqlApi("case f53 when 0 then f53 else f2 end", "42.0000");
        this.testSqlApi("case f53 when 0 then f23 else f53 end", Double.toString(scala.package$.MODULE$.BigDecimal().apply("0.0001").doubleValue()));
    }

    @Test
    public void testEquality() {
        this.testSqlApi("f63=f64", "TRUE");
        this.testSqlApi("f63=f65", "TRUE");
        this.testSqlApi("f63=f66", "TRUE");
        this.testSqlApi("f64=f63", "TRUE");
        this.testSqlApi("f65=f63", "TRUE");
        this.testSqlApi("f66=f63", "TRUE");
        this.testSqlApi("f63 IN(f64)", "TRUE");
        this.testSqlApi("f63 IN(f65)", "TRUE");
        this.testSqlApi("f63 IN(f66)", "TRUE");
        this.testSqlApi("f64 IN(f63)", "TRUE");
        this.testSqlApi("f65 IN(f63)", "TRUE");
        this.testSqlApi("f66 IN(f63)", "TRUE");
        this.testSqlApi("f63 IS DISTINCT FROM f64", "FALSE");
        this.testSqlApi("f64 IS DISTINCT FROM f63", "FALSE");
        this.testSqlApi("f63 IS DISTINCT FROM f65", "FALSE");
        this.testSqlApi("f65 IS DISTINCT FROM f63", "FALSE");
        this.testSqlApi("f63 IS DISTINCT FROM f66", "FALSE");
        this.testSqlApi("f66 IS DISTINCT FROM f63", "FALSE");
        this.testSqlApi("NULLIF(f63,f64)", "NULL");
        this.testSqlApi("NULLIF(f63,f65)", "NULL");
        this.testSqlApi("NULLIF(f63,f66)", "NULL");
        this.testSqlApi("NULLIF(f64,f63)", "NULL");
        this.testSqlApi("NULLIF(f65,f63)", "NULL");
        this.testSqlApi("NULLIF(f66,f63)", "NULL");
        this.testSqlApi("NULLIF(f63,f64)", "NULL");
        this.testSqlApi("case f63 when f64 then 1 else 0 end", "1");
        this.testSqlApi("case f63 when f65 then 1 else 0 end", "1");
        this.testSqlApi("case f63 when f66 then 1 else 0 end", "1");
        this.testSqlApi("case f64 when f63 then 1 else 0 end", "1");
        this.testSqlApi("case f65 when f64 then 1 else 0 end", "1");
        this.testSqlApi("case f66 when f65 then 1 else 0 end", "1");
    }

    @Test
    public void testComparison() {
        this.testSqlApi("f63 < f64", "FALSE");
        this.testSqlApi("f63 < f65", "FALSE");
        this.testSqlApi("f63 < f66", "FALSE");
        this.testSqlApi("f64 < f63", "FALSE");
        this.testSqlApi("f65 < f63", "FALSE");
        this.testSqlApi("f66 < f63", "FALSE");
        this.testSqlApi("f67 < f68", "TRUE");
        this.testSqlApi("f67 < f69", "TRUE");
        this.testSqlApi("f67 < f70", "TRUE");
        this.testSqlApi("f68 < f67", "FALSE");
        this.testSqlApi("f69 < f67", "FALSE");
        this.testSqlApi("f70 < f67", "FALSE");
        this.testSqlApi("f63 between f64 and 1", "TRUE");
        this.testSqlApi("f64 between f63 and 1", "TRUE");
        this.testSqlApi("f63 between f65 and 1", "TRUE");
        this.testSqlApi("f65 between f63 and 1", "TRUE");
        this.testSqlApi("f63 between f66 and 1", "TRUE");
        this.testSqlApi("f66 between f63 and 1", "TRUE");
        this.testSqlApi("f63 between 0 and f64", "TRUE");
        this.testSqlApi("f64 between 0 and f63", "TRUE");
        this.testSqlApi("f63 between 0 and f65", "TRUE");
        this.testSqlApi("f65 between 0 and f63", "TRUE");
        this.testSqlApi("f63 between 0 and f66", "TRUE");
        this.testSqlApi("f66 between 0 and f63", "TRUE");
    }

    @Test
    public void testCompareDecimalColWithNull() {
        this.testSqlApi("f35>cast(1234567890123.123 as decimal(20,16))", "NULL");
    }

    @Override
    public Row testData() {
        Row testData = new Row(71);
        testData.setField(0, (Object)scala.package$.MODULE$.BigDecimal().apply("123456789.123456789123456789").bigDecimal());
        testData.setField(1, (Object)scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789").bigDecimal());
        testData.setField(2, (Object)BoxesRunTime.boxToInteger((int)42));
        testData.setField(3, (Object)BoxesRunTime.boxToDouble((double)4.2));
        testData.setField(4, (Object)scala.package$.MODULE$.BigDecimal().apply("123456789").bigDecimal());
        testData.setField(5, (Object)scala.package$.MODULE$.BigDecimal().apply("0.000").bigDecimal());
        testData.setField(6, (Object)scala.package$.MODULE$.BigDecimal().apply("123").bigDecimal());
        testData.setField(7, (Object)scala.package$.MODULE$.BigDecimal().apply("123.45").bigDecimal());
        testData.setField(8, (Object)scala.package$.MODULE$.BigDecimal().apply("100.004").bigDecimal());
        testData.setField(9, (Object)scala.package$.MODULE$.BigDecimal().apply("100.1").bigDecimal());
        testData.setField(10, (Object)scala.package$.MODULE$.BigDecimal().apply("100.0040").bigDecimal());
        testData.setField(11, (Object)scala.package$.MODULE$.BigDecimal().apply("123").bigDecimal());
        testData.setField(12, (Object)scala.package$.MODULE$.BigDecimal().apply("123.0000").bigDecimal());
        testData.setField(13, (Object)scala.package$.MODULE$.BigDecimal().apply("100.12").bigDecimal());
        testData.setField(14, (Object)scala.package$.MODULE$.BigDecimal().apply("200.1234").bigDecimal());
        testData.setField(15, (Object)scala.package$.MODULE$.BigDecimal().apply("100.0123456789").bigDecimal());
        testData.setField(16, (Object)scala.package$.MODULE$.BigDecimal().apply("200.0123456789012345678901234567").bigDecimal());
        testData.setField(17, (Object)scala.package$.MODULE$.BigDecimal().apply("1e10").bigDecimal());
        testData.setField(18, (Object)scala.package$.MODULE$.BigDecimal().apply("0").bigDecimal());
        testData.setField(19, (Object)scala.package$.MODULE$.BigDecimal().apply("5e37").bigDecimal());
        testData.setField(20, (Object)scala.package$.MODULE$.BigDecimal().apply("1.00").bigDecimal());
        testData.setField(21, (Object)scala.package$.MODULE$.BigDecimal().apply("2.0000").bigDecimal());
        testData.setField(22, (Object)BoxesRunTime.boxToInteger((int)200));
        testData.setField(23, (Object)BoxesRunTime.boxToDouble((double)3.14));
        testData.setField(24, (Object)scala.package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(25, (Object)scala.package$.MODULE$.BigDecimal().apply("2").bigDecimal());
        testData.setField(26, (Object)scala.package$.MODULE$.BigDecimal().apply("0.01").bigDecimal());
        testData.setField(27, (Object)scala.package$.MODULE$.BigDecimal().apply("0.0000006").bigDecimal());
        testData.setField(28, (Object)scala.package$.MODULE$.BigDecimal().apply("1.0").bigDecimal());
        testData.setField(29, (Object)scala.package$.MODULE$.BigDecimal().apply("1e19").bigDecimal());
        testData.setField(30, (Object)scala.package$.MODULE$.BigDecimal().apply("1.0").bigDecimal());
        testData.setField(31, (Object)scala.package$.MODULE$.BigDecimal().apply("1.00").bigDecimal());
        testData.setField(32, (Object)scala.package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(33, (Object)scala.package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(34, (Object)scala.package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(35, (Object)scala.package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(36, (Object)scala.package$.MODULE$.BigDecimal().apply("1.00").bigDecimal());
        testData.setField(37, (Object)BoxesRunTime.boxToInteger((int)2));
        testData.setField(38, (Object)BoxesRunTime.boxToDouble((double)3.0));
        testData.setField(39, (Object)scala.package$.MODULE$.BigDecimal().apply("1e20").bigDecimal());
        testData.setField(40, (Object)scala.package$.MODULE$.BigDecimal().apply("1e-15").bigDecimal());
        testData.setField(41, (Object)scala.package$.MODULE$.BigDecimal().apply("3.00").bigDecimal());
        testData.setField(42, (Object)scala.package$.MODULE$.BigDecimal().apply("5.00").bigDecimal());
        testData.setField(43, (Object)BoxesRunTime.boxToInteger((int)7));
        testData.setField(44, (Object)scala.package$.MODULE$.BigDecimal().apply("3").bigDecimal());
        testData.setField(45, (Object)scala.package$.MODULE$.BigDecimal().apply("5").bigDecimal());
        testData.setField(46, (Object)scala.package$.MODULE$.BigDecimal().apply("3.1234").bigDecimal());
        testData.setField(47, (Object)scala.package$.MODULE$.BigDecimal().apply("5").bigDecimal());
        testData.setField(48, (Object)scala.package$.MODULE$.BigDecimal().apply("3.14").bigDecimal());
        testData.setField(49, (Object)scala.package$.MODULE$.BigDecimal().apply("2.17").bigDecimal());
        testData.setField(50, (Object)scala.package$.MODULE$.BigDecimal().apply("646.646").bigDecimal());
        testData.setField(51, (Object)scala.package$.MODULE$.BigDecimal().apply("99.99").bigDecimal());
        testData.setField(52, (Object)scala.package$.MODULE$.BigDecimal().apply("1E38").bigDecimal().subtract(scala.package$.MODULE$.BigDecimal().apply("1").bigDecimal()));
        testData.setField(53, (Object)scala.package$.MODULE$.BigDecimal().apply("0.0001").bigDecimal());
        testData.setField(54, (Object)scala.package$.MODULE$.BigDecimal().apply("0.01").bigDecimal());
        testData.setField(55, (Object)"3.14");
        testData.setField(56, (Object)scala.package$.MODULE$.BigDecimal().apply("3.15").bigDecimal());
        testData.setField(57, (Object)BoxesRunTime.boxToDouble((double)3.15));
        testData.setField(58, (Object)"3.15");
        testData.setField(59, (Object)"13.14");
        testData.setField(60, (Object)scala.package$.MODULE$.BigDecimal().apply("1.99").bigDecimal());
        testData.setField(61, (Object)"1.99");
        testData.setField(62, (Object)BoxesRunTime.boxToInteger((int)1));
        testData.setField(63, (Object)scala.package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(64, (Object)scala.package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(65, (Object)BoxesRunTime.boxToInteger((int)1));
        testData.setField(66, (Object)BoxesRunTime.boxToDouble((double)1.0));
        testData.setField(67, (Object)scala.package$.MODULE$.BigDecimal().apply("1").bigDecimal());
        testData.setField(68, (Object)scala.package$.MODULE$.BigDecimal().apply("99").bigDecimal());
        testData.setField(69, (Object)BoxesRunTime.boxToInteger((int)99));
        testData.setField(70, (Object)BoxesRunTime.boxToDouble((double)99.0));
        return testData;
    }

    public DataType testDataType() {
        return DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)30, (int)18)), DataTypes.FIELD((String)"f1", (DataType)DataTypes.DECIMAL((int)30, (int)0)), DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f4", (DataType)DataTypes.DECIMAL((int)10, (int)0)), DataTypes.FIELD((String)"f5", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"f6", (DataType)DataTypes.DECIMAL((int)10, (int)0)), DataTypes.FIELD((String)"f7", (DataType)DataTypes.DECIMAL((int)7, (int)2)), DataTypes.FIELD((String)"f8", (DataType)DataTypes.DECIMAL((int)7, (int)2)), DataTypes.FIELD((String)"f9", (DataType)DataTypes.DECIMAL((int)7, (int)2)), DataTypes.FIELD((String)"f10", (DataType)DataTypes.DECIMAL((int)5, (int)2)), DataTypes.FIELD((String)"f11", (DataType)DataTypes.DECIMAL((int)2, (int)0)), DataTypes.FIELD((String)"f12", (DataType)DataTypes.DECIMAL((int)4, (int)2)), DataTypes.FIELD((String)"f13", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f14", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f15", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f16", (DataType)DataTypes.DECIMAL((int)38, (int)28)), DataTypes.FIELD((String)"f17", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f18", (DataType)DataTypes.DECIMAL((int)38, (int)28)), DataTypes.FIELD((String)"f19", (DataType)DataTypes.DECIMAL((int)38, (int)0)), DataTypes.FIELD((String)"f20", (DataType)DataTypes.DECIMAL((int)5, (int)2)), DataTypes.FIELD((String)"f21", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f22", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f23", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f24", (DataType)DataTypes.DECIMAL((int)30, (int)6)), DataTypes.FIELD((String)"f25", (DataType)DataTypes.DECIMAL((int)30, (int)10)), DataTypes.FIELD((String)"f26", (DataType)DataTypes.DECIMAL((int)30, (int)20)), DataTypes.FIELD((String)"f27", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f28", (DataType)DataTypes.DECIMAL((int)38, (int)10)), DataTypes.FIELD((String)"f29", (DataType)DataTypes.DECIMAL((int)38, (int)0)), DataTypes.FIELD((String)"f30", (DataType)DataTypes.DECIMAL((int)30, (int)20)), DataTypes.FIELD((String)"f31", (DataType)DataTypes.DECIMAL((int)20, (int)2)), DataTypes.FIELD((String)"f32", (DataType)DataTypes.DECIMAL((int)2, (int)1)), DataTypes.FIELD((String)"f33", (DataType)DataTypes.DECIMAL((int)4, (int)3)), DataTypes.FIELD((String)"f34", (DataType)DataTypes.DECIMAL((int)20, (int)10)), DataTypes.FIELD((String)"f35", (DataType)DataTypes.DECIMAL((int)20, (int)16)), DataTypes.FIELD((String)"f36", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f37", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f38", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f39", (DataType)DataTypes.DECIMAL((int)30, (int)0)), DataTypes.FIELD((String)"f40", (DataType)DataTypes.DECIMAL((int)30, (int)20)), DataTypes.FIELD((String)"f41", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f42", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f43", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f44", (DataType)DataTypes.DECIMAL((int)1, (int)0)), DataTypes.FIELD((String)"f45", (DataType)DataTypes.DECIMAL((int)1, (int)0)), DataTypes.FIELD((String)"f46", (DataType)DataTypes.DECIMAL((int)10, (int)4)), DataTypes.FIELD((String)"f47", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f48", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f49", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f50", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"f51", (DataType)DataTypes.DECIMAL((int)4, (int)2)), DataTypes.FIELD((String)"f52", (DataType)DataTypes.DECIMAL((int)38, (int)0)), DataTypes.FIELD((String)"f53", (DataType)DataTypes.DECIMAL((int)8, (int)4)), DataTypes.FIELD((String)"f54", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f55", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f56", (DataType)DataTypes.DECIMAL((int)8, (int)2)), DataTypes.FIELD((String)"f57", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f58", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f59", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f60", (DataType)DataTypes.DECIMAL((int)4, (int)2)), DataTypes.FIELD((String)"f61", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f62", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f63", (DataType)DataTypes.DECIMAL((int)8, (int)2)), DataTypes.FIELD((String)"f64", (DataType)DataTypes.DECIMAL((int)8, (int)4)), DataTypes.FIELD((String)"f65", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f66", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f67", (DataType)DataTypes.DECIMAL((int)1, (int)0)), DataTypes.FIELD((String)"f68", (DataType)DataTypes.DECIMAL((int)2, (int)0)), DataTypes.FIELD((String)"f69", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f70", (DataType)DataTypes.DOUBLE())});
    }

    @Override
    public boolean containsLegacyTypes() {
        return false;
    }

    public DecimalTypeTest() {
        super(ExpressionTestBase$.MODULE$.$lessinit$greater$default$1());
    }
}

