/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.expressions.ColumnReferenceFinder;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ColumnReferenceFinderTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(TableConfig.getDefault());
    private ResolvedSchema resolvedSchema;

    ColumnReferenceFinderTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.resolvedSchema = this.util.testingTableEnv().getCatalogManager().getSchemaResolver().resolve(Schema.newBuilder().columnByExpression("a", "b || '_001'").column("b", (AbstractDataType)DataTypes.STRING()).columnByExpression("c", "d * e + 2").column("d", (AbstractDataType)DataTypes.DOUBLE()).columnByMetadata("e", (AbstractDataType)DataTypes.INT(), null, true).column("tuple", (AbstractDataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.TIMESTAMP((int)3), DataTypes.INT()})).column("g", (AbstractDataType)DataTypes.TIMESTAMP((int)3)).columnByExpression("ts", "tuple.f0").watermark("ts", "g - interval '5' day").build());
    }

    @Test
    void testFindReferencedColumn() {
        Assertions.assertThat((Collection)ColumnReferenceFinder.findReferencedColumn((String)"b", (ResolvedSchema)this.resolvedSchema)).isEqualTo(Collections.emptySet());
        Assertions.assertThat((Collection)ColumnReferenceFinder.findReferencedColumn((String)"a", (ResolvedSchema)this.resolvedSchema)).containsExactlyInAnyOrder((Object[])new String[]{"b"});
        Assertions.assertThat((Collection)ColumnReferenceFinder.findReferencedColumn((String)"c", (ResolvedSchema)this.resolvedSchema)).containsExactlyInAnyOrder((Object[])new String[]{"d", "e"});
        Assertions.assertThat((Collection)ColumnReferenceFinder.findReferencedColumn((String)"ts", (ResolvedSchema)this.resolvedSchema)).containsExactlyInAnyOrder((Object[])new String[]{"tuple"});
        Assertions.assertThat((Collection)ColumnReferenceFinder.findWatermarkReferencedColumn((ResolvedSchema)this.resolvedSchema)).containsExactlyInAnyOrder((Object[])new String[]{"ts", "g"});
    }
}

