/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class JavaCatalogTableTest
extends TableTestBase {
    @Parameter
    private boolean streamingMode;

    JavaCatalogTableTest() {
    }

    @Parameters(name="streamingMode = {0}")
    private static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    private TableTestUtil getTestUtil() {
        if (this.streamingMode) {
            return this.streamTestUtil(TableConfig.getDefault());
        }
        return this.batchTestUtil(TableConfig.getDefault());
    }

    @TestTemplate
    void testResolvingSchemaOfCustomCatalogTableSql() throws Exception {
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.streamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        tableEnvironment.executeSql("CREATE VIEW testTable2 AS SELECT * FROM testCatalog.`default`.testTable");
        testUtil.verifyExecPlan("SELECT COUNT(*) FROM testTable2 GROUP BY TUMBLE(rowtime, INTERVAL '10' MINUTE)");
    }

    @TestTemplate
    void testResolvingSchemaOfCustomCatalogTableTableApi() throws Exception {
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.streamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        Table table = tableEnvironment.from("testCatalog.`default`.testTable").window((GroupWindow)Tumble.over((Expression)((Expression)Expressions.lit((Object)10).minute())).on((Expression)Expressions.$((String)"rowtime")).as("w")).groupBy(new Expression[]{Expressions.$((String)"w")}).select(new Expression[]{(Expression)Expressions.lit((Object)1).count()});
        testUtil.verifyExecPlan(table);
    }

    @TestTemplate
    void testResolvingProctimeOfCustomTableSql() throws Exception {
        if (!this.streamingMode) {
            return;
        }
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.streamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        testUtil.verifyExecPlan("SELECT COUNT(*) FROM testCatalog.`default`.testTable GROUP BY TUMBLE(proctime, INTERVAL '10' MINUTE)");
    }

    @TestTemplate
    void testResolvingProctimeOfCustomTableTableApi() throws Exception {
        if (!this.streamingMode) {
            return;
        }
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.streamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        Table table = tableEnvironment.from("testCatalog.`default`.testTable").window((GroupWindow)Tumble.over((Expression)((Expression)Expressions.lit((Object)10).minute())).on((Expression)Expressions.$((String)"proctime")).as("w")).groupBy(new Expression[]{Expressions.$((String)"w")}).select(new Expression[]{(Expression)Expressions.lit((Object)1).count()});
        testUtil.verifyExecPlan(table);
    }

    @TestTemplate
    void testTimeAttributeOfView() {
        if (!this.streamingMode) {
            return;
        }
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        tableEnvironment.registerCatalog("cat", (Catalog)new CustomCatalog("cat"));
        tableEnvironment.executeSql("CREATE TABLE t(i INT, ts TIMESTAMP_LTZ(3), WATERMARK FOR ts AS ts) WITH ('connector' = 'datagen')");
        tableEnvironment.executeSql("CREATE VIEW `cat`.`default`.v AS SELECT * FROM t");
        testUtil.verifyExecPlan("SELECT sum(i), window_start FROM TUMBLE(\n     DATA => TABLE `cat`.`default`.v,\n     TIMECOL => DESCRIPTOR(ts),\n     SIZE => INTERVAL '10' MINUTES)\nGROUP BY window_start, window_end");
    }

    @TestTemplate
    void testTimeAttributeOfViewSelect() {
        if (!this.streamingMode) {
            return;
        }
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        tableEnvironment.registerCatalog("cat", (Catalog)new CustomCatalog("cat"));
        tableEnvironment.executeSql("CREATE TABLE `cat`.`default`.`t`( order_id INT,  customer_id INT,  product_id INT,  product_ids ARRAY<INT>,  ts TIMESTAMP_LTZ(3), WATERMARK FOR ts AS ts) WITH ('connector' = 'datagen')");
        tableEnvironment.executeSql("CREATE VIEW `cat`.`default`.v AS SELECT `o`.`order_id`, `o`.`customer_id`, `pids`.`product_id`, `o`.`ts`\nFROM `cat`.`default`.`t` AS `o`\nCROSS JOIN UNNEST(`o`.`product_ids`) AS `pids` (`product_id`)");
        testUtil.verifyExecPlan("SELECT * FROM `cat`.`default`.v");
    }

    private static class CustomCatalogTable
    implements CatalogTable {
        private final boolean streamingMode;

        private CustomCatalogTable(boolean streamingMode) {
            this.streamingMode = streamingMode;
        }

        public boolean isPartitioned() {
            return false;
        }

        public List<String> getPartitionKeys() {
            return Collections.emptyList();
        }

        public CatalogTable copy(Map<String, String> options) {
            return this;
        }

        public Map<String, String> getOptions() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("connector", "values");
            map.put("bounded", Boolean.toString(!this.streamingMode));
            return map;
        }

        public TableSchema getSchema() {
            return TableSchema.builder().field("count", DataTypes.BIGINT()).field("rowtime", DataTypes.TIMESTAMP((int)3)).field("proctime", DataTypes.TIMESTAMP((int)3), "proctime()").watermark("rowtime", "rowtime - INTERVAL '5' SECONDS", DataTypes.TIMESTAMP()).build();
        }

        public String getComment() {
            return null;
        }

        public CatalogBaseTable copy() {
            return this;
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getDetailedDescription() {
            return Optional.empty();
        }
    }

    private static class CustomCatalog
    extends GenericInMemoryCatalog {
        public CustomCatalog(String name) {
            super(name);
        }

        public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException {
            CatalogBaseTable table = super.getTable(tablePath);
            if (table.getTableKind() == CatalogBaseTable.TableKind.VIEW) {
                return new CustomView((CatalogView)table);
            }
            return table;
        }
    }

    private static class CustomView
    implements CatalogView {
        private final CatalogView origin;

        public CustomView(CatalogView table) {
            this.origin = table;
        }

        public String getOriginalQuery() {
            return this.origin.getOriginalQuery();
        }

        public String getExpandedQuery() {
            return this.origin.getExpandedQuery();
        }

        public Map<String, String> getOptions() {
            return this.origin.getOptions();
        }

        public Schema getUnresolvedSchema() {
            Schema originalSchema = this.origin.getUnresolvedSchema();
            return Schema.newBuilder().fromColumns(originalSchema.getColumns().stream().map(c -> {
                if (c instanceof Schema.UnresolvedPhysicalColumn) {
                    DataType dataType = (DataType)((Schema.UnresolvedPhysicalColumn)c).getDataType();
                    String stringType = dataType.getLogicalType().asSerializableString();
                    return new Schema.UnresolvedPhysicalColumn(c.getName(), (AbstractDataType)DataTypes.of((String)stringType));
                }
                throw new UnsupportedOperationException("Unexpected column type");
            }).collect(Collectors.toList())).build();
        }

        public String getComment() {
            return this.origin.getComment();
        }

        public CatalogBaseTable copy() {
            return new CustomView((CatalogView)this.origin.copy());
        }

        public Optional<String> getDescription() {
            return this.origin.getDescription();
        }

        public Optional<String> getDetailedDescription() {
            return this.origin.getDetailedDescription();
        }
    }
}

