/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.DataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0002\u0004\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0014\u0001A\u0003%\u0001\u0005C\u0003(\u0001\u0011\u0005\u0001F\u0001\tDCR\fGn\\4UC\ndW\rV3ti*\u0011q\u0001C\u0001\bG\u0006$\u0018\r\\8h\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u00051\u0011\u0001\u0002;F]Z,\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003G)\t1!\u00199j\u0013\t)#E\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\u0006)A/\u00128wA\u0005iA/Z:u\t\u0012c5k\u00195f[\u0006$\u0012!\u000b\t\u0003+)J!a\u000b\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t5\u0002\"A\f\u001b\u000e\u0003=R!a\t\u0019\u000b\u0005E\u0012\u0014a\u00026va&$XM\u001d\u0006\u0003gA\tQA[;oSRL!!N\u0018\u0003\tQ+7\u000f\u001e")
public class CatalogTableTest {
    private final TableEnvironment tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inStreamingMode().build());

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    @Test
    public void testDDLSchema() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE t1 (\n        |  f1 INT,\n        |  f2 BIGINT NOT NULL,\n        |  f3 STRING,\n        |  f4 DECIMAL(10, 4),\n        |  f5 TIMESTAMP(2) NOT NULL,\n        |  f6 TIME,\n        |  f7 DATE,\n        |  f8 VARCHAR(10) NOT NULL,\n        |  c AS f3 || f8\n        |) WITH (\n        |  'connector' = 'COLLECTION'\n        |)\n      ")).stripMargin());
        ResolvedSchema actual = this.tEnv().sqlQuery("SELECT * FROM t1").getResolvedSchema();
        ResolvedSchema expected = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f1", (DataType)DataTypes.INT()), Column.physical((String)"f2", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"f3", (DataType)DataTypes.STRING()), Column.physical((String)"f4", (DataType)DataTypes.DECIMAL((int)10, (int)4)), Column.physical((String)"f5", (DataType)((DataType)DataTypes.TIMESTAMP((int)2).notNull())), Column.physical((String)"f6", (DataType)DataTypes.TIME()), Column.physical((String)"f7", (DataType)DataTypes.DATE()), Column.physical((String)"f8", (DataType)((DataType)DataTypes.VARCHAR((int)10).notNull())), Column.physical((String)"c", (DataType)DataTypes.STRING())});
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

