/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CatalogConstraintTest {
    private String databaseName = "default_database";
    private TableEnvironment tEnv;
    private Catalog catalog;

    @BeforeEach
    void setup() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
        this.tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        this.catalog = this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElse(null);
        Assertions.assertThat((Object)this.catalog).isNotNull();
    }

    @Test
    void testWithPrimaryKey() throws Exception {
        Schema tableSchema = Schema.newBuilder().fromResolvedSchema(new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"c", (DataType)DataTypes.INT())), Collections.emptyList(), UniqueConstraint.primaryKey((String)"primary_constraint", Collections.singletonList("b")))).build();
        Map<String, String> properties = this.buildCatalogTableProperties(tableSchema);
        this.catalog.createTable(new ObjectPath(this.databaseName, "T1"), (CatalogBaseTable)CatalogTable.newBuilder().schema(tableSchema).comment("").options(properties).build(), false);
        RelNode t1 = TableTestUtil.toRelNode(this.tEnv.sqlQuery("select * from T1"));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assertions.assertThat((Collection)mq.getUniqueKeys(t1)).isEqualTo((Object)ImmutableSet.of((Object)ImmutableBitSet.of((int[])new int[]{1})));
    }

    @Test
    void testWithoutPrimaryKey() throws Exception {
        Schema tableSchema = Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.STRING()), Column.physical((String)"c", (DataType)DataTypes.INT())})).build();
        Map<String, String> properties = this.buildCatalogTableProperties(tableSchema);
        this.catalog.createTable(new ObjectPath(this.databaseName, "T1"), (CatalogBaseTable)CatalogTable.newBuilder().schema(tableSchema).comment("").options(properties).build(), false);
        RelNode t1 = TableTestUtil.toRelNode(this.tEnv.sqlQuery("select * from T1"));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assertions.assertThat((Collection)mq.getUniqueKeys(t1)).isEqualTo((Object)ImmutableSet.of());
    }

    private Map<String, String> buildCatalogTableProperties(Schema tableSchema) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector.type", "filesystem");
        properties.put("connector.property-version", "1");
        properties.put("connector.path", "/path/to/csv");
        properties.put("format.type", "csv");
        properties.put("format.property-version", "1");
        properties.put("format.field-delimiter", ";");
        return properties;
    }
}

