/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch.sql.validation;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class MatchRecognizeValidationTest
extends TableTestBase {
    private static final String STREAM = "stream";
    private static final String BATCH = "batch";
    @Parameter
    private String mode;
    private TableTestUtil util;
    private TableEnvironment tEnv;

    MatchRecognizeValidationTest() {
    }

    @Parameters(name="mode = {0}")
    private static Collection<String> parameters() {
        return Arrays.asList(STREAM, BATCH);
    }

    @BeforeEach
    void setup() {
        this.util = STREAM.equals(this.mode) ? this.streamTestUtil(TableConfig.getDefault()) : this.batchTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        this.tEnv.executeSql("CREATE TABLE Ticker (\n  `symbol` VARCHAR,\n  `price` INT,\n  `tax` INT,\n  `proctime` as PROCTIME()\n) with (\n  'connector' = 'values',\n  'bounded' = 'true'\n)");
        this.tEnv.executeSql("CREATE TABLE MyTable (\n  a BIGINT,\n  b INT,\n  proctime as PROCTIME()\n) with (\n  'connector' = 'values',\n  'bounded' = 'true'\n)");
    }

    @AfterEach
    void after() {
        this.util.getTableEnv().executeSql("DROP TABLE Ticker");
        this.util.getTableEnv().executeSql("DROP TABLE MyTable");
    }

    @TestTemplate
    void testMatchRowTimeInSelect() {
        String sql = "SELECT MATCH_ROWTIME() FROM MyTable";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util.verifyExplain(sql));
    }

    @TestTemplate
    void testMatchProcTimeInSelect() {
        String sql = "SELECT MATCH_PROCTIME() FROM MyTable";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util.verifyExplain(sql));
    }

    @TestTemplate
    void testSortProcessingTimeDesc() {
        if (STREAM.equals(this.mode)) {
            String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime DESC\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("Primary sort order of a streaming table must be ascending on time.");
        }
    }

    @TestTemplate
    void testSortProcessingTimeSecondaryField() {
        if (STREAM.equals(this.mode)) {
            String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY price, proctime\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("You must specify either rowtime or proctime for order by as the first one.");
        }
    }

    @TestTemplate
    void testSortNoOrder() {
        if (STREAM.equals(this.mode)) {
            String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("You must specify either rowtime or proctime for order by.");
        }
    }

    @TestTemplate
    void testUpdatesInUpstreamOperatorNotSupported() {
        if (STREAM.equals(this.mode)) {
            String sqlQuery = "SELECT *\nFROM (SELECT DISTINCT * FROM Ticker)\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n   ONE ROW PER MATCH  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("Match Recognize doesn't support consuming update changes which is produced by node GroupAggregate(");
        }
    }

    @TestTemplate
    void testAggregatesOnMultiplePatternVariablesNotSupported() {
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    SUM(A.price + B.tax) AS taxedPrice\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("SQL validation failed.");
    }

    @TestTemplate
    void testAggregatesOnMultiplePatternVariablesNotSupportedInUDAGs() {
        this.util.addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.WeightedAvg());
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    weightedAvg(A.price, B.tax) AS weightedAvg\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("Aggregation must be applied to a single pattern variable");
    }

    @TestTemplate
    void testValidatingAmbiguousColumns() {
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  PARTITION BY symbol, price\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS symbol,\n    A.price AS price\n  PATTERN (A)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("Columns ambiguously defined: {symbol, price}");
    }

    @TestTemplate
    void testMatchPythonFunction() {
        this.util.addTemporarySystemFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = "SELECT T.aa as ta\nFROM MyTable\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.a as aa,\n    pyFunc(1,2) as bb\n  PATTERN (A B)\n  DEFINE\n    A AS a = 1,\n    B AS b = 'b'\n) AS T";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sql)).withMessageContaining("Python Function can not be used in MATCH_RECOGNIZE for now.");
    }

    @TestTemplate
    void testAllRowsPerMatch() {
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n  ALL ROWS PER MATCH\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("All rows per match mode is not supported yet.");
    }

    @TestTemplate
    void testGreedyQuantifierAtTheEndIsNotSupported() {
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B+)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
    }

    @TestTemplate
    void testPatternsProducingEmptyMatchesAreNotSupported() {
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A*)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
    }

    @TestTemplate
    void testDistinctAggregationsNotSupported() {
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    COUNT(DISTINCT A.price) AS price\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.tEnv.executeSql(sqlQuery)).withMessageContaining("SQL validation failed.");
    }
}

