/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.source.split;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.connector.source.TerminatingLogic;
import org.apache.flink.connector.source.split.ValuesSourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class ValuesSourceSplitSerializer
implements SimpleVersionedSerializer<ValuesSourceSplit> {
    public int getVersion() {
        return 0;
    }

    public byte[] serialize(ValuesSourceSplit split) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeInt(split.getIndex());
                TerminatingLogic.writeTo(out, split.getTerminatingLogic());
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public ValuesSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            ValuesSourceSplit valuesSourceSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                int index = in.readInt();
                TerminatingLogic terminatingLogic = TerminatingLogic.readFrom(in);
                valuesSourceSplit = new ValuesSourceSplit(index, terminatingLogic);
            }
            return valuesSourceSplit;
        }
    }
}

