/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.legacy.api;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Deprecated
@Internal
public abstract class TableColumn {
    private final String name;
    private final DataType type;

    private TableColumn(String name, DataType type) {
        this.name = name;
        this.type = type;
    }

    public static PhysicalColumn physical(String name, DataType type) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null.");
        Preconditions.checkNotNull((Object)type, (String)"Column type can not be null.");
        return new PhysicalColumn(name, type);
    }

    public static ComputedColumn computed(String name, DataType type, String expression) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null.");
        Preconditions.checkNotNull((Object)type, (String)"Column type can not be null.");
        Preconditions.checkNotNull((Object)expression, (String)"Column expression can not be null.");
        return new ComputedColumn(name, type, expression);
    }

    public static MetadataColumn metadata(String name, DataType type) {
        return TableColumn.metadata(name, type, null, false);
    }

    public static MetadataColumn metadata(String name, DataType type, boolean isVirtual) {
        return TableColumn.metadata(name, type, null, isVirtual);
    }

    public static MetadataColumn metadata(String name, DataType type, String metadataAlias) {
        Preconditions.checkNotNull((Object)metadataAlias, (String)"Metadata alias can not be null.");
        return TableColumn.metadata(name, type, metadataAlias, false);
    }

    public static MetadataColumn metadata(String name, DataType type, @Nullable String metadataAlias, boolean isVirtual) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null.");
        Preconditions.checkNotNull((Object)type, (String)"Column type can not be null.");
        return new MetadataColumn(name, type, metadataAlias, isVirtual);
    }

    @Deprecated
    public static TableColumn of(String name, DataType type) {
        return TableColumn.physical(name, type);
    }

    @Deprecated
    public static TableColumn of(String name, DataType type, String expression) {
        return TableColumn.computed(name, type, expression);
    }

    public abstract boolean isPhysical();

    public abstract boolean isPersisted();

    public DataType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String asSummaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(": ");
        sb.append(this.type);
        this.explainExtras().ifPresent(e -> {
            sb.append(" ");
            sb.append((String)e);
        });
        return sb.toString();
    }

    public abstract Optional<String> explainExtras();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableColumn that = (TableColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return this.asSummaryString();
    }

    @Internal
    public static class PhysicalColumn
    extends TableColumn {
        private PhysicalColumn(String name, DataType type) {
            super(name, type);
        }

        @Override
        public boolean isPhysical() {
            return true;
        }

        @Override
        public boolean isPersisted() {
            return true;
        }

        @Override
        public Optional<String> explainExtras() {
            return Optional.empty();
        }
    }

    @Internal
    public static class ComputedColumn
    extends TableColumn {
        private final String expression;

        private ComputedColumn(String name, DataType type, String expression) {
            super(name, type);
            this.expression = expression;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public boolean isPersisted() {
            return false;
        }

        public String getExpression() {
            return this.expression;
        }

        @Override
        public Optional<String> explainExtras() {
            return Optional.of("AS " + this.expression);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ComputedColumn that = (ComputedColumn)o;
            return this.expression.equals(that.expression);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.expression);
        }
    }

    @Internal
    public static class MetadataColumn
    extends TableColumn {
        @Nullable
        private final String metadataAlias;
        private final boolean isVirtual;

        private MetadataColumn(String name, DataType type, @Nullable String metadataAlias, boolean isVirtual) {
            super(name, type);
            this.metadataAlias = metadataAlias;
            this.isVirtual = isVirtual;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public Optional<String> getMetadataAlias() {
            return Optional.ofNullable(this.metadataAlias);
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public boolean isPersisted() {
            return !this.isVirtual;
        }

        @Override
        public Optional<String> explainExtras() {
            StringBuilder sb = new StringBuilder();
            sb.append("METADATA");
            if (this.metadataAlias != null) {
                sb.append(" FROM ");
                sb.append("'");
                sb.append(this.metadataAlias);
                sb.append("'");
            }
            if (this.isVirtual) {
                sb.append(" VIRTUAL");
            }
            return Optional.of(sb.toString());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MetadataColumn that = (MetadataColumn)o;
            return this.isVirtual == that.isVirtual && Objects.equals(this.metadataAlias, that.metadataAlias);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.metadataAlias, this.isVirtual);
        }
    }
}

