/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.table.utils.PartitionPathUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartitionPathUtilsTest {
    PartitionPathUtilsTest() {
    }

    @Test
    void testEscapeChar() {
        for (char c = '\u0000'; c <= '\u0080'; c = (char)(c + '\u0001')) {
            String expected = "%" + String.format("%1$02X", c);
            String actual = PartitionPathUtils.escapeChar((char)c, (StringBuilder)new StringBuilder()).toString();
            Assertions.assertThat((String)actual).isEqualTo(expected);
        }
    }

    @Test
    void testEscapePathNameWithHeadControl() {
        String origin = "[00";
        String expected = "%5B00";
        String actual = PartitionPathUtils.escapePathName((String)origin);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        Assertions.assertThat((String)PartitionPathUtils.unescapePathName((String)actual)).isEqualTo(origin);
    }

    @Test
    void testEscapePathNameWithTailControl() {
        String origin = "00]";
        String expected = "00%5D";
        String actual = PartitionPathUtils.escapePathName((String)origin);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        Assertions.assertThat((String)PartitionPathUtils.unescapePathName((String)actual)).isEqualTo(origin);
    }

    @Test
    void testEscapePathNameWithMidControl() {
        String origin = "00:00";
        String expected = "00%3A00";
        String actual = PartitionPathUtils.escapePathName((String)origin);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        Assertions.assertThat((String)PartitionPathUtils.unescapePathName((String)actual)).isEqualTo(origin);
    }

    @Test
    void testEscapePathName() {
        String origin = "[00:00]";
        String expected = "%5B00%3A00%5D";
        String actual = PartitionPathUtils.escapePathName((String)origin);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        Assertions.assertThat((String)PartitionPathUtils.unescapePathName((String)actual)).isEqualTo(origin);
    }

    @Test
    void testEscapePathNameWithoutControl() {
        String origin = "0000";
        String expected = "0000";
        String actual = PartitionPathUtils.escapePathName((String)origin);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        Assertions.assertThat((String)PartitionPathUtils.unescapePathName((String)actual)).isEqualTo(origin);
    }

    @Test
    void testEscapePathNameWithCurlyBraces() {
        String origin = "{partName}";
        String expected = "%7BpartName%7D";
        String actual = PartitionPathUtils.escapePathName((String)origin);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        Assertions.assertThat((String)PartitionPathUtils.unescapePathName((String)actual)).isEqualTo(origin);
    }
}

